/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Client.Common.Network.API;

import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import net.ME1312.Galaxi.Library.Container.Pair;
import net.ME1312.Galaxi.Library.Map.ObjectMap;
import net.ME1312.Galaxi.Library.Map.ObjectMapValue;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.SubData.Client.DataClient;
import net.ME1312.SubData.Client.DataSender;
import net.ME1312.SubData.Client.Library.ForwardedDataSender;
import net.ME1312.SubData.Client.Protocol.PacketOut;
import net.ME1312.SubData.Client.SubDataClient;
import net.ME1312.SubData.Client.SubDataSender;
import net.ME1312.SubServers.Client.Common.ClientAPI;
import net.ME1312.SubServers.Client.Common.Network.API.RemotePlayer;
import net.ME1312.SubServers.Client.Common.Network.API.Server;
import net.ME1312.SubServers.Client.Common.Network.API.SimplifiedData;
import net.ME1312.SubServers.Client.Common.Network.API.SubCreator;
import net.ME1312.SubServers.Client.Common.Network.API.SubServer;
import net.ME1312.SubServers.Client.Common.Network.Packet.PacketAddServer;
import net.ME1312.SubServers.Client.Common.Network.Packet.PacketDeleteServer;
import net.ME1312.SubServers.Client.Common.Network.Packet.PacketDownloadHostInfo;
import net.ME1312.SubServers.Client.Common.Network.Packet.PacketDownloadPlayerInfo;
import net.ME1312.SubServers.Client.Common.Network.Packet.PacketRemoveServer;

public class Host {
    HashMap<String, SubServer> servers = new HashMap();
    private SubCreator creator;
    private List<RemotePlayer> players = null;
    ObjectMap<String> raw;
    DataClient client;
    long timestamp;

    public Host(ObjectMap<String> raw) {
        this(null, raw);
    }

    Host(DataClient client, ObjectMap<String> raw) {
        this.client = client;
        this.load(raw);
    }

    public boolean equals(Object obj) {
        return obj instanceof Host && this.getSignature().equals(((Host)obj).getSignature());
    }

    private void load(ObjectMap<String> raw) {
        this.raw = raw;
        this.players = null;
        this.timestamp = Calendar.getInstance().getTime().getTime();
        this.servers.clear();
        this.creator = new SubCreator(this, (ObjectMap<String>)raw.getMap((Object)"creator"));
        for (String server : raw.getMap((Object)"servers").getKeys()) {
            this.servers.put(server.toLowerCase(), new SubServer(this, (ObjectMap<String>)raw.getMap((Object)"servers").getMap((Object)server)));
        }
    }

    private SubDataClient client() {
        return SimplifiedData.client(this.client);
    }

    public void refresh() {
        String name = this.getName();
        this.client().sendPacket(new PacketOut[]{new PacketDownloadHostInfo(Collections.singletonList(name), data -> this.load((ObjectMap<String>)data.getMap((Object)name)))});
    }

    public DataSender[] getSubData() {
        if (this.raw.contains((Object)"subdata")) {
            ObjectMap subdata = new ObjectMap((Map)this.raw.getObject((Object)"subdata"));
            Object[] keys = subdata.getKeys().toArray(new Integer[0]);
            DataSender[] channels = new DataSender[keys.length];
            Arrays.sort(keys);
            for (int i = 0; i < keys.length; ++i) {
                channels[i] = subdata.isNull(keys[i]) ? null : new ForwardedDataSender((SubDataClient)ClientAPI.getInstance().getSubDataNetwork()[0], subdata.getUUID(keys[i]));
            }
            return channels;
        }
        return new SubDataSender[0];
    }

    public boolean isAvailable() {
        return this.raw.getBoolean((Object)"available");
    }

    public boolean isEnabled() {
        return this.raw.getBoolean((Object)"enabled");
    }

    public InetAddress getAddress() {
        try {
            return InetAddress.getByName(this.raw.getString((Object)"address"));
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("Invalid address response from raw data key: address");
        }
    }

    public String getPath() {
        return this.raw.getString((Object)"dir");
    }

    public String getName() {
        return this.raw.getString((Object)"name");
    }

    public String getDisplayName() {
        return this.raw.getString((Object)"display");
    }

    public Collection<Pair<String, UUID>> getRemotePlayers() {
        ArrayList<Pair<String, UUID>> players = new ArrayList<Pair<String, UUID>>();
        for (SubServer subServer : this.getSubServers().values()) {
            players.addAll(subServer.getRemotePlayers());
        }
        return players;
    }

    public void getRemotePlayers(Consumer<Collection<RemotePlayer>> callback) {
        Util.nullpo(callback);
        StackTraceElement[] origin = new Throwable().getStackTrace();
        Runnable run = () -> {
            try {
                callback.accept(this.players);
            }
            catch (Throwable e) {
                InvocationTargetException ew = new InvocationTargetException(e);
                ew.setStackTrace(origin);
                ew.printStackTrace();
            }
        };
        if (this.players == null) {
            LinkedList<UUID> ids = new LinkedList<UUID>();
            HashMap<UUID, SubServer> servers = new HashMap<UUID, SubServer>();
            for (SubServer subServer : this.getSubServers().values()) {
                for (Pair<String, UUID> player : subServer.getRemotePlayers()) {
                    ids.add((UUID)player.value());
                    servers.put((UUID)player.value(), subServer);
                }
            }
            this.client().sendPacket(new PacketOut[]{new PacketDownloadPlayerInfo((List<UUID>)ids, (Consumer<ObjectMap<String>>[])new Consumer[]{data -> {
                LinkedList<RemotePlayer> players = new LinkedList<RemotePlayer>();
                for (String player : data.getKeys()) {
                    players.add(RemotePlayer.instance.construct((Server)servers.get(UUID.fromString(player)), (ObjectMap<String>)data.getMap((Object)player)));
                }
                this.players = players;
                run.run();
            }})});
        } else {
            run.run();
        }
    }

    public void start(String ... servers) {
        this.start((UUID)null, servers);
    }

    public void start(UUID player, String ... servers) {
        for (String server : servers) {
            this.getSubServer(server.toLowerCase()).start(player);
        }
    }

    public void stop(String ... servers) {
        this.stop((UUID)null, servers);
    }

    public void stop(UUID player, String ... servers) {
        for (String server : servers) {
            this.getSubServer(server.toLowerCase()).stop(player);
        }
    }

    public void terminate(String ... servers) {
        this.terminate((UUID)null, servers);
    }

    public void terminate(UUID player, String ... servers) {
        for (String server : servers) {
            this.getSubServer(server.toLowerCase()).terminate(player);
        }
    }

    public void command(String command, String ... servers) {
        this.command((UUID)null, command, servers);
    }

    public void command(UUID player, String command, String ... servers) {
        for (String server : servers) {
            this.getSubServer(server.toLowerCase()).command(player, command);
        }
    }

    public SubCreator getCreator() {
        return this.creator;
    }

    public Map<String, ? extends SubServer> getSubServers() {
        return new TreeMap<String, SubServer>(this.servers);
    }

    public SubServer getSubServer(String name) {
        Util.nullpo((Object)name);
        return this.getSubServers().get(name.toLowerCase());
    }

    public void addSubServer(String name, boolean enabled, int port, String motd, boolean log, String directory, String executable, String stopcmd, boolean hidden, boolean restricted, IntConsumer response) {
        this.addSubServer(null, name, enabled, port, motd, log, directory, executable, stopcmd, hidden, restricted, response);
    }

    public void addSubServer(UUID player, String name, boolean enabled, int port, String motd, boolean log, String directory, String executable, String stopcmd, boolean hidden, boolean restricted, IntConsumer response) {
        Util.nullpo((Object)response);
        StackTraceElement[] origin = new Throwable().getStackTrace();
        this.client().sendPacket(new PacketOut[]{new PacketAddServer(player, name, enabled, this.getName(), port, motd, log, directory, executable, stopcmd, hidden, restricted, data -> {
            try {
                response.accept(data.getInt((Object)1));
            }
            catch (Throwable e) {
                InvocationTargetException ew = new InvocationTargetException(e);
                ew.setStackTrace(origin);
                ew.printStackTrace();
            }
        })});
    }

    public void addSubServer(String name, boolean enabled, int port, String motd, boolean log, String directory, String executable, String stopcmd, boolean hidden, boolean restricted) {
        this.addSubServer(null, name, enabled, port, motd, log, directory, executable, stopcmd, hidden, restricted);
    }

    public void addSubServer(UUID player, String name, boolean enabled, int port, String motd, boolean log, String directory, String executable, String stopcmd, boolean hidden, boolean restricted) {
        this.addSubServer(player, name, enabled, port, motd, log, directory, executable, stopcmd, hidden, restricted, i -> {});
    }

    public void removeSubServer(String name) {
        this.removeSubServer(null, name);
    }

    public void removeSubServer(UUID player, String name) {
        Util.nullpo((Object)name);
        this.removeSubServer(player, name, false, i -> {});
    }

    public void forceRemoveSubServer(String name) {
        this.forceRemoveSubServer(null, name);
    }

    public void forceRemoveSubServer(UUID player, String name) {
        Util.nullpo((Object)name);
        this.removeSubServer(player, name, true, i -> {});
    }

    public void removeSubServer(String name, IntConsumer response) {
        this.removeSubServer(null, name, response);
    }

    public void removeSubServer(UUID player, String name, IntConsumer response) {
        Util.nullpo((Object)name);
        this.removeSubServer(player, name, false, response);
    }

    public void forceRemoveSubServer(String name, IntConsumer response) {
        this.forceRemoveSubServer(null, name, response);
    }

    public void forceRemoveSubServer(UUID player, String name, IntConsumer response) {
        Util.nullpo((Object)name);
        this.removeSubServer(player, name, true, response);
    }

    private void removeSubServer(UUID player, String name, boolean force, IntConsumer response) {
        Util.nullpo((Object)response);
        StackTraceElement[] origin = new Throwable().getStackTrace();
        this.client().sendPacket(new PacketOut[]{new PacketRemoveServer(player, name, force, data -> {
            try {
                response.accept(data.getInt((Object)1));
            }
            catch (Throwable e) {
                InvocationTargetException ew = new InvocationTargetException(e);
                ew.setStackTrace(origin);
                ew.printStackTrace();
            }
        })});
    }

    public void recycleSubServer(String name) {
        this.recycleSubServer(null, name);
    }

    public void recycleSubServer(UUID player, String name) {
        Util.nullpo((Object)name);
        this.deleteSubServer(player, name, true, false, i -> {});
    }

    public void forceRecycleSubServer(String name) {
        this.forceRecycleSubServer(null, name);
    }

    public void forceRecycleSubServer(UUID player, String name) {
        Util.nullpo((Object)name);
        this.deleteSubServer(player, name, true, true, i -> {});
    }

    public void recycleSubServer(String name, IntConsumer response) {
        this.recycleSubServer(null, name, response);
    }

    public void recycleSubServer(UUID player, String name, IntConsumer response) {
        Util.nullpo((Object)name);
        this.deleteSubServer(player, name, true, false, response);
    }

    public void forceRecycleSubServer(String name, IntConsumer response) {
        this.forceRecycleSubServer(null, name, response);
    }

    public void forceRecycleSubServer(UUID player, String name, IntConsumer response) {
        Util.nullpo((Object)name);
        this.deleteSubServer(player, name, true, true, response);
    }

    public void deleteSubServer(String name) {
        this.deleteSubServer(null, name);
    }

    public void deleteSubServer(UUID player, String name) {
        Util.nullpo((Object)name);
        this.deleteSubServer(player, name, false, false, i -> {});
    }

    public void forceDeleteSubServer(String name) {
        this.forceDeleteSubServer(null, name);
    }

    public void forceDeleteSubServer(UUID player, String name) {
        Util.nullpo((Object)name);
        this.deleteSubServer(player, name, false, true, i -> {});
    }

    public void deleteSubServer(String name, IntConsumer response) {
        this.deleteSubServer(null, name, response);
    }

    public void deleteSubServer(UUID player, String name, IntConsumer response) {
        Util.nullpo((Object)name);
        this.deleteSubServer(player, name, false, false, response);
    }

    public void forceDeleteSubServer(String name, IntConsumer response) {
        this.forceDeleteSubServer(null, name, response);
    }

    public void forceDeleteSubServer(UUID player, String name, IntConsumer response) {
        Util.nullpo((Object)name);
        this.deleteSubServer(player, name, false, true, response);
    }

    private void deleteSubServer(UUID player, String name, boolean recycle, boolean force, IntConsumer response) {
        Util.nullpo((Object)response);
        StackTraceElement[] origin = new Throwable().getStackTrace();
        this.client().sendPacket(new PacketOut[]{new PacketDeleteServer(player, name, recycle, force, data -> {
            try {
                response.accept(data.getInt((Object)1));
            }
            catch (Throwable e) {
                InvocationTargetException ew = new InvocationTargetException(e);
                ew.setStackTrace(origin);
                ew.printStackTrace();
            }
        })});
    }

    public final String getSignature() {
        return this.raw.getString((Object)"signature");
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean hasExtra(String handle) {
        Util.nullpo((Object)handle);
        return this.raw.getMap((Object)"extra").getKeys().contains(handle);
    }

    public ObjectMapValue<String> getExtra(String handle) {
        Util.nullpo((Object)handle);
        return this.raw.getMap((Object)"extra").get((Object)handle);
    }

    public ObjectMap<String> getExtra() {
        return this.raw.getMap((Object)"extra").clone();
    }

    public ObjectMap<String> getRaw() {
        return this.raw.clone();
    }
}

