/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Client.Common.Network.API;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.ME1312.Galaxi.Library.Container.ContainedPair;
import net.ME1312.Galaxi.Library.Container.Pair;
import net.ME1312.Galaxi.Library.Map.ObjectMap;
import net.ME1312.Galaxi.Library.Map.ObjectMapValue;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.SubData.Client.DataClient;
import net.ME1312.SubData.Client.DataSender;
import net.ME1312.SubData.Client.Library.ForwardedDataSender;
import net.ME1312.SubData.Client.Protocol.PacketOut;
import net.ME1312.SubData.Client.SubDataClient;
import net.ME1312.SubServers.Client.Common.ClientAPI;
import net.ME1312.SubServers.Client.Common.Network.API.RemotePlayer;
import net.ME1312.SubServers.Client.Common.Network.API.SimplifiedData;
import net.ME1312.SubServers.Client.Common.Network.Packet.PacketDownloadPlayerInfo;
import net.ME1312.SubServers.Client.Common.Network.Packet.PacketDownloadProxyInfo;

public class Proxy {
    ObjectMap<String> raw;
    private List<RemotePlayer> players = null;
    DataClient client;
    long timestamp;

    public Proxy(ObjectMap<String> raw) {
        this(null, raw);
    }

    Proxy(DataClient client, ObjectMap<String> raw) {
        this.client = client;
        this.load(raw);
    }

    public boolean equals(Object obj) {
        return obj instanceof Proxy && this.getSignature().equals(((Proxy)obj).getSignature());
    }

    private void load(ObjectMap<String> raw) {
        this.raw = raw;
        this.players = null;
        this.timestamp = Calendar.getInstance().getTime().getTime();
    }

    private SubDataClient client() {
        return SimplifiedData.client(this.client);
    }

    public void refresh() {
        String name = this.getName();
        this.client().sendPacket(new PacketOut[]{new PacketDownloadProxyInfo(Collections.singletonList(name), data -> this.load((ObjectMap<String>)data.getMap((Object)name)))});
    }

    public DataSender[] getSubData() {
        ObjectMap subdata = new ObjectMap((Map)this.raw.getObject((Object)"subdata"));
        Object[] keys = subdata.getKeys().toArray(new Integer[0]);
        DataSender[] channels = new DataSender[keys.length];
        Arrays.sort(keys);
        for (int i = 0; i < keys.length; ++i) {
            channels[i] = subdata.isNull(keys[i]) ? null : new ForwardedDataSender((SubDataClient)ClientAPI.getInstance().getSubDataNetwork()[0], subdata.getUUID(keys[i]));
        }
        return channels;
    }

    public String getName() {
        return this.raw.getString((Object)"name");
    }

    public String getDisplayName() {
        return this.raw.getString((Object)"display");
    }

    public boolean isMaster() {
        return this.raw.getBoolean((Object)"master");
    }

    public Collection<Pair<String, UUID>> getPlayers() {
        ArrayList<Pair<String, UUID>> players = new ArrayList<Pair<String, UUID>>();
        for (String id : this.raw.getMap((Object)"players").getKeys()) {
            players.add((Pair<String, UUID>)new ContainedPair((Object)this.raw.getMap((Object)"players").getString((Object)id), (Object)UUID.fromString(id)));
        }
        return players;
    }

    public void getPlayers(Consumer<Collection<RemotePlayer>> callback) {
        Util.nullpo(callback);
        StackTraceElement[] origin = new Throwable().getStackTrace();
        Runnable run = () -> {
            try {
                callback.accept(this.players);
            }
            catch (Throwable e) {
                InvocationTargetException ew = new InvocationTargetException(e);
                ew.setStackTrace(origin);
                ew.printStackTrace();
            }
        };
        if (this.players == null) {
            LinkedList<UUID> ids = new LinkedList<UUID>();
            for (String id : this.raw.getMap((Object)"players").getKeys()) {
                ids.add(UUID.fromString(id));
            }
            this.client().sendPacket(new PacketOut[]{new PacketDownloadPlayerInfo((List<UUID>)ids, (Consumer<ObjectMap<String>>[])new Consumer[]{data -> {
                LinkedList<RemotePlayer> players = new LinkedList<RemotePlayer>();
                for (String player : data.getKeys()) {
                    players.add(RemotePlayer.instance.construct(this, (ObjectMap<String>)data.getMap((Object)player)));
                }
                this.players = players;
                run.run();
            }})});
        } else {
            run.run();
        }
    }

    public final String getSignature() {
        return this.raw.getString((Object)"signature");
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean hasExtra(String handle) {
        Util.nullpo((Object)handle);
        return this.raw.getMap((Object)"extra").getKeys().contains(handle);
    }

    public ObjectMapValue<String> getExtra(String handle) {
        Util.nullpo((Object)handle);
        return this.raw.getMap((Object)"extra").get((Object)handle);
    }

    public ObjectMap<String> getExtra() {
        return this.raw.getMap((Object)"extra").clone();
    }

    public ObjectMap<String> getRaw() {
        return this.raw.clone();
    }
}

