/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Client.Common.Network.API;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Consumer;
import net.ME1312.Galaxi.Library.Container.ContainedPair;
import net.ME1312.Galaxi.Library.Container.Pair;
import net.ME1312.Galaxi.Library.Map.ObjectMap;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.SubData.Client.DataClient;
import net.ME1312.SubData.Client.Protocol.PacketOut;
import net.ME1312.SubData.Client.SubDataClient;
import net.ME1312.SubServers.Client.Common.ClientAPI;
import net.ME1312.SubServers.Client.Common.Network.API.Host;
import net.ME1312.SubServers.Client.Common.Network.API.Proxy;
import net.ME1312.SubServers.Client.Common.Network.API.RemotePlayer;
import net.ME1312.SubServers.Client.Common.Network.API.Server;
import net.ME1312.SubServers.Client.Common.Network.API.SubServer;
import net.ME1312.SubServers.Client.Common.Network.Packet.PacketDownloadGroupInfo;
import net.ME1312.SubServers.Client.Common.Network.Packet.PacketDownloadHostInfo;
import net.ME1312.SubServers.Client.Common.Network.Packet.PacketDownloadPlayerInfo;
import net.ME1312.SubServers.Client.Common.Network.Packet.PacketDownloadProxyInfo;
import net.ME1312.SubServers.Client.Common.Network.Packet.PacketDownloadServerInfo;

public final class SimplifiedData {
    private SimplifiedData() {
    }

    static SubDataClient client(DataClient client) {
        return (SubDataClient)(client != null ? client : ClientAPI.getInstance().getSubDataNetwork()[0]);
    }

    public static void requestHosts(DataClient client, Consumer<Map<String, Host>> callback) {
        Util.nullpo(callback);
        StackTraceElement[] origin = new Throwable().getStackTrace();
        SimplifiedData.client(client).sendPacket(new PacketOut[]{new PacketDownloadHostInfo(null, data -> {
            TreeMap<String, Host> hosts = new TreeMap<String, Host>();
            for (String host : data.getKeys()) {
                hosts.put(host.toLowerCase(), new Host(client, (ObjectMap<String>)data.getMap((Object)host)));
            }
            try {
                callback.accept(hosts);
            }
            catch (Throwable e) {
                InvocationTargetException ew = new InvocationTargetException(e);
                ew.setStackTrace(origin);
                ew.printStackTrace();
            }
        })});
    }

    public static void requestHost(DataClient client, String name, Consumer<Host> callback) {
        Util.nullpo((Object[])new Object[]{name, callback});
        StackTraceElement[] origin = new Throwable().getStackTrace();
        SimplifiedData.client(client).sendPacket(new PacketOut[]{new PacketDownloadHostInfo(Collections.singletonList(name), data -> {
            Host host = null;
            if (data.getKeys().size() > 0) {
                host = new Host(client, (ObjectMap<String>)data.getMap((Object)((String)new LinkedList(data.getKeys()).getFirst())));
            }
            try {
                callback.accept(host);
            }
            catch (Throwable e) {
                InvocationTargetException ew = new InvocationTargetException(e);
                ew.setStackTrace(origin);
                ew.printStackTrace();
            }
        })});
    }

    public static void requestGroups(DataClient client, Consumer<Map<String, List<Server>>> callback) {
        Util.nullpo(callback);
        StackTraceElement[] origin = new Throwable().getStackTrace();
        SimplifiedData.client(client).sendPacket(new PacketOut[]{new PacketDownloadGroupInfo(null, data -> {
            TreeMap groups = new TreeMap();
            for (String group : data.getKeys()) {
                ArrayList<Server> servers = new ArrayList<Server>();
                for (String server : data.getMap((Object)group).getKeys()) {
                    if (data.getMap((Object)group).getMap((Object)server).getString((Object)"type", "Server").equals("SubServer")) {
                        servers.add(new SubServer(client, (ObjectMap<String>)data.getMap((Object)group).getMap((Object)server)));
                        continue;
                    }
                    servers.add(new Server(client, (ObjectMap<String>)data.getMap((Object)group).getMap((Object)server)));
                }
                if (servers.size() <= 0) continue;
                groups.put(group, servers);
            }
            try {
                callback.accept(groups);
            }
            catch (Throwable e) {
                InvocationTargetException ew = new InvocationTargetException(e);
                ew.setStackTrace(origin);
                ew.printStackTrace();
            }
        })});
    }

    public static void requestLowercaseGroups(DataClient client, Consumer<Map<String, List<Server>>> callback) {
        Util.nullpo(callback);
        SimplifiedData.requestGroups(client, groups -> {
            TreeMap<String, List> lowercaseGroups = new TreeMap<String, List>();
            for (String key : groups.keySet()) {
                lowercaseGroups.put(key.toLowerCase(), (List)groups.get(key));
            }
            callback.accept(lowercaseGroups);
        });
    }

    public static void requestGroup(DataClient client, String name, Consumer<Pair<String, List<Server>>> callback) {
        Util.nullpo(callback);
        StackTraceElement[] origin = new Throwable().getStackTrace();
        SimplifiedData.client(client).sendPacket(new PacketOut[]{new PacketDownloadGroupInfo(name == null ? Collections.emptyList() : Collections.singletonList(name), data -> {
            ContainedPair group = null;
            if (data.getKeys().size() > 0) {
                String key = (String)new LinkedList(data.getKeys()).getFirst();
                LinkedList<Server> servers = new LinkedList<Server>();
                for (String server : data.getMap((Object)key).getKeys()) {
                    if (data.getMap((Object)key).getMap((Object)server).getString((Object)"type", "Server").equals("SubServer")) {
                        servers.add(new SubServer(client, (ObjectMap<String>)data.getMap((Object)key).getMap((Object)server)));
                        continue;
                    }
                    servers.add(new Server(client, (ObjectMap<String>)data.getMap((Object)key).getMap((Object)server)));
                }
                group = new ContainedPair((Object)key, servers);
            }
            try {
                callback.accept((Pair<String, List<Server>>)group);
            }
            catch (Throwable e) {
                InvocationTargetException ew = new InvocationTargetException(e);
                ew.setStackTrace(origin);
                ew.printStackTrace();
            }
        })});
    }

    public static void requestServers(DataClient client, Consumer<Map<String, Server>> callback) {
        Util.nullpo(callback);
        StackTraceElement[] origin = new Throwable().getStackTrace();
        SimplifiedData.client(client).sendPacket(new PacketOut[]{new PacketDownloadServerInfo(null, data -> {
            TreeMap<String, Server> servers = new TreeMap<String, Server>();
            for (String server : data.getKeys()) {
                if (data.getMap((Object)server).getString((Object)"type", "Server").equals("SubServer")) {
                    servers.put(server.toLowerCase(), new SubServer(client, (ObjectMap<String>)data.getMap((Object)server)));
                    continue;
                }
                servers.put(server.toLowerCase(), new Server(client, (ObjectMap<String>)data.getMap((Object)server)));
            }
            try {
                callback.accept(servers);
            }
            catch (Throwable e) {
                InvocationTargetException ew = new InvocationTargetException(e);
                ew.setStackTrace(origin);
                ew.printStackTrace();
            }
        })});
    }

    public static void requestServer(DataClient client, String name, Consumer<Server> callback) {
        Util.nullpo((Object[])new Object[]{name, callback});
        StackTraceElement[] origin = new Throwable().getStackTrace();
        SimplifiedData.client(client).sendPacket(new PacketOut[]{new PacketDownloadServerInfo(Collections.singletonList(name), data -> {
            Server server = null;
            if (data.getKeys().size() > 0) {
                String key = (String)new LinkedList(data.getKeys()).getFirst();
                server = data.getMap((Object)key).getString((Object)"type", "Server").equals("SubServer") ? new SubServer(client, (ObjectMap<String>)data.getMap((Object)key)) : new Server(client, (ObjectMap<String>)data.getMap((Object)key));
            }
            try {
                callback.accept(server);
            }
            catch (Throwable e) {
                InvocationTargetException ew = new InvocationTargetException(e);
                ew.setStackTrace(origin);
                ew.printStackTrace();
            }
        })});
    }

    public static void requestSubServers(DataClient client, Consumer<Map<String, SubServer>> callback) {
        Util.nullpo(callback);
        SimplifiedData.requestServers(client, servers -> {
            TreeMap<String, SubServer> subservers = new TreeMap<String, SubServer>();
            for (String server : servers.keySet()) {
                if (!(servers.get(server) instanceof SubServer)) continue;
                subservers.put(server, (SubServer)servers.get(server));
            }
            callback.accept(subservers);
        });
    }

    public static void requestSubServer(DataClient client, String name, Consumer<SubServer> callback) {
        Util.nullpo((Object[])new Object[]{name, callback});
        SimplifiedData.requestServer(client, name, server -> callback.accept(server instanceof SubServer ? (SubServer)server : null));
    }

    public static void requestProxies(DataClient client, Consumer<Map<String, Proxy>> callback) {
        Util.nullpo(callback);
        StackTraceElement[] origin = new Throwable().getStackTrace();
        SimplifiedData.client(client).sendPacket(new PacketOut[]{new PacketDownloadProxyInfo(null, data -> {
            TreeMap<String, Proxy> proxies = new TreeMap<String, Proxy>();
            for (String proxy : data.getKeys()) {
                proxies.put(proxy.toLowerCase(), new Proxy(client, (ObjectMap<String>)data.getMap((Object)proxy)));
            }
            try {
                callback.accept(proxies);
            }
            catch (Throwable e) {
                InvocationTargetException ew = new InvocationTargetException(e);
                ew.setStackTrace(origin);
                ew.printStackTrace();
            }
        })});
    }

    public static void requestProxy(DataClient client, String name, Consumer<Proxy> callback) {
        Util.nullpo((Object[])new Object[]{name, callback});
        StackTraceElement[] origin = new Throwable().getStackTrace();
        SimplifiedData.client(client).sendPacket(new PacketOut[]{new PacketDownloadProxyInfo(Collections.singletonList(name), data -> {
            Proxy proxy = null;
            if (data.getKeys().size() > 0) {
                proxy = new Proxy(client, (ObjectMap<String>)data.getMap((Object)((String)new LinkedList(data.getKeys()).getFirst())));
            }
            try {
                callback.accept(proxy);
            }
            catch (Throwable e) {
                InvocationTargetException ew = new InvocationTargetException(e);
                ew.setStackTrace(origin);
                ew.printStackTrace();
            }
        })});
    }

    public static void requestMasterProxy(DataClient client, Consumer<Proxy> callback) {
        Util.nullpo(callback);
        StackTraceElement[] origin = new Throwable().getStackTrace();
        SimplifiedData.client(client).sendPacket(new PacketOut[]{new PacketDownloadProxyInfo(Collections.emptyList(), data -> {
            Proxy proxy = null;
            if (data.getKeys().size() > 0) {
                proxy = new Proxy(client, (ObjectMap<String>)data.getMap((Object)((String)new LinkedList(data.getKeys()).getFirst())));
            }
            try {
                callback.accept(proxy);
            }
            catch (Throwable e) {
                InvocationTargetException ew = new InvocationTargetException(e);
                ew.setStackTrace(origin);
                ew.printStackTrace();
            }
        })});
    }

    public static void requestRemotePlayers(DataClient client, Consumer<Map<UUID, RemotePlayer>> callback) {
        Util.nullpo(callback);
        StackTraceElement[] origin = new Throwable().getStackTrace();
        SimplifiedData.client(client).sendPacket(new PacketOut[]{new PacketDownloadPlayerInfo((List<UUID>)null, data -> {
            TreeMap<UUID, RemotePlayer> players = new TreeMap<UUID, RemotePlayer>();
            for (String player : data.getKeys()) {
                players.put(UUID.fromString(player), RemotePlayer.instance.construct(client, (ObjectMap<String>)data.getMap((Object)player)));
            }
            try {
                callback.accept(players);
            }
            catch (Throwable e) {
                InvocationTargetException ew = new InvocationTargetException(e);
                ew.setStackTrace(origin);
                ew.printStackTrace();
            }
        })});
    }

    public static void requestRemotePlayer(DataClient client, String name, Consumer<RemotePlayer> callback) {
        Util.nullpo((Object[])new Object[]{name, callback});
        StackTraceElement[] origin = new Throwable().getStackTrace();
        SimplifiedData.client(client).sendPacket(new PacketOut[]{new PacketDownloadPlayerInfo((Collection<String>)Collections.singletonList(name), (Consumer<ObjectMap<String>>[])new Consumer[]{data -> {
            RemotePlayer player = null;
            if (data.getKeys().size() > 0) {
                player = RemotePlayer.instance.construct(client, (ObjectMap<String>)data.getMap((Object)((String)new LinkedList(data.getKeys()).getFirst())));
            }
            try {
                callback.accept(player);
            }
            catch (Throwable e) {
                InvocationTargetException ew = new InvocationTargetException(e);
                ew.setStackTrace(origin);
                ew.printStackTrace();
            }
        }})});
    }

    public static void requestRemotePlayer(DataClient client, UUID id, Consumer<RemotePlayer> callback) {
        Util.nullpo((Object[])new Object[]{id, callback});
        StackTraceElement[] origin = new Throwable().getStackTrace();
        SimplifiedData.client(client).sendPacket(new PacketOut[]{new PacketDownloadPlayerInfo(Collections.singletonList(id), data -> {
            RemotePlayer player = null;
            if (data.getKeys().size() > 0) {
                player = RemotePlayer.instance.construct(client, (ObjectMap<String>)data.getMap((Object)((String)new LinkedList(data.getKeys()).getFirst())));
            }
            try {
                callback.accept(player);
            }
            catch (Throwable e) {
                InvocationTargetException ew = new InvocationTargetException(e);
                ew.setStackTrace(origin);
                ew.printStackTrace();
            }
        })});
    }
}

