/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Client.Common.Network.API;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.IntConsumer;
import net.ME1312.Galaxi.Library.Map.ObjectMap;
import net.ME1312.Galaxi.Library.Try;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.Galaxi.Library.Version.Version;
import net.ME1312.SubData.Client.Protocol.PacketOut;
import net.ME1312.SubData.Client.SubDataClient;
import net.ME1312.SubServers.Client.Common.ClientAPI;
import net.ME1312.SubServers.Client.Common.Network.API.Host;
import net.ME1312.SubServers.Client.Common.Network.API.SubServer;
import net.ME1312.SubServers.Client.Common.Network.Packet.PacketCreateServer;
import net.ME1312.SubServers.Client.Common.Network.Packet.PacketUpdateServer;

public class SubCreator {
    HashMap<String, ServerTemplate> templates = new HashMap();
    Host host;
    ObjectMap<String> raw;

    SubCreator(Host host, ObjectMap<String> raw) {
        this.host = host;
        this.raw = raw;
        for (String template : raw.getMap((Object)"templates").getKeys()) {
            this.templates.put(template.toLowerCase(), new ServerTemplate((ObjectMap<String>)raw.getMap((Object)"templates").getMap((Object)template)));
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof SubCreator && this.host.getSignature().equals(((SubCreator)obj).host.getSignature());
    }

    public void create(UUID player, String name, ServerTemplate template, Version version, Integer port, IntConsumer response) {
        Util.nullpo((Object)response);
        StackTraceElement[] origin = new Throwable().getStackTrace();
        ((SubDataClient)ClientAPI.getInstance().getSubDataNetwork()[0]).sendPacket(new PacketOut[]{new PacketCreateServer(player, name, this.host.getName(), template.getName(), version, port, data -> {
            try {
                response.accept(data.getInt((Object)1));
            }
            catch (Throwable e) {
                InvocationTargetException ew = new InvocationTargetException(e);
                ew.setStackTrace(origin);
                ew.printStackTrace();
            }
        })});
    }

    public void create(String name, ServerTemplate template, Version version, Integer port, IntConsumer response) {
        this.create(null, name, template, version, port, response);
    }

    public void create(UUID player, String name, ServerTemplate template, Version version, Integer port) {
        this.create(player, name, template, version, port, i -> {});
    }

    public void create(String name, ServerTemplate template, Version version, Integer port) {
        this.create(name, template, version, port, (int i) -> {});
    }

    public void update(UUID player, SubServer server, ServerTemplate template, Version version, IntConsumer response) {
        Util.nullpo((Object)response);
        StackTraceElement[] origin = new Throwable().getStackTrace();
        ((SubDataClient)ClientAPI.getInstance().getSubDataNetwork()[0]).sendPacket(new PacketOut[]{new PacketUpdateServer(player, server.getName(), template.getName(), version, data -> {
            try {
                response.accept(data.getInt((Object)1));
            }
            catch (Throwable e) {
                InvocationTargetException ew = new InvocationTargetException(e);
                ew.setStackTrace(origin);
                ew.printStackTrace();
            }
        })});
    }

    public void update(UUID player, SubServer server, ServerTemplate template, Version version) {
        this.update(player, server, template, version, null);
    }

    public void update(SubServer server, ServerTemplate template, Version version, IntConsumer response) {
        this.update(null, server, template, version, response);
    }

    public void update(SubServer server, ServerTemplate template, Version version) {
        this.update(null, server, template, version);
    }

    public void update(UUID player, SubServer server, Version version) {
        this.update(player, server, null, version);
    }

    public void update(SubServer server, Version version) {
        this.update(null, server, version);
    }

    public Host getHost() {
        return this.host;
    }

    public Map<String, ServerTemplate> getTemplates() {
        return new TreeMap<String, ServerTemplate>(this.templates);
    }

    public ServerTemplate getTemplate(String name) {
        return this.getTemplates().get(name.toLowerCase());
    }

    public static class ServerTemplate {
        private ObjectMap<String> raw;
        private ServerType type;

        public ServerTemplate(ObjectMap<String> raw) {
            this.raw = raw;
            this.type = (ServerType)((Object)Try.all.get(() -> ServerType.valueOf(raw.getString((Object)"type").toUpperCase().replace('-', '_').replace(' ', '_')), (Object)ServerType.CUSTOM));
        }

        public String getName() {
            return this.raw.getString((Object)"name");
        }

        public String getDisplayName() {
            return this.raw.getString((Object)"display");
        }

        public boolean isEnabled() {
            return this.raw.getBoolean((Object)"enabled");
        }

        public String getIcon() {
            return this.raw.getString((Object)"icon");
        }

        public ServerType getType() {
            return this.type;
        }

        public boolean requiresVersion() {
            return this.raw.getBoolean((Object)"version-req");
        }

        public boolean canUpdate() {
            return this.raw.getBoolean((Object)"can-update");
        }
    }

    public static enum ServerType {
        SPIGOT,
        VANILLA,
        FORGE,
        SPONGE,
        CUSTOM;


        public String toString() {
            return super.toString().substring(0, 1).toUpperCase() + super.toString().substring(1).toLowerCase();
        }
    }
}

