/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Client.Common.Network.Packet;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.Consumer;
import net.ME1312.Galaxi.Library.Map.ObjectMap;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.SubData.Client.Protocol.PacketObjectIn;
import net.ME1312.SubData.Client.Protocol.PacketObjectOut;
import net.ME1312.SubData.Client.SubDataSender;

public class PacketAddServer
implements PacketObjectIn<Integer>,
PacketObjectOut<Integer> {
    private static HashMap<UUID, Consumer<ObjectMap<Integer>>[]> callbacks = new HashMap();
    private UUID player;
    private String name;
    private ObjectMap<String> opt;
    private boolean subserver;
    private UUID tracker;

    public PacketAddServer() {
    }

    @SafeVarargs
    public PacketAddServer(UUID player, String name, InetAddress ip, int port, String motd, boolean hidden, boolean restricted, Consumer<ObjectMap<Integer>> ... callback) {
        Util.nullpo((Object[])new Serializable[]{name, ip, Integer.valueOf(port), motd, Boolean.valueOf(hidden), Boolean.valueOf(restricted)});
        this.player = player;
        this.name = name;
        this.subserver = false;
        ObjectMap opt = new ObjectMap();
        opt.set((Object)"address", (Object)(ip.getHostAddress() + ':' + port));
        opt.set((Object)"motd", (Object)motd);
        opt.set((Object)"restricted", (Object)restricted);
        opt.set((Object)"hidden", (Object)hidden);
        this.opt = opt;
        this.tracker = (UUID)Util.getNew(callbacks.keySet(), UUID::randomUUID);
        callbacks.put(this.tracker, callback);
    }

    @SafeVarargs
    public PacketAddServer(UUID player, String name, boolean enabled, String host, int port, String motd, boolean log, String directory, String executable, String stopcmd, boolean hidden, boolean restricted, Consumer<ObjectMap<Integer>> ... callback) {
        Util.nullpo((Object[])new Serializable[]{host, name, Boolean.valueOf(enabled), Integer.valueOf(port), motd, Boolean.valueOf(log), directory, executable, stopcmd, Boolean.valueOf(hidden), Boolean.valueOf(restricted)});
        this.player = player;
        this.name = name;
        this.subserver = true;
        ObjectMap opt = new ObjectMap();
        opt.set((Object)"enabled", (Object)enabled);
        opt.set((Object)"host", (Object)host);
        opt.set((Object)"port", (Object)port);
        opt.set((Object)"motd", (Object)motd);
        opt.set((Object)"log", (Object)log);
        opt.set((Object)"dir", (Object)directory);
        opt.set((Object)"exec", (Object)executable);
        opt.set((Object)"stop-cmd", (Object)stopcmd);
        opt.set((Object)"restricted", (Object)restricted);
        opt.set((Object)"hidden", (Object)hidden);
        this.opt = opt;
        this.tracker = (UUID)Util.getNew(callbacks.keySet(), UUID::randomUUID);
        callbacks.put(this.tracker, callback);
    }

    public ObjectMap<Integer> send(SubDataSender client) {
        ObjectMap data = new ObjectMap();
        data.set((Object)0, (Object)this.tracker);
        data.set((Object)1, (Object)this.name);
        data.set((Object)2, (Object)this.subserver);
        data.set((Object)3, this.opt);
        if (this.player != null) {
            data.set((Object)4, (Object)this.player);
        }
        return data;
    }

    public void receive(SubDataSender client, ObjectMap<Integer> data) {
        for (Consumer<ObjectMap<Integer>> callback : callbacks.remove(data.getUUID((Object)0))) {
            callback.accept(data);
        }
    }
}

