/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Client.Common.Network.Packet;

import java.io.Serializable;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.Consumer;
import net.ME1312.Galaxi.Library.Map.ObjectMap;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.Galaxi.Library.Version.Version;
import net.ME1312.SubData.Client.Protocol.PacketObjectIn;
import net.ME1312.SubData.Client.Protocol.PacketObjectOut;
import net.ME1312.SubData.Client.SubDataSender;

public class PacketCreateServer
implements PacketObjectIn<Integer>,
PacketObjectOut<Integer> {
    private static HashMap<UUID, Consumer<ObjectMap<Integer>>[]> callbacks = new HashMap();
    private UUID player;
    private String name;
    private String host;
    private String template;
    private Version version;
    private Integer port;
    private boolean waitfor;
    private UUID tracker;

    public PacketCreateServer() {
    }

    @SafeVarargs
    public PacketCreateServer(UUID player, String name, String host, String template, Version version, Integer port, Consumer<ObjectMap<Integer>> ... callback) {
        this(player, name, host, template, version, port, false, callback);
    }

    @SafeVarargs
    public PacketCreateServer(UUID player, String name, String host, String template, Version version, Integer port, boolean waitfor, Consumer<ObjectMap<Integer>> ... callback) {
        Util.nullpo((Object[])new Serializable[]{name, host, template, callback});
        this.player = player;
        this.name = name;
        this.host = host;
        this.template = template;
        this.version = version;
        this.port = port;
        this.waitfor = waitfor;
        this.tracker = (UUID)Util.getNew(callbacks.keySet(), UUID::randomUUID);
        callbacks.put(this.tracker, callback);
    }

    public ObjectMap<Integer> send(SubDataSender client) {
        ObjectMap data = new ObjectMap();
        data.set((Object)0, (Object)this.tracker);
        data.set((Object)1, (Object)this.name);
        data.set((Object)2, (Object)this.host);
        data.set((Object)3, (Object)this.template);
        if (this.version != null) {
            data.set((Object)4, (Object)this.version);
        }
        if (this.port != null) {
            data.set((Object)5, (Object)this.port);
        }
        if (this.player != null) {
            data.set((Object)6, (Object)this.player);
        }
        if (this.waitfor) {
            data.set((Object)7, (Object)true);
        }
        return data;
    }

    public void receive(SubDataSender client, ObjectMap<Integer> data) {
        for (Consumer<ObjectMap<Integer>> callback : callbacks.remove(data.getUUID((Object)0))) {
            callback.accept(data);
        }
    }
}

