/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Client.Common.Network.Packet;

import java.io.Serializable;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.Consumer;
import net.ME1312.Galaxi.Library.Map.ObjectMap;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.SubData.Client.Protocol.PacketObjectIn;
import net.ME1312.SubData.Client.Protocol.PacketObjectOut;
import net.ME1312.SubData.Client.SubDataSender;

public class PacketStartServer
implements PacketObjectIn<Integer>,
PacketObjectOut<Integer> {
    private static HashMap<UUID, Consumer<ObjectMap<Integer>>[]> callbacks = new HashMap();
    private UUID player;
    private String server;
    private UUID tracker;

    public PacketStartServer() {
    }

    @SafeVarargs
    public PacketStartServer(UUID player, String server, Consumer<ObjectMap<Integer>> ... callback) {
        Util.nullpo((Object[])new Serializable[]{server, callback});
        this.player = player;
        this.server = server;
        this.tracker = (UUID)Util.getNew(callbacks.keySet(), UUID::randomUUID);
        callbacks.put(this.tracker, callback);
    }

    public ObjectMap<Integer> send(SubDataSender client) {
        ObjectMap data = new ObjectMap();
        data.set((Object)0, (Object)this.tracker);
        data.set((Object)1, (Object)this.server);
        if (this.player != null) {
            data.set((Object)2, (Object)this.player);
        }
        return data;
    }

    public void receive(SubDataSender client, ObjectMap<Integer> data) {
        for (Consumer<ObjectMap<Integer>> callback : callbacks.remove(data.getUUID((Object)0))) {
            callback.accept(data);
        }
    }
}

