/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubData.Server;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.SubData.Server.DataClient;
import net.ME1312.SubData.Server.DataProtocol;

public abstract class DataServer {
    private static final Pattern REG_ADRESS_PATTERN = Pattern.compile("^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$");
    private static final Pattern REG_ALLOWED_PATTERN = Pattern.compile("^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})(?:/(\\d{1,2}))?$");
    public final Events on = new Events();
    HashMap<String, Boolean> whitelist = new HashMap();

    public abstract DataProtocol getProtocol();

    public abstract DataClient getClient(UUID var1);

    public abstract Map<UUID, ? extends DataClient> getClients();

    public abstract void removeClient(DataClient var1) throws IOException;

    public abstract void removeClient(UUID var1) throws IOException;

    public void whitelist(String address) {
        Util.nullpo((Object)address);
        this.whitelist.put(address, true);
    }

    boolean isWhitelisted(InetAddress address) {
        ArrayList<String> whitelist = new ArrayList<String>(this.getProtocol().whitelist);
        for (String next : this.whitelist.keySet()) {
            if (this.whitelist.get(next).booleanValue()) {
                whitelist.add(next);
                continue;
            }
            whitelist.remove(next);
        }
        boolean whitelisted = false;
        Matcher regMatcher = REG_ADRESS_PATTERN.matcher(address.getHostAddress());
        if (regMatcher.find()) {
            int rip = 0;
            for (int i = 1; i <= 4; ++i) {
                int octet = Integer.parseInt(regMatcher.group(i));
                if (octet > 255) {
                    octet = 255;
                }
                rip = (rip << 8) + octet;
            }
            for (String allowed : whitelist) {
                int sub;
                Matcher regallowed;
                if (whitelisted || !(regallowed = REG_ALLOWED_PATTERN.matcher(allowed)).find()) continue;
                int n = sub = regallowed.group(5) == null ? 32 : Integer.parseInt(regallowed.group(5));
                if (sub > 32) {
                    sub = 32;
                }
                sub = sub > 0 ? -1 << 32 - sub : 0;
                int aip = 0;
                for (int i = 1; i <= 4; ++i) {
                    int octet = Integer.parseInt(regallowed.group(i));
                    if (octet > 255) {
                        octet = 255;
                    }
                    aip = (aip << 8) + octet;
                }
                if ((rip & sub) != aip) continue;
                whitelisted = true;
            }
        }
        return whitelisted;
    }

    public void unwhitelist(String address) {
        Util.nullpo((Object)address);
        if (this.getProtocol().whitelist.contains(address)) {
            this.whitelist.put(address, false);
        } else {
            this.whitelist.remove(address);
        }
    }

    public abstract void close() throws IOException;

    public void waitFor() throws InterruptedException {
        while (!this.isClosed()) {
            Thread.sleep(125L);
        }
    }

    public abstract boolean isClosed();

    public static class Events {
        LinkedList<Function<DataClient, Boolean>> connect = new LinkedList();
        LinkedList<Function<DataServer, Boolean>> close = new LinkedList();
        LinkedList<Consumer<DataServer>> closed = new LinkedList();

        private Events() {
        }

        @SafeVarargs
        public final void connect(Function<DataClient, Boolean> ... callbacks) {
            this.connect.addAll(Arrays.asList(callbacks));
        }

        @SafeVarargs
        public final void close(Function<DataServer, Boolean> ... callbacks) {
            this.close.addAll(Arrays.asList(callbacks));
        }

        @SafeVarargs
        public final void closed(Consumer<DataServer> ... callbacks) {
            this.closed.addAll(Arrays.asList(callbacks));
        }
    }
}

