/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Bungee.Host.External;

import com.google.common.collect.Range;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import net.ME1312.Galaxi.Library.Map.ObjectMap;
import net.ME1312.Galaxi.Library.Try;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.SubData.Server.ClientHandler;
import net.ME1312.SubData.Server.DataClient;
import net.ME1312.SubData.Server.Protocol.PacketOut;
import net.ME1312.SubData.Server.SubDataClient;
import net.ME1312.SubServers.Bungee.Event.SubAddServerEvent;
import net.ME1312.SubServers.Bungee.Event.SubRemoveServerEvent;
import net.ME1312.SubServers.Bungee.Host.External.ExternalSubCreator;
import net.ME1312.SubServers.Bungee.Host.External.ExternalSubLogger;
import net.ME1312.SubServers.Bungee.Host.External.ExternalSubServer;
import net.ME1312.SubServers.Bungee.Host.Host;
import net.ME1312.SubServers.Bungee.Host.SubCreator;
import net.ME1312.SubServers.Bungee.Host.SubServer;
import net.ME1312.SubServers.Bungee.Library.Compatibility.Logger;
import net.ME1312.SubServers.Bungee.Library.Exception.InvalidServerException;
import net.ME1312.SubServers.Bungee.Network.Packet.PacketExAddServer;
import net.ME1312.SubServers.Bungee.Network.Packet.PacketExDeleteServer;
import net.ME1312.SubServers.Bungee.Network.Packet.PacketExRemoveServer;
import net.ME1312.SubServers.Bungee.Network.Packet.PacketOutExReset;
import net.ME1312.SubServers.Bungee.SubProxy;
import net.md_5.bungee.api.plugin.Event;

public class ExternalHost
extends Host
implements ClientHandler {
    private HashMap<Integer, SubDataClient> subdata = new HashMap();
    private HashMap<String, SubServer> servers = new HashMap();
    private String name;
    boolean available;
    private boolean enabled;
    private InetAddress address;
    private SubCreator creator;
    private String directory;
    private LinkedList<PacketOut> queue;
    private boolean clean;
    SubProxy plugin;

    public ExternalHost(SubProxy plugin, String name, boolean enabled, Range<Integer> ports, boolean log, InetAddress address, String directory, String gitBash) {
        super(plugin, name, enabled, ports, log, address, directory, gitBash);
        this.plugin = plugin;
        this.name = name;
        this.available = false;
        this.enabled = enabled;
        this.address = address;
        this.creator = new ExternalSubCreator(this, ports, log, gitBash);
        this.directory = directory;
        this.queue = new LinkedList();
        this.clean = false;
        this.subdata.put(0, null);
    }

    public DataClient[] getSubData() {
        Object[] keys = this.subdata.keySet().toArray(new Integer[0]);
        DataClient[] channels = new DataClient[keys.length];
        Arrays.sort(keys);
        for (int i = 0; i < keys.length; ++i) {
            channels[i] = (DataClient)this.subdata.get(keys[i]);
        }
        return channels;
    }

    public void setSubData(DataClient client, int channel) {
        if (channel < 0) {
            throw new IllegalArgumentException("Subchannel ID cannot be less than zero");
        }
        if (client == null && channel == 0) {
            this.available = false;
        }
        if (client != null || channel == 0) {
            if (!this.subdata.containsKey(channel) || channel == 0 && (client == null || this.subdata.get(channel) == null)) {
                this.subdata.put(channel, (SubDataClient)client);
                if (!(client == null || client.getHandler() != null && this.equals(client.getHandler()))) {
                    ((SubDataClient)client).setHandler((ClientHandler)this);
                }
            }
        } else {
            this.subdata.remove(channel);
        }
    }

    public void removeSubData(DataClient client) {
        for (Integer channel : Util.getBackwards(this.subdata, (Object)((SubDataClient)client))) {
            this.setSubData(null, channel);
        }
    }

    void queue(PacketOut ... packet) {
        for (PacketOut p : packet) {
            if (this.getSubData()[0] == null || !this.available) {
                this.queue.add(p);
                continue;
            }
            ((SubDataClient)this.getSubData()[0]).sendPacket(new PacketOut[]{p});
        }
    }

    private void requeue() {
        SubDataClient client = (SubDataClient)this.getSubData()[0];
        if (!this.clean) {
            client.sendPacket(new PacketOut[]{new PacketOutExReset("Prevent Desync")});
            this.clean = true;
        }
        HashSet<String> served = new HashSet<String>();
        LinkedList<PacketOut> queue = this.queue;
        this.queue = new LinkedList();
        PacketOut[] payload = new PacketOut[queue.size()];
        for (int i = 0; i < payload.length; ++i) {
            PacketOut packet = queue.get(i);
            if (packet instanceof PacketExAddServer) {
                served.add(((PacketExAddServer)packet).peek());
            }
            payload[i] = packet;
        }
        for (SubServer server : this.servers.values()) {
            if (served.contains(server.getName())) continue;
            client.sendPacket(new PacketOut[]{new PacketExAddServer((ExternalSubServer)server, server.isRunning() ? ((ExternalSubLogger)server.getLogger()).getExternalAddress() : null, data -> {
                if (data.contains((Object)2)) {
                    ((ExternalSubServer)server).started(data.getUUID((Object)2));
                } else if (server.isRunning()) {
                    ((ExternalSubServer)server).stopped(false);
                }
            })});
        }
        client.sendPacket(payload);
        this.available = true;
        while (this.queue.size() != 0) {
            client.sendPacket(new PacketOut[]{this.queue.remove(0)});
        }
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    @Override
    public InetAddress getAddress() {
        return this.address;
    }

    @Override
    public String getPath() {
        return this.directory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public SubCreator getCreator() {
        return this.creator;
    }

    @Override
    public Map<String, ? extends SubServer> getSubServers() {
        return new TreeMap<String, SubServer>(this.servers);
    }

    @Override
    public SubServer getSubServer(String name) {
        if (Util.isNull((Object)name)) {
            return null;
        }
        return this.servers.get(name.toLowerCase());
    }

    @Override
    public SubServer constructSubServer(String name, boolean enabled, int port, String motd, boolean log, String directory, String executable, String stopcmd, boolean hidden, boolean restricted) throws InvalidServerException {
        return ExternalSubServer.construct(this, name, enabled, port, motd, log, directory, executable, stopcmd, hidden, restricted);
    }

    @Override
    public boolean addSubServer(UUID player, SubServer server) throws InvalidServerException {
        if (server.getHost() != this) {
            throw new IllegalArgumentException("That Server does not belong to this Host!");
        }
        if (this.plugin.api.getServers().containsKey(server.getName().toLowerCase())) {
            throw new InvalidServerException("A Server already exists with this name!");
        }
        SubAddServerEvent event = new SubAddServerEvent(player, this, server);
        this.plugin.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            this.queue(new PacketOut[]{new PacketExAddServer((ExternalSubServer)server, server.isRunning() ? ((ExternalSubLogger)server.getLogger()).getExternalAddress() : null, data -> {
                if (data.contains((Object)2)) {
                    ((ExternalSubServer)server).started(data.getUUID((Object)2));
                }
                ((ExternalSubServer)server).registered(true);
            })});
            this.servers.put(server.getName().toLowerCase(), server);
            return true;
        }
        return false;
    }

    @Override
    protected boolean removeSubServer(UUID player, String name, boolean forced) throws InterruptedException {
        Util.nullpo((Object)name);
        ExternalSubServer server = (ExternalSubServer)this.servers.get(name.toLowerCase());
        SubRemoveServerEvent event = new SubRemoveServerEvent(player, this, server);
        this.plugin.getPluginManager().callEvent((Event)event);
        if (forced || !event.isCancelled()) {
            server.registered(false);
            if (server.isRunning()) {
                server.stop();
                server.waitFor();
            }
            this.servers.remove(name.toLowerCase());
            this.queue(new PacketOut[]{new PacketExRemoveServer(name.toLowerCase(), data -> {
                if (data.getInt((Object)1) != 0 && data.getInt((Object)1) != 1) {
                    server.registered(true);
                    this.servers.put(name.toLowerCase(), server);
                }
            })});
            return true;
        }
        return false;
    }

    @Override
    protected boolean recycleSubServer(UUID player, String name, boolean forced) throws InterruptedException {
        Util.nullpo((Object)name);
        ExternalSubServer s = (ExternalSubServer)this.servers.get(name.toLowerCase());
        String server = s.getName();
        SubRemoveServerEvent event = new SubRemoveServerEvent(player, this, s);
        this.plugin.getPluginManager().callEvent((Event)event);
        if (forced || !event.isCancelled()) {
            s.registered(false);
            if (s.isRunning()) {
                s.stop();
                s.waitFor();
            }
            Logger.get((String)"SubServers").info("Saving...");
            ObjectMap info = this.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(server) ? this.plugin.servers.get().getMap((Object)"Servers").getMap((Object)server).clone() : new ObjectMap();
            info.set((Object)"Name", (Object)server);
            info.set((Object)"Timestamp", (Object)Calendar.getInstance().getTime().getTime());
            try {
                if (this.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(server)) {
                    this.plugin.servers.get().getMap((Object)"Servers").remove((Object)server);
                    this.plugin.servers.save();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Logger.get((String)"SubServers").info("Moving Files...");
            this.queue(new PacketOut[]{new PacketExDeleteServer(server, (ObjectMap<String>)info, true, data -> {
                if (data.getInt((Object)1) == 0 || data.getInt((Object)1) == 1) {
                    this.servers.remove(server.toLowerCase());
                    Logger.get((String)"SubServers").info("Deleted SubServer: " + server);
                } else {
                    s.registered(true);
                    Logger.get((String)"SubServers").info("Couldn't remove " + server + " from memory. See " + this.getName() + " console for more details");
                }
            })});
            return true;
        }
        return false;
    }

    @Override
    protected boolean deleteSubServer(UUID player, String name, boolean forced) throws InterruptedException {
        Util.nullpo((Object)name);
        ExternalSubServer s = (ExternalSubServer)this.servers.get(name.toLowerCase());
        String server = s.getName();
        SubRemoveServerEvent event = new SubRemoveServerEvent(player, this, this.getSubServer(server));
        this.plugin.getPluginManager().callEvent((Event)event);
        if (forced || !event.isCancelled()) {
            s.registered(false);
            if (s.isRunning()) {
                s.stop();
                s.waitFor();
            }
            Logger.get((String)"SubServers").info("Saving...");
            ObjectMap info = this.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(server) ? this.plugin.servers.get().getMap((Object)"Servers").getMap((Object)server).clone() : new ObjectMap();
            info.set((Object)"Name", (Object)server);
            info.set((Object)"Timestamp", (Object)Calendar.getInstance().getTime().getTime());
            try {
                if (this.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(server)) {
                    this.plugin.servers.get().getMap((Object)"Servers").remove((Object)server);
                    this.plugin.servers.save();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Logger.get((String)"SubServers").info("Removing Files...");
            this.queue(new PacketOut[]{new PacketExDeleteServer(server, (ObjectMap<String>)info, false, data -> {
                if (data.getInt((Object)1) == 0 || data.getInt((Object)1) == 1) {
                    this.servers.remove(server.toLowerCase());
                    Logger.get((String)"SubServers").info("Deleted SubServer: " + server);
                } else {
                    s.registered(true);
                    Logger.get((String)"SubServers").info("Couldn't remove " + server + " from memory. See " + this.getName() + " console for more details");
                }
            })});
            return true;
        }
        return false;
    }

    @Override
    public boolean destroy() {
        if (((Boolean)Try.all.get(() -> (Boolean)Util.reflect((Field)SubProxy.class.getDeclaredField("running"), (Object)((Object)this.plugin)), (Object)true)).booleanValue()) {
            return super.destroy();
        }
        return true;
    }

    @Override
    public ObjectMap<String> forSubData() {
        ObjectMap<String> hinfo = super.forSubData();
        ObjectMap subdata = new ObjectMap();
        for (int channel : this.subdata.keySet()) {
            subdata.set((Object)channel, this.subdata.get(channel) == null ? null : this.subdata.get(channel).getID());
        }
        hinfo.set((Object)"subdata", (Object)subdata);
        return hinfo;
    }
}

