/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Bungee.Host.External;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import net.ME1312.Galaxi.Library.Container.Value;
import net.ME1312.Galaxi.Library.Try;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.SubServers.Bungee.Host.SubLogFilter;
import net.ME1312.SubServers.Bungee.Host.SubLogger;
import net.ME1312.SubServers.Bungee.Library.Compatibility.Logger;
import net.ME1312.SubServers.Bungee.Network.Packet.PacketInExLogMessage;
import net.ME1312.SubServers.Bungee.SubAPI;

public class ExternalSubLogger
extends SubLogger {
    private Object handle;
    UUID id = null;
    String name;
    Value<Boolean> log;
    private List<SubLogFilter> filters = new CopyOnWriteArrayList<SubLogFilter>();
    File file;
    private PrintWriter writer = null;
    private boolean started = false;

    ExternalSubLogger(Object user, String name, Value<Boolean> log, File file) {
        this.handle = user;
        this.name = name;
        this.log = log;
        this.file = file;
    }

    @Override
    public void start() {
        this.id = PacketInExLogMessage.register(this);
        this.started = true;
        if (this.file != null && this.writer == null) {
            try {
                this.writer = new PrintWriter(this.file, "UTF-8");
                this.writer.println("---------- LOG START \u2014 " + this.name + " ----------");
                this.writer.flush();
            }
            catch (FileNotFoundException | UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        ArrayList<SubLogFilter> filters = new ArrayList<SubLogFilter>();
        filters.addAll(this.filters);
        for (SubLogFilter filter : filters) {
            try {
                filter.start();
            }
            catch (Throwable e) {
                new InvocationTargetException(e, "Exception while running SubLogger Event").printStackTrace();
            }
        }
    }

    private void log(int type, String msg) {
        if (this.started) {
            Level level;
            switch (type) {
                case 80: {
                    level = Level.FINE;
                    break;
                }
                case 40: {
                    level = Level.WARNING;
                    break;
                }
                case 20: 
                case 30: {
                    level = Level.SEVERE;
                    break;
                }
                default: {
                    level = Level.INFO;
                }
            }
            boolean allow = SubAPI.getInstance().getInternals().sudo == this.getHandler() && SubAPI.getInstance().getInternals().canSudo || (Boolean)this.log.value() != false && (SubAPI.getInstance().getInternals().sudo == null || !SubAPI.getInstance().getInternals().canSudo);
            ArrayList<SubLogFilter> filters = new ArrayList<SubLogFilter>();
            filters.addAll(this.filters);
            for (SubLogFilter filter : filters) {
                try {
                    allow = filter.log(level, msg) && allow;
                }
                catch (Throwable e) {
                    new InvocationTargetException(e, "Exception while running SubLogger Event").printStackTrace();
                }
            }
            if (allow) {
                Logger.get((String)this.name).log(level, msg);
            }
            if (this.writer != null) {
                this.writer.println('[' + new SimpleDateFormat("HH:mm:ss").format(Calendar.getInstance().getTime()) + "] [" + level + "] > " + msg);
                this.writer.flush();
            }
        }
    }

    public UUID getExternalAddress() {
        return this.id;
    }

    @Override
    public void registerFilter(SubLogFilter filter) {
        Util.nullpo((Object)filter);
        this.filters.add(filter);
    }

    @Override
    public void unregisterFilter(SubLogFilter filter) {
        Util.nullpo((Object)filter);
        Try.all.run(() -> this.filters.remove(filter));
    }

    @Override
    public void stop() {
        if (this.started) {
            this.id = null;
            this.started = false;
            ArrayList<SubLogFilter> filters = new ArrayList<SubLogFilter>();
            filters.addAll(this.filters);
            for (SubLogFilter filter : filters) {
                try {
                    filter.stop();
                }
                catch (Throwable e) {
                    new InvocationTargetException(e, "Exception while running SubLogger Event").printStackTrace();
                }
            }
            if (this.writer != null) {
                PrintWriter writer = this.writer;
                this.writer = null;
                int l = (("---------- LOG START \u2014 " + this.name + " ----------").length() - 9) / 2;
                String s = "";
                while (s.length() < l) {
                    s = s + '-';
                }
                writer.println(s + " LOG END " + s);
                writer.close();
            }
        }
    }

    @Override
    public Object getHandler() {
        return this.handle;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isLogging() {
        return (Boolean)this.log.value();
    }
}

