/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Bungee.Host;

import com.google.common.collect.Range;
import java.net.InetAddress;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import net.ME1312.Galaxi.Library.ExtraDataHandler;
import net.ME1312.Galaxi.Library.Map.ObjectMap;
import net.ME1312.Galaxi.Library.Map.ObjectMapValue;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.SubServers.Bungee.Host.RemotePlayer;
import net.ME1312.SubServers.Bungee.Host.SubCreator;
import net.ME1312.SubServers.Bungee.Host.SubServer;
import net.ME1312.SubServers.Bungee.Library.Compatibility.Logger;
import net.ME1312.SubServers.Bungee.Library.Exception.InvalidHostException;
import net.ME1312.SubServers.Bungee.Library.Exception.InvalidServerException;
import net.ME1312.SubServers.Bungee.SubAPI;
import net.ME1312.SubServers.Bungee.SubProxy;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public abstract class Host
implements ExtraDataHandler<String> {
    private final ObjectMap<String> extra = new ObjectMap();
    private final String signature;
    private String nick = null;

    public Host(SubProxy plugin, String name, boolean enabled, Range<Integer> ports, boolean log, InetAddress address, String directory, String gitBash) {
        if (name.contains(" ")) {
            throw new InvalidHostException("Host names cannot have spaces: " + name);
        }
        if (!ports.hasLowerBound() || !ports.hasUpperBound()) {
            throw new InvalidHostException("Port range is not bound");
        }
        Util.nullpo((Object[])new Object[]{plugin, name, enabled, ports, log, address, directory, gitBash});
        this.signature = plugin.api.signAnonymousObject();
        SubAPI.getInstance().getInternals().subprotocol.whitelist(address.getHostAddress());
    }

    public boolean isAvailable() {
        return true;
    }

    public abstract boolean isEnabled();

    public abstract void setEnabled(boolean var1);

    public abstract InetAddress getAddress();

    public abstract String getPath();

    public abstract String getName();

    public String getDisplayName() {
        return this.nick == null ? this.getName() : this.nick;
    }

    public void setDisplayName(String value) {
        this.nick = value == null || value.length() == 0 || this.getName().equals(value) ? null : value;
    }

    public Collection<ProxiedPlayer> getPlayers() {
        LinkedList<ProxiedPlayer> players = new LinkedList<ProxiedPlayer>();
        for (SubServer subServer : this.getSubServers().values()) {
            players.addAll(subServer.getPlayers());
        }
        return players;
    }

    public Collection<RemotePlayer> getRemotePlayers() {
        LinkedList<RemotePlayer> players = new LinkedList<RemotePlayer>();
        for (SubServer subServer : this.getSubServers().values()) {
            players.addAll(subServer.getRemotePlayers());
        }
        return players;
    }

    public int start(String ... servers) {
        return this.start((UUID)null, servers);
    }

    public int start(UUID player, String ... servers) {
        int i = 0;
        for (String server : servers) {
            if (!this.getSubServer(server.toLowerCase()).start(player)) continue;
            ++i;
        }
        return i;
    }

    public int stop(String ... servers) {
        return this.stop((UUID)null, servers);
    }

    public int stop(UUID player, String ... servers) {
        int i = 0;
        for (String server : servers) {
            if (!this.getSubServer(server.toLowerCase()).stop(player)) continue;
            ++i;
        }
        return i;
    }

    public int terminate(String ... servers) {
        return this.terminate((UUID)null, servers);
    }

    public int terminate(UUID player, String ... servers) {
        int i = 0;
        for (String server : servers) {
            if (!this.getSubServer(server.toLowerCase()).terminate(player)) continue;
            ++i;
        }
        return i;
    }

    public int command(String command, String ... servers) {
        return this.command((UUID)null, command, servers);
    }

    public int command(UUID player, String command, String ... servers) {
        int i = 0;
        for (String server : servers) {
            if (!this.getSubServer(server.toLowerCase()).command(player, command)) continue;
            ++i;
        }
        return i;
    }

    public abstract SubCreator getCreator();

    public abstract Map<String, ? extends SubServer> getSubServers();

    public abstract SubServer getSubServer(String var1);

    public abstract SubServer constructSubServer(String var1, boolean var2, int var3, String var4, boolean var5, String var6, String var7, String var8, boolean var9, boolean var10) throws InvalidServerException;

    public SubServer addSubServer(String name, boolean enabled, int port, String motd, boolean log, String directory, String executable, String stopcmd, boolean hidden, boolean restricted) throws InvalidServerException {
        return this.addSubServer(null, name, enabled, port, motd, log, directory, executable, stopcmd, hidden, restricted);
    }

    public SubServer addSubServer(UUID player, String name, boolean enabled, int port, String motd, boolean log, String directory, String executable, String stopcmd, boolean hidden, boolean restricted) throws InvalidServerException {
        SubServer server = this.constructSubServer(name, enabled, port, motd, log, directory, executable, stopcmd, hidden, restricted);
        return this.addSubServer(player, server) ? server : null;
    }

    public boolean addSubServer(SubServer server) throws InvalidServerException {
        return this.addSubServer(null, server);
    }

    public abstract boolean addSubServer(UUID var1, SubServer var2) throws InvalidServerException;

    public boolean removeSubServer(String name) throws InterruptedException {
        return this.removeSubServer(null, name);
    }

    public boolean removeSubServer(UUID player, String name) throws InterruptedException {
        return this.removeSubServer(player, name, false);
    }

    protected abstract boolean removeSubServer(UUID var1, String var2, boolean var3) throws InterruptedException;

    public boolean forceRemoveSubServer(String name) throws InterruptedException {
        return this.forceRemoveSubServer(null, name);
    }

    public boolean forceRemoveSubServer(UUID player, String name) throws InterruptedException {
        return this.removeSubServer(player, name, true);
    }

    public boolean recycleSubServer(String name) throws InterruptedException {
        return this.recycleSubServer(null, name);
    }

    public boolean recycleSubServer(UUID player, String name) throws InterruptedException {
        return this.recycleSubServer(player, name, false);
    }

    protected abstract boolean recycleSubServer(UUID var1, String var2, boolean var3) throws InterruptedException;

    public boolean forceRecycleSubServer(String name) throws InterruptedException {
        return this.forceRecycleSubServer(null, name);
    }

    public boolean forceRecycleSubServer(UUID player, String name) throws InterruptedException {
        return this.recycleSubServer(player, name, true);
    }

    public boolean deleteSubServer(String name) throws InterruptedException {
        return this.deleteSubServer(null, name);
    }

    public boolean deleteSubServer(UUID player, String name) throws InterruptedException {
        return this.deleteSubServer(player, name, false);
    }

    protected abstract boolean deleteSubServer(UUID var1, String var2, boolean var3) throws InterruptedException;

    public boolean forceDeleteSubServer(String name) throws InterruptedException {
        return this.forceDeleteSubServer(null, name);
    }

    public boolean forceDeleteSubServer(UUID player, String name) throws InterruptedException {
        return this.deleteSubServer(player, name, true);
    }

    public boolean destroy() {
        try {
            Map.Entry[] subservers;
            for (Map.Entry entry : subservers = this.getSubServers().entrySet().toArray(new Map.Entry[0])) {
                if (((SubServer)entry.getValue()).isRunning()) {
                    Logger.get((String)"SubServers").info("Stopping " + ((SubServer)entry.getValue()).getName());
                }
                this.forceRemoveSubServer((String)entry.getKey());
            }
            this.getCreator().terminate();
            this.getCreator().waitFor();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public final String getSignature() {
        return this.signature;
    }

    public boolean equals(Object obj) {
        return obj instanceof Host && this.signature.equals(((Host)obj).signature);
    }

    public void addExtra(String handle, Object value) {
        Util.nullpo((Object[])new Object[]{handle, value});
        this.extra.set((Object)handle, value);
    }

    public boolean hasExtra(String handle) {
        Util.nullpo((Object)handle);
        return this.extra.getKeys().contains(handle);
    }

    public ObjectMapValue getExtra(String handle) {
        Util.nullpo((Object)handle);
        return this.extra.get((Object)handle);
    }

    public ObjectMap<String> getExtra() {
        return this.extra.clone();
    }

    public void removeExtra(String handle) {
        Util.nullpo((Object)handle);
        this.extra.remove((Object)handle);
    }

    public ObjectMap<String> forSubData() {
        ObjectMap hinfo = new ObjectMap();
        hinfo.set((Object)"type", (Object)"Host");
        hinfo.set((Object)"name", (Object)this.getName());
        hinfo.set((Object)"display", (Object)this.getDisplayName());
        hinfo.set((Object)"available", (Object)this.isAvailable());
        hinfo.set((Object)"enabled", (Object)this.isEnabled());
        hinfo.set((Object)"address", (Object)this.getAddress().getHostAddress());
        hinfo.set((Object)"dir", (Object)this.getPath());
        ObjectMap cinfo = new ObjectMap();
        ObjectMap templates = new ObjectMap();
        for (SubCreator.ServerTemplate template : this.getCreator().getTemplates().values()) {
            templates.set((Object)template.getName(), template.forSubData());
        }
        cinfo.set((Object)"templates", (Object)templates);
        hinfo.set((Object)"creator", (Object)cinfo);
        ObjectMap servers = new ObjectMap();
        for (SubServer subServer : this.getSubServers().values()) {
            servers.set((Object)subServer.getName(), (Object)subServer.forSubData());
        }
        hinfo.set((Object)"servers", (Object)servers);
        hinfo.set((Object)"signature", (Object)this.signature);
        hinfo.set((Object)"extra", this.getExtra());
        return hinfo;
    }
}

