/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Bungee.Host.Internal;

import com.google.common.collect.Range;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.regex.Pattern;
import net.ME1312.Galaxi.Library.Config.YAMLConfig;
import net.ME1312.Galaxi.Library.Config.YAMLSection;
import net.ME1312.Galaxi.Library.Container.ContainedPair;
import net.ME1312.Galaxi.Library.Container.Container;
import net.ME1312.Galaxi.Library.Container.Pair;
import net.ME1312.Galaxi.Library.Container.Value;
import net.ME1312.Galaxi.Library.Directories;
import net.ME1312.Galaxi.Library.Map.ObjectMap;
import net.ME1312.Galaxi.Library.Map.ObjectMapValue;
import net.ME1312.Galaxi.Library.Try;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.Galaxi.Library.Version.Version;
import net.ME1312.SubServers.Bungee.Event.SubCreateEvent;
import net.ME1312.SubServers.Bungee.Event.SubCreatedEvent;
import net.ME1312.SubServers.Bungee.Host.Executable;
import net.ME1312.SubServers.Bungee.Host.Host;
import net.ME1312.SubServers.Bungee.Host.Internal.InternalHost;
import net.ME1312.SubServers.Bungee.Host.Internal.InternalSubLogger;
import net.ME1312.SubServers.Bungee.Host.Internal.InternalSubServer;
import net.ME1312.SubServers.Bungee.Host.SubCreator;
import net.ME1312.SubServers.Bungee.Host.SubLogger;
import net.ME1312.SubServers.Bungee.Host.SubServer;
import net.ME1312.SubServers.Bungee.Library.Compatibility.Logger;
import net.ME1312.SubServers.Bungee.Library.Exception.InvalidServerException;
import net.ME1312.SubServers.Bungee.Library.Exception.SubCreatorException;
import net.ME1312.SubServers.Bungee.Library.ReplacementScanner;
import net.ME1312.SubServers.Bungee.SubAPI;
import net.ME1312.SubServers.Bungee.SubProxy;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.plugin.Event;

public class InternalSubCreator
extends SubCreator {
    private HashMap<String, SubCreator.ServerTemplate> templates = new HashMap();
    private InternalHost host;
    private Range<Integer> ports;
    private Value<Boolean> log;
    private String gitBash;
    private TreeMap<String, CreatorTask> thread;
    private static Pair<YAMLSection, Map<String, Object>> subdata = null;

    public InternalSubCreator(InternalHost host, Range<Integer> ports, boolean log, String gitBash) {
        if (!ports.hasLowerBound() || !ports.hasUpperBound()) {
            throw new IllegalArgumentException("Port range is not bound");
        }
        Util.nullpo((Object[])new Object[]{host, ports, log, gitBash});
        this.host = host;
        this.ports = ports;
        this.log = new Container((Object)log);
        String string = this.gitBash = System.getenv("ProgramFiles(x86)") == null ? Pattern.compile("%(ProgramFiles)\\(x86\\)%", 2).matcher(gitBash).replaceAll("%$1%") : gitBash;
        if (this.gitBash.endsWith(File.pathSeparator)) {
            this.gitBash = this.gitBash.substring(0, this.gitBash.length() - 1);
        }
        this.thread = new TreeMap();
        this.reload();
    }

    @Override
    public void reload() {
        this.templates.clear();
        if (new File(this.host.plugin.dir, "SubServers/Templates").exists()) {
            for (File file : new File(this.host.plugin.dir, "SubServers/Templates").listFiles()) {
                try {
                    if (!file.isDirectory() || file.getName().endsWith(".x")) continue;
                    ObjectMap config = new File(file, "template.yml").exists() ? new YAMLConfig(new File(file, "template.yml")).get().getMap((Object)"Template", new ObjectMap()) : new ObjectMap();
                    SubCreator.ServerTemplate template = this.loadTemplate(file.getName(), config.getBoolean((Object)"Enabled", Boolean.valueOf(true)), config.getBoolean((Object)"Internal", Boolean.valueOf(false)), config.getString((Object)"Icon", "::NULL::"), file, (ObjectMap<String>)config.getMap((Object)"Build", new ObjectMap()), (ObjectMap<String>)config.getMap((Object)"Settings", new ObjectMap()));
                    this.templates.put(file.getName().toLowerCase(), template);
                    if (!config.getKeys().contains("Display")) continue;
                    template.setDisplayName(Util.unescapeJavaString((String)config.getString((Object)"Display")));
                }
                catch (Exception e) {
                    Logger.get((String)this.host.getName()).severe("Couldn't load template: " + file.getName());
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public boolean create(UUID player, String name, SubCreator.ServerTemplate template, Version version, Integer port, Consumer<SubServer> callback) {
        Util.nullpo((Object[])new Object[]{name, template});
        if (this.host.isAvailable() && this.host.isEnabled() && template.isEnabled() && !SubAPI.getInstance().getSubServers().containsKey(name.toLowerCase()) && !SubCreator.isReserved(name) && (version != null || !template.requiresVersion())) {
            StackTraceElement[] origin = new Throwable().getStackTrace();
            if (port == null) {
                Container i = new Container((Object)((Integer)this.ports.lowerEndpoint() - 1));
                port = ((InetSocketAddress)Util.getNew(InternalSubCreator.getAllReservedAddresses(), () -> this.lambda$create$0((Value)i))).getPort();
            }
            CreatorTask task = new CreatorTask(player, name, template, version, port, server -> {
                if (callback != null) {
                    try {
                        callback.accept((SubServer)server);
                    }
                    catch (Throwable e) {
                        InvocationTargetException ew = new InvocationTargetException(e);
                        ew.setStackTrace(origin);
                        ew.printStackTrace();
                    }
                }
            });
            this.thread.put(name.toLowerCase(), task);
            SubCreateEvent event = new SubCreateEvent(player, this.host, name, template, version, port);
            this.host.plugin.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                task.start();
                return true;
            }
            this.thread.remove(name.toLowerCase());
            return false;
        }
        return false;
    }

    @Override
    public boolean update(UUID player, SubServer server, SubCreator.ServerTemplate template, Version version, Consumer<Boolean> callback) {
        SubCreator.ServerTemplate ft;
        Util.nullpo((Object)server);
        SubCreator.ServerTemplate serverTemplate = ft = template == null ? server.getTemplate() : template;
        if (this.host.isAvailable() && this.host.isEnabled() && this.host == server.getHost() && server.isAvailable() && !server.isRunning() && ft != null && ft.isEnabled() && ft.canUpdate() && (version != null || !ft.requiresVersion())) {
            StackTraceElement[] origin = new Throwable().getStackTrace();
            ((InternalSubServer)server).updating(true);
            CreatorTask task = new CreatorTask(player, server, ft, version, x -> {
                ((InternalSubServer)server).updating(false);
                if (callback != null) {
                    try {
                        callback.accept(x != null);
                    }
                    catch (Throwable e) {
                        InvocationTargetException ew = new InvocationTargetException(e);
                        ew.setStackTrace(origin);
                        ew.printStackTrace();
                    }
                }
            });
            this.thread.put(server.getName().toLowerCase(), task);
            SubCreateEvent event = new SubCreateEvent(player, server, ft, version);
            this.host.plugin.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                task.start();
                return true;
            }
            this.thread.remove(server.getName().toLowerCase());
            return false;
        }
        return false;
    }

    @Override
    public void terminate() {
        HashMap<String, CreatorTask> temp = new HashMap<String, CreatorTask>();
        temp.putAll(this.thread);
        for (String i : temp.keySet()) {
            this.terminate(i);
        }
    }

    @Override
    public void terminate(String name) {
        if (this.thread.containsKey(name.toLowerCase())) {
            if (this.thread.get(name.toLowerCase()).process != null && this.thread.get(name.toLowerCase()).process.isAlive()) {
                Executable.terminate(this.thread.get(name.toLowerCase()).process);
            } else if (this.thread.get(name.toLowerCase()).isAlive()) {
                this.thread.get(name.toLowerCase()).interrupt();
                this.thread.remove(name.toLowerCase());
            }
        }
    }

    @Override
    public void waitFor() throws InterruptedException {
        HashMap<String, CreatorTask> temp = new HashMap<String, CreatorTask>();
        temp.putAll(this.thread);
        for (String i : temp.keySet()) {
            this.waitFor(i);
        }
    }

    @Override
    public void waitFor(String name) throws InterruptedException {
        while (this.thread.containsKey(name.toLowerCase()) && this.thread.get(name.toLowerCase()).isAlive()) {
            Thread.sleep(250L);
        }
    }

    @Override
    public Host getHost() {
        return this.host;
    }

    @Override
    public Range getPortRange() {
        return this.ports;
    }

    @Override
    public void setPortRange(Range<Integer> value) {
        if (!value.hasLowerBound() || !value.hasUpperBound()) {
            throw new IllegalArgumentException("Port range is not bound");
        }
        this.ports = value;
    }

    @Override
    public String getBashDirectory() {
        return this.gitBash;
    }

    @Override
    public List<SubLogger> getLoggers() {
        ArrayList<SubLogger> loggers = new ArrayList<SubLogger>();
        HashMap<String, CreatorTask> temp = new HashMap<String, CreatorTask>();
        temp.putAll(this.thread);
        for (String i : temp.keySet()) {
            loggers.add(this.getLogger(i));
        }
        return loggers;
    }

    @Override
    public SubLogger getLogger(String name) {
        return this.thread.get(name.toLowerCase()).log;
    }

    @Override
    public boolean isLogging() {
        return (Boolean)this.log.value();
    }

    @Override
    public void setLogging(boolean value) {
        Util.nullpo((Object)value);
        this.log.value((Object)value);
    }

    @Override
    public List<String> getReservedNames() {
        return new ArrayList<String>(this.thread.keySet());
    }

    @Override
    public List<Integer> getReservedPorts() {
        ArrayList<Integer> ports = new ArrayList<Integer>();
        for (CreatorTask task : this.thread.values()) {
            ports.add(task.port);
        }
        return ports;
    }

    @Override
    public Map<String, SubCreator.ServerTemplate> getTemplates() {
        TreeMap<String, SubCreator.ServerTemplate> map = new TreeMap<String, SubCreator.ServerTemplate>();
        for (Map.Entry<String, SubCreator.ServerTemplate> template : this.templates.entrySet()) {
            if (template.getValue().isInternal()) continue;
            map.put(template.getKey(), template.getValue());
        }
        return map;
    }

    @Override
    public SubCreator.ServerTemplate getTemplate(String name) {
        Util.nullpo((Object)name);
        SubCreator.ServerTemplate template = this.templates.getOrDefault(name.toLowerCase(), null);
        if (template == null || template.isInternal()) {
            return null;
        }
        return template;
    }

    private Map<String, Object> getSubData() {
        if (subdata == null || this.host.plugin.config.get() != subdata.key()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("Address", this.host.plugin.config.get().getMap((Object)"Settings").getMap((Object)"SubData").getString((Object)"Address", "127.0.0.1").replace("0.0.0.0", "127.0.0.1"));
            if (this.host.plugin.config.get().getMap((Object)"Settings").getMap((Object)"SubData").getString((Object)"Password", "").length() > 0) {
                map.put("Password", this.host.plugin.config.get().getMap((Object)"Settings").getMap((Object)"SubData").getString((Object)"Password"));
            }
            subdata = new ContainedPair((Object)this.host.plugin.config.get(), map);
        }
        return (Map)subdata.value();
    }

    private void generateClient(File dir, SubCreator.ServerType type, String name) throws IOException {
        boolean installed = false;
        if (type == SubCreator.ServerType.SPIGOT) {
            installed = true;
            if (!new File(dir, "plugins").exists()) {
                new File(dir, "plugins").mkdirs();
            }
            if (!new File(dir, "plugins/SubServers.Client.jar").exists()) {
                Util.copyFromJar((ClassLoader)SubProxy.class.getClassLoader(), (String)"net/ME1312/SubServers/Bungee/Library/Files/client.jar", (String)new File(dir, "plugins/SubServers.Client.jar").getPath());
            }
        } else if (type == SubCreator.ServerType.FORGE || type == SubCreator.ServerType.SPONGE) {
            installed = true;
            if (!new File(dir, "mods").exists()) {
                new File(dir, "mods").mkdirs();
            }
            if (!new File(dir, "mods/SubServers.Client.jar").exists()) {
                Util.copyFromJar((ClassLoader)SubProxy.class.getClassLoader(), (String)"net/ME1312/SubServers/Bungee/Library/Files/client.jar", (String)new File(dir, "mods/SubServers.Client.jar").getPath());
            }
        }
        if (installed) {
            YAMLSection config = new YAMLSection();
            FileWriter writer = new FileWriter(new File(dir, "subdata.json"), false);
            config.setAll(this.getSubData());
            writer.write(new Gson().toJson((Object)config.get()));
            writer.close();
            if (!new File(dir, "subdata.rsa.key").exists() && new File("SubServers/subdata.rsa.key").exists()) {
                Files.copy(new File("SubServers/subdata.rsa.key").toPath(), new File(dir, "subdata.rsa.key").toPath(), new CopyOption[0]);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateDirectory(File from, File to, boolean overwrite) {
        if (!to.exists()) {
            Directories.copy((File)from, (File)to);
            return;
        } else if (from.isDirectory() && !Files.isSymbolicLink(from.toPath())) {
            String[] files;
            for (String file : files = from.list()) {
                File srcFile = new File(from, file);
                File destFile = new File(to, file);
                this.updateDirectory(srcFile, destFile, overwrite);
            }
            return;
        } else {
            try {
                if (!overwrite || from.length() == to.length() && Arrays.equals(this.generateSHA256(to), this.generateSHA256(from))) return;
                if (to.exists()) {
                    if (to.isDirectory()) {
                        Directories.delete((File)to);
                    } else {
                        to.delete();
                    }
                }
                Files.copy(from.toPath(), to.toPath(), LinkOption.NOFOLLOW_LINKS, StandardCopyOption.REPLACE_EXISTING);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private byte[] generateSHA256(File file) throws Exception {
        int nread;
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        FileInputStream fis = new FileInputStream(file);
        byte[] dataBytes = new byte[4096];
        while ((nread = fis.read(dataBytes)) != -1) {
            md.update(dataBytes, 0, nread);
        }
        fis.close();
        return md.digest();
    }

    private /* synthetic */ InetSocketAddress lambda$create$0(Value i) {
        do {
            i.value((Object)((Integer)i.value() + 1));
            if ((Integer)i.value() <= (Integer)this.ports.upperEndpoint()) continue;
            throw new IllegalStateException("There are no more ports available in range: " + this.ports.toString());
        } while (!this.ports.contains((Comparable)((Integer)i.value())));
        return new InetSocketAddress(this.host.getAddress(), (int)((Integer)i.value()));
    }

    private class CreatorTask
    extends Thread {
        private final UUID player;
        private final SubServer update;
        private final String name;
        private final SubCreator.ServerTemplate template;
        private final Version version;
        private final int port;
        private final String prefix;
        private final InternalSubLogger log;
        private final LinkedList<String> replace;
        private final HashMap<String, String> replacements;
        private final Consumer<SubServer> callback;
        private boolean install;
        private Process process;

        private CreatorTask(UUID player, String name, SubCreator.ServerTemplate template, Version version, int port, Consumer<SubServer> callback) {
            super("SubServers.Bungee::Internal_SubCreator_Process_Handler(" + name + ')');
            this.player = player;
            this.update = null;
            this.name = name;
            this.template = template;
            this.version = version;
            this.port = port;
            this.prefix = name + File.separator + "Creator";
            this.log = new InternalSubLogger(null, this, this.prefix, (Value<Boolean>)InternalSubCreator.this.log, null);
            this.replace = new LinkedList<String>();
            this.replace.add("/server.properties");
            this.replacements = new HashMap();
            this.callback = callback;
            this.install = true;
        }

        private CreatorTask(UUID player, SubServer server, SubCreator.ServerTemplate template, Version version, Consumer<SubServer> callback) {
            super("SubServers.Bungee::Internal_SubCreator_Process_Handler(" + server.getName() + ')');
            this.player = player;
            this.update = server;
            this.name = server.getName();
            this.template = template;
            this.version = version;
            this.port = server.getAddress().getPort();
            this.prefix = this.name + File.separator + "Updater";
            this.log = new InternalSubLogger(null, this, this.prefix, (Value<Boolean>)InternalSubCreator.this.log, null);
            this.replace = new LinkedList<String>();
            this.replace.add("/server.properties");
            this.replacements = new HashMap();
            this.callback = callback;
            this.install = true;
        }

        private ObjectMap<String> build(File dir, SubCreator.ServerTemplate template, List<SubCreator.ServerTemplate> history, List<SubCreator.ServerTemplate> stack) throws SubCreatorException {
            ObjectMap server = new ObjectMap();
            Version version = this.version;
            HashMap<String, String> var = new HashMap<String, String>();
            boolean error = false;
            if (stack.contains(template)) {
                throw new IllegalStateException("Infinite template import loop detected");
            }
            stack.add(template);
            for (String other : template.getBuildOptions().getStringList((Object)"Import", new ArrayList())) {
                if (InternalSubCreator.this.templates.containsKey(other.toLowerCase())) {
                    SubCreator.ServerTemplate ot = (SubCreator.ServerTemplate)InternalSubCreator.this.templates.get(other.toLowerCase());
                    if (ot.isEnabled()) {
                        if (version != null || !ot.requiresVersion()) {
                            if (this.update == null || ot.canUpdate()) {
                                if (!history.contains(ot)) {
                                    server.setAll(this.build(dir, ot, history, stack));
                                    continue;
                                }
                                this.log.log(Level.WARNING, "Skipping template that is already loaded: " + other);
                                continue;
                            }
                            this.log.log(Level.WARNING, "Skipping template that cannot be run in update mode: " + other);
                            continue;
                        }
                        this.log.log(Level.WARNING, "Skipping template that requires extra versioning information: " + other);
                        continue;
                    }
                    this.log.log(Level.WARNING, "Skipping disabled template: " + other);
                    continue;
                }
                this.log.log(Level.WARNING, "Skipping missing template: " + other);
            }
            history.add(template);
            stack.remove(template);
            server.setAll(template.getConfigOptions());
            try {
                this.log.log(Level.INFO, "Loading" + (template.isDynamic() ? " Dynamic" : "") + " Template: " + template.getDisplayName());
                InternalSubCreator.this.updateDirectory(template.getDirectory(), dir, template.getBuildOptions().getBoolean((Object)"Update-Files", Boolean.valueOf(false)));
                this.install = template.getBuildOptions().getBoolean((Object)"Install-Client", Boolean.valueOf(this.install));
                this.replace.addAll(template.getBuildOptions().getStringList((Object)"Replace", Collections.emptyList()));
                for (ObjectMapValue replacement : template.getBuildOptions().getMap((Object)"Replacements", new ObjectMap()).getValues()) {
                    if (replacement.isNull()) continue;
                    this.replacements.put(((String)replacement.getHandle()).toLowerCase().replace('-', '_').replace(' ', '_'), replacement.asString());
                }
                var.putAll(this.replacements);
                var.put("java", System.getProperty("java.home") + File.separator + "bin" + File.separator + "java");
                var.put("mode", this.update == null ? "CREATE" : (this.template.equals(this.update.getTemplate()) ? "UPDATE" : "SWITCH"));
                if (this.player != null) {
                    var.put("player", this.player.toString().toUpperCase());
                } else {
                    var.remove("player");
                }
                var.put("name", this.name);
                var.put("host", InternalSubCreator.this.host.getName());
                var.put("template", template.getName());
                var.put("type", template.getType().toString().toUpperCase());
                if (version != null) {
                    var.put("version", version.toString());
                } else {
                    var.remove("version");
                }
                var.put("address", InternalSubCreator.this.host.getAddress().getHostAddress());
                var.put("port", Integer.toString(this.port));
                switch (template.getType()) {
                    case SPONGE: 
                    case FORGE: {
                        if (version == null) break;
                        this.log.log(Level.INFO, "Searching Versions...");
                        ObjectMap spversionmanifest = new ObjectMap((Map)new Gson().fromJson("{\"versions\":" + Util.readAll((Reader)new BufferedReader(new InputStreamReader(new URL("https://dl-api.spongepowered.org/v1/org.spongepowered/sponge" + (template.getType() == SubCreator.ServerType.FORGE ? "forge" : "vanilla") + "/downloads?type=stable&minecraft=" + version).openStream(), Charset.forName("UTF-8")))) + '}', Map.class));
                        ObjectMap spprofile = null;
                        Version spversion = null;
                        for (ObjectMap profile : spversionmanifest.getMapList((Object)"versions")) {
                            if (!profile.getMap((Object)"dependencies").getString((Object)"minecraft").equalsIgnoreCase(version.toString()) || spversion != null && new Version(profile.getString((Object)"version")).compareTo(spversion) < 0) continue;
                            spprofile = profile;
                            spversion = new Version(profile.getString((Object)"version"));
                        }
                        if (spversion == null) {
                            throw new InvalidServerException("Cannot find Sponge version for Minecraft " + version.toString());
                        }
                        this.log.log(Level.INFO, "Found \"sponge" + (template.getType() == SubCreator.ServerType.FORGE ? "forge" : "vanilla") + "-" + spversion.toString() + '\"');
                        if (template.getType() == SubCreator.ServerType.FORGE) {
                            Version mcfversion = new Version((spprofile.getMap((Object)"dependencies").getString((Object)"forge").contains("-") ? "" : spprofile.getMap((Object)"dependencies").getString((Object)"minecraft") + '-') + spprofile.getMap((Object)"dependencies").getString((Object)"forge"));
                            this.log.log(Level.INFO, "Found \"forge-" + mcfversion.toString() + '\"');
                            var.put("mcf_version", mcfversion.toString());
                        }
                        var.put("sp_version", spversion.toString());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (template.getBuildOptions().contains((Object)"Executable")) {
                File cache = null;
                if (template.getBuildOptions().getBoolean((Object)"Use-Cache", Boolean.valueOf(true)).booleanValue()) {
                    cache = new File(((InternalSubCreator)InternalSubCreator.this).host.plugin.dir, "SubServers/Cache/Templates/" + template.getName());
                    cache.mkdirs();
                    var.put("cache", cache.getAbsolutePath());
                }
                var.put("source", dir.getAbsolutePath());
                try {
                    this.log.log(Level.INFO, "Launching Build Script...");
                    ProcessBuilder pb = new ProcessBuilder(new String[0]).command(Executable.parse(InternalSubCreator.this.gitBash, template.getBuildOptions().getString((Object)"Executable"))).directory(dir);
                    pb.environment().putAll(var);
                    this.log.file = new File(dir, "SubCreator-" + template.getName() + (version != null ? "-" + version.toString() : "") + ".log");
                    this.log.process = this.process = pb.start();
                    this.log.start();
                    this.process.waitFor();
                    Thread.sleep(250L);
                    if (this.process.exitValue() != 0) {
                        error = true;
                    }
                }
                catch (InterruptedException e) {
                    error = true;
                }
                catch (Exception e) {
                    error = true;
                    e.printStackTrace();
                }
                if (cache != null) {
                    if (cache.isDirectory() && cache.listFiles().length == 0) {
                        cache.delete();
                    }
                    if ((cache = new File(((InternalSubCreator)InternalSubCreator.this).host.plugin.dir, "SubServers/Cache/Templates")).isDirectory() && cache.listFiles().length == 0) {
                        cache.delete();
                    }
                    if ((cache = new File(((InternalSubCreator)InternalSubCreator.this).host.plugin.dir, "SubServers/Cache")).isDirectory() && cache.listFiles().length == 0) {
                        cache.delete();
                    }
                }
            }
            new File(dir, "template.yml").delete();
            if (error) {
                throw new SubCreatorException();
            }
            return server;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ObjectMap config;
            Runnable declaration = () -> {
                this.replacements.put("player", this.player == null ? "" : this.player.toString());
                this.replacements.put("name", this.name);
                this.replacements.put("host", InternalSubCreator.this.host.getName());
                this.replacements.put("template", this.template.getName());
                this.replacements.put("type", this.template.getType().toString());
                this.replacements.put("version", this.version != null ? this.version.toString() : "");
                this.replacements.put("address", InternalSubCreator.this.host.getAddress().getHostAddress());
                this.replacements.put("port", Integer.toString(this.port));
            };
            declaration.run();
            File dir = this.update != null ? new File(this.update.getFullPath()) : new File(InternalSubCreator.this.host.getPath(), this.template.getConfigOptions().contains((Object)"Directory") ? new ReplacementScanner(this.replacements).replace(this.template.getConfigOptions().getString((Object)"Directory")).toString() : this.name);
            ObjectMap server = new ObjectMap();
            try {
                this.log.init();
                config = this.build(dir, this.template, new LinkedList<SubCreator.ServerTemplate>(), new LinkedList<SubCreator.ServerTemplate>());
            }
            catch (SubCreatorException e) {
                config = null;
            }
            catch (Exception e) {
                config = null;
                e.printStackTrace();
            }
            finally {
                this.log.destroy();
            }
            declaration.run();
            ReplacementScanner replacements = new ReplacementScanner(this.replacements);
            if (config != null) {
                try {
                    if (this.install) {
                        InternalSubCreator.this.generateClient(dir, this.template.getType(), this.name);
                    }
                    replacements.replace(dir, this.replace.toArray(new String[0]));
                }
                catch (Exception e) {
                    config = null;
                    e.printStackTrace();
                }
            }
            if (config != null) {
                try {
                    Logger.get((String)this.prefix).info("Saving...");
                    SubServer subserver = this.update;
                    if (this.update == null || this.update.getTemplate() != this.template || this.template.getBuildOptions().getBoolean((Object)"Update-Settings", Boolean.valueOf(false)).booleanValue()) {
                        if (((InternalSubCreator)InternalSubCreator.this).host.plugin.exServers.containsKey(this.name.toLowerCase())) {
                            ((InternalSubCreator)InternalSubCreator.this).host.plugin.exServers.remove(this.name.toLowerCase());
                        }
                        if ((config = new ObjectMap((Map)replacements.replace(config.get()))).contains((Object)"Directory") && (this.update != null || !this.template.getConfigOptions().contains((Object)"Directory"))) {
                            config.remove((Object)"Directory");
                        }
                        if (this.update == null) {
                            server.set((Object)"Enabled", (Object)true);
                            server.set((Object)"Display", (Object)"");
                            server.set((Object)"Host", (Object)InternalSubCreator.this.host.getName());
                            server.set((Object)"Template", (Object)this.template.getName());
                            server.set((Object)"Group", new ArrayList());
                            server.set((Object)"Port", (Object)this.port);
                            server.set((Object)"Motd", (Object)"Some SubServer");
                            server.set((Object)"Log", (Object)true);
                            server.set((Object)"Directory", (Object)("./" + this.name));
                            server.set((Object)"Executable", (Object)("java -Xmx1024M -jar " + this.template.getType().toString() + ".jar"));
                            server.set((Object)"Stop-Command", (Object)"stop");
                            server.set((Object)"Stop-Action", (Object)"NONE");
                            server.set((Object)"Run-On-Launch", (Object)false);
                            server.set((Object)"Restricted", (Object)false);
                            server.set((Object)"Incompatible", new ArrayList());
                            server.set((Object)"Hidden", (Object)false);
                        } else {
                            server.setAll(((InternalSubCreator)InternalSubCreator.this).host.plugin.servers.get().getMap((Object)"Servers").getMap((Object)this.name, new HashMap()));
                            server.set((Object)"Template", (Object)this.template.getName());
                        }
                        server.setAll(config);
                        if (this.update != null) {
                            Try.all.run(() -> this.update.getHost().forceRemoveSubServer(this.name));
                        }
                        subserver = InternalSubCreator.this.host.constructSubServer(this.name, server.getBoolean((Object)"Enabled"), this.port, ChatColor.translateAlternateColorCodes((char)'&', (String)Util.unescapeJavaString((String)server.getString((Object)"Motd"))), server.getBoolean((Object)"Log"), server.getString((Object)"Directory"), server.getString((Object)"Executable"), server.getString((Object)"Stop-Command"), server.getBoolean((Object)"Hidden"), server.getBoolean((Object)"Restricted"));
                        if (server.getString((Object)"Display").length() > 0) {
                            subserver.setDisplayName(Util.unescapeJavaString((String)server.getString((Object)"Display")));
                        }
                        subserver.setTemplate(server.getString((Object)"Template"));
                        for (String group : server.getStringList((Object)"Group")) {
                            subserver.addGroup(group);
                        }
                        SubServer.StopAction action = (SubServer.StopAction)((Object)Try.all.get(() -> SubServer.StopAction.valueOf(server.getString((Object)"Stop-Action").toUpperCase().replace('-', '_').replace(' ', '_'))));
                        if (action != null) {
                            subserver.setStopAction(action);
                        }
                        if (server.contains((Object)"Extra")) {
                            for (String extra : server.getMap((Object)"Extra").getKeys()) {
                                subserver.addExtra(extra, server.getMap((Object)"Extra").getObject((Object)extra));
                            }
                        }
                        if (this.update != null && ((InternalSubCreator)InternalSubCreator.this).host.plugin.servers.get().getMap((Object)"Servers").contains((Object)this.name) || subserver.getStopAction() != SubServer.StopAction.REMOVE_SERVER && subserver.getStopAction() != SubServer.StopAction.RECYCLE_SERVER && subserver.getStopAction() != SubServer.StopAction.DELETE_SERVER) {
                            ((InternalSubCreator)InternalSubCreator.this).host.plugin.servers.get().getMap((Object)"Servers").set((Object)this.name, (Object)server);
                            ((InternalSubCreator)InternalSubCreator.this).host.plugin.servers.save();
                        }
                        InternalSubCreator.this.host.addSubServer(subserver);
                        if (this.update == null && this.template.getBuildOptions().getBoolean((Object)"Run-On-Finish", Boolean.valueOf(true)).booleanValue()) {
                            subserver.start();
                        }
                    }
                    InternalSubCreator.this.thread.remove(this.name.toLowerCase());
                    ((InternalSubCreator)InternalSubCreator.this).host.plugin.getPluginManager().callEvent((Event)new SubCreatedEvent(this.player, InternalSubCreator.this.host, this.name, this.template, this.version, this.port, subserver, this.update != null, true));
                    this.callback.accept(subserver);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ((InternalSubCreator)InternalSubCreator.this).host.plugin.getPluginManager().callEvent((Event)new SubCreatedEvent(this.player, InternalSubCreator.this.host, this.name, this.template, this.version, this.port, this.update, this.update != null, false));
                    this.callback.accept(null);
                }
            } else {
                Logger.get((String)this.prefix).info("Couldn't build the server jar. Check the SubCreator logs for more detail.");
                ((InternalSubCreator)InternalSubCreator.this).host.plugin.getPluginManager().callEvent((Event)new SubCreatedEvent(this.player, InternalSubCreator.this.host, this.name, this.template, this.version, this.port, this.update, this.update != null, false));
                this.callback.accept(null);
            }
            InternalSubCreator.this.thread.remove(this.name.toLowerCase());
        }
    }
}

