/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Bungee.Host;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import net.ME1312.Galaxi.Library.ExtraDataHandler;
import net.ME1312.Galaxi.Library.Map.ObjectMap;
import net.ME1312.Galaxi.Library.Map.ObjectMapValue;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.SubData.Server.ClientHandler;
import net.ME1312.SubData.Server.DataClient;
import net.ME1312.SubData.Server.Protocol.PacketOut;
import net.ME1312.SubData.Server.SubDataClient;
import net.ME1312.SubServers.Bungee.Event.SubRemoveProxyEvent;
import net.ME1312.SubServers.Bungee.Host.RemotePlayer;
import net.ME1312.SubServers.Bungee.Network.Packet.PacketExSyncPlayer;
import net.ME1312.SubServers.Bungee.SubAPI;
import net.ME1312.SubServers.Bungee.SubProxy;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.plugin.Event;

public class Proxy
implements ClientHandler,
ExtraDataHandler<String> {
    private final HashMap<Integer, SubDataClient> subdata = new HashMap();
    private final ObjectMap<String> extra = new ObjectMap();
    private final String signature;
    private boolean persistent = false;
    private String nick = null;
    private final String name;

    public Proxy(String name) throws IllegalArgumentException {
        if (name == null) {
            name = (String)Util.getNew(SubAPI.getInstance().getInternals().proxies.keySet(), () -> UUID.randomUUID().toString());
        }
        if (name.contains(" ")) {
            throw new IllegalArgumentException("Proxy names cannot have spaces: " + name);
        }
        this.name = name;
        this.signature = SubAPI.getInstance().signAnonymousObject();
        this.subdata.put(0, null);
    }

    public DataClient[] getSubData() {
        Object[] keys = this.subdata.keySet().toArray(new Integer[0]);
        DataClient[] channels = new DataClient[keys.length];
        Arrays.sort(keys);
        for (int i = 0; i < keys.length; ++i) {
            channels[i] = (DataClient)this.subdata.get(keys[i]);
        }
        return channels;
    }

    public void setSubData(SubDataClient client, int channel) {
        DataClient[] subdata;
        boolean update = false;
        if (channel < 0) {
            throw new IllegalArgumentException("Subchannel ID cannot be less than zero");
        }
        if (client != null || channel == 0) {
            if (!this.subdata.containsKey(channel) || channel == 0 && (client == null || this.subdata.get(channel) == null)) {
                update = true;
                this.subdata.put(channel, client);
                if (!(client == null || client.getHandler() != null && this.equals(client.getHandler()))) {
                    client.setHandler((ClientHandler)this);
                }
            }
        } else {
            update = true;
            this.subdata.remove(channel);
        }
        if (update && (subdata = this.getSubData())[0] == null && subdata.length <= 1) {
            SubProxy plugin = SubAPI.getInstance().getInternals();
            for (UUID id : Util.getBackwards(plugin.rPlayerLinkP, (Object)this)) {
                plugin.rPlayerLinkS.remove(id);
                plugin.rPlayerLinkP.remove(id);
                plugin.rPlayers.remove(id);
            }
            for (Proxy proxy : SubAPI.getInstance().getProxies().values()) {
                if (proxy.getSubData()[0] == null || proxy == this) continue;
                ((SubDataClient)proxy.getSubData()[0]).sendPacket(new PacketOut[]{new PacketExSyncPlayer(this.getName(), null, null)});
            }
            if (!this.persistent) {
                ProxyServer.getInstance().getPluginManager().callEvent((Event)new SubRemoveProxyEvent(this));
                SubAPI.getInstance().getInternals().proxies.remove(this.getName().toLowerCase());
            }
        }
    }

    public void removeSubData(DataClient client) {
        for (Integer channel : Util.getBackwards(this.subdata, (Object)((SubDataClient)client))) {
            this.setSubData(null, channel);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.nick == null ? this.getName() : this.nick;
    }

    public void setDisplayName(String value) {
        this.nick = value == null || value.length() == 0 || this.getName().equals(value) ? null : value;
    }

    public boolean isMaster() {
        return SubAPI.getInstance().getMasterProxy() == this;
    }

    public Collection<RemotePlayer> getPlayers() {
        SubProxy plugin = SubAPI.getInstance().getInternals();
        ArrayList<RemotePlayer> players = new ArrayList<RemotePlayer>();
        for (UUID id : Util.getBackwards(plugin.rPlayerLinkP, (Object)this)) {
            players.add(plugin.rPlayers.get(id));
        }
        return players;
    }

    public final void persist() {
        this.persistent = true;
    }

    public final String getSignature() {
        return this.signature;
    }

    public boolean equals(Object obj) {
        return obj instanceof Proxy && this.signature.equals(((Proxy)obj).signature);
    }

    public void addExtra(String handle, Object value) {
        Util.nullpo((Object[])new Object[]{handle, value});
        this.extra.set((Object)handle, value);
    }

    public boolean hasExtra(String handle) {
        Util.nullpo((Object)handle);
        return this.extra.getKeys().contains(handle);
    }

    public ObjectMapValue getExtra(String handle) {
        Util.nullpo((Object)handle);
        return this.extra.get((Object)handle);
    }

    public ObjectMap<String> getExtra() {
        return this.extra.clone();
    }

    public void removeExtra(String handle) {
        Util.nullpo((Object)handle);
        this.extra.remove((Object)handle);
    }

    public ObjectMap<String> forSubData() {
        ObjectMap info = new ObjectMap();
        info.set((Object)"type", (Object)"Proxy");
        info.set((Object)"name", (Object)this.getName());
        info.set((Object)"display", (Object)this.getDisplayName());
        ObjectMap players = new ObjectMap();
        for (RemotePlayer player : this.getPlayers()) {
            players.set((Object)player.getUniqueId().toString(), (Object)player.getName());
        }
        info.set((Object)"players", (Object)players);
        info.set((Object)"master", (Object)this.isMaster());
        ObjectMap subdata = new ObjectMap();
        for (int channel : this.subdata.keySet()) {
            subdata.set((Object)channel, this.subdata.get(channel) == null ? null : this.subdata.get(channel).getID());
        }
        info.set((Object)"subdata", (Object)subdata);
        info.set((Object)"signature", (Object)this.signature);
        info.set((Object)"extra", this.getExtra());
        return info;
    }
}

