/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Bungee.Host;

import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.UUID;
import java.util.function.IntConsumer;
import net.ME1312.Galaxi.Library.Container.ContainedPair;
import net.ME1312.Galaxi.Library.Map.ObjectMap;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.SubData.Server.SubDataClient;
import net.ME1312.SubData.Server.SubDataSerializable;
import net.ME1312.SubServers.Bungee.Host.Proxy;
import net.ME1312.SubServers.Bungee.Host.Server;
import net.ME1312.SubServers.Bungee.Library.Compatibility.RPSI;
import net.ME1312.SubServers.Bungee.Network.Packet.PacketDisconnectPlayer;
import net.ME1312.SubServers.Bungee.Network.Packet.PacketMessagePlayer;
import net.ME1312.SubServers.Bungee.Network.Packet.PacketTransferPlayer;
import net.ME1312.SubServers.Bungee.SubAPI;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public class RemotePlayer
implements net.ME1312.SubServers.Bungee.Library.Compatibility.RemotePlayer,
SubDataSerializable {
    private ProxiedPlayer local;
    private UUID id;
    private String name;
    private InetSocketAddress ip;
    private Proxy proxy;
    private Server server;

    public RemotePlayer(ProxiedPlayer player) {
        this(player, player.getServer().getInfo());
    }

    public RemotePlayer(ProxiedPlayer player, ServerInfo server) {
        Util.nullpo((Object)player);
        this.local = player;
        this.id = player.getUniqueId();
        this.server = server instanceof Server ? (Server)server : null;
    }

    public RemotePlayer(String name, UUID id, Proxy proxy, ServerInfo server, InetSocketAddress ip) {
        Util.nullpo((Object[])new Object[]{name, id, proxy, ip});
        this.id = id;
        this.name = name;
        this.ip = ip;
        this.proxy = proxy;
        this.server = server instanceof Server ? (Server)server : null;
    }

    public ProxiedPlayer get() {
        return this.local;
    }

    private static ProxiedPlayer get(UUID player) {
        return ProxyServer.getInstance().getPlayer(player);
    }

    public UUID getUniqueId() {
        if (this.local != null) {
            return this.local.getUniqueId();
        }
        return this.id;
    }

    public String getName() {
        if (this.local != null) {
            return this.local.getName();
        }
        return this.name;
    }

    public InetSocketAddress getAddress() {
        if (this.local != null) {
            return this.local.getAddress();
        }
        return this.ip;
    }

    public Proxy getProxy() {
        if (this.local != null) {
            return SubAPI.getInstance().getMasterProxy();
        }
        return this.proxy;
    }

    public String getProxyName() {
        Proxy proxy = this.getProxy();
        return proxy == null ? null : proxy.getName();
    }

    private SubDataClient getProxyConnection() {
        Proxy proxy = this.getProxy();
        return proxy == null ? null : (SubDataClient)proxy.getSubData()[0];
    }

    public Server getServer() {
        return this.server;
    }

    public String getServerName() {
        Server server = this.getServer();
        return server == null ? null : server.getName();
    }

    public boolean equals(Object obj) {
        return obj instanceof RemotePlayer && this.getUniqueId().equals(((RemotePlayer)obj).getUniqueId());
    }

    public ObjectMap<String> forSubData() {
        ObjectMap pinfo = new ObjectMap();
        pinfo.set((Object)"name", (Object)this.getName());
        pinfo.set((Object)"id", (Object)this.getUniqueId());
        pinfo.set((Object)"address", (Object)(this.getAddress().getAddress().getHostAddress() + ':' + this.getAddress().getPort()));
        if (this.getServer() != null) {
            pinfo.set((Object)"server", (Object)this.getServer().getName());
        }
        if (this.getProxy() != null) {
            pinfo.set((Object)"proxy", (Object)this.getProxy().getName());
        }
        return pinfo;
    }

    public static void broadcastMessage(String ... messages) {
        net.ME1312.SubServers.Bungee.Library.Compatibility.RemotePlayer.broadcastMessage((String[])messages);
    }

    public static void broadcastMessage(String message, IntConsumer response) {
        net.ME1312.SubServers.Bungee.Library.Compatibility.RemotePlayer.broadcastMessage((String)message, (IntConsumer)response);
    }

    public static void broadcastMessage(String[] messages, IntConsumer response) {
        net.ME1312.SubServers.Bungee.Library.Compatibility.RemotePlayer.broadcastMessage((String[])messages, (IntConsumer)response);
    }

    public static void sendMessage(UUID[] players, String ... messages) {
        net.ME1312.SubServers.Bungee.Library.Compatibility.RemotePlayer.sendMessage((UUID[])players, (String[])messages);
    }

    public static void sendMessage(UUID[] players, String message, IntConsumer response) {
        net.ME1312.SubServers.Bungee.Library.Compatibility.RemotePlayer.sendMessage((UUID[])players, (String)message, (IntConsumer)response);
    }

    public static void sendMessage(UUID[] players, String[] messages, IntConsumer response) {
        net.ME1312.SubServers.Bungee.Library.Compatibility.RemotePlayer.sendMessage((UUID[])players, (String[])messages, (IntConsumer)response);
    }

    public static void broadcastMessage(BaseComponent ... message) {
        net.ME1312.SubServers.Bungee.Library.Compatibility.RemotePlayer.broadcastMessage((BaseComponent[])message);
    }

    public static void broadcastMessage(BaseComponent message, IntConsumer response) {
        net.ME1312.SubServers.Bungee.Library.Compatibility.RemotePlayer.broadcastMessage((BaseComponent)message, (IntConsumer)response);
    }

    public static void broadcastMessage(BaseComponent[] message, IntConsumer response) {
        net.ME1312.SubServers.Bungee.Library.Compatibility.RemotePlayer.broadcastMessage((BaseComponent[])message, (IntConsumer)response);
    }

    public static void broadcastMessage(BaseComponent[] ... messages) {
        net.ME1312.SubServers.Bungee.Library.Compatibility.RemotePlayer.broadcastMessage((BaseComponent[][])messages);
    }

    public static void broadcastMessage(BaseComponent[][] messages, IntConsumer response) {
        net.ME1312.SubServers.Bungee.Library.Compatibility.RemotePlayer.broadcastMessage((BaseComponent[][])messages, (IntConsumer)response);
    }

    public static void sendMessage(UUID[] players, BaseComponent ... message) {
        net.ME1312.SubServers.Bungee.Library.Compatibility.RemotePlayer.sendMessage((UUID[])players, (BaseComponent[])message);
    }

    public static void sendMessage(UUID[] players, BaseComponent message, IntConsumer response) {
        net.ME1312.SubServers.Bungee.Library.Compatibility.RemotePlayer.sendMessage((UUID[])players, (BaseComponent)message, (IntConsumer)response);
    }

    public static void sendMessage(UUID[] players, BaseComponent[] message, IntConsumer response) {
        net.ME1312.SubServers.Bungee.Library.Compatibility.RemotePlayer.sendMessage((UUID[])players, (BaseComponent[])message, (IntConsumer)response);
    }

    public static void sendMessage(UUID[] players, BaseComponent[] ... messages) {
        net.ME1312.SubServers.Bungee.Library.Compatibility.RemotePlayer.sendMessage((UUID[])players, (BaseComponent[][])messages);
    }

    public static void sendMessage(UUID[] players, BaseComponent[][] messages, IntConsumer response) {
        net.ME1312.SubServers.Bungee.Library.Compatibility.RemotePlayer.sendMessage((UUID[])players, (BaseComponent[][])messages, (IntConsumer)response);
    }

    public static void transfer(UUID[] players, String server) {
        net.ME1312.SubServers.Bungee.Library.Compatibility.RemotePlayer.transfer((UUID[])players, (String)server);
    }

    public static void transfer(UUID[] players, String server, IntConsumer response) {
        net.ME1312.SubServers.Bungee.Library.Compatibility.RemotePlayer.transfer((UUID[])players, (String)server, (IntConsumer)response);
    }

    public static void transfer(UUID[] players, ServerInfo server) {
        net.ME1312.SubServers.Bungee.Library.Compatibility.RemotePlayer.transfer((UUID[])players, (ServerInfo)server);
    }

    public static void transfer(UUID[] players, ServerInfo server, IntConsumer response) {
        net.ME1312.SubServers.Bungee.Library.Compatibility.RemotePlayer.transfer((UUID[])players, (ServerInfo)server, (IntConsumer)response);
    }

    public static void disconnect(UUID ... players) {
        net.ME1312.SubServers.Bungee.Library.Compatibility.RemotePlayer.disconnect((UUID[])players);
    }

    public static void disconnect(UUID[] players, IntConsumer response) {
        net.ME1312.SubServers.Bungee.Library.Compatibility.RemotePlayer.disconnect((UUID[])players, (IntConsumer)response);
    }

    public static void disconnect(UUID[] players, String reason) {
        net.ME1312.SubServers.Bungee.Library.Compatibility.RemotePlayer.disconnect((UUID[])players, (String)reason);
    }

    public static void disconnect(UUID[] players, String reason, IntConsumer response) {
        net.ME1312.SubServers.Bungee.Library.Compatibility.RemotePlayer.disconnect((UUID[])players, (String)reason, (IntConsumer)response);
    }

    static {
        new RPSI(){

            protected void sendMessage(UUID[] players, String[] messages, IntConsumer response) {
                StackTraceElement[] origin = new Throwable().getStackTrace();
                PacketMessagePlayer.run(Arrays.asList(players), (ContainedPair<String[], BaseComponent[][]>)new ContainedPair((Object)messages, null), null, i -> {
                    try {
                        response.accept(i);
                    }
                    catch (Throwable e) {
                        InvocationTargetException ew = new InvocationTargetException(e);
                        ew.setStackTrace(origin);
                        ew.printStackTrace();
                    }
                });
            }

            protected void sendMessage(UUID[] players, BaseComponent[][] messages, IntConsumer response) {
                StackTraceElement[] origin = new Throwable().getStackTrace();
                PacketMessagePlayer.run(Arrays.asList(players), (ContainedPair<String[], BaseComponent[][]>)new ContainedPair(null, (Object)messages), null, i -> {
                    try {
                        response.accept(i);
                    }
                    catch (Throwable e) {
                        InvocationTargetException ew = new InvocationTargetException(e);
                        ew.setStackTrace(origin);
                        ew.printStackTrace();
                    }
                });
            }

            protected void transfer(UUID[] players, String server, IntConsumer response) {
                StackTraceElement[] origin = new Throwable().getStackTrace();
                PacketTransferPlayer.run(Arrays.asList(players), server, i -> {
                    try {
                        response.accept(i);
                    }
                    catch (Throwable e) {
                        InvocationTargetException ew = new InvocationTargetException(e);
                        ew.setStackTrace(origin);
                        ew.printStackTrace();
                    }
                });
            }

            protected void disconnect(UUID[] players, String reason, IntConsumer response) {
                StackTraceElement[] origin = new Throwable().getStackTrace();
                PacketDisconnectPlayer.run(Arrays.asList(players), reason, i -> {
                    try {
                        response.accept(i);
                    }
                    catch (Throwable e) {
                        InvocationTargetException ew = new InvocationTargetException(e);
                        ew.setStackTrace(origin);
                        ew.printStackTrace();
                    }
                });
            }
        };
    }
}

