/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Bungee.Host;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.ME1312.Galaxi.Library.Map.ObjectMap;
import net.ME1312.Galaxi.Library.Map.ObjectMapValue;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.SubData.Server.ClientHandler;
import net.ME1312.SubData.Server.DataClient;
import net.ME1312.SubData.Server.Protocol.PacketOut;
import net.ME1312.SubData.Server.SubDataClient;
import net.ME1312.SubServers.Bungee.Event.SubSendCommandEvent;
import net.ME1312.SubServers.Bungee.Host.Proxy;
import net.ME1312.SubServers.Bungee.Host.RemotePlayer;
import net.ME1312.SubServers.Bungee.Host.Server;
import net.ME1312.SubServers.Bungee.Host.SubServerImpl;
import net.ME1312.SubServers.Bungee.Library.Exception.InvalidServerException;
import net.ME1312.SubServers.Bungee.Network.Packet.PacketExControlPlayer;
import net.ME1312.SubServers.Bungee.Network.Packet.PacketOutExEditServer;
import net.ME1312.SubServers.Bungee.SubAPI;
import net.md_5.bungee.BungeeServerInfo;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Event;

public class ServerImpl
extends BungeeServerInfo
implements Server {
    private HashMap<Integer, SubDataClient> subdata = new HashMap();
    private ObjectMap<String> extra = new ObjectMap();
    private String nick = null;
    private List<String> groups = new ArrayList<String>();
    private List<UUID> whitelist = new ArrayList<UUID>();
    private boolean hidden;
    private final String signature = SubAPI.getInstance().signAnonymousObject();
    private volatile boolean persistent = true;

    public static ServerImpl construct(String name, SocketAddress address, String motd, boolean hidden, boolean restricted) throws InvalidServerException {
        try {
            return new ServerImpl(name, address, motd, hidden, restricted);
        }
        catch (NoSuchMethodError e) {
            return new ServerImpl(name, (InetSocketAddress)address, motd, hidden, restricted);
        }
    }

    protected ServerImpl(String name, SocketAddress address, String motd, boolean hidden, boolean restricted) throws InvalidServerException {
        super(name, address, motd, restricted);
        this.init(name, address, motd, hidden, restricted);
    }

    protected ServerImpl(String name, InetSocketAddress address, String motd, boolean hidden, boolean restricted) throws InvalidServerException {
        super(name, address, motd, restricted);
        this.init(name, address, motd, hidden, restricted);
    }

    private void init(String name, SocketAddress address, String motd, boolean hidden, boolean restricted) throws InvalidServerException {
        Util.nullpo((Object[])new Serializable[]{name, address, motd, Boolean.valueOf(hidden), Boolean.valueOf(restricted)});
        if (name.contains(" ")) {
            throw new InvalidServerException("Server names cannot have spaces: " + name);
        }
        SubAPI.getInstance().getInternals().subprotocol.whitelist(this.getAddress().getAddress().getHostAddress());
        this.hidden = hidden;
        this.subdata.put(0, null);
    }

    protected boolean isRegistered() {
        return SubAPI.getInstance().getInternals().exServers.containsKey(this.getName().toLowerCase());
    }

    public DataClient[] getSubData() {
        Object[] keys = this.subdata.keySet().toArray(new Integer[0]);
        DataClient[] channels = new DataClient[keys.length];
        Arrays.sort(keys);
        for (int i = 0; i < keys.length; ++i) {
            channels[i] = (DataClient)this.subdata.get(keys[i]);
        }
        return channels;
    }

    @Override
    public void setSubData(DataClient client, int channel) {
        boolean update = false;
        if (channel < 0) {
            throw new IllegalArgumentException("Subchannel ID cannot be less than zero");
        }
        if (client != null || channel == 0) {
            if (!this.subdata.containsKey(channel) || channel == 0 && (client == null || this.subdata.get(channel) == null)) {
                update = true;
                this.subdata.put(channel, (SubDataClient)client);
                if (!(client == null || client.getHandler() != null && this.equals(client.getHandler()))) {
                    ((SubDataClient)client).setHandler((ClientHandler)this);
                }
            }
        } else {
            update = true;
            this.subdata.remove(channel);
        }
        if (update) {
            DataClient[] subdata;
            for (Proxy proxy : SubAPI.getInstance().getProxies().values()) {
                if (proxy.getSubData()[0] == null) continue;
                if (client != null) {
                    ((SubDataClient)proxy.getSubData()[0]).sendPacket(new PacketOut[]{new PacketOutExEditServer(this, PacketOutExEditServer.Edit.CONNECTED, channel, client.getID())});
                    continue;
                }
                ((SubDataClient)proxy.getSubData()[0]).sendPacket(new PacketOut[]{new PacketOutExEditServer(this, PacketOutExEditServer.Edit.DISCONNECTED, channel)});
            }
            if (!this.persistent && (subdata = this.getSubData())[0] == null && subdata.length <= 1) {
                SubAPI.getInstance().removeServer(this.getName());
            }
        }
    }

    public void removeSubData(DataClient client) {
        for (Integer channel : Util.getBackwards(this.subdata, (Object)((SubDataClient)client))) {
            this.setSubData(null, channel);
        }
    }

    @Override
    public String getDisplayName() {
        return this.nick == null ? this.getName() : this.nick;
    }

    @Override
    public void setDisplayName(String value) {
        this.nick = value == null || value.length() == 0 || this.getName().equals(value) ? null : value;
        for (Proxy proxy : SubAPI.getInstance().getProxies().values()) {
            if (proxy.getSubData()[0] == null) continue;
            ((SubDataClient)proxy.getSubData()[0]).sendPacket(new PacketOut[]{new PacketOutExEditServer(this, PacketOutExEditServer.Edit.DISPLAY_NAME, this.getDisplayName())});
        }
    }

    @Override
    public List<String> getGroups() {
        return this.groups;
    }

    @Override
    public void addGroup(String value) {
        Util.nullpo((Object)value);
        if (value.length() > 0 && !this.groups.contains(value)) {
            this.groups.add(value);
            Collections.sort(this.groups);
        }
    }

    @Override
    public void removeGroup(String value) {
        Util.nullpo((Object)value);
        this.groups.remove(value);
        Collections.sort(this.groups);
    }

    @Override
    public boolean command(UUID player, UUID target, String command) {
        Util.nullpo((Object)command);
        SubDataClient channel = (SubDataClient)this.getSubData()[0];
        if (channel != null) {
            SubSendCommandEvent event = new SubSendCommandEvent(player, this, command, target);
            ProxyServer.getInstance().getPluginManager().callEvent((Event)event);
            if (!(event.isCancelled() || player != null && SubServerImpl.DISALLOWED_COMMANDS.matcher(command).find())) {
                channel.sendPacket(new PacketOut[]{new PacketExControlPlayer(target, command, new Consumer[0])});
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public Collection<RemotePlayer> getRemotePlayers() {
        return SubAPI.getInstance().getRemotePlayers(this).values();
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void setHidden(boolean value) {
        this.hidden = value;
        if (this.isRegistered()) {
            for (Proxy proxy : SubAPI.getInstance().getProxies().values()) {
                if (proxy.getSubData()[0] == null) continue;
                ((SubDataClient)proxy.getSubData()[0]).sendPacket(new PacketOut[]{new PacketOutExEditServer(this, PacketOutExEditServer.Edit.HIDDEN, this.isHidden())});
            }
        }
    }

    @Override
    public void setMotd(String value) {
        Util.nullpo((Object)value);
        try {
            Util.reflect((Field)BungeeServerInfo.class.getDeclaredField("motd"), (Object)this, (Object)value);
            for (Proxy proxy : SubAPI.getInstance().getProxies().values()) {
                if (proxy.getSubData()[0] == null) continue;
                ((SubDataClient)proxy.getSubData()[0]).sendPacket(new PacketOut[]{new PacketOutExEditServer(this, PacketOutExEditServer.Edit.MOTD, this.getMotd())});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setRestricted(boolean value) {
        Util.nullpo((Object)value);
        try {
            Util.reflect((Field)BungeeServerInfo.class.getDeclaredField("restricted"), (Object)this, (Object)value);
            if (this.isRegistered()) {
                for (Proxy proxy : SubAPI.getInstance().getProxies().values()) {
                    if (proxy.getSubData()[0] == null) continue;
                    ((SubDataClient)proxy.getSubData()[0]).sendPacket(new PacketOut[]{new PacketOutExEditServer(this, PacketOutExEditServer.Edit.RESTRICTED, this.isRestricted())});
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean canAccess(CommandSender player) {
        return super.canAccess(player) || player instanceof ProxiedPlayer && this.whitelist.contains(((ProxiedPlayer)player).getUniqueId());
    }

    @Override
    public Collection<UUID> getWhitelist() {
        return new ArrayList<UUID>(this.whitelist);
    }

    @Override
    public boolean isWhitelisted(UUID player) {
        return this.whitelist.contains(player);
    }

    @Override
    public void whitelist(UUID player) {
        Util.nullpo((Object)player);
        if (!this.whitelist.contains(player)) {
            this.whitelist.add(player);
        }
        if (this.isRegistered()) {
            for (Proxy proxy : SubAPI.getInstance().getProxies().values()) {
                if (proxy.getSubData()[0] == null) continue;
                ((SubDataClient)proxy.getSubData()[0]).sendPacket(new PacketOut[]{new PacketOutExEditServer(this, PacketOutExEditServer.Edit.WHITELIST_ADD, player)});
            }
        }
    }

    @Override
    public void unwhitelist(UUID player) {
        Util.nullpo((Object)player);
        this.whitelist.remove(player);
        if (this.isRegistered()) {
            for (Proxy proxy : SubAPI.getInstance().getProxies().values()) {
                if (proxy.getSubData()[0] == null) continue;
                ((SubDataClient)proxy.getSubData()[0]).sendPacket(new PacketOut[]{new PacketOutExEditServer(this, PacketOutExEditServer.Edit.WHITELIST_REMOVE, player)});
            }
        }
    }

    @Override
    public final void persist() {
        this.persistent = true;
    }

    @Override
    public final String getSignature() {
        return this.signature;
    }

    public boolean equals(Object obj) {
        return obj instanceof ServerImpl && this.signature.equals(((ServerImpl)obj).signature);
    }

    public void addExtra(String handle, Object value) {
        Util.nullpo((Object[])new Object[]{handle, value});
        this.extra.set((Object)handle, value);
    }

    public boolean hasExtra(String handle) {
        Util.nullpo((Object)handle);
        return this.extra.getKeys().contains(handle);
    }

    public ObjectMapValue getExtra(String handle) {
        Util.nullpo((Object)handle);
        return this.extra.get((Object)handle);
    }

    public ObjectMap<String> getExtra() {
        return this.extra.clone();
    }

    public void removeExtra(String handle) {
        Util.nullpo((Object)handle);
        this.extra.remove((Object)handle);
    }

    public ObjectMap<String> forSubData() {
        ObjectMap info = new ObjectMap();
        info.set((Object)"type", (Object)"Server");
        info.set((Object)"name", (Object)this.getName());
        info.set((Object)"display", (Object)this.getDisplayName());
        info.set((Object)"group", this.getGroups());
        info.set((Object)"address", (Object)(this.getAddress().getAddress().getHostAddress() + ':' + this.getAddress().getPort()));
        info.set((Object)"motd", (Object)this.getMotd());
        info.set((Object)"whitelist", this.getWhitelist());
        info.set((Object)"restricted", (Object)this.isRestricted());
        info.set((Object)"hidden", (Object)this.isHidden());
        ObjectMap players = new ObjectMap();
        for (RemotePlayer player : this.getRemotePlayers()) {
            players.set((Object)player.getUniqueId().toString(), (Object)player.getName());
        }
        info.set((Object)"players", (Object)players);
        ObjectMap subdata = new ObjectMap();
        for (int channel : this.subdata.keySet()) {
            subdata.set((Object)channel, this.subdata.get(channel) == null ? null : this.subdata.get(channel).getID());
        }
        info.set((Object)"subdata", (Object)subdata);
        info.set((Object)"signature", (Object)this.signature);
        info.set((Object)"extra", this.getExtra());
        return info;
    }
}

