/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Bungee.Host;

import com.google.common.collect.Range;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.ME1312.Galaxi.Library.Map.ObjectMap;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.Galaxi.Library.Version.Version;
import net.ME1312.SubServers.Bungee.Host.Host;
import net.ME1312.SubServers.Bungee.Host.Server;
import net.ME1312.SubServers.Bungee.Host.SubLogger;
import net.ME1312.SubServers.Bungee.Host.SubServer;
import net.ME1312.SubServers.Bungee.Library.Exception.InvalidTemplateException;
import net.ME1312.SubServers.Bungee.SubAPI;

public abstract class SubCreator {
    public abstract boolean create(UUID var1, String var2, ServerTemplate var3, Version var4, Integer var5, Consumer<SubServer> var6);

    public boolean create(UUID player, String name, ServerTemplate template, Version version, Integer port) {
        return this.create(player, name, template, version, port, null);
    }

    public boolean create(String name, ServerTemplate template, Version version, Integer port, Consumer<SubServer> callback) {
        return this.create(null, name, template, version, port, callback);
    }

    public boolean create(String name, ServerTemplate template, Version version, Integer port) {
        return this.create(null, name, template, version, port);
    }

    public abstract boolean update(UUID var1, SubServer var2, ServerTemplate var3, Version var4, Consumer<Boolean> var5);

    public boolean update(UUID player, SubServer server, ServerTemplate template, Version version) {
        return this.update(player, server, template, version, null);
    }

    public boolean update(SubServer server, ServerTemplate template, Version version, Consumer<Boolean> callback) {
        return this.update(null, server, template, version, callback);
    }

    public boolean update(SubServer server, ServerTemplate template, Version version) {
        return this.update(null, server, template, version);
    }

    public boolean update(UUID player, SubServer server, Version version) {
        return this.update(player, server, null, version);
    }

    public boolean update(SubServer server, Version version) {
        return this.update(null, server, version);
    }

    public abstract void terminate();

    public abstract void terminate(String var1);

    public abstract void waitFor() throws InterruptedException;

    public abstract void waitFor(String var1) throws InterruptedException;

    public abstract Host getHost();

    public abstract Range getPortRange();

    public abstract void setPortRange(Range<Integer> var1);

    public abstract String getBashDirectory();

    public abstract List<SubLogger> getLoggers();

    public abstract SubLogger getLogger(String var1);

    public abstract boolean isLogging();

    public abstract void setLogging(boolean var1);

    public abstract List<String> getReservedNames();

    public abstract List<Integer> getReservedPorts();

    public static boolean isReserved(String name) {
        boolean reserved = false;
        for (List<String> list : SubCreator.getAllReservedNames().values()) {
            for (String reserve : list) {
                if (!reserve.equalsIgnoreCase(name)) continue;
                reserved = true;
            }
        }
        return reserved;
    }

    public static boolean isReserved(InetSocketAddress address) {
        boolean reserved = false;
        for (InetSocketAddress list : SubCreator.getAllReservedAddresses()) {
            if (!list.equals(address)) continue;
            reserved = true;
        }
        return reserved;
    }

    public static Map<Host, List<String>> getAllReservedNames() {
        HashMap<Host, List<String>> names = new HashMap<Host, List<String>>();
        for (Host host : SubAPI.getInstance().getHosts().values()) {
            names.put(host, host.getCreator().getReservedNames());
        }
        return names;
    }

    public static List<InetSocketAddress> getAllReservedAddresses() {
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
        for (Server server : SubAPI.getInstance().getSubServers().values()) {
            addresses.add(server.getAddress());
        }
        for (Host host : SubAPI.getInstance().getHosts().values()) {
            for (int port : host.getCreator().getReservedPorts()) {
                addresses.add(new InetSocketAddress(host.getAddress(), port));
            }
        }
        return addresses;
    }

    public abstract Map<String, ServerTemplate> getTemplates();

    public abstract ServerTemplate getTemplate(String var1);

    protected ServerTemplate loadTemplate(String name, boolean enabled, boolean internal, String icon, File directory, ObjectMap<String> build, ObjectMap<String> options) {
        return new ServerTemplate(name, enabled, internal, icon, directory, build, options, false);
    }

    public abstract void reload();

    public boolean equals(Object obj) {
        return obj instanceof SubCreator && this.getHost().getSignature().equals(((SubCreator)obj).getHost().getSignature());
    }

    public static class ServerTemplate {
        private final boolean dynamic;
        private String name;
        private String nick = null;
        private boolean enabled;
        private boolean internal;
        private String icon;
        private File directory;
        private ServerType type;
        private ObjectMap<String> build;
        private ObjectMap<String> options;

        public ServerTemplate(String name, boolean enabled, String icon, File directory, ObjectMap<String> build, ObjectMap<String> options) {
            this(name, enabled, false, icon, directory, build, options, true);
        }

        private ServerTemplate(String name, boolean enabled, boolean internal, String icon, File directory, ObjectMap<String> build, ObjectMap<String> options, boolean dynamic) {
            Util.nullpo((Object[])new Object[]{name, enabled, directory, build, options});
            if (name.contains(" ")) {
                throw new InvalidTemplateException("Template names cannot have spaces: " + name);
            }
            this.name = name;
            this.enabled = enabled;
            this.internal = internal;
            this.icon = icon;
            this.directory = directory;
            this.type = build.contains((Object)"Server-Type") ? ServerType.valueOf(build.getString((Object)"Server-Type").toUpperCase()) : ServerType.CUSTOM;
            this.build = build;
            this.options = options;
            this.dynamic = dynamic;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.nick == null ? this.getName() : this.nick;
        }

        public void setDisplayName(String value) {
            this.nick = value == null || value.length() == 0 || this.getName().equals(value) ? null : value;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean value) {
            this.enabled = value;
        }

        public boolean isInternal() {
            return this.internal;
        }

        public String getIcon() {
            return this.icon;
        }

        public void setIcon(String value) {
            this.icon = value;
        }

        public File getDirectory() {
            return this.directory;
        }

        public ServerType getType() {
            return this.type;
        }

        public boolean requiresVersion() {
            return this.getBuildOptions().getBoolean((Object)"Require-Version", Boolean.valueOf(false));
        }

        public boolean canUpdate() {
            return this.getBuildOptions().getBoolean((Object)"Can-Update", Boolean.valueOf(false));
        }

        public boolean isDynamic() {
            return this.dynamic;
        }

        public ObjectMap<String> getBuildOptions() {
            return this.build;
        }

        public ObjectMap<String> getConfigOptions() {
            return this.options;
        }

        public ObjectMap<String> forSubData() {
            ObjectMap tinfo = new ObjectMap();
            tinfo.set((Object)"enabled", (Object)this.isEnabled());
            tinfo.set((Object)"name", (Object)this.getName());
            tinfo.set((Object)"display", (Object)this.getDisplayName());
            tinfo.set((Object)"icon", (Object)this.getIcon());
            tinfo.set((Object)"type", (Object)this.getType().toString());
            tinfo.set((Object)"version-req", (Object)this.requiresVersion());
            tinfo.set((Object)"can-update", (Object)this.canUpdate());
            return tinfo;
        }
    }

    public static enum ServerType {
        SPIGOT,
        VANILLA,
        FORGE,
        SPONGE,
        CUSTOM;


        public String toString() {
            return super.toString().substring(0, 1).toUpperCase() + super.toString().substring(1).toLowerCase();
        }
    }
}

