/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Bungee.Library;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.ME1312.Galaxi.Library.Config.YAMLConfig;
import net.ME1312.Galaxi.Library.Config.YAMLSection;
import net.ME1312.Galaxi.Library.Map.ObjectMap;
import net.ME1312.Galaxi.Library.Version.Version;
import net.ME1312.SubServers.Bungee.Library.Compatibility.Logger;
import net.ME1312.SubServers.Bungee.SubAPI;

public class ConfigUpdater {
    private static final Version UNSIGNED = new Version(new SimpleDateFormat("yy'w'ww'zz'").format(Calendar.getInstance().getTime()));

    public static void updateConfig(File file) throws IOException {
        YAMLConfig config = new YAMLConfig(file);
        YAMLSection existing = config.get().clone();
        YAMLSection updated = existing.clone();
        YAMLSection rewritten = new YAMLSection();
        Version was = existing.getMap((Object)"Settings", new ObjectMap()).getVersion((Object)"Version", new Version(new int[]{0}));
        Version now = SubAPI.getInstance().getWrapperBuild();
        int i = 0;
        if (now == null) {
            now = UNSIGNED;
        }
        if (!existing.contains((Object)"Settings") || !existing.getMap((Object)"Settings").contains((Object)"Version")) {
            YAMLSection hosts = new YAMLSection();
            YAMLSection host = new YAMLSection();
            host.set((Object)"Enabled", (Object)true);
            host.set((Object)"Display", (Object)"Default");
            hosts.set((Object)"~", (Object)host);
            updated.set((Object)"Hosts", (Object)hosts);
            ++i;
            Logger.get((String)"SubServers").info("Created ./SubServers/config.yml");
        } else {
            if (was.compareTo(new Version("19w17a")) <= 0) {
                if (existing.getMap((Object)"Settings", (ObjectMap)new YAMLSection()).contains((Object)"Log-Creator")) {
                    for (String name : existing.getMap((Object)"Hosts", (ObjectMap)new YAMLSection()).getKeys()) {
                        updated.getMap((Object)"Hosts").getMap((Object)name).safeSet((Object)"Log-Creator", (Object)existing.getMap((Object)"Settings").getBoolean((Object)"Log-Creator"));
                    }
                }
                if (existing.getMap((Object)"Settings", (ObjectMap)new YAMLSection()).contains((Object)"SubData") && !existing.getMap((Object)"Settings", (ObjectMap)new YAMLSection()).getMap((Object)"SubData").contains((Object)"Encryption")) {
                    updated.getMap((Object)"Settings").getMap((Object)"SubData").set((Object)"Encryption", (Object)"NONE");
                }
                if (existing.contains((Object)"Servers")) {
                    YAMLConfig sc = new YAMLConfig(new File(file.getParentFile(), "servers.yml"));
                    YAMLSection settings = new YAMLSection();
                    settings.set((Object)"Version", (Object)was.toString());
                    settings.set((Object)"Run-On-Launch-Timeout", (Object)(existing.getMap((Object)"Settings", (ObjectMap)new YAMLSection()).contains((Object)"Run-On-Launch-Timeout") ? existing.getMap((Object)"Settings").getInt((Object)"Run-On-Launch-Timeout") : 0));
                    sc.get().safeSet((Object)"Settings", (Object)settings);
                    sc.get().safeSet((Object)"Servers", (Object)new YAMLSection());
                    sc.get().getMap((Object)"Servers").safeSetAll(existing.getMap((Object)"Servers"));
                    Logger.get((String)"SubServers").info("Created ./SubServers/servers.yml (using existing data)");
                    sc.save();
                }
                existing = updated.clone();
                ++i;
            }
            if (was.compareTo(new Version("19w35c")) <= 0) {
                if (existing.getMap((Object)"Settings", (ObjectMap)new YAMLSection()).contains((Object)"SubData")) {
                    LinkedList whitelist = new LinkedList();
                    LinkedList<String> newWhitelist = new LinkedList<String>();
                    whitelist.addAll(existing.getMap((Object)"Settings", (ObjectMap)new YAMLSection()).getMap((Object)"SubData", (ObjectMap)new YAMLSection()).getStringList((Object)"Allowed-Connections", Collections.emptyList()));
                    whitelist.addAll(existing.getMap((Object)"Settings", (ObjectMap)new YAMLSection()).getMap((Object)"SubData", (ObjectMap)new YAMLSection()).getStringList((Object)"Whitelist", Collections.emptyList()));
                    boolean warnPls = false;
                    Iterator iterator = whitelist.iterator();
                    while (iterator.hasNext()) {
                        String address = (String)iterator.next();
                        Matcher regAddress = Pattern.compile("^(\\d{1,3}|%)\\.(\\d{1,3}|%)\\.(\\d{1,3}|%)\\.(\\d{1,3}|%)$").matcher(address);
                        if (!regAddress.find()) continue;
                        StringBuilder newAddress = new StringBuilder();
                        int subnet = -1;
                        boolean warn = false;
                        for (int o = 1; o <= 4; ++o) {
                            if (o > 1) {
                                newAddress.append('.');
                            }
                            if (subnet == -1) {
                                if (!regAddress.group(o).equals("%")) {
                                    newAddress.append(regAddress.group(o));
                                    continue;
                                }
                                subnet = 8 * (o - 1);
                                newAddress.append('0');
                                continue;
                            }
                            if (!regAddress.group(o).equals("%")) {
                                warnPls = true;
                                warn = true;
                            }
                            newAddress.append('0');
                        }
                        if (subnet < 0) {
                            subnet = 32;
                        }
                        if (warn) {
                            Logger.get((String)"SubServers").warning("Updating non-standard mask: " + address);
                        }
                        newAddress.append('/');
                        newAddress.append(subnet);
                        newWhitelist.add(newAddress.toString());
                    }
                    updated.getMap((Object)"Settings").getMap((Object)"SubData").set((Object)"Whitelist", newWhitelist);
                    if (warnPls) {
                        Logger.get((String)"SubServers").warning("Non-standard masks have been updated. This may expose SubData to unintended networks!");
                    }
                }
                existing = updated.clone();
                ++i;
            }
            if (was.compareTo(new Version("20w08d")) <= 0) {
                if (existing.contains((Object)"Hosts")) {
                    for (String name : existing.getMap((Object)"Hosts", (ObjectMap)new YAMLSection()).getKeys()) {
                        if (!existing.getMap((Object)"Hosts").getMap((Object)name).getString((Object)"Driver", "BUILT_IN").replace('-', '_').replace(' ', '_').equalsIgnoreCase("BUILT_IN")) continue;
                        updated.getMap((Object)"Hosts").getMap((Object)name).set((Object)"Driver", (Object)"VIRTUAL");
                    }
                }
                existing = updated.clone();
                ++i;
            }
            if (was.compareTo(new Version("20w34a")) <= 0) {
                if (existing.getMap((Object)"Settings", (ObjectMap)new YAMLSection()).contains((Object)"Smart-Fallback") && existing.getMap((Object)"Settings").isBoolean((Object)"Smart-Fallback")) {
                    YAMLSection smart_fallback = new YAMLSection();
                    smart_fallback.set((Object)"Enabled", (Object)existing.getMap((Object)"Settings").getBoolean((Object)"Smart-Fallback"));
                    smart_fallback.set((Object)"Fallback", (Object)existing.getMap((Object)"Settings").getBoolean((Object)"Smart-Fallback"));
                    updated.getMap((Object)"Settings").set((Object)"Smart-Fallback", (Object)smart_fallback);
                }
                if (existing.getMap((Object)"Settings", (ObjectMap)new YAMLSection()).contains((Object)"Override-Bungee-Commands") && existing.getMap((Object)"Settings").isBoolean((Object)"Override-Bungee-Commands")) {
                    LinkedList<String> overrides = new LinkedList<String>();
                    if (!existing.getMap((Object)"Settings").getBoolean((Object)"Override-Bungee-Commands").booleanValue()) {
                        overrides.add("/server");
                        overrides.add("/glist");
                    }
                    updated.getMap((Object)"Settings").set((Object)"Disabled-Overrides", overrides);
                }
                existing = updated.clone();
                ++i;
            } else if (was.compareTo(new Version("21w27b")) <= 0) {
                ++i;
            }
            if (i > 0) {
                Logger.get((String)"SubServers").info("Updated ./SubServers/config.yml (" + i + " pass" + (i != 1 ? "es" : "") + ")");
            }
        }
        if (i > 0) {
            YAMLSection settings = new YAMLSection();
            settings.set((Object)"Version", (Object)(now.compareTo(was) <= 0 ? was : now).toString());
            if (updated.getMap((Object)"Settings", (ObjectMap)new YAMLSection()).contains((Object)"RPEC-Check-Interval")) {
                settings.set((Object)"RPEC-Check-Interval", (Object)updated.getMap((Object)"Settings").getString((Object)"RPEC-Check-Interval"));
            }
            settings.set((Object)"Strict-Server-Linking", (Object)updated.getMap((Object)"Settings", (ObjectMap)new YAMLSection()).getBoolean((Object)"Strict-Server-Linking", Boolean.valueOf(true)));
            settings.set((Object)"Disabled-Overrides", (Object)updated.getMap((Object)"Settings", (ObjectMap)new YAMLSection()).getStringList((Object)"Disabled-Overrides", Collections.emptyList()));
            YAMLSection smart_fallback = new YAMLSection();
            smart_fallback.set((Object)"Enabled", (Object)updated.getMap((Object)"Settings", (ObjectMap)new YAMLSection()).getMap((Object)"Smart-Fallback", (ObjectMap)new YAMLSection()).getBoolean((Object)"Enabled", Boolean.valueOf(true)));
            smart_fallback.set((Object)"Fallback", (Object)updated.getMap((Object)"Settings", (ObjectMap)new YAMLSection()).getMap((Object)"Smart-Fallback", (ObjectMap)new YAMLSection()).getBoolean((Object)"Fallback", Boolean.valueOf(true)));
            smart_fallback.set((Object)"Reconnect", (Object)updated.getMap((Object)"Settings", (ObjectMap)new YAMLSection()).getMap((Object)"Smart-Fallback", (ObjectMap)new YAMLSection()).getBoolean((Object)"Reconnect", Boolean.valueOf(false)));
            smart_fallback.set((Object)"DNS-Forward", (Object)updated.getMap((Object)"Settings", (ObjectMap)new YAMLSection()).getMap((Object)"Smart-Fallback", (ObjectMap)new YAMLSection()).getBoolean((Object)"DNS-Forward", Boolean.valueOf(false)));
            settings.set((Object)"Smart-Fallback", (Object)smart_fallback);
            YAMLSection upnp = new YAMLSection();
            upnp.set((Object)"Forward-Proxy", (Object)updated.getMap((Object)"Settings", (ObjectMap)new YAMLSection()).getMap((Object)"UPnP", (ObjectMap)new YAMLSection()).getBoolean((Object)"Forward-Proxy", Boolean.valueOf(true)));
            upnp.set((Object)"Forward-SubData", (Object)updated.getMap((Object)"Settings", (ObjectMap)new YAMLSection()).getMap((Object)"UPnP", (ObjectMap)new YAMLSection()).getBoolean((Object)"Forward-SubData", Boolean.valueOf(false)));
            upnp.set((Object)"Forward-Servers", (Object)updated.getMap((Object)"Settings", (ObjectMap)new YAMLSection()).getMap((Object)"UPnP", (ObjectMap)new YAMLSection()).getBoolean((Object)"Forward-Servers", Boolean.valueOf(false)));
            settings.set((Object)"UPnP", (Object)upnp);
            YAMLSection subdata = new YAMLSection();
            subdata.set((Object)"Address", (Object)updated.getMap((Object)"Settings", (ObjectMap)new YAMLSection()).getMap((Object)"SubData", (ObjectMap)new YAMLSection()).getString((Object)"Address", "127.0.0.1:4391"));
            if (updated.getMap((Object)"Settings", (ObjectMap)new YAMLSection()).getMap((Object)"SubData", (ObjectMap)new YAMLSection()).contains((Object)"Password")) {
                subdata.set((Object)"Password", (Object)updated.getMap((Object)"Settings").getMap((Object)"SubData").getString((Object)"Password"));
            }
            subdata.set((Object)"Encryption", (Object)updated.getMap((Object)"Settings", (ObjectMap)new YAMLSection()).getMap((Object)"SubData", (ObjectMap)new YAMLSection()).getString((Object)"Encryption", "RSA/AES"));
            subdata.set((Object)"Whitelist", (Object)updated.getMap((Object)"Settings", (ObjectMap)new YAMLSection()).getMap((Object)"SubData", (ObjectMap)new YAMLSection()).getStringList((Object)"Whitelist", Collections.emptyList()));
            settings.set((Object)"SubData", (Object)subdata);
            rewritten.set((Object)"Settings", (Object)settings);
            YAMLSection hosts = new YAMLSection();
            for (String name : updated.getMap((Object)"Hosts", (ObjectMap)new YAMLSection()).getKeys()) {
                YAMLSection host = new YAMLSection();
                host.set((Object)"Enabled", (Object)updated.getMap((Object)"Hosts").getMap((Object)name).getBoolean((Object)"Enabled", Boolean.valueOf(false)));
                host.set((Object)"Display", (Object)updated.getMap((Object)"Hosts").getMap((Object)name).getString((Object)"Display", ""));
                host.set((Object)"Driver", (Object)updated.getMap((Object)"Hosts").getMap((Object)name).getString((Object)"Driver", "VIRTUAL"));
                host.set((Object)"Address", (Object)updated.getMap((Object)"Hosts").getMap((Object)name).getString((Object)"Address", "127.0.0.1"));
                host.set((Object)"Port-Range", (Object)updated.getMap((Object)"Hosts").getMap((Object)name).getString((Object)"Port-Range", "25500-25559"));
                host.set((Object)"Directory", (Object)updated.getMap((Object)"Hosts").getMap((Object)name).getString((Object)"Directory", host.getString((Object)"Driver").equalsIgnoreCase("VIRTUAL") ? "./SubServers/Servers" : "./Servers"));
                host.set((Object)"Git-Bash", (Object)updated.getMap((Object)"Hosts").getMap((Object)name).getString((Object)"Git-Bash", "%ProgramFiles%\\Git"));
                host.set((Object)"Log-Creator", (Object)updated.getMap((Object)"Hosts").getMap((Object)name).getBoolean((Object)"Log-Creator", Boolean.valueOf(true)));
                if (updated.getMap((Object)"Hosts").getMap((Object)name).contains((Object)"Extra")) {
                    host.set((Object)"Extra", (Object)updated.getMap((Object)"Hosts").getMap((Object)name).getMap((Object)"Extra"));
                }
                hosts.set((Object)name, (Object)host);
            }
            rewritten.set((Object)"Hosts", (Object)hosts);
            config.set(rewritten);
            config.save();
        }
    }

    public static void updateServers(File file) throws IOException {
        YAMLConfig config = new YAMLConfig(file);
        YAMLSection existing = config.get().clone();
        YAMLSection updated = existing.clone();
        YAMLSection rewritten = new YAMLSection();
        Version was = existing.getMap((Object)"Settings", new ObjectMap()).getVersion((Object)"Version", new Version(new int[]{0}));
        Version now = SubAPI.getInstance().getWrapperBuild();
        int i = 0;
        if (now == null) {
            now = UNSIGNED;
        }
        if (!existing.contains((Object)"Settings") || !existing.getMap((Object)"Settings").contains((Object)"Version")) {
            YAMLSection servers = new YAMLSection();
            servers.set((Object)"Example", (Object)new YAMLSection());
            updated.set((Object)"Servers", (Object)servers);
            ++i;
            Logger.get((String)"SubServers").info("Created ./SubServers/servers.yml");
        } else {
            if (was.compareTo(new Version("19w17a")) <= 0) {
                if (existing.contains((Object)"Servers")) {
                    for (String name : existing.getMap((Object)"Servers", (ObjectMap)new YAMLSection()).getKeys()) {
                        if (existing.getMap((Object)"Servers").getMap((Object)name).getBoolean((Object)"Auto-Restart", Boolean.valueOf(true)).booleanValue()) {
                            updated.getMap((Object)"Servers").getMap((Object)name).safeSet((Object)"Stop-Action", (Object)"RESTART");
                        }
                        if (!existing.getMap((Object)"Servers").getMap((Object)name).getString((Object)"Stop-Action", "NONE").equalsIgnoreCase("DELETE_SERVER")) continue;
                        updated.getMap((Object)"Servers").getMap((Object)name).set((Object)"Stop-Action", (Object)"RECYCLE_SERVER");
                    }
                }
                existing = updated.clone();
                ++i;
            }
            if (i > 0) {
                Logger.get((String)"SubServers").info("Updated ./SubServers/servers.yml (" + i + " pass" + (i != 1 ? "es" : "") + ")");
            }
        }
        if (i > 0) {
            YAMLSection settings = new YAMLSection();
            settings.set((Object)"Version", (Object)(now.compareTo(was) <= 0 ? was : now).toString());
            settings.set((Object)"Run-On-Launch-Timeout", (Object)updated.getMap((Object)"Settings", (ObjectMap)new YAMLSection()).getInt((Object)"Run-On-Launch-Timeout", Integer.valueOf(0)));
            rewritten.set((Object)"Settings", (Object)settings);
            YAMLSection servers = new YAMLSection();
            for (String name : updated.getMap((Object)"Servers", (ObjectMap)new YAMLSection()).getKeys()) {
                YAMLSection server = new YAMLSection();
                server.set((Object)"Enabled", (Object)updated.getMap((Object)"Servers").getMap((Object)name).getBoolean((Object)"Enabled", Boolean.valueOf(false)));
                server.set((Object)"Display", (Object)updated.getMap((Object)"Servers").getMap((Object)name).getString((Object)"Display", ""));
                server.set((Object)"Host", (Object)updated.getMap((Object)"Servers").getMap((Object)name).getString((Object)"Host", "~"));
                if (updated.getMap((Object)"Servers").getMap((Object)name).contains((Object)"Template")) {
                    server.set((Object)"Template", (Object)updated.getMap((Object)"Servers").getMap((Object)name).getString((Object)"Template"));
                }
                server.set((Object)"Group", (Object)updated.getMap((Object)"Servers").getMap((Object)name).getStringList((Object)"Groups", Collections.emptyList()));
                server.set((Object)"Port", (Object)updated.getMap((Object)"Servers").getMap((Object)name).getInt((Object)"Port", Integer.valueOf(25567)));
                server.set((Object)"Motd", (Object)updated.getMap((Object)"Servers").getMap((Object)name).getString((Object)"Motd", "Some SubServer"));
                server.set((Object)"Log", (Object)updated.getMap((Object)"Servers").getMap((Object)name).getBoolean((Object)"Log", Boolean.valueOf(true)));
                server.set((Object)"Directory", (Object)updated.getMap((Object)"Servers").getMap((Object)name).getString((Object)"Directory", "." + File.separatorChar));
                server.set((Object)"Executable", (Object)updated.getMap((Object)"Servers").getMap((Object)name).getString((Object)"Executable", "java -Xmx1024M -Djline.terminal=jline.UnsupportedTerminal -jar Spigot.jar"));
                server.set((Object)"Stop-Command", (Object)updated.getMap((Object)"Servers").getMap((Object)name).getString((Object)"Stop-Command", "stop"));
                server.set((Object)"Stop-Action", (Object)updated.getMap((Object)"Servers").getMap((Object)name).getString((Object)"Stop-Action", "NONE"));
                server.set((Object)"Run-On-Launch", (Object)updated.getMap((Object)"Servers").getMap((Object)name).getBoolean((Object)"Run-On-Launch", Boolean.valueOf(false)));
                server.set((Object)"Restricted", (Object)updated.getMap((Object)"Servers").getMap((Object)name).getBoolean((Object)"Restricted", Boolean.valueOf(false)));
                server.set((Object)"Incompatible", (Object)updated.getMap((Object)"Servers").getMap((Object)name).getStringList((Object)"Incompatible", Collections.emptyList()));
                server.set((Object)"Hidden", (Object)updated.getMap((Object)"Servers").getMap((Object)name).getBoolean((Object)"Hidden", Boolean.valueOf(false)));
                if (updated.getMap((Object)"Servers").getMap((Object)name).contains((Object)"Extra")) {
                    server.set((Object)"Extra", (Object)updated.getMap((Object)"Servers").getMap((Object)name).getMap((Object)"Extra"));
                }
                servers.set((Object)name, (Object)server);
            }
            rewritten.set((Object)"Servers", (Object)servers);
            config.set(rewritten);
            config.save();
        }
    }

    public static void updateLang(File file) throws IOException {
        YAMLConfig config = new YAMLConfig(file);
        YAMLSection existing = config.get().clone();
        YAMLSection updated = existing.clone();
        YAMLSection rewritten = new YAMLSection();
        Version was = existing.getMap((Object)"Settings", new ObjectMap()).getVersion((Object)"Version", new Version(new int[]{0}));
        Version now = SubAPI.getInstance().getWrapperBuild();
        int i = 0;
        if (now == null) {
            now = UNSIGNED;
        }
        if (!existing.contains((Object)"Settings") || !existing.getMap((Object)"Settings").contains((Object)"Version")) {
            ++i;
            Logger.get((String)"SubServers").info("Created ./SubServers/lang.yml");
        } else {
            if (was.compareTo(new Version("19w22b")) <= 0) {
                if (existing.contains((Object)"Lang")) {
                    updated.getMap((Object)"Lang").remove((Object)"Interface.Host-Admin.SubServers");
                    updated.getMap((Object)"Lang").remove((Object)"Interface.Server-Admin.Command");
                }
                existing = updated.clone();
                ++i;
            }
            if (was.compareTo(new Version("20w08d")) <= 0) {
                if (existing.contains((Object)"Lang")) {
                    LinkedList keys = new LinkedList(existing.getMap((Object)"Lang").getKeys());
                    for (String key : keys) {
                        if (!key.startsWith("Command.")) continue;
                        updated.getMap((Object)"Lang").remove((Object)key);
                    }
                }
                existing = updated.clone();
                ++i;
            }
            if (was.compareTo(new Version("22w07c")) <= 0) {
                if (existing.contains((Object)"Lang")) {
                    updated.getMap((Object)"Lang").remove((Object)"Command.Teleport");
                }
                existing = updated.clone();
                ++i;
            }
            if (i > 0) {
                Logger.get((String)"SubServers").info("Updated ./SubServers/lang.yml (" + i + " pass" + (i != 1 ? "es" : "") + ")");
            }
        }
        if (i > 0) {
            YAMLSection settings = new YAMLSection();
            settings.set((Object)"Version", (Object)(now.compareTo(was) <= 0 ? was : now).toString());
            rewritten.set((Object)"Settings", (Object)settings);
            LinkedHashMap<String, String> def = new LinkedHashMap<String, String>();
            def.put("Bungee.Feature.Smart-Fallback", "&6Returning from $str$: &r$msg$");
            def.put("Bungee.Feature.Smart-Fallback.Result", "&6You are now on $str$.");
            def.put("Bungee.Restricted", "&cYou don't have permission to access this server.");
            def.put("Bungee.Ping.Offline", "&6&l[&e&lWarning&6&l] &7Backend server(s) are not running");
            def.put("Bungee.Server.Current", "&6You are currently connected to $str$");
            def.put("Bungee.Server.Available", "&6You may connect to the following servers at this time:");
            def.put("Bungee.Server.List", "&6$str$");
            def.put("Bungee.Server.Hover", "$int$ player(s)\\n&oClick to connect to the server");
            def.put("Bungee.Server.Divider", "&6, ");
            def.put("Bungee.Server.Offline", "&cThe specified server is not currently running.");
            def.put("Bungee.Server.Invalid", "&cThe specified server does not exist.");
            def.put("Bungee.List.Format", "&a[$str$] &e($int$)&r: ");
            def.put("Bungee.List.List", "&f$str$");
            def.put("Bungee.List.Divider", "&f, ");
            def.put("Bungee.List.Total", "Total players online: $int$");
            def.put("Signs.Create", "&aSubServers &2&l\\u00BB&a Server sign activated");
            def.put("Signs.Delete", "&aSubServers &2&l\\u00BB&a Server sign removed");
            def.put("Signs.Text.Unknown", "&f&oSubServers\\n&3$str$\\n&7Unknown Status\\n&8\\u2022 \\u2022 \\u2022 \\u2022 \\u2022 \\u2022 \\u2022");
            def.put("Signs.Text.Offline", "&c&oSubServers\\n&3$str$\\n&4Offline\\n&7Click to Start");
            def.put("Signs.Text.Starting", "&e&oSubServers\\n&3$str$\\n&6Starting\\n&8\\u2022 \\u2022 \\u2022 \\u2022 \\u2022 \\u2022 \\u2022");
            def.put("Signs.Text.Online", "&a&oSubServers\\n&3$str$\\n&2$int$ Online\\n&7Click to Join");
            def.put("Signs.Text.Stopping", "&e&oSubServers\\n&3$str$\\n&6Stopping\\n&8\\u2022 \\u2022 \\u2022 \\u2022 \\u2022 \\u2022 \\u2022");
            def.put("Command.Generic.Player-Only", "&cSubServers &4&l\\u00BB&c The console cannot perform this command");
            def.put("Command.Generic.Console-Only", "&cSubServers &4&l\\u00BB&c This command is for console use only");
            def.put("Command.Generic.Usage", "&7SubServers &8&l\\u00BB&7 Usage: &f$str$");
            def.put("Command.Generic.Exception", "&cSubServers &4&l\\u00BB&c An unexpected exception has occurred while parsing this command");
            def.put("Command.Generic.Invalid-Subcommand", "&cSubServers &4&l\\u00BB&c Unknown sub-command: &4$str$");
            def.put("Command.Generic.Invalid-Permission", "&cSubServers &4&l\\u00BB&c You need &4&n$str$&c to use this command");
            def.put("Command.Generic.Invalid-Select-Permission", "&cSubServers &4&l\\u00BB&c You don't have permission to select &4$str$");
            def.put("Command.Generic.Unknown-Proxy", "&cSubServers &4&l\\u00BB&c There is no proxy named &4$str$");
            def.put("Command.Generic.Unknown-Host", "&cSubServers &4&l\\u00BB&c There is no host named &4$str$");
            def.put("Command.Generic.Unknown-Group", "&cSubServers &4&l\\u00BB&c There is no group named &4$str$");
            def.put("Command.Generic.Unknown-Server", "&cSubServers &4&l\\u00BB&c There is no server named &4$str$");
            def.put("Command.Generic.Unknown-SubServer", "&cSubServers &4&l\\u00BB&c There is no subserver named &4$str$");
            def.put("Command.Generic.Unknown-Player", "&cSubServers &4&l\\u00BB&c There is no player named &4$str$");
            def.put("Command.Generic.No-Servers-On-Host", "&7SubServers &8&l\\u00BB&7 There are no servers on host &f$str$");
            def.put("Command.Generic.No-SubServers-On-Host", "&7SubServers &8&l\\u00BB&7 There are no subservers on host &f$str$");
            def.put("Command.Generic.No-Servers-In-Group", "&7SubServers &8&l\\u00BB&7 There are no servers in group &f$str$");
            def.put("Command.Generic.No-SubServers-In-Group", "&7SubServers &8&l\\u00BB&7 There are no subservers in group &f$str$");
            def.put("Command.Generic.No-Servers-Selected", "&cSubServers &4&l\\u00BB&c No servers were selected");
            def.put("Command.Generic.No-SubServers-Selected", "&cSubServers &4&l\\u00BB&c No subservers were selected");
            def.put("Command.Help.Header", "&7SubServers &8&l\\u00BB&7 Command Help:");
            def.put("Command.Help.Help", "   &7Help:&f $str$");
            def.put("Command.Help.List", "   &7List:&f $str$");
            def.put("Command.Help.Version", "   &7Version:&f $str$");
            def.put("Command.Help.Info", "   &7Info:&f $str$");
            def.put("Command.Help.Host.Create", "   &7Create Server:&f $str$");
            def.put("Command.Help.SubServer.Start", "   &7Start Server:&f $str$");
            def.put("Command.Help.SubServer.Restart", "   &7Restart Server:&f $str$");
            def.put("Command.Help.SubServer.Stop", "   &7Stop Server:&f $str$");
            def.put("Command.Help.SubServer.Terminate", "   &7Terminate Server:&f $str$");
            def.put("Command.Help.SubServer.Command", "   &7Command Server:&f $str$");
            def.put("Command.Help.SubServer.Update", "   &7Update Server:&f $str$");
            def.put("Command.Version", "&7SubServers &8&l\\u00BB&7 These are the platforms and versions that are running &f$str$&7:");
            def.put("Command.Version.Outdated", "&7$name$ &f$str$ &7is available. You are $int$ version(s) behind.");
            def.put("Command.Version.Latest", "&7You are on the latest version.");
            def.put("Command.List.Group-Header", "&7SubServers &8&l\\u00BB&7 Group/Server List:");
            def.put("Command.List.Host-Header", "&7SubServers &8&l\\u00BB&7 Host/SubServer List:");
            def.put("Command.List.Server-Header", "&7SubServers &8&l\\u00BB&7 Server List:");
            def.put("Command.List.Proxy-Header", "&7SubServers &8&l\\u00BB&7 Proxy List:");
            def.put("Command.List.Header", "&7: ");
            def.put("Command.List.Divider", "&7, ");
            def.put("Command.List.Empty", "&7(none)");
            def.put("Command.Info", "&7SubServers &8&l\\u00BB&7 Info on $str$: &r");
            def.put("Command.Info.Unknown", "&cSubServers &4&l\\u00BB&c There is no object with that name");
            def.put("Command.Info.Unknown-Type", "&cSubServers &4&l\\u00BB&c There is no object type with that name");
            def.put("Command.Info.Unknown-Proxy", "&cSubServers &4&l\\u00BB&c There is no proxy with that name");
            def.put("Command.Info.Unknown-Host", "&cSubServers &4&l\\u00BB&c There is no host with that name");
            def.put("Command.Info.Unknown-Group", "&cSubServers &4&l\\u00BB&c There is no group with that name");
            def.put("Command.Info.Unknown-Server", "&cSubServers &4&l\\u00BB&c There is no server with that name");
            def.put("Command.Info.Unknown-Player", "&cSubServers &4&l\\u00BB&c There is no player with that name");
            def.put("Command.Info.Format", " -> &7$str$&7: &r");
            def.put("Command.Info.List", "  - ");
            def.put("Command.Start", "&aSubServers &2&l\\u00BB&a Started &2$int$&a subserver(s)");
            def.put("Command.Start.Disappeared", "&cSubServers &4&l\\u00BB&c Subserver &4$str$&c has disappeared");
            def.put("Command.Start.Host-Unavailable", "&cSubServers &4&l\\u00BB&c The host for &4$str$&c is not available");
            def.put("Command.Start.Host-Disabled", "&cSubServers &4&l\\u00BB&c The host for &4$str$&c is not enabled");
            def.put("Command.Start.Server-Unavailable", "&cSubServers &4&l\\u00BB&c Subserver &4$str$&c is not available");
            def.put("Command.Start.Server-Disabled", "&cSubServers &4&l\\u00BB&c Subserver &4$str$&c is not enabled");
            def.put("Command.Start.Server-Incompatible", "&cSubServers &4&l\\u00BB&c Subserver &4$str$&c cannot start while incompatible server(s) are running");
            def.put("Command.Start.Running", "&7SubServers &8&l\\u00BB&7 &f$int$&7 subserver(s) were already running");
            def.put("Command.Restart", "&aSubServers &2&l\\u00BB&a Restarting &2$int$&a subserver(s)");
            def.put("Command.Restart.Disappeared", "&cSubServers &4&l\\u00BB&c Could not restart server: Subserver &4$str$&c has disappeared");
            def.put("Command.Restart.Host-Unavailable", "&cSubServers &4&l\\u00BB&c Could not restart server: The host for &4$str$&c is no longer available");
            def.put("Command.Restart.Host-Disabled", "&cSubServers &4&l\\u00BB&c Could not restart server: The host for &4$str$&c is no longer enabled");
            def.put("Command.Restart.Server-Unavailable", "&cSubServers &4&l\\u00BB&c Could not restart server: Subserver &4$str$&c is no longer available");
            def.put("Command.Restart.Server-Disabled", "&cSubServers &4&l\\u00BB&c Could not restart server: Subserver &4$str$&c is no longer enabled");
            def.put("Command.Restart.Server-Incompatible", "&cSubServers &4&l\\u00BB&c Could not restart server: Subserver &4$str$&c cannot start while incompatible server(s) are running");
            def.put("Command.Stop", "&aSubServers &2&l\\u00BB&a Stopping &2$int$&a subserver(s)");
            def.put("Command.Stop.Disappeared", "&cSubServers &4&l\\u00BB&c Subserver &4$str$&c has disappeared");
            def.put("Command.Stop.Not-Running", "&7SubServers &8&l\\u00BB&7 &f$int$&7 subserver(s) were already offline");
            def.put("Command.Terminate", "&aSubServers &2&l\\u00BB&a Terminated &2$int$&a subserver(s)");
            def.put("Command.Terminate.Disappeared", "&cSubServers &4&l\\u00BB&c Subserver &4$str$&c has disappeared");
            def.put("Command.Terminate.Not-Running", "&7SubServers &8&l\\u00BB&7 &f$int$&7 subserver(s) were already offline");
            def.put("Command.Command", "&aSubServers &2&l\\u00BB&a Sent command to &2$int$&a server(s)");
            def.put("Command.Command.Disappeared", "&cSubServers &4&l\\u00BB&c Server &4$str$&c has disappeared");
            def.put("Command.Command.No-Command", "&cSubServers &4&l\\u00BB&c No command was entered");
            def.put("Command.Command.Not-Running", "&7SubServers &8&l\\u00BB&7 &f$int$&7 server(s) were unavailable");
            def.put("Command.Creator", "&aSubServers &2&l\\u00BB&a Creating subserver &2$str$&a");
            def.put("Command.Creator.Exists", "&cSubServers &4&l\\u00BB&c There is already a subserver with that name");
            def.put("Command.Creator.Unknown-Host", "&cSubServers &4&l\\u00BB&c There is no host with that name");
            def.put("Command.Creator.Host-Unavailable", "&cSubServers &4&l\\u00BB&c That host is not available");
            def.put("Command.Creator.Host-Disabled", "&cSubServers &4&l\\u00BB&c That host is not enabled");
            def.put("Command.Creator.Unknown-Template", "&cSubServers &4&l\\u00BB&c There is no template with that name");
            def.put("Command.Creator.Template-Disabled", "&cSubServers &4&l\\u00BB&c That template is not enabled");
            def.put("Command.Creator.Template-Invalid", "&cSubServers &4&l\\u00BB&c That template does not support subserver updating");
            def.put("Command.Creator.Version-Required", "&cSubServers &4&l\\u00BB&c That template requires a Minecraft version to be specified");
            def.put("Command.Creator.Invalid-Port", "&cSubServers &4&l\\u00BB&c Invalid port number");
            def.put("Command.Update", "&aSubServers &2&l\\u00BB&a Updating &2$int$&a subserver(s)");
            def.put("Command.Update.Disappeared", "&cSubServers &4&l\\u00BB&c Subserver &4$str$&c has disappeared");
            def.put("Command.Update.Host-Unavailable", "&cSubServers &4&l\\u00BB&c The host for &4$str$&c is not available");
            def.put("Command.Update.Host-Disabled", "&cSubServers &4&l\\u00BB&c The host for &4$str$&c is not enabled");
            def.put("Command.Update.Server-Unavailable", "&cSubServers &4&l\\u00BB&c Subserver &4$str$&c is not available");
            def.put("Command.Update.Running", "&cSubServers &4&l\\u00BB&c Cannot update &4$str$&c while it is still running");
            def.put("Command.Update.Unknown-Template", "&cSubServers &4&l\\u00BB&c We don't know which template created &4$str$");
            def.put("Command.Update.Template-Disabled", "&cSubServers &4&l\\u00BB&c The template that created &4$str$&c is not enabled");
            def.put("Command.Update.Template-Invalid", "&cSubServers &4&l\\u00BB&c The template that created &4$str$&c does not support subserver updating");
            def.put("Command.Update.Version-Required", "&cSubServers &4&l\\u00BB&c The template that created &4$str$&c requires a Minecraft version to be specified");
            def.put("Command.Delete.Disappeared", "&cSubServers &4&l\\u00BB&c Subserver &4$str$&c has disappeared");
            def.put("Command.Delete.Running", "&cSubServers &4&l\\u00BB&c Cannot delete &4$str$&c while it is still running");
            def.put("Command.Delete", "&aSubServers &2&l\\u00BB&a Deleting &2$int$&a subserver(s)");
            def.put("Command.Teleport", "&aSubServers &2&l\\u00BB&a Teleporting to &2$str$");
            def.put("Command.Teleport.Others", "&aSubServers &2&l\\u00BB&a Teleporting &2$name$&a to &2$str$");
            def.put("Command.Teleport.Not-Running", "&cSubServers &4&l\\u00BB&c Subserver &4$str$&c is not running");
            def.put("Interface.Generic.Back", "&cBack");
            def.put("Interface.Generic.Back-Arrow", "&e&l<--");
            def.put("Interface.Generic.Next-Arrow", "&e&l-->");
            def.put("Interface.Generic.Undo", "&6Undo");
            def.put("Interface.Generic.Downloading", "&7SubServers &8&l\\u00BB&7 Downloading:&f $str$");
            def.put("Interface.Generic.Downloading.Title", "Downloading...");
            def.put("Interface.Generic.Downloading.Title-Color", "&b");
            def.put("Interface.Generic.Downloading.Title-Color-Alt", "&3");
            def.put("Interface.Generic.Downloading.Response", "&eWaiting for response");
            def.put("Interface.Generic.Invalid-Permission", "&4You need &n$str$");
            def.put("Interface.Proxy-Menu.Proxy-Player-Count", "&2$int$ Player(s) Online");
            def.put("Interface.Proxy-Menu.Proxy-Master", "&8Master Proxy");
            def.put("Interface.Proxy-Menu.Proxy-Disconnected", "&4Disconnected");
            def.put("Interface.Host-Menu.Title", "Host Menu");
            def.put("Interface.Host-Menu.Host-Unavailable", "&4Unavailable");
            def.put("Interface.Host-Menu.Host-Disabled", "&4Disabled");
            def.put("Interface.Host-Menu.Host-Server-Count", "&9$int$ Server(s)");
            def.put("Interface.Host-Menu.No-Hosts", "&c&oThere are No Hosts");
            def.put("Interface.Host-Menu.Group-Menu", "&6&lView Servers by Group");
            def.put("Interface.Host-Menu.Server-Menu", "&a&lView Servers");
            def.put("Interface.Host-Admin.Title", "Host/$str$");
            def.put("Interface.Host-Admin.Creator", "&eCreate a SubServer");
            def.put("Interface.Host-Admin.SubServers", "&bView SubServers");
            def.put("Interface.Host-Admin.Plugins", "&bPlugins...");
            def.put("Interface.Host-Creator.Title", "Host/$str$/Create");
            def.put("Interface.Host-Creator.Edit-Name", "Change Name");
            def.put("Interface.Host-Creator.Edit-Name.Title", "&eSubCreator\\n&6Enter a Name for this Server");
            def.put("Interface.Host-Creator.Edit-Name.Message", "&eSubCreator &6&l\\u00BB&e Enter a Name for this Server via Chat");
            def.put("Interface.Host-Creator.Edit-Name.Exists", "&cSubCreator &4&l\\u00BB&c There is already a SubServer with that name");
            def.put("Interface.Host-Creator.Edit-Name.Exists-Title", "&eSubCreator\\n&cThere is already a SubServer with that name");
            def.put("Interface.Host-Creator.Edit-Name.Invalid", "&cSubCreator &4&l\\u00BB&c Invalid Server Name");
            def.put("Interface.Host-Creator.Edit-Name.Invalid-Title", "&eSubCreator\\n&cInvalid Server Name");
            def.put("Interface.Host-Creator.Edit-Template", "Change Server Template");
            def.put("Interface.Host-Creator.Edit-Template.Title", "Host/$str$/Templates");
            def.put("Interface.Host-Creator.Edit-Template.No-Templates", "&c&oThere are No Templates");
            def.put("Interface.Host-Creator.Edit-Version", "Change Server Version");
            def.put("Interface.Host-Creator.Edit-Version.Title", "&eSubCreator\\n&6Enter a Server Version");
            def.put("Interface.Host-Creator.Edit-Version.Message", "&eSubCreator &6&l\\u00BB&e Enter a Server Version via Chat");
            def.put("Interface.Host-Creator.Edit-Port", "Change Server Port");
            def.put("Interface.Host-Creator.Edit-Port.Title", "&eSubCreator\\n&6Enter a Port Number");
            def.put("Interface.Host-Creator.Edit-Port.Message", "&eSubCreator &6&l\\u00BB&e Enter a Port Number via Chat");
            def.put("Interface.Host-Creator.Edit-Port.Invalid", "&cSubCreator &4&l\\u00BB&c Invalid Port Number");
            def.put("Interface.Host-Creator.Edit-Port.Invalid-Title", "&eSubCreator\\n&cInvalid Port Number");
            def.put("Interface.Host-Creator.Submit", "&eCreate SubServer");
            def.put("Interface.Host-Creator.Form-Incomplete", "&4Buttons above must be green");
            def.put("Interface.Host-Plugin.Title", "Host/$str$/Plugins");
            def.put("Interface.Host-Plugin.No-Plugins", "&c&oThere are No Plugins Available");
            def.put("Interface.Host-SubServer.Title", "Host/$str$/SubServers");
            def.put("Interface.Group-Menu.Title", "Group Menu");
            def.put("Interface.Group-Menu.Group-Server-Count", "&9$int$ Server(s)");
            def.put("Interface.Group-Menu.Ungrouped", "&7(ungrouped)");
            def.put("Interface.Group-Menu.Server-Menu", "&a&lView All Servers");
            def.put("Interface.Group-SubServer.Title", "Group/$str$/Servers");
            def.put("Interface.Group-SubServer.Title-Ungrouped", "Ungrouped Server Menu");
            def.put("Interface.Server-Menu.Title", "Server Menu");
            def.put("Interface.Server-Menu.Server-Player-Count", "&2$int$ Player(s) Online");
            def.put("Interface.Server-Menu.Server-External", "&7External Server");
            def.put("Interface.Server-Menu.SubServer-Temporary", "&9Temporary");
            def.put("Interface.Server-Menu.SubServer-Offline", "&6Offline");
            def.put("Interface.Server-Menu.SubServer-Incompatible", "&4Incompatible with $str$");
            def.put("Interface.Server-Menu.SubServer-Unavailable", "&4Unavailable");
            def.put("Interface.Server-Menu.SubServer-Disabled", "&4Disabled");
            def.put("Interface.Server-Menu.No-Servers", "&c&oThere are No Servers");
            def.put("Interface.Server-Menu.Host-Menu", "&b&lView Hosts");
            def.put("Interface.Server-Admin.Title", "Server/$str$");
            def.put("Interface.Server-Admin.Start", "&aStart SubServer");
            def.put("Interface.Server-Admin.Start.Title", "&aStarting SubServer");
            def.put("Interface.Server-Admin.Stop", "&cStop SubServer");
            def.put("Interface.Server-Admin.Stop.Title", "&cStopping $str$");
            def.put("Interface.Server-Admin.Terminate", "&4Terminate SubServer");
            def.put("Interface.Server-Admin.Terminate.Title", "&cTerminating $str$");
            def.put("Interface.Server-Admin.Command", "&bSend a Command to the Server");
            def.put("Interface.Server-Admin.Command.Title", "&eSubServers\\n&6Enter a Command to send via Chat");
            def.put("Interface.Server-Admin.Command.Message", "&eSubServers &6&l\\u00BB&e Enter a Command to send via Chat");
            def.put("Interface.Server-Admin.Update", "&eUpdate SubServer");
            def.put("Interface.Server-Admin.Update.Title", "&eSubServers\\n&6Enter a Server Version to update to");
            def.put("Interface.Server-Admin.Update.Message", "&eSubServers &6&l\\u00BB&e Enter a Server Version to update to via Chat");
            def.put("Interface.Server-Admin.Plugins", "&bPlugins...");
            def.put("Interface.SubServer-Plugin.Title", "Server/$str$/Plugins");
            def.put("Interface.SubServer-Plugin.No-Plugins", "&c&oThere are No Plugins Available");
            YAMLSection lang = new YAMLSection();
            for (String key : def.keySet()) {
                lang.set((Object)key, (Object)updated.getMap((Object)"Lang", (ObjectMap)new YAMLSection()).getString((Object)key, (String)def.get(key)));
            }
            rewritten.set((Object)"Lang", (Object)lang);
            config.set(rewritten);
            config.save();
        }
    }
}

