/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Bungee.Network.Packet;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.ME1312.Galaxi.Library.Map.ObjectMap;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.SubData.Server.Protocol.PacketObjectIn;
import net.ME1312.SubData.Server.Protocol.PacketObjectOut;
import net.ME1312.SubData.Server.Protocol.PacketOut;
import net.ME1312.SubData.Server.SubDataClient;
import net.ME1312.SubServers.Bungee.Host.Server;
import net.ME1312.SubServers.Bungee.SubProxy;

public class PacketDownloadGroupInfo
implements PacketObjectIn<Integer>,
PacketObjectOut<Integer> {
    private SubProxy plugin;
    private String[] groups;
    private UUID tracker;

    public PacketDownloadGroupInfo(SubProxy plugin) {
        this.plugin = (SubProxy)((Object)Util.nullpo((Object)((Object)plugin)));
    }

    public PacketDownloadGroupInfo(SubProxy plugin, List<String> groups, UUID tracker) {
        this.plugin = (SubProxy)((Object)Util.nullpo((Object)((Object)plugin)));
        this.tracker = tracker;
        if (groups != null) {
            this.groups = new String[groups.size()];
            for (int i = 0; i < this.groups.length; ++i) {
                this.groups[i] = groups.get(i).toLowerCase();
            }
            Arrays.sort(this.groups);
        }
    }

    public ObjectMap<Integer> send(SubDataClient client) {
        ObjectMap data = new ObjectMap();
        if (this.tracker != null) {
            data.set((Object)0, (Object)this.tracker);
        }
        if (this.groups == null || this.groups.length > 0) {
            ObjectMap groups = new ObjectMap();
            for (Map.Entry<String, List<Server>> group : this.plugin.api.getGroups().entrySet()) {
                if (this.groups != null && Arrays.binarySearch(this.groups, group.getKey().toLowerCase()) < 0) continue;
                ObjectMap servers = new ObjectMap();
                for (Server server : group.getValue()) {
                    servers.set((Object)server.getName(), (Object)server.forSubData());
                }
                groups.set((Object)group.getKey(), (Object)servers);
            }
            data.set((Object)1, (Object)groups);
        } else {
            ObjectMap ungrouped = new ObjectMap();
            for (Server server : this.plugin.api.getServers().values()) {
                if (server.getGroups().size() > 0) continue;
                ungrouped.set((Object)server.getName(), (Object)server.forSubData());
            }
            data.set((Object)1, Collections.emptyMap());
            data.set((Object)2, (Object)ungrouped);
        }
        return data;
    }

    public void receive(SubDataClient client, ObjectMap<Integer> data) {
        client.sendPacket(new PacketOut[]{new PacketDownloadGroupInfo(this.plugin, data.contains((Object)1) ? data.getStringList((Object)1) : null, data.contains((Object)0) ? data.getUUID((Object)0) : null)});
    }
}

