/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Bungee.Network.Packet;

import java.util.HashMap;
import java.util.UUID;
import java.util.function.Consumer;
import net.ME1312.Galaxi.Library.Map.ObjectMap;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.SubData.Server.Protocol.PacketObjectIn;
import net.ME1312.SubData.Server.Protocol.PacketObjectOut;
import net.ME1312.SubData.Server.SubDataClient;
import net.ME1312.SubServers.Bungee.Host.External.ExternalSubServer;

public class PacketExAddServer
implements PacketObjectIn<Integer>,
PacketObjectOut<Integer> {
    private static HashMap<UUID, Consumer<ObjectMap<Integer>>[]> callbacks = new HashMap();
    private String name;
    private boolean enabled;
    private int port;
    private boolean log;
    private String directory;
    private String executable;
    private String stopcmd;
    private UUID running;
    private UUID tracker;

    public PacketExAddServer() {
    }

    @SafeVarargs
    public PacketExAddServer(ExternalSubServer server, UUID running, Consumer<ObjectMap<Integer>> ... callback) {
        if (callback == null) {
            throw new NullPointerException();
        }
        this.name = server.getName();
        this.enabled = server.isEnabled();
        this.port = server.getAddress().getPort();
        this.log = server.isLogging();
        this.directory = server.getPath();
        this.executable = server.getExecutable();
        this.stopcmd = server.getStopCommand();
        this.running = running;
        this.tracker = (UUID)Util.getNew(callbacks.keySet(), UUID::randomUUID);
        callbacks.put(this.tracker, callback);
    }

    public String peek() {
        return this.name;
    }

    public ObjectMap<Integer> send(SubDataClient client) {
        ObjectMap data = new ObjectMap();
        data.set((Object)0, (Object)this.tracker);
        data.set((Object)1, (Object)this.name);
        data.set((Object)2, (Object)this.enabled);
        data.set((Object)3, (Object)this.port);
        data.set((Object)4, (Object)this.log);
        data.set((Object)5, (Object)this.directory);
        data.set((Object)6, (Object)this.executable);
        data.set((Object)7, (Object)this.stopcmd);
        if (this.running != null) {
            data.set((Object)8, (Object)this.running);
        }
        return data;
    }

    public void receive(SubDataClient client, ObjectMap<Integer> data) {
        for (Consumer<ObjectMap<Integer>> callback : callbacks.remove(data.getUUID((Object)0))) {
            callback.accept(data);
        }
    }
}

