/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Bungee.Network.Packet;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.ME1312.Galaxi.Library.Map.ObjectMap;
import net.ME1312.Galaxi.Library.Try;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.SubData.Server.DataClient;
import net.ME1312.SubData.Server.Library.DisconnectReason;
import net.ME1312.SubData.Server.Protocol.Initial.InitialPacket;
import net.ME1312.SubData.Server.Protocol.PacketObjectIn;
import net.ME1312.SubData.Server.Protocol.PacketObjectOut;
import net.ME1312.SubData.Server.Protocol.PacketOut;
import net.ME1312.SubData.Server.SubDataClient;
import net.ME1312.SubServers.Bungee.Event.SubStartedEvent;
import net.ME1312.SubServers.Bungee.Host.Server;
import net.ME1312.SubServers.Bungee.Host.ServerImpl;
import net.ME1312.SubServers.Bungee.Host.SubServer;
import net.ME1312.SubServers.Bungee.Host.SubServerImpl;
import net.ME1312.SubServers.Bungee.Library.Compatibility.Logger;
import net.ME1312.SubServers.Bungee.Network.Packet.PacketOutExReset;
import net.ME1312.SubServers.Bungee.SubAPI;
import net.ME1312.SubServers.Bungee.SubProxy;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.plugin.Event;

public class PacketLinkServer
implements InitialPacket,
PacketObjectIn<Integer>,
PacketObjectOut<Integer> {
    public static boolean strict = true;
    private SubProxy plugin;
    private int response;
    private String message;
    private String name;
    static long req = 1L;
    static long last = Calendar.getInstance().getTime().getTime();

    public PacketLinkServer(SubProxy plugin) {
        this.plugin = (SubProxy)((Object)Util.nullpo((Object)((Object)plugin)));
    }

    public PacketLinkServer(String name, int response, String message) {
        Util.nullpo((Object)response);
        this.name = name;
        this.response = response;
        this.message = message;
    }

    public ObjectMap<Integer> send(SubDataClient client) {
        ObjectMap data = new ObjectMap();
        data.set((Object)0, (Object)this.name);
        data.set((Object)1, (Object)this.response);
        if (this.message != null) {
            data.set((Object)2, (Object)this.message);
        }
        return data;
    }

    public void receive(SubDataClient client, ObjectMap<Integer> data) {
        block12: {
            String name = data.contains((Object)0) ? data.getString((Object)0) : null;
            Integer channel = data.getInt((Object)2);
            try {
                InetSocketAddress address;
                if (!data.contains((Object)1)) {
                    address = null;
                } else if (data.isNumber((Object)1)) {
                    address = new InetSocketAddress(client.getAddress().getAddress(), (int)data.getInt((Object)1));
                } else {
                    String[] sa = data.getString((Object)1).split(":");
                    address = new InetSocketAddress(sa[0], Integer.parseInt(sa[1]));
                }
                Map<String, Server> servers = this.plugin.api.getServers();
                if (name != null && servers.containsKey(name.toLowerCase())) {
                    this.link(client, servers.get(name.toLowerCase()), channel);
                    break block12;
                }
                if (address != null) {
                    Server server = this.search(address);
                    if (server != null || (server = this.create(name, address)) != null) {
                        this.link(client, server, channel);
                        break block12;
                    }
                    throw new ServerLinkException("There is no server with address: " + address.getAddress().getHostAddress() + ':' + address.getPort());
                }
                throw new ServerLinkException("Not enough arguments");
            }
            catch (ServerLinkException e) {
                if (name != null) {
                    client.sendPacket(new PacketOut[]{new PacketLinkServer(null, 3, "There is no server with name: " + name)});
                } else {
                    client.sendPacket(new PacketOut[]{new PacketLinkServer(null, 2, e.getMessage())});
                }
            }
            catch (Throwable e) {
                client.sendPacket(new PacketOut[]{new PacketLinkServer(null, 1, null)});
                e.printStackTrace();
            }
        }
    }

    private Server create(String name, InetSocketAddress address) throws Throwable {
        if (strict) {
            return null;
        }
        String id = name == null ? (String)Util.getNew(SubAPI.getInstance().getServers().keySet(), () -> UUID.randomUUID().toString()) : name;
        Server server = SubAPI.getInstance().addServer(id, address.getAddress(), address.getPort(), "Some Dynamic Server", name == null, false);
        if (server != null) {
            Util.reflect((Field)ServerImpl.class.getDeclaredField("persistent"), (Object)server, (Object)false);
        }
        return server;
    }

    private Server search(InetSocketAddress address) {
        Server server = null;
        for (Server s : this.plugin.api.getServers().values()) {
            if (!s.getAddress().equals(address)) continue;
            if (server != null) {
                throw new ServerLinkException("Multiple servers match address: " + address.getAddress().getHostAddress() + ':' + address.getPort());
            }
            server = s;
        }
        return server;
    }

    private void link(SubDataClient client, Server server, int channel) throws Throwable {
        HashMap subdata = (HashMap)Try.all.get(() -> (HashMap)Util.reflect((Field)ServerImpl.class.getDeclaredField("subdata"), (Object)server));
        if (!subdata.containsKey(channel) || channel == 0 && subdata.get(0) == null) {
            server.setSubData((DataClient)client, channel);
            Logger.get((String)"SubData").info(client.getAddress().toString() + " has been defined as " + (server instanceof SubServer ? "SubServer" : "Server") + ": " + server.getName() + (channel > 0 ? " [+" + channel + "]" : ""));
            final Runnable register = () -> {
                if (server instanceof SubServer && !((SubServer)server).isRunning()) {
                    if (((SubServer)server).isAvailable()) {
                        Logger.get((String)"SubServers").info("Sending shutdown signal to rogue SubServer: " + server.getName());
                        client.sendPacket(new PacketOut[]{new PacketOutExReset("Rogue SubServer Detected")});
                    } else {
                        Try.all.run(() -> Util.reflect((Method)SubDataClient.class.getDeclaredMethod("close", DisconnectReason.class), (Object)client, (Object[])new Object[]{DisconnectReason.CLOSE_REQUESTED}));
                    }
                } else {
                    if (server instanceof SubServer && !((Boolean)Try.all.get(() -> (Boolean)Util.reflect((Field)SubServerImpl.class.getDeclaredField("started"), (Object)server), (Object)true)).booleanValue()) {
                        Try.all.run(() -> Util.reflect((Field)SubServerImpl.class.getDeclaredField("started"), (Object)server, (Object)true));
                        SubStartedEvent event = new SubStartedEvent((SubServer)server);
                        ProxyServer.getInstance().getPluginManager().callEvent((Event)event);
                    }
                    client.sendPacket(new PacketOut[]{new PacketLinkServer(server.getName(), 0, null)});
                }
                --req;
            };
            long now = Calendar.getInstance().getTime().getTime();
            final Timer timer = new Timer("SubServers.Bungee::Server_Linker(" + server.getName() + ")");
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    register.run();
                    timer.cancel();
                }
            }, (server instanceof SubServer && !((SubServer)server).isRunning() ? TimeUnit.SECONDS.toMillis(5L) : 0L) + (now - last < 500L ? req * 500L : 0L));
            ++req;
            last = now;
            this.setReady(client);
        } else {
            client.sendPacket(new PacketOut[]{new PacketLinkServer(null, 4, "Server already linked: " + server.getName())});
        }
    }

    private static class ServerLinkException
    extends IllegalStateException {
        public ServerLinkException(String message) {
            super(message);
        }
    }
}

