/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Bungee.Library.Fallback;

import java.util.LinkedList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.config.ServerInfo;

public class FallbackState {
    public final UUID player;
    public final LinkedList<String> names;
    public final LinkedList<ServerInfo> servers;
    public final BaseComponent[] reason;
    private Map<String, ServerInfo> map;
    private Timer finish;

    public FallbackState(UUID player, Map<String, ServerInfo> servers, BaseComponent ... reason) {
        this.player = player;
        this.map = servers;
        this.names = new LinkedList<String>(servers.keySet());
        this.servers = new LinkedList<ServerInfo>(servers.values());
        this.reason = reason;
    }

    public void remove(String name) {
        this.servers.remove(this.map.get(name));
        this.names.remove(name);
        this.map.remove(name);
    }

    public void remove(ServerInfo server) {
        this.map.remove(server.getName());
        this.names.remove(server.getName());
        this.servers.remove(server);
    }

    public void done(final Runnable callback, long delay) {
        if (this.finish != null) {
            this.finish.cancel();
        }
        this.finish = new Timer("SubServers.Bungee::Fallback_Limbo_Timer(" + this.player + ')');
        this.finish.schedule(new TimerTask(){

            @Override
            public void run() {
                if (callback != null) {
                    callback.run();
                }
                FallbackState.this.finish.cancel();
            }
        }, delay);
    }
}

