/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.Galaxi.Library.Config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.LinkedHashMap;
import net.ME1312.Galaxi.Library.Config.YAMLSection;
import net.ME1312.Galaxi.Library.Try;
import net.ME1312.Galaxi.Library.Util;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;

public class YAMLConfig {
    private File file;
    private Yaml yaml;
    private YAMLSection config;

    public YAMLConfig(File file) throws IOException, YAMLException {
        Util.nullpo(file);
        this.file = file;
        this.yaml = new Yaml(YAMLConfig.getDumperOptions());
        if (file.exists()) {
            FileInputStream stream = new FileInputStream(file);
            this.config = new YAMLSection((LinkedHashMap)this.yaml.loadAs((InputStream)stream, LinkedHashMap.class), this.yaml);
            ((InputStream)stream).close();
        } else {
            this.config = new YAMLSection(null, this.yaml);
        }
    }

    public YAMLSection get() {
        return this.config;
    }

    public void set(YAMLSection value) {
        Util.nullpo(value);
        this.config = value;
    }

    public synchronized void reload() throws IOException {
        if (this.file.exists()) {
            FileInputStream stream = new FileInputStream(this.file);
            this.config = new YAMLSection((LinkedHashMap)this.yaml.loadAs((InputStream)stream, LinkedHashMap.class), this.yaml);
            ((InputStream)stream).close();
        } else {
            this.config = new YAMLSection(null, this.yaml);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        YAMLSection config;
        YAMLSection yAMLSection = config = this.config;
        synchronized (yAMLSection) {
            if (!this.file.exists()) {
                this.file.createNewFile();
            }
            FileWriter writer = new FileWriter(this.file);
            this.yaml.dump(config.get(), (Writer)writer);
            writer.close();
        }
    }

    public boolean equals(Object object) {
        if (object instanceof YAMLConfig) {
            return this.get().equals(((YAMLConfig)object).get());
        }
        return super.equals(object);
    }

    public String toString() {
        return this.config.toString();
    }

    static DumperOptions getDumperOptions() {
        DumperOptions options = new DumperOptions();
        Try.all.run(() -> options.setAllowUnicode(false));
        Try.all.run(() -> options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK));
        Try.all.run(() -> options.setIndent(2));
        Try.all.run(() -> options.setSplitLines(false));
        Try.all.run(() -> options.setLineBreak(DumperOptions.LineBreak.UNIX));
        Try.all.run(() -> options.setNonPrintableStyle(DumperOptions.NonPrintableStyle.ESCAPE));
        return options;
    }
}

