/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.Galaxi.Library.Map;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.ME1312.Galaxi.Library.Map.ObjectMap;
import net.ME1312.Galaxi.Library.Version.Version;

public class ObjectMapValue<K> {
    Object obj;
    K label;
    ObjectMap<K> up;

    protected ObjectMapValue(Object obj) {
        this.obj = obj;
    }

    public ObjectMap<K> getParent() {
        return this.up;
    }

    public K getHandle() {
        return this.label;
    }

    public List<ObjectMapValue<K>> asList() {
        if (this.obj != null) {
            LinkedList<ObjectMapValue<K>> values = new LinkedList<ObjectMapValue<K>>();
            for (Object value : (List)this.obj) {
                values.add(this.up.wrap(null, value));
            }
            return values;
        }
        return null;
    }

    public Object asObject() {
        return this.up.simplify(this.obj);
    }

    public List<?> asObjectList() {
        return (List)this.up.simplify(this.obj);
    }

    public Boolean asBoolean() {
        return (Boolean)this.obj;
    }

    public List<Boolean> asBooleanList() {
        return (List)this.obj;
    }

    public ObjectMap<K> asMap() {
        return (ObjectMap)this.obj;
    }

    public List<ObjectMap<K>> asMapList() {
        return (List)this.obj;
    }

    public Double asDouble() {
        return ((Number)this.obj).doubleValue();
    }

    public List<Double> asDoubleList() {
        return (List)this.obj;
    }

    public Float asFloat() {
        return Float.valueOf(((Number)this.obj).floatValue());
    }

    public List<Float> asFloatList() {
        return (List)this.obj;
    }

    public Integer asInt() {
        return ((Number)this.obj).intValue();
    }

    public List<Integer> asIntList() {
        return (List)this.obj;
    }

    public Long asLong() {
        return ((Number)this.obj).longValue();
    }

    public List<Long> asLongList() {
        return (List)this.obj;
    }

    public Short asShort() {
        return ((Number)this.obj).shortValue();
    }

    public List<Short> asShortList() {
        return (List)this.obj;
    }

    public String asString() {
        if (this.obj != null) {
            return this.obj.toString();
        }
        return null;
    }

    public List<String> asStringList() {
        if (this.obj != null) {
            LinkedList<String> values = new LinkedList<String>();
            for (Object value : (List)this.obj) {
                values.add(value == null ? null : value.toString());
            }
            return values;
        }
        return null;
    }

    public UUID asUUID() {
        return ObjectMapValue.parseUUID(this.obj);
    }

    private static UUID parseUUID(Object obj) {
        if (obj instanceof Collection) {
            Iterator i = ((Collection)obj).iterator();
            return new UUID(((Number)i.next()).longValue(), ((Number)i.next()).longValue());
        }
        if (obj != null) {
            return UUID.fromString(obj.toString());
        }
        return null;
    }

    public List<UUID> asUUIDList() {
        if (this.obj != null) {
            LinkedList<UUID> values = new LinkedList<UUID>();
            for (Object value : (List)this.obj) {
                values.add(ObjectMapValue.parseUUID(value));
            }
            return values;
        }
        return null;
    }

    public Version asVersion() {
        if (this.obj != null) {
            return Version.fromString(this.asString());
        }
        return null;
    }

    public List<Version> asVersionList() {
        if (this.obj != null) {
            LinkedList<Version> values = new LinkedList<Version>();
            for (String value : this.asStringList()) {
                values.add(value == null ? null : Version.fromString(value));
            }
            return values;
        }
        return null;
    }

    public boolean isNull() {
        return this.obj == null;
    }

    public boolean isBoolean() {
        return this.obj instanceof Boolean;
    }

    public boolean isMap() {
        return this.obj instanceof ObjectMap;
    }

    public boolean isList() {
        return this.obj instanceof List;
    }

    public boolean isNumber() {
        return this.obj instanceof Number;
    }

    public boolean isString() {
        return this.obj instanceof String;
    }

    public boolean isUUID() {
        if (this.obj instanceof Collection) {
            Iterator i = ((Collection)this.obj).iterator();
            if (i.hasNext()) {
                i.next();
                return i.hasNext();
            }
        } else if (this.obj instanceof String) {
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (this.obj == null) {
            return object == null;
        }
        if (object instanceof ObjectMapValue) {
            return this.obj.equals(((ObjectMapValue)object).obj);
        }
        return this.obj.equals(object);
    }

    public String toString() {
        if (this.obj != null) {
            return this.obj.toString();
        }
        return "null";
    }
}

