/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.Galaxi.Library;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.LambdaMetafactory;
import java.util.Locale;
import java.util.regex.Pattern;
import net.ME1312.Galaxi.Library.Try;
import net.ME1312.Galaxi.Library.Util;

public final class Platform
extends Enum<Platform> {
    public static final /* enum */ Platform WINDOWS = new Platform("Windows", new File(System.getenv("APPDATALOCAL") != null ? System.getenv("APPDATALOCAL") : System.getenv("APPDATA"), "GalaxiEngine"));
    public static final /* enum */ Platform MAC_OS = new Platform("macOS", new File(System.getProperty("user.home"), "Library/Application Support/GalaxiEngine"));
    public static final /* enum */ Platform UNIX = new Platform("Unix-like", new File(System.getProperty("user.home"), ".GalaxiEngine"));
    private static final Platform OS;
    private static final String OS_NAME;
    private static final String OS_VERSION;
    private static final String OS_BUILD;
    private static final String OS_ARCH;
    private static final int JAVA_LANG;
    private static final String JAVA_ARCH;
    private final String name;
    private final File appdata;
    private static final /* synthetic */ Platform[] $VALUES;

    public static Platform[] values() {
        return (Platform[])$VALUES.clone();
    }

    public static Platform valueOf(String name) {
        return Enum.valueOf(Platform.class, name);
    }

    private Platform(String name, File appdata) {
        this.name = name;
        this.appdata = appdata;
    }

    public String getName() {
        return this.name;
    }

    public File getAppDataDirectory() {
        return this.appdata;
    }

    public static Platform getSystem() {
        return OS;
    }

    public static String getSystemName() {
        return OS_NAME;
    }

    public static String getSystemVersion() {
        return OS_VERSION;
    }

    public static String getSystemBuild() {
        return OS_BUILD;
    }

    public static String getSystemArchitecture() {
        return OS_ARCH;
    }

    public static String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public static int getJavaLanguageLevel() {
        return JAVA_LANG;
    }

    public static String getJavaArchitecture() {
        return JAVA_ARCH;
    }

    private static /* synthetic */ void lambda$static$0(String jarch) throws Throwable {
        Long.parseLong(jarch);
    }

    private static /* synthetic */ Platform[] $values() {
        return new Platform[]{WINDOWS, MAC_OS, UNIX};
    }

    /*
     * Unable to fully structure code
     */
    static {
        Platform.$VALUES = Platform.$values();
        osversion = System.getProperty("os.version");
        osname = System.getProperty("os.name", "Unknown OS");
        os = osname.toLowerCase(Locale.ENGLISH);
        if (os.startsWith("mac") || os.startsWith("darwin")) {
            Platform.OS = Platform.MAC_OS;
            Platform.OS_NAME = Platform.OS.name;
            Platform.OS_VERSION = osversion;
        } else if (os.startsWith("win")) {
            Platform.OS = Platform.WINDOWS;
            if (os.startsWith("windows server ")) {
                Platform.OS_NAME = "Windows Server";
                Platform.OS_VERSION = osname.substring(Platform.OS_NAME.length() + 1);
            } else if (os.startsWith("windows ")) {
                Platform.OS_NAME = Platform.OS.name;
                Platform.OS_VERSION = osname.substring(Platform.OS_NAME.length() + 1);
            } else {
                Platform.OS_NAME = osname;
                Platform.OS_VERSION = osversion;
            }
        } else {
            Platform.OS = Platform.UNIX;
            Platform.OS_NAME = osname;
            Platform.OS_VERSION = osversion;
        }
        if (Platform.OS == Platform.WINDOWS) {
            osbuild = null;
            try {
                build = Pattern.compile(Pattern.quote(osversion) + "(?:\\.\\d+)*").matcher(Util.readAll(new InputStreamReader(Runtime.getRuntime().exec(new String[]{"cmd.exe", "/q", "/c", "ver"}).getInputStream())));
                if (build.find()) {
                    osbuild = build.group().substring(osversion.length() + 1);
                }
            }
            catch (IOException build) {
                // empty catch block
            }
            Platform.OS_BUILD = osbuild;
            osarch = System.getenv("PROCESSOR_ARCHITEW6432");
            if (osarch == null) {
                osarch = System.getenv("PROCESSOR_ARCHITECTURE");
            }
        } else {
            Platform.OS_BUILD = null;
            osarch = System.getProperty("os.arch");
        }
        x86 = false;
        if (osarch != null) {
            if ((osarch = osarch.replaceAll("[^a-zA-Z0-9]", "").toLowerCase(Locale.ROOT)).matches("^((amd|x86|x)64|em64t|ia32e)$")) {
                Platform.OS_ARCH = "x64";
                x86 = true;
            } else if (osarch.matches("^((i[3-6]|x)86|(ia|x86|x)32)$")) {
                Platform.OS_ARCH = "x86";
                x86 = true;
            } else {
                Platform.OS_ARCH = osarch.equals("aarch64") || osarch.equals("arm64") ? "arm64" : (osarch.equals("aarch32") || osarch.startsWith("arm") ? "arm" : osarch);
            }
        } else {
            Platform.OS_ARCH = "unknown";
        }
        jarch = System.getProperty("sun.arch.data.model", "unknown");
        if (!x86) ** GOTO lbl-1000
        if (jarch.equals("64")) {
            Platform.JAVA_ARCH = "x64";
        } else if (jarch.equals("32")) {
            Platform.JAVA_ARCH = "x86";
        } else lbl-1000:
        // 2 sources

        {
            Platform.JAVA_ARCH = Try.all.run((Try.Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$static$0(java.lang.String ), ()V)((String)jarch)) != false ? jarch + "-bit" : jarch;
        }
        jversion = System.getProperty("java.specification.version");
        regex = Pattern.compile("(?:1\\.)?(\\d+).*").matcher(jversion);
        Platform.JAVA_LANG = regex.find() != false ? Integer.parseInt(regex.group(1)) : 0x7FFFFFFF;
    }
}

