/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.Galaxi.Library;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.ME1312.Galaxi.Library.Try;

public final class Util {
    private Util() {
    }

    public static <T> T nullpo(T value) {
        if (value == null) {
            throw new NullPointerException("Illegal null value");
        }
        return value;
    }

    @SafeVarargs
    public static <T> T[] nullpo(T ... values) {
        if (values == null) {
            throw new NullPointerException("Illegal null array");
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != null) continue;
            throw new NullPointerException("Illegal null value at position: [" + i + "]");
        }
        return values;
    }

    public static <T> T[] nullpoCopy(T[] values) {
        if (values == null) {
            throw new NullPointerException("Illegal null array");
        }
        Object[] copy = (Object[])Array.newInstance(values.getClass().getComponentType(), values.length);
        for (int i = 0; i < values.length; ++i) {
            copy[i] = values[i];
            if (copy[i] != null) continue;
            throw new NullPointerException("Illegal null value at position: [" + i + "]");
        }
        return copy;
    }

    public static boolean isNull(Object value) {
        return value == null;
    }

    public static boolean isNull(Object ... values) {
        if (values == null) {
            return true;
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != null) continue;
            return true;
        }
        return false;
    }

    public static <K, V> List<K> getBackwards(Map<K, V> map, V value) {
        ArrayList<K> values = new ArrayList<K>();
        for (K key : map.keySet()) {
            if (map.get(key) == null || value == null) {
                if (key != value) continue;
                values.add(key);
                continue;
            }
            if (!map.get(key).equals(value)) continue;
            values.add(key);
        }
        return values;
    }

    public static <V> V getCaseInsensitively(Map<String, V> map, String key) {
        HashMap<String, String> insensitivity = new HashMap<String, String>();
        for (String item : map.keySet()) {
            insensitivity.put(item.toLowerCase(), item);
        }
        if (insensitivity.containsKey(key.toLowerCase())) {
            return map.get(insensitivity.get(key.toLowerCase()));
        }
        return null;
    }

    public static <V> V getNew(Collection<? extends V> existing, Supplier<V> generator) {
        V result = null;
        while (result == null) {
            V tmp = generator.get();
            if (existing.contains(tmp)) continue;
            result = tmp;
        }
        return result;
    }

    public static String readAll(Reader rd) throws IOException {
        int cp;
        StringBuilder sb = new StringBuilder();
        while ((cp = rd.read()) != -1) {
            sb.append((char)cp);
        }
        return sb.toString();
    }

    public static void copyFromJar(ClassLoader loader, String resource, String destination) {
        File resDestFile = new File(destination);
        try (InputStream resStreamIn = loader.getResourceAsStream(resource);
             FileOutputStream resStreamOut = new FileOutputStream(resDestFile);){
            int readBytes;
            byte[] buffer = new byte[4096];
            while ((readBytes = resStreamIn.read(buffer)) > 0) {
                ((OutputStream)resStreamOut).write(buffer, 0, readBytes);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static <R> R reflect(Field field, Object instance) throws IllegalAccessException {
        field.setAccessible(true);
        try {
            Object object = field.get(instance);
            return (R)object;
        }
        finally {
            field.setAccessible(false);
        }
    }

    public static void reflect(Field field, Object instance, Object value) throws IllegalAccessException {
        field.setAccessible(true);
        try {
            field.set(instance, value);
        }
        finally {
            field.setAccessible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R reflect(Method method, Object instance, Object ... arguments) throws InvocationTargetException, IllegalAccessException {
        method.setAccessible(true);
        try {
            Object object = method.invoke(instance, arguments);
            return (R)object;
        }
        finally {
            method.setAccessible(false);
        }
    }

    public static <R> R reflect(Constructor<?> constructor, Object ... arguments) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        constructor.setAccessible(true);
        try {
            Object obj = constructor.newInstance(arguments);
            return (R)obj;
        }
        finally {
            constructor.setAccessible(false);
        }
    }

    public static RuntimeException sneakyThrow(Throwable e) {
        return (RuntimeException)Try.sneakyThrow(e);
    }

    /*
     * Unable to fully structure code
     */
    public static String unescapeJavaString(String str) {
        sb = new StringBuilder(str.length());
        block13: for (i = 0; i < str.length(); ++i) {
            block23: {
                ch = str.codePointAt(i);
                if (ch != 92) break block23;
                v0 = nextChar = i == str.length() - 1 ? 92 : str.codePointAt(i + 1);
                if (nextChar >= 48 && nextChar <= 55) {
                    code = new StringBuilder();
                    code.appendCodePoint(nextChar);
                    if (++i < str.length() - 1 && str.codePointAt(i + 1) >= 48 && str.codePointAt(i + 1) <= 55) {
                        code.appendCodePoint(str.codePointAt(i + 1));
                        if (++i < str.length() - 1 && str.codePointAt(i + 1) >= 48 && str.codePointAt(i + 1) <= 55) {
                            code.appendCodePoint(str.codePointAt(i + 1));
                            ++i;
                        }
                    }
                    sb.append((char)Integer.parseInt(code.toString(), 8));
                    continue;
                }
                switch (nextChar) {
                    case 92: {
                        ch = 92;
                        ** GOTO lbl77
                    }
                    case 98: {
                        ch = 8;
                        ** GOTO lbl77
                    }
                    case 102: {
                        ch = 12;
                        ** GOTO lbl77
                    }
                    case 110: {
                        ch = 10;
                        ** GOTO lbl77
                    }
                    case 114: {
                        ch = 13;
                        ** GOTO lbl77
                    }
                    case 116: {
                        ch = 9;
                        ** GOTO lbl77
                    }
                    case 34: {
                        ch = 34;
                        ** GOTO lbl77
                    }
                    case 39: {
                        ch = 39;
                        ** GOTO lbl77
                    }
                    case 117: {
                        try {
                            if (i >= str.length() - 4) {
                                throw new IllegalStateException();
                            }
                            escape = new StringBuilder();
                            if (str.codePointAt(i + 2) != 123) {
                                if (i >= str.length() - 5) {
                                    throw new IllegalStateException();
                                }
                                for (offset = 2; offset <= 5; ++offset) {
                                    Integer.toString(str.codePointAt(i + offset), 16);
                                    escape.appendCodePoint(str.codePointAt(i + offset));
                                }
                                --offset;
                            } else {
                                ++offset;
                                while (str.codePointAt(i + offset) != 125) {
                                    Integer.toString(str.codePointAt(i + offset), 16);
                                    escape.appendCodePoint(str.codePointAt(i + offset));
                                    ++offset;
                                }
                            }
                            sb.append(new String(new int[]{Integer.parseInt(escape.toString(), 16)}, 0, 1));
                            i += offset;
                            continue block13;
                        }
                        catch (Throwable e) {
                            sb.append('\\');
                            ch = 117;
                        }
                    }
lbl77:
                    // 10 sources

                    default: {
                        ++i;
                    }
                }
            }
            sb.appendCodePoint(ch);
        }
        return sb.toString();
    }
}

