/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Bungee.Library.Compatibility;

import java.net.InetSocketAddress;
import java.util.UUID;
import java.util.function.IntConsumer;
import net.ME1312.SubServers.Bungee.Library.Compatibility.RPSI;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public interface RemotePlayer {
    public ProxiedPlayer get();

    public UUID getUniqueId();

    public String getName();

    public InetSocketAddress getAddress();

    public String getProxyName();

    public String getServerName();

    public ServerInfo getServer();

    public static void broadcastMessage(String ... messages) {
        RemotePlayer.broadcastMessage(messages, (int i) -> {});
    }

    public static void broadcastMessage(String message, IntConsumer response) {
        RemotePlayer.broadcastMessage(new String[]{message}, response);
    }

    public static void broadcastMessage(String[] messages, IntConsumer response) {
        RemotePlayer.sendMessage(null, messages, response);
    }

    default public void sendMessage(String ... messages) {
        this.sendMessage(messages, (int i) -> {});
    }

    default public void sendMessage(String message, IntConsumer response) {
        this.sendMessage(new String[]{message}, response);
    }

    default public void sendMessage(String[] messages, IntConsumer response) {
        RemotePlayer.sendMessage(new UUID[]{this.getUniqueId()}, messages, response);
    }

    public static void sendMessage(UUID[] players, String ... messages) {
        RemotePlayer.sendMessage(players, messages, (int i) -> {});
    }

    public static void sendMessage(UUID[] players, String message, IntConsumer response) {
        RemotePlayer.sendMessage(players, new String[]{message}, response);
    }

    public static void sendMessage(UUID[] players, String[] messages, IntConsumer response) {
        RPSI.instance.sendMessage(players, messages, response);
    }

    public static void broadcastMessage(BaseComponent ... message) {
        RemotePlayer.broadcastMessage(message, (int i) -> {});
    }

    public static void broadcastMessage(BaseComponent message, IntConsumer response) {
        RemotePlayer.broadcastMessage(new BaseComponent[]{message}, response);
    }

    public static void broadcastMessage(BaseComponent[] message, IntConsumer response) {
        RemotePlayer.broadcastMessage((BaseComponent[][])new BaseComponent[][]{message}, response);
    }

    public static void broadcastMessage(BaseComponent[] ... messages) {
        RemotePlayer.broadcastMessage(messages, (int i) -> {});
    }

    public static void broadcastMessage(BaseComponent[][] messages, IntConsumer response) {
        RemotePlayer.sendMessage(null, messages, response);
    }

    default public void sendMessage(BaseComponent ... message) {
        this.sendMessage(message, (int i) -> {});
    }

    default public void sendMessage(BaseComponent message, IntConsumer response) {
        this.sendMessage(new BaseComponent[]{message}, response);
    }

    default public void sendMessage(BaseComponent[] message, IntConsumer response) {
        this.sendMessage((BaseComponent[][])new BaseComponent[][]{message}, response);
    }

    default public void sendMessage(BaseComponent[] ... messages) {
        this.sendMessage(messages, (int i) -> {});
    }

    default public void sendMessage(BaseComponent[][] messages, IntConsumer response) {
        RemotePlayer.sendMessage(new UUID[]{this.getUniqueId()}, messages, response);
    }

    public static void sendMessage(UUID[] players, BaseComponent ... message) {
        RemotePlayer.sendMessage(players, message, (int i) -> {});
    }

    public static void sendMessage(UUID[] players, BaseComponent message, IntConsumer response) {
        RemotePlayer.sendMessage(players, new BaseComponent[]{message}, response);
    }

    public static void sendMessage(UUID[] players, BaseComponent[] message, IntConsumer response) {
        RemotePlayer.sendMessage(players, (BaseComponent[][])new BaseComponent[][]{message}, response);
    }

    public static void sendMessage(UUID[] players, BaseComponent[] ... messages) {
        RemotePlayer.sendMessage(players, messages, (int i) -> {});
    }

    public static void sendMessage(UUID[] players, BaseComponent[][] messages, IntConsumer response) {
        RPSI.instance.sendMessage(players, messages, response);
    }

    default public void transfer(String server) {
        this.transfer(server, (int i) -> {});
    }

    default public void transfer(String server, IntConsumer response) {
        RemotePlayer.transfer(new UUID[]{this.getUniqueId()}, server, response);
    }

    public static void transfer(UUID[] players, String server) {
        RemotePlayer.transfer(players, server, (int i) -> {});
    }

    public static void transfer(UUID[] players, String server, IntConsumer response) {
        RPSI.instance.transfer(players, server, response);
    }

    default public void transfer(ServerInfo server) {
        this.transfer(server, (int i) -> {});
    }

    default public void transfer(ServerInfo server, IntConsumer response) {
        RemotePlayer.transfer(new UUID[]{this.getUniqueId()}, server, response);
    }

    public static void transfer(UUID[] players, ServerInfo server) {
        RemotePlayer.transfer(players, server, (int i) -> {});
    }

    public static void transfer(UUID[] players, ServerInfo server, IntConsumer response) {
        RPSI.instance.transfer(players, server.getName(), response);
    }

    default public void disconnect() {
        this.disconnect((String)null);
    }

    default public void disconnect(IntConsumer response) {
        this.disconnect(null, response);
    }

    default public void disconnect(String reason) {
        this.disconnect(reason, i -> {});
    }

    default public void disconnect(String reason, IntConsumer response) {
        RemotePlayer.disconnect(new UUID[]{this.getUniqueId()}, reason, response);
    }

    public static void disconnect(UUID ... players) {
        RemotePlayer.disconnect(players, (String)null);
    }

    public static void disconnect(UUID[] players, IntConsumer response) {
        RemotePlayer.disconnect(players, null, response);
    }

    public static void disconnect(UUID[] players, String reason) {
        RemotePlayer.disconnect(players, reason, (int i) -> {});
    }

    public static void disconnect(UUID[] players, String reason, IntConsumer response) {
        RPSI.instance.disconnect(players, reason, response);
    }
}

