/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Bungee.Library.Fallback;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.ME1312.Galaxi.Library.Map.ObjectMap;
import net.ME1312.Galaxi.Library.Try;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.SubServers.Bungee.BungeeCommon;
import net.ME1312.SubServers.Bungee.Library.Fallback.FallbackInspector;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.ReconnectHandler;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.PendingConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public class SmartFallback
implements ReconnectHandler {
    private static List<FallbackInspector> inspectors = new CopyOnWriteArrayList<FallbackInspector>();
    private static ReconnectHandler reconnect;
    public static boolean dns_forward;

    public SmartFallback(ObjectMap<String> settings) {
        dns_forward = settings.getBoolean((Object)"DNS-Forward", Boolean.valueOf(false));
        if (reconnect == null && settings.getBoolean((Object)"Reconnect", Boolean.valueOf(false)).booleanValue()) {
            reconnect = (ReconnectHandler)Try.all.get(() -> (ReconnectHandler)Util.reflect(ProxyServer.getInstance().getPluginManager().getPlugin("reconnect_yaml").getClass().getClassLoader().loadClass("net.md_5.bungee.module.reconnect.yaml.YamlReconnectHandler").getConstructor(new Class[0]), (Object[])new Object[0]));
        }
    }

    public ServerInfo getServer(ProxiedPlayer player) {
        return this.getServer(player, player instanceof UserConnection);
    }

    protected ServerInfo getServer(ProxiedPlayer player, boolean queue) {
        ServerInfo override = SmartFallback.getForcedHost(player.getPendingConnection());
        if (override != null || (override = SmartFallback.getDNS(player.getPendingConnection())) != null) {
            if (queue) {
                ((UserConnection)player).setServerJoinQueue(new LinkedList());
            }
            return override;
        }
        Map<String, ServerInfo> fallbacks = SmartFallback.getFallbackServers(player.getPendingConnection().getListener(), player);
        override = SmartFallback.getReconnectServer(player);
        if (override != null || !fallbacks.isEmpty()) {
            if (queue) {
                ((UserConnection)player).setServerJoinQueue(new LinkedList<String>(fallbacks.keySet()));
            }
            return override != null ? override : new LinkedList<ServerInfo>(fallbacks.values()).getFirst();
        }
        return null;
    }

    public static ServerInfo getForcedHost(PendingConnection connection) {
        if (connection.getVirtualHost() == null) {
            return null;
        }
        String forced = (String)connection.getListener().getForcedHosts().get(connection.getVirtualHost().getHostString());
        return ProxyServer.getInstance().getServerInfo(forced);
    }

    public static ServerInfo getDNS(PendingConnection connection) {
        if (connection.getVirtualHost() == null || !dns_forward) {
            return null;
        }
        Map.Entry<String, ServerInfo> server = null;
        String dns = connection.getVirtualHost().getHostString().toLowerCase();
        for (Map.Entry<String, ServerInfo> s : ((BungeeCommon)ProxyServer.getInstance()).getServersCopy().entrySet()) {
            if (!dns.startsWith(s.getKey().toLowerCase() + '.') || server != null && ((String)server.getKey()).length() >= s.getKey().length()) continue;
            server = s;
        }
        return server == null ? null : (ServerInfo)server.getValue();
    }

    public static ServerInfo getReconnectServer(ProxiedPlayer player) {
        if (reconnect == null) {
            return null;
        }
        try {
            return (ServerInfo)Util.reflect((Method)reconnect.getClass().getDeclaredMethod("getStoredServer", ProxiedPlayer.class), (Object)reconnect, (Object[])new Object[]{player});
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, ServerInfo> getFallbackServers(ListenerInfo listener) {
        return SmartFallback.getFallbackServers(listener, null);
    }

    public static Map<String, ServerInfo> getFallbackServers(ListenerInfo listener, ProxiedPlayer player) {
        TreeMap score = new TreeMap(Collections.reverseOrder());
        for (String name : listener.getServerPriority()) {
            ServerInfo server = ProxyServer.getInstance().getServerInfo(name);
            if (server == null) continue;
            boolean valid = true;
            double confidence = 0.0;
            ArrayList<FallbackInspector> inspectors = new ArrayList<FallbackInspector>();
            inspectors.addAll(SmartFallback.inspectors);
            for (FallbackInspector inspector : inspectors) {
                try {
                    Double response = inspector.inspect(player, server);
                    if (response == null) {
                        valid = false;
                        continue;
                    }
                    confidence += response.doubleValue();
                }
                catch (Throwable e) {
                    new InvocationTargetException(e, "Exception while running inspecting fallback server: " + server.getName()).printStackTrace();
                }
            }
            if (!valid) continue;
            LinkedList<ServerInfo> servers = score.containsKey(confidence) ? (List)score.get(confidence) : new LinkedList<ServerInfo>();
            servers.add(server);
            score.put(confidence, servers);
        }
        Random random = new Random();
        LinkedHashMap<String, ServerInfo> map = new LinkedHashMap<String, ServerInfo>();
        for (List servers : score.values()) {
            while (!servers.isEmpty()) {
                ServerInfo next = (ServerInfo)servers.get(random.nextInt(servers.size()));
                map.put(next.getName(), next);
                servers.remove(next);
            }
        }
        return map;
    }

    public static void addInspector(FallbackInspector inspector) {
        Util.nullpo((Object)inspector);
        inspectors.add(inspector);
    }

    public static void removeInspector(FallbackInspector inspector) {
        Util.nullpo((Object)inspector);
        Try.all.run(() -> inspectors.remove(inspector));
    }

    public void setServer(ProxiedPlayer player) {
        if (reconnect != null) {
            reconnect.setServer(player);
        }
    }

    public void save() {
        if (reconnect != null) {
            reconnect.save();
        }
    }

    public void close() {
        if (reconnect != null) {
            reconnect.close();
        }
    }

    static {
        dns_forward = false;
    }
}

