/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.Galaxi.Library.Map;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.ME1312.Galaxi.Library.Map.ObjectMapValue;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.Galaxi.Library.Version.Version;

public class ObjectMap<K> {
    private static final Object x = null;
    LinkedHashMap<K, ObjectMapValue<K>> map = new LinkedHashMap();
    ObjectMap<K> up;
    K label;

    public ObjectMap() {
        this((Map)null);
    }

    public ObjectMap(Map<? extends K, ?> map) {
        if (map != null) {
            this.setAll(map);
        }
    }

    public ObjectMap(ObjectMap<? extends K> map) {
        this(map.map);
    }

    public Map<K, ?> get() {
        return (Map)this.simplify(this);
    }

    public ObjectMap<K> clone() {
        return this.constructMap(this.map);
    }

    public ObjectMap<K> getParent() {
        return this.up;
    }

    public <T> ObjectMap<T> key() {
        return this;
    }

    public Set<K> getKeys() {
        return this.map.keySet();
    }

    public Collection<? extends ObjectMapValue<K>> getValues() {
        return this.map.values();
    }

    public Collection<Map.Entry<K, ObjectMapValue<K>>> getEntries() {
        return this.map.entrySet();
    }

    public boolean contains(K handle) {
        return this.map.containsKey(handle);
    }

    protected ObjectMap<K> constructMap(Map<? extends K, ?> map) {
        return new ObjectMap<K>(map);
    }

    protected ObjectMapValue<K> constructValue(Object value) {
        return new ObjectMapValue(value);
    }

    protected Object complicate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            return this.constructMap((Map)value);
        }
        if (value instanceof ObjectMap) {
            if (((ObjectMap)value).up != this && (((ObjectMap)value).up != null || ((ObjectMap)value).label != null)) {
                return ((ObjectMap)value).clone();
            }
            return value;
        }
        if (value instanceof Collection) {
            LinkedList<Object> list = new LinkedList<Object>();
            for (Object val : (Collection)value) {
                list.add(this.complicate(val));
            }
            return list;
        }
        if (value.getClass().isArray()) {
            LinkedList<Object> list = new LinkedList<Object>();
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                list.add(this.complicate(Array.get(value, i)));
            }
            return list;
        }
        if (value instanceof UUID) {
            return Arrays.asList(((UUID)value).getMostSignificantBits(), ((UUID)value).getLeastSignificantBits());
        }
        if (value instanceof Version) {
            return ((Version)value).toFullString();
        }
        return value;
    }

    ObjectMapValue<K> wrap(K key, Object value) {
        ObjectMapValue<K> wrapped = this.constructValue(this.complicate(value instanceof ObjectMapValue ? ((ObjectMapValue)value).obj : value));
        if (wrapped.isMap()) {
            wrapped.asMap().up = this;
            wrapped.asMap().label = key;
        }
        wrapped.up = this;
        wrapped.label = key;
        return wrapped;
    }

    protected Object simplify(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof ObjectMap) {
            LinkedHashMap<K, Object> map = new LinkedHashMap<K, Object>();
            for (Map.Entry<K, ObjectMapValue<K>> e : ((ObjectMap)value).getEntries()) {
                map.put(e.getKey(), e.getValue() == null ? null : this.simplify(e.getValue().obj));
            }
            return map;
        }
        if (value instanceof ObjectMapValue) {
            return this.simplify(((ObjectMapValue)value).obj);
        }
        if (value instanceof Collection) {
            LinkedList<Object> list = new LinkedList<Object>();
            for (Object val : (Collection)value) {
                list.add(this.simplify(val));
            }
            return list;
        }
        return value;
    }

    public synchronized void set(K handle, Object value) {
        Util.nullpo(handle);
        this.map.put(handle, this.wrap(handle, value));
    }

    public void safeSet(K handle, Object value) {
        Util.nullpo(handle);
        if (!this.contains(handle)) {
            this.set(handle, value);
        }
    }

    public void safeSet(K handle, Supplier<?> value) {
        Util.nullpo(handle, value);
        if (!this.contains(handle)) {
            this.set(handle, value.get());
        }
    }

    public void setAll(Map<? extends K, ?> values) {
        Util.nullpo(values);
        for (K value : values.keySet()) {
            this.set(value, values.get(value));
        }
    }

    public void safeSetAll(Map<? extends K, ?> values) {
        Util.nullpo(values);
        for (K value : values.keySet()) {
            this.safeSet(value, values.get(value));
        }
    }

    public void setAll(ObjectMap<? extends K> values) {
        Util.nullpo(values);
        this.setAll(values.map);
    }

    public void safeSetAll(ObjectMap<? extends K> values) {
        Util.nullpo(values);
        this.safeSetAll(values.map);
    }

    public synchronized void remove(K handle) {
        Util.nullpo(handle);
        this.map.remove(handle);
    }

    public void clear() {
        this.map.clear();
    }

    public ObjectMapValue<K> get(K handle) {
        Util.nullpo(handle);
        return this.map.get(handle);
    }

    public ObjectMapValue<K> get(K handle, Object def) {
        Util.nullpo(handle);
        return this.map.get(handle) != null ? this.map.get(handle) : this.wrap(handle, def);
    }

    public ObjectMapValue<K> get(K handle, Supplier<?> def) {
        Util.nullpo(handle, def);
        return this.map.get(handle) != null ? this.map.get(handle) : this.wrap(handle, def.get());
    }

    public ObjectMapValue<K> get(K handle, ObjectMapValue<K> def) {
        Util.nullpo(handle);
        return this.map.get(handle) != null ? this.map.get(handle) : def;
    }

    public List<? extends ObjectMapValue<K>> getList(K handle) {
        Util.nullpo(handle);
        return this.map.get(handle).asList();
    }

    public List<? extends ObjectMapValue<K>> getList(K handle, Collection<?> def) {
        Util.nullpo(handle);
        if (this.map.get(handle) != null) {
            return this.getList(handle);
        }
        if (def != null) {
            LinkedList<ObjectMapValue<Object>> values = new LinkedList<ObjectMapValue<Object>>();
            for (Object value : def) {
                values.add(this.wrap(null, value));
            }
            return values;
        }
        return null;
    }

    public List<? extends ObjectMapValue<K>> getList(K handle, Supplier<? extends Collection<?>> def) {
        Util.nullpo(handle, def);
        if (this.map.get(handle) != null) {
            return this.getList(handle);
        }
        if (def != null) {
            LinkedList<ObjectMapValue<Object>> values = new LinkedList<ObjectMapValue<Object>>();
            for (Object value : def.get()) {
                values.add(this.wrap(null, value));
            }
            return values;
        }
        return null;
    }

    public List<? extends ObjectMapValue<K>> getList(K handle, List<? extends ObjectMapValue<K>> def) {
        Util.nullpo(handle);
        if (this.map.get(handle) != null) {
            return this.getList(handle);
        }
        if (def != null) {
            return def;
        }
        return null;
    }

    public Object getObject(K handle) {
        return this.get(handle, x).asObject();
    }

    public Object getObject(K handle, Object def) {
        return this.get(handle, def).asObject();
    }

    public Object getObject(K handle, Supplier<?> def) {
        return this.get(handle, def).asObject();
    }

    public List<?> getObjectList(K handle) {
        return this.get(handle, x).asObjectList();
    }

    public List<?> getObjectList(K handle, List<?> def) {
        return this.get(handle, def).asObjectList();
    }

    public List<?> getObjectList(K handle, Supplier<? extends List<?>> def) {
        return this.get(handle, def).asObjectList();
    }

    public Boolean getBoolean(K handle) {
        return this.get(handle, x).asBoolean();
    }

    public Boolean getBoolean(K handle, Boolean def) {
        return this.get(handle, def).asBoolean();
    }

    public Boolean getBoolean(K handle, Supplier<Boolean> def) {
        return this.get(handle, def).asBoolean();
    }

    public List<Boolean> getBooleanList(K handle) {
        return this.get(handle, x).asBooleanList();
    }

    public List<Boolean> getBooleanList(K handle, List<Boolean> def) {
        return this.get(handle, def).asBooleanList();
    }

    public List<Boolean> getBooleanList(K handle, Supplier<? extends List<Boolean>> def) {
        return this.get(handle, def).asBooleanList();
    }

    public ObjectMap<K> getMap(K handle) {
        return this.get(handle, x).asMap();
    }

    public ObjectMap<K> getMap(K handle, Map<? extends K, ?> def) {
        return this.get(handle, def).asMap();
    }

    public ObjectMap<K> getMap(K handle, ObjectMap<? extends K> def) {
        Util.nullpo(handle);
        if (this.map.get(handle) != null) {
            return this.getMap(handle);
        }
        if (def != null) {
            return def;
        }
        return null;
    }

    public ObjectMap<K> getMap(K handle, Supplier<? extends ObjectMap<? extends K>> def) {
        Util.nullpo(handle, def);
        if (this.map.get(handle) != null) {
            return this.getMap(handle);
        }
        if (def != null) {
            return def.get();
        }
        return null;
    }

    public List<? extends ObjectMap<K>> getMapList(K handle) {
        return this.get(handle, x).asMapList();
    }

    public List<? extends ObjectMap<K>> getMapList(K handle, Collection<? extends Map<? extends K, ?>> def) {
        return this.get(handle, def).asMapList();
    }

    public List<? extends ObjectMap<K>> getMapList(K handle, List<? extends ObjectMap<? extends K>> def) {
        Util.nullpo(handle);
        if (this.map.get(handle) != null) {
            return this.get(handle).asMapList();
        }
        if (def != null) {
            return def;
        }
        return null;
    }

    public List<? extends ObjectMap<K>> getMapList(K handle, Supplier<? extends List<? extends ObjectMap<? extends K>>> def) {
        Util.nullpo(handle, def);
        if (this.map.get(handle) != null) {
            return this.get(handle).asMapList();
        }
        if (def != null) {
            return def.get();
        }
        return null;
    }

    public Double getDouble(K handle) {
        return this.get(handle, x).asDouble();
    }

    public Double getDouble(K handle, Double def) {
        return this.get(handle, def).asDouble();
    }

    public Double getDouble(K handle, Supplier<Double> def) {
        return this.get(handle, def).asDouble();
    }

    public List<Double> getDoubleList(K handle) {
        return this.get(handle, x).asDoubleList();
    }

    public List<Double> getDoubleList(K handle, List<Double> def) {
        return this.get(handle, def).asDoubleList();
    }

    public List<Double> getDoubleList(K handle, Supplier<? extends List<Double>> def) {
        return this.get(handle, def).asDoubleList();
    }

    public Float getFloat(K handle) {
        return this.get(handle, x).asFloat();
    }

    public Float getFloat(K handle, Float def) {
        return this.get(handle, def).asFloat();
    }

    public Float getFloat(K handle, Supplier<Float> def) {
        return this.get(handle, def).asFloat();
    }

    public List<Float> getFloatList(K handle) {
        return this.get(handle, x).asFloatList();
    }

    public List<Float> getFloatList(K handle, List<Float> def) {
        return this.get(handle, def).asFloatList();
    }

    public List<Float> getFloatList(K handle, Supplier<? extends List<Float>> def) {
        return this.get(handle, def).asFloatList();
    }

    public Integer getInt(K handle) {
        return this.get(handle, x).asInt();
    }

    public Integer getInt(K handle, Integer def) {
        return this.get(handle, def).asInt();
    }

    public Integer getInt(K handle, Supplier<Integer> def) {
        return this.get(handle, def).asInt();
    }

    public List<Integer> getIntList(K handle) {
        return this.get(handle, x).asIntList();
    }

    public List<Integer> getIntList(K handle, List<Integer> def) {
        return this.get(handle, def).asIntList();
    }

    public List<Integer> getIntList(K handle, Supplier<? extends List<Integer>> def) {
        return this.get(handle, def).asIntList();
    }

    public Long getLong(K handle) {
        return this.get(handle, x).asLong();
    }

    public Long getLong(K handle, Long def) {
        return this.get(handle, def).asLong();
    }

    public Long getLong(K handle, Supplier<Long> def) {
        return this.get(handle, def).asLong();
    }

    public List<Long> getLongList(K handle) {
        return this.get(handle, x).asLongList();
    }

    public List<Long> getLongList(K handle, List<Long> def) {
        return this.get(handle, def).asLongList();
    }

    public List<Long> getLongList(K handle, Supplier<? extends List<Long>> def) {
        return this.get(handle, def).asLongList();
    }

    public Short getShort(K handle) {
        return this.get(handle, x).asShort();
    }

    public Short getShort(K handle, Short def) {
        return this.get(handle, def).asShort();
    }

    public Short getShort(K handle, Supplier<Short> def) {
        return this.get(handle, def).asShort();
    }

    public List<Short> getShortList(K handle) {
        return this.get(handle, x).asShortList();
    }

    public List<Short> getShortList(K handle, List<Short> def) {
        return this.get(handle, def).asShortList();
    }

    public List<Short> getShortList(K handle, Supplier<? extends List<Short>> def) {
        return this.get(handle, def).asShortList();
    }

    public String getString(K handle) {
        return this.get(handle, x).asString();
    }

    public String getString(K handle, String def) {
        return this.get(handle, def).asString();
    }

    public String getString(K handle, Supplier<String> def) {
        return this.get(handle, def).asString();
    }

    public List<String> getStringList(K handle) {
        return this.get(handle, x).asStringList();
    }

    public List<String> getStringList(K handle, List<String> def) {
        return this.get(handle, def).asStringList();
    }

    public List<String> getStringList(K handle, Supplier<? extends List<String>> def) {
        return this.get(handle, def).asStringList();
    }

    public UUID getUUID(K handle) {
        return this.get(handle, x).asUUID();
    }

    public UUID getUUID(K handle, UUID def) {
        return this.get(handle, def).asUUID();
    }

    public UUID getUUID(K handle, Supplier<UUID> def) {
        return this.get(handle, def).asUUID();
    }

    public List<UUID> getUUIDList(K handle) {
        return this.get(handle, x).asUUIDList();
    }

    public List<UUID> getUUIDList(K handle, List<UUID> def) {
        return this.get(handle, def).asUUIDList();
    }

    public List<UUID> getUUIDList(K handle, Supplier<? extends List<UUID>> def) {
        return this.get(handle, def).asUUIDList();
    }

    public Version getVersion(K handle) {
        return this.get(handle, x).asVersion();
    }

    public Version getVersion(K handle, Version def) {
        return this.get(handle, def).asVersion();
    }

    public Version getVersion(K handle, Supplier<Version> def) {
        return this.get(handle, def).asVersion();
    }

    public List<Version> getVersionList(K handle) {
        return this.get(handle, x).asVersionList();
    }

    public List<Version> getVersionList(K handle, List<Version> def) {
        return this.get(handle, def).asVersionList();
    }

    public List<Version> getVersionList(K handle, Supplier<? extends List<Version>> def) {
        return this.get(handle, def).asVersionList();
    }

    public boolean isNull(K handle) {
        return this.get(handle, x).isNull();
    }

    public boolean isBoolean(K handle) {
        return this.get(handle, x).isBoolean();
    }

    public boolean isMap(K handle) {
        return this.get(handle, x).isMap();
    }

    public boolean isList(K handle) {
        return this.get(handle, x).isList();
    }

    public boolean isNumber(K handle) {
        return this.get(handle, x).isNumber();
    }

    public boolean isString(K handle) {
        return this.get(handle, x).isString();
    }

    public boolean isUUID(K handle) {
        return this.get(handle, x).isUUID();
    }

    public boolean equals(Object object) {
        if (object instanceof ObjectMap) {
            return this.map.equals(((ObjectMap)object).map);
        }
        return super.equals(object);
    }

    public String toString() {
        if (this.map != null) {
            return this.map.toString();
        }
        return "null";
    }
}

