/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.Galaxi.Library.Version;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.Galaxi.Library.Version.VersionTokenizer;
import net.ME1312.Galaxi.Library.Version.VersionType;

public final class Version
implements Serializable,
Comparable<Version> {
    private final Version parent;
    private final VersionType type;
    private final String string;

    public Version(String string) {
        this(VersionType.VERSION, string);
    }

    public Version(VersionType type, String string) {
        this(null, type, string);
    }

    public Version(Version parent, String string) {
        this(parent, VersionType.VERSION, string);
    }

    public Version(Version parent, VersionType type, String string) {
        Util.nullpo(new Serializable[]{string, type});
        this.parent = parent;
        this.type = type;
        this.string = string;
    }

    public Version(int ... ints) {
        this(VersionType.VERSION, ints);
    }

    public Version(VersionType type, int ... ints) {
        this(null, type, ints);
    }

    public Version(Version parent, int ... ints) {
        this(parent, VersionType.VERSION, ints);
    }

    public Version(Version parent, VersionType type, int ... ints) {
        Util.nullpo(type);
        this.parent = parent;
        this.type = type;
        String string = Integer.toString(ints[0]);
        int i = 0;
        if (ints.length != 1) {
            do {
                string = string + "." + ints[++i];
            } while (i + 1 != ints.length);
        }
        this.string = string;
    }

    public static Version fromString(String string) {
        Matcher regex = Pattern.compile("(r[cv]|p?[abr]|[psuv])?([^/]+)", 2).matcher(string);
        Version current = null;
        while (regex.find()) {
            try {
                VersionType type = VersionType.VERSION;
                if (regex.group(1) != null) {
                    switch (regex.group(1).toLowerCase()) {
                        case "pa": {
                            type = VersionType.PRE_ALPHA;
                            break;
                        }
                        case "a": {
                            type = VersionType.ALPHA;
                            break;
                        }
                        case "pb": {
                            type = VersionType.PRE_BETA;
                            break;
                        }
                        case "b": {
                            type = VersionType.BETA;
                            break;
                        }
                        case "p": {
                            type = VersionType.PREVIEW;
                            break;
                        }
                        case "s": {
                            type = VersionType.SNAPSHOT;
                            break;
                        }
                        case "pr": {
                            type = VersionType.PRE_RELEASE;
                            break;
                        }
                        case "rc": {
                            type = VersionType.RELEASE_CANDIDATE;
                            break;
                        }
                        case "r": {
                            type = VersionType.RELEASE;
                            break;
                        }
                        case "rv": {
                            type = VersionType.REVISION;
                            break;
                        }
                        case "u": {
                            type = VersionType.UPDATE;
                        }
                    }
                }
                current = new Version(current, type, regex.group(2));
            }
            catch (Throwable throwable) {}
        }
        if (current == null) {
            throw new IllegalArgumentException("Could not find version in string: " + string);
        }
        return current;
    }

    public String toString() {
        return (this.parent == null ? "" : this.parent.toString() + '/' + this.type.shortname) + this.string;
    }

    public String toFullString() {
        return (this.parent == null ? "" : this.parent.toFullString() + '/') + this.type.shortname + this.string;
    }

    public String toExtendedString() {
        return (this.parent == null ? "" : this.parent.toExtendedString() + ' ' + this.type.longname + ' ') + this.string;
    }

    public String toFullExtendedString() {
        return (this.parent == null ? "" : this.parent.toFullExtendedString() + ' ') + this.type.longname + ' ' + this.string;
    }

    public static String toString(Collection<Version> collection) {
        return collection.toString();
    }

    public static String toFullString(Collection<Version> collection) {
        if (collection.size() == 0) {
            return "[]";
        }
        StringBuilder string = new StringBuilder("[");
        Iterator<Version> i = collection.iterator();
        while (true) {
            Version next;
            string.append((next = i.next()) == null ? "null" : next.toFullString());
            if (!i.hasNext()) break;
            string.append(", ");
        }
        string.append(']');
        return string.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof Version) {
            return this.equals((Version)object);
        }
        return super.equals(object);
    }

    public boolean equals(Version version) {
        return this.compareTo(version) == 0;
    }

    @Override
    public int compareTo(Version version) {
        return Version.compare(this, version);
    }

    public static boolean equals(Version ver1, Version ver2) {
        return Version.compare(ver1, ver2) == 0;
    }

    public static int compare(Version ver1, Version ver2) {
        int id;
        if (ver1 == null && ver2 == null) {
            return 0;
        }
        if (ver1 == null) {
            return -1;
        }
        if (ver2 == null) {
            return 1;
        }
        LinkedList<Version> stack1 = new LinkedList<Version>();
        stack1.add(ver1);
        while (ver1.parent != null) {
            ver1 = ver1.parent;
            stack1.add(ver1);
        }
        Collections.reverse(stack1);
        LinkedList<Version> stack2 = new LinkedList<Version>();
        stack2.add(ver2);
        while (ver2.parent != null) {
            ver2 = ver2.parent;
            stack2.add(ver2);
        }
        Collections.reverse(stack2);
        for (id = 0; id < stack1.size(); ++id) {
            if (id >= stack2.size()) {
                if (((Version)stack1.get((int)id)).type.stageid < 0) {
                    return -1;
                }
                return 1;
            }
            int result = ((Version)stack1.get(id)).compare((Version)stack2.get(id));
            if (result == 0) continue;
            return result;
        }
        if (id < stack2.size()) {
            if (((Version)stack2.get((int)id)).type.stageid < 0) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    private int compare(Version version) {
        String suffix2;
        int number2;
        if (this.type.stageid > version.type.stageid) {
            return 1;
        }
        if (this.type.stageid < version.type.stageid) {
            return -1;
        }
        VersionTokenizer tokenizer1 = new VersionTokenizer(this.string);
        VersionTokenizer tokenizer2 = new VersionTokenizer(version.string);
        while (tokenizer1.MoveNext()) {
            boolean empty2;
            String suffix1;
            int number1;
            if (!tokenizer2.MoveNext()) {
                do {
                    number1 = tokenizer1.getNumber();
                    suffix1 = tokenizer1.getSuffix();
                    if (number1 == 0 && suffix1.length() == 0) continue;
                    return 1;
                } while (tokenizer1.MoveNext());
                return 0;
            }
            number1 = tokenizer1.getNumber();
            suffix1 = tokenizer1.getSuffix();
            number2 = tokenizer2.getNumber();
            suffix2 = tokenizer2.getSuffix();
            if (number1 < number2) {
                return -1;
            }
            if (number1 > number2) {
                return 1;
            }
            boolean empty1 = suffix1.length() == 0;
            boolean bl = empty2 = suffix2.length() == 0;
            if (empty1 && empty2) continue;
            if (empty1) {
                return 1;
            }
            if (empty2) {
                return -1;
            }
            int result = suffix1.compareTo(suffix2);
            if (result == 0) continue;
            return result;
        }
        if (tokenizer2.MoveNext()) {
            do {
                number2 = tokenizer2.getNumber();
                suffix2 = tokenizer2.getSuffix();
                if (number2 == 0 && suffix2.length() == 0) continue;
                return -1;
            } while (tokenizer2.MoveNext());
            return 0;
        }
        return 0;
    }
}

