/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubData.Server.Encryption;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import net.ME1312.Galaxi.Library.Container.ContainedPair;
import net.ME1312.Galaxi.Library.Container.Pair;
import net.ME1312.SubData.Server.Cipher;
import net.ME1312.SubData.Server.DataClient;
import net.ME1312.SubData.Server.Library.Exception.EncryptionException;

public final class AES
implements Cipher {
    private static final String CIPHER_SPEC = "AES/CBC/PKCS5Padding";
    private static final String KEYGEN_SPEC = "PBKDF2WithHmacSHA256";
    private static final int SALT_LENGTH = 16;
    private static final int AUTH_KEY_LENGTH = 8;
    private static final int ITERATIONS = 32768;
    private static final int BUFFER_SIZE = 1024;
    private final int keyLength;
    private final String key;

    public AES(int keyLength, String key) {
        if (keyLength != 128 && keyLength != 192 && keyLength != 256) {
            throw new IllegalArgumentException(Integer.toString(keyLength));
        }
        this.keyLength = keyLength;
        this.key = key;
    }

    static Pair<Cipher, String> random(int keyLength) {
        StringBuilder builder = new StringBuilder();
        SecureRandom random = new SecureRandom();
        for (int i = random.nextInt(keyLength + 1) + keyLength; i > 0; i -= 8) {
            builder.append((char)random.nextInt(65536));
        }
        String key = builder.toString();
        return new ContainedPair((Object)new AES(keyLength, key), (Object)key);
    }

    private static byte[] generateSalt() {
        SecureRandom r = new SecureRandom();
        byte[] salt = new byte[16];
        ((Random)r).nextBytes(salt);
        return salt;
    }

    private static Keys keygen(int keyLength, char[] password, byte[] salt) {
        SecretKeyFactory factory;
        try {
            factory = SecretKeyFactory.getInstance(KEYGEN_SPEC);
        }
        catch (NoSuchAlgorithmException impossible) {
            return null;
        }
        PBEKeySpec spec = new PBEKeySpec(password, salt, 32768, keyLength + 64);
        SecretKey tmp = null;
        try {
            tmp = factory.generateSecret(spec);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            // empty catch block
        }
        byte[] fullKey = tmp.getEncoded();
        SecretKeySpec authKey = new SecretKeySpec(Arrays.copyOfRange(fullKey, 0, 8), "AES");
        SecretKeySpec encKey = new SecretKeySpec(Arrays.copyOfRange(fullKey, 8, fullKey.length), "AES");
        return new Keys(encKey, authKey);
    }

    public static void encrypt(int keyLength, String password, InputStream input, OutputStream output) throws InvalidKeyLengthException, StrongEncryptionNotAvailableException, IOException {
        int numRead;
        if (keyLength != 128 && keyLength != 192 && keyLength != 256) {
            throw new InvalidKeyLengthException(keyLength);
        }
        byte[] salt = AES.generateSalt();
        Keys keys = AES.keygen(keyLength, password.toCharArray(), salt);
        javax.crypto.Cipher encrypt = null;
        try {
            encrypt = javax.crypto.Cipher.getInstance(CIPHER_SPEC);
            encrypt.init(1, keys.encryption);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
        }
        catch (InvalidKeyException e) {
            throw new StrongEncryptionNotAvailableException(keyLength);
        }
        byte[] iv = null;
        try {
            iv = encrypt.getParameters().getParameterSpec(IvParameterSpec.class).getIV();
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            // empty catch block
        }
        output.write(keyLength / 8);
        output.write(salt);
        output.write(keys.authentication.getEncoded());
        output.write(iv);
        byte[] buffer = new byte[1024];
        byte[] encrypted = null;
        while ((numRead = input.read(buffer)) > 0) {
            encrypted = encrypt.update(buffer, 0, numRead);
            if (encrypted == null) continue;
            output.write(encrypted);
        }
        try {
            encrypted = encrypt.doFinal();
        }
        catch (BadPaddingException | IllegalBlockSizeException generalSecurityException) {
            // empty catch block
        }
        if (encrypted != null) {
            output.write(encrypted);
        }
        output.flush();
    }

    public void encrypt(DataClient client, InputStream in, OutputStream out) throws Exception {
        AES.encrypt(this.keyLength, this.key, in, out);
    }

    public String getName() {
        return "AES-" + this.keyLength;
    }

    public static int decrypt(String password, InputStream input, OutputStream output) throws InvalidPasswordException, InvalidAESStreamException, IOException, StrongEncryptionNotAvailableException {
        byte[] decrypted;
        int numRead;
        int keyLength = input.read() * 8;
        if (keyLength != 128 && keyLength != 192 && keyLength != 256) {
            throw new InvalidAESStreamException();
        }
        byte[] salt = new byte[16];
        input.read(salt);
        Keys keys = AES.keygen(keyLength, password.toCharArray(), salt);
        byte[] authRead = new byte[8];
        input.read(authRead);
        if (!Arrays.equals(keys.authentication.getEncoded(), authRead)) {
            throw new InvalidPasswordException();
        }
        byte[] iv = new byte[16];
        input.read(iv);
        javax.crypto.Cipher decrypt = null;
        try {
            decrypt = javax.crypto.Cipher.getInstance(CIPHER_SPEC);
            decrypt.init(2, (Key)keys.encryption, new IvParameterSpec(iv));
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
        }
        catch (InvalidKeyException e) {
            throw new StrongEncryptionNotAvailableException(keyLength);
        }
        byte[] buffer = new byte[1024];
        while ((numRead = input.read(buffer)) > 0) {
            decrypted = decrypt.update(buffer, 0, numRead);
            if (decrypted == null) continue;
            output.write(decrypted);
        }
        try {
            decrypted = decrypt.doFinal();
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new InvalidAESStreamException(e);
        }
        if (decrypted != null) {
            output.write(decrypted);
        }
        output.flush();
        return keyLength;
    }

    public void decrypt(DataClient client, InputStream in, OutputStream out) throws Exception {
        AES.decrypt(this.key, in, out);
    }

    private static class Keys {
        public final SecretKey encryption;
        public final SecretKey authentication;

        public Keys(SecretKey encryption, SecretKey authentication) {
            this.encryption = encryption;
            this.authentication = authentication;
        }
    }

    public static class InvalidKeyLengthException
    extends EncryptionException {
        InvalidKeyLengthException(int length) {
            super("Invalid AES key length: " + length);
        }
    }

    public static class StrongEncryptionNotAvailableException
    extends EncryptionException {
        public StrongEncryptionNotAvailableException(int keySize) {
            super(keySize + "-bit AES encryption is not available on this Java platform.");
        }
    }

    public static class InvalidAESStreamException
    extends EncryptionException {
        public InvalidAESStreamException() {
        }

        public InvalidAESStreamException(Exception e) {
            super((Throwable)e);
        }
    }

    public static class InvalidPasswordException
    extends EncryptionException {
    }
}

