/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubData.Server.Encryption;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.crypto.KeyAgreement;
import net.ME1312.Galaxi.Library.Container.Pair;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.SubData.Server.Cipher;
import net.ME1312.SubData.Server.CipherFactory;
import net.ME1312.SubData.Server.DataClient;
import net.ME1312.SubData.Server.Encryption.AES;
import net.ME1312.SubData.Server.Library.EscapedOutputStream;
import net.ME1312.SubData.Server.Library.Exception.EncryptionException;
import net.ME1312.SubData.Server.Library.OutputStreamL1;
import net.ME1312.SubData.Server.Protocol.Internal.PacketNull;
import net.ME1312.SubData.Server.SubDataClient;

public class DHE
implements Cipher,
CipherFactory {
    private static final HashMap<String, Supplier<Pair<Cipher, String>>> forwardG = new HashMap();
    private static final HashMap<String, Function<String, Cipher>> forwardP = new HashMap();
    private static final int REFRESH = 125;
    private static final HashMap<Integer, DHE> instances = new HashMap();
    private final HashMap<DataClient, Data> data = new HashMap();
    private final int keyLength;

    public String getName() {
        return "DHE-" + this.keyLength;
    }

    public static DHE get(int keyLength) {
        if (keyLength != 128 && keyLength != 192 && keyLength != 256) {
            throw new IllegalArgumentException(Integer.toString(keyLength));
        }
        if (!instances.containsKey(keyLength)) {
            instances.put(keyLength, new DHE(keyLength));
        }
        return instances.get(keyLength);
    }

    private DHE(int keyLength) {
        this.keyLength = keyLength;
    }

    public void encrypt(DataClient client, InputStream in, OutputStream out) throws Exception {
        Data data = this.data.get(client);
        if (data == null) {
            data = new Data();
            this.data.put(client, data);
        }
        if (!data.sent) {
            try {
                EscapedOutputStream stream = new EscapedOutputStream(out, 27, 14, 15);
                stream.control(14);
                stream.write(data.key.getEncoded());
                stream.control(15);
                ((OutputStreamL1)Util.reflect((Field)SubDataClient.class.getDeclaredField("out"), (Object)client)).flush();
                data.sent = true;
            }
            catch (Throwable e) {
                throw new EncryptionException(e);
            }
        }
        while (data.next == null) {
            Thread.sleep(125L);
        }
        data.next.encrypt(client, in, out);
    }

    public void decrypt(DataClient client, InputStream in, OutputStream out) throws Exception {
        int b;
        Data data = this.data.get(client);
        if (data == null) {
            data = new Data();
            this.data.put(client, data);
        }
        boolean escaped = false;
        boolean receiving = false;
        while (!data.received && (b = in.read()) != -1) {
            if (escaped) {
                switch (b) {
                    case 27: {
                        if (!receiving) break;
                        data.data.write(27);
                        break;
                    }
                    case 14: {
                        data.data = new ByteArrayOutputStream();
                        receiving = true;
                        break;
                    }
                    case 15: {
                        data.compile();
                        break;
                    }
                    default: {
                        if (!receiving) break;
                        data.data.write(27);
                        data.data.write(b);
                    }
                }
                escaped = false;
                continue;
            }
            if (b == 27) {
                escaped = true;
                continue;
            }
            if (!receiving) continue;
            data.data.write(b);
        }
        if (data.received) {
            if (!data.initSent) {
                data.initSent = true;
                OutputStreamL1 stream = (OutputStreamL1)Util.reflect((Field)SubDataClient.class.getDeclaredField("out"), (Object)client);
                stream.control(24);
                stream.flush();
                ((SubDataClient)client).sendPacket(new PacketNull());
            }
            while (data.next == null) {
                Thread.sleep(125L);
            }
            data.next.decrypt(client, in, out);
        }
    }

    public void retire(DataClient client) {
        this.data.remove(client);
    }

    public Pair<Cipher, String> newCipher(String handle) {
        return forwardG.getOrDefault(handle.toUpperCase(), () -> null).get();
    }

    public Cipher getCipher(String handle, String key) {
        return forwardP.getOrDefault(handle.toUpperCase(), token -> null).apply(key);
    }

    public static void addCipher(String handle, Supplier<Pair<Cipher, String>> generator, Function<String, Cipher> parser) {
        Util.nullpo(generator);
        handle = handle.toUpperCase();
        if (!forwardG.containsKey(handle)) {
            forwardG.put(handle, generator);
        }
        if (!forwardP.containsKey(handle)) {
            forwardP.put(handle, parser);
        }
    }

    public static void removeCipher(String handle) {
        forwardG.remove(handle.toUpperCase());
        forwardP.remove(handle.toUpperCase());
    }

    static {
        DHE.addCipher("AES", () -> AES.random(128), key -> new AES(128, (String)key));
        DHE.addCipher("AES-128", () -> AES.random(128), key -> new AES(128, (String)key));
        DHE.addCipher("AES-192", () -> AES.random(192), key -> new AES(192, (String)key));
        DHE.addCipher("AES-256", () -> AES.random(256), key -> new AES(256, (String)key));
    }

    private final class Data {
        private final PublicKey key;
        private final KeyAgreement agreement;
        private ByteArrayOutputStream data;
        private boolean sent;
        private boolean initSent;
        private boolean received;
        private Cipher next;

        private Data() throws EncryptionException {
            try {
                KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC");
                ECGenParameterSpec spec = DHE.this.keyLength >= 256 ? new ECGenParameterSpec("secp521r1") : (DHE.this.keyLength >= 192 ? new ECGenParameterSpec("secp384r1") : new ECGenParameterSpec("secp256r1"));
                kpg.initialize(spec);
                KeyPair kp = kpg.generateKeyPair();
                this.key = kp.getPublic();
                this.agreement = KeyAgreement.getInstance("ECDH");
                this.agreement.init(kp.getPrivate());
            }
            catch (Throwable e) {
                throw new EncryptionException(e);
            }
        }

        private void compile() throws EncryptionException {
            this.received = true;
            try {
                this.agreement.doPhase(KeyFactory.getInstance("EC").generatePublic(new X509EncodedKeySpec(this.data.toByteArray())), true);
                StringBuilder builder = new StringBuilder();
                byte[] ba = this.agreement.generateSecret();
                ByteBuffer buf = ByteBuffer.wrap(ba);
                for (int i = ba.length; i > 1; i -= 2) {
                    builder.append(buf.getChar());
                }
                String key = builder.toString();
                this.next = new AES(DHE.this.keyLength, key);
            }
            catch (Throwable e) {
                throw new EncryptionException(e);
            }
        }
    }
}

