/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubData.Server.Encryption;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.nio.file.Files;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import net.ME1312.Galaxi.Library.Container.Container;
import net.ME1312.Galaxi.Library.Container.Pair;
import net.ME1312.Galaxi.Library.Container.Value;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.SubData.Server.Cipher;
import net.ME1312.SubData.Server.CipherFactory;
import net.ME1312.SubData.Server.DataClient;
import net.ME1312.SubData.Server.Encryption.AES;
import net.ME1312.SubData.Server.Library.EscapedOutputStream;
import net.ME1312.SubData.Server.Library.Exception.EncryptionException;

public final class RSA
implements Cipher,
CipherFactory {
    private static final HashMap<String, Supplier<Pair<Cipher, String>>> forwardG = new HashMap();
    private static final HashMap<String, Function<String, Cipher>> forwardP = new HashMap();
    private static final String CIPHER_SPEC = "RSA/ECB/PKCS1Padding";
    private final int BUFFER_SIZE;
    private final PrivateKey privateKey;
    private final PublicKey publicKey;

    public String getName() {
        return "RSA";
    }

    public RSA(int keyLength, File privateKey, File publicKey) throws Exception {
        if (!privateKey.exists() || !publicKey.exists()) {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
            kpg.initialize(keyLength);
            KeyPair kp = kpg.generateKeyPair();
            try (FileOutputStream out = new FileOutputStream(privateKey);){
                out.write(kp.getPrivate().getEncoded());
            }
            out = new FileOutputStream(publicKey);
            try {
                out.write(kp.getPublic().getEncoded());
            }
            finally {
                out.close();
            }
            this.privateKey = kp.getPrivate();
            this.publicKey = kp.getPublic();
        } else {
            byte[] bytes = Files.readAllBytes(privateKey.toPath());
            PKCS8EncodedKeySpec ks1 = new PKCS8EncodedKeySpec(bytes);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            this.privateKey = kf.generatePrivate(ks1);
            bytes = Files.readAllBytes(publicKey.toPath());
            X509EncodedKeySpec ks2 = new X509EncodedKeySpec(bytes);
            kf = KeyFactory.getInstance("RSA");
            this.publicKey = kf.generatePublic(ks2);
        }
        this.BUFFER_SIZE = keyLength / 8 - 11;
    }

    public RSA(File publicKey) throws Exception {
        byte[] bytes = Files.readAllBytes(publicKey.toPath());
        X509EncodedKeySpec ks = new X509EncodedKeySpec(bytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        this.privateKey = null;
        this.publicKey = kf.generatePublic(ks);
        this.BUFFER_SIZE = ((RSAPublicKey)this.publicKey).getModulus().bitLength() / 8 - 11;
    }

    public void encrypt(DataClient client, final InputStream in, OutputStream out) throws Exception {
        EscapedOutputStream stream = new EscapedOutputStream(out, 27, 23);
        Container reset = new Container((Object)false);
        while (!((Boolean)reset.value()).booleanValue()) {
            Container wrote = new Container((Object)false);
            this.encrypt(new InputStream((Value)reset, (Value)wrote){
                boolean open = true;
                int bc = 1;
                final /* synthetic */ Value val$reset;
                final /* synthetic */ Value val$wrote;
                {
                    this.val$reset = value;
                    this.val$wrote = value2;
                }

                private int next() throws IOException {
                    if (this.bc > RSA.this.BUFFER_SIZE) {
                        return -1;
                    }
                    int b = in.read();
                    if (b == -1) {
                        this.val$reset.value((Object)true);
                    } else {
                        this.val$wrote.value((Object)true);
                    }
                    return b;
                }

                @Override
                public int read() throws IOException {
                    if (this.open) {
                        int b = this.next();
                        if (b <= -1) {
                            this.close();
                        } else {
                            ++this.bc;
                        }
                        return b;
                    }
                    return -1;
                }

                @Override
                public void close() throws IOException {
                    if (this.open) {
                        this.open = false;
                    }
                }
            }, stream);
            if (!((Boolean)wrote.value()).booleanValue()) continue;
            stream.control(23);
            stream.flush();
        }
    }

    private void encrypt(InputStream in, OutputStream out) throws Exception {
        try {
            byte[] obuf;
            int len;
            javax.crypto.Cipher ci = javax.crypto.Cipher.getInstance(CIPHER_SPEC);
            ci.init(1, this.privateKey != null ? this.privateKey : this.publicKey);
            byte[] ibuf = new byte[this.BUFFER_SIZE];
            while ((len = in.read(ibuf)) != -1) {
                obuf = ci.update(ibuf, 0, len);
                if (obuf == null) continue;
                out.write(obuf);
            }
            obuf = ci.doFinal();
            if (obuf != null) {
                out.write(obuf);
            }
        }
        catch (SocketException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new EncryptionException(e, "Could not encrypt data");
        }
    }

    public void decrypt(DataClient client, final InputStream in, OutputStream out) throws Exception {
        Container reset = new Container((Object)false);
        while (!((Boolean)reset.value()).booleanValue()) {
            this.decrypt(new InputStream((Value)reset){
                boolean open = true;
                Integer pending = null;
                final /* synthetic */ Value val$reset;
                {
                    this.val$reset = value;
                }

                private int next() throws IOException {
                    int b = this.pending != null ? this.pending.intValue() : in.read();
                    this.pending = null;
                    block0 : switch (b) {
                        case -1: {
                            this.val$reset.value((Object)true);
                        }
                        case 27: {
                            int next = in.read();
                            switch (next) {
                                case 27: {
                                    break block0;
                                }
                                case 23: {
                                    b = -1;
                                    break block0;
                                }
                            }
                            this.pending = next;
                        }
                    }
                    return b;
                }

                @Override
                public int read() throws IOException {
                    if (this.open) {
                        int b = this.next();
                        if (b <= -1) {
                            this.close();
                        }
                        return b;
                    }
                    return -1;
                }

                @Override
                public void close() throws IOException {
                    if (this.open) {
                        this.open = false;
                    }
                }
            }, out);
        }
    }

    private void decrypt(InputStream in, OutputStream out) throws Exception {
        try {
            byte[] obuf;
            int len;
            javax.crypto.Cipher ci = javax.crypto.Cipher.getInstance(CIPHER_SPEC);
            ci.init(2, this.privateKey != null ? this.privateKey : this.publicKey);
            byte[] ibuf = new byte[this.BUFFER_SIZE];
            boolean wrote = false;
            while ((len = in.read(ibuf)) != -1) {
                obuf = ci.update(ibuf, 0, len);
                if (obuf != null) {
                    out.write(obuf);
                }
                wrote = true;
            }
            if (wrote && (obuf = ci.doFinal()) != null) {
                out.write(obuf);
            }
        }
        catch (SocketException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new EncryptionException(e, "Could not decrypt data");
        }
    }

    public Pair<Cipher, String> newCipher(String handle) {
        return forwardG.getOrDefault(handle.toUpperCase(), () -> null).get();
    }

    public Cipher getCipher(String handle, String key) {
        return forwardP.getOrDefault(handle.toUpperCase(), token -> null).apply(key);
    }

    public static void addCipher(String handle, Supplier<Pair<Cipher, String>> generator, Function<String, Cipher> parser) {
        Util.nullpo(generator);
        handle = handle.toUpperCase();
        if (!forwardG.containsKey(handle)) {
            forwardG.put(handle, generator);
        }
        if (!forwardP.containsKey(handle)) {
            forwardP.put(handle, parser);
        }
    }

    public static void removeCipher(String handle) {
        forwardG.remove(handle.toUpperCase());
        forwardP.remove(handle.toUpperCase());
    }

    static {
        RSA.addCipher("AES", () -> AES.random(128), key -> new AES(128, (String)key));
        RSA.addCipher("AES-128", () -> AES.random(128), key -> new AES(128, (String)key));
        RSA.addCipher("AES-192", () -> AES.random(192), key -> new AES(192, (String)key));
        RSA.addCipher("AES-256", () -> AES.random(256), key -> new AES(256, (String)key));
    }
}

