/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubData.Server.Library;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import net.ME1312.SubData.Server.Library.DebugUtil;

public class EscapedOutputStream
extends OutputStream {
    private final int escape;
    private final int[] controls;
    private final OutputStream out;
    private boolean escaped = false;

    public EscapedOutputStream(OutputStream stream, int escape, int ... controls) {
        Arrays.sort(controls);
        this.out = stream;
        this.escape = escape;
        this.controls = controls;
    }

    private boolean check(int b) {
        for (int c : this.controls) {
            if (b != c) continue;
            return true;
        }
        return false;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.escaped) {
            if (b == this.escape || this.check(b)) {
                this.out.write(this.escape);
            }
            this.escaped = false;
        }
        if (b == this.escape) {
            this.escaped = true;
        }
        this.out.write(b);
    }

    public void control(int b) throws IOException {
        if (!this.check(b)) {
            throw new IllegalArgumentException("Character " + DebugUtil.toHex(65535, b) + " is not a control character");
        }
        if (this.escaped) {
            this.out.write(this.escape);
            this.escaped = false;
        }
        this.out.write(this.escape);
        this.out.write(b);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

