/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubData.Server.Protocol.Internal;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;
import net.ME1312.SubData.Server.Protocol.PacketStreamIn;
import net.ME1312.SubData.Server.Protocol.PacketStreamOut;
import net.ME1312.SubData.Server.SubDataClient;

public class PacketForwardPacket
implements PacketStreamIn,
PacketStreamOut {
    private InputStream in;
    private UUID id;

    public PacketForwardPacket() {
    }

    public PacketForwardPacket(SubDataClient sender, InputStream in) {
        this.id = sender.getID();
        this.in = in;
    }

    @Override
    public void send(SubDataClient client, OutputStream out) throws Throwable {
        int i;
        out.write(ByteBuffer.allocate(16).order(ByteOrder.BIG_ENDIAN).putLong(this.id.getMostSignificantBits()).putLong(this.id.getLeastSignificantBits()).array());
        byte[] b = new byte[1024];
        while ((i = this.in.read(b)) != -1) {
            out.write(b, 0, i);
        }
        out.close();
    }

    @Override
    public void receive(SubDataClient client, InputStream in) throws Throwable {
        UUID id;
        int b;
        ByteBuffer data = ByteBuffer.allocate(16).order(ByteOrder.BIG_ENDIAN);
        int i = 0;
        while ((b = in.read()) != -1) {
            data.put((byte)b);
            if (++i != 16) continue;
        }
        data.position(0);
        if (i == 16) {
            id = new UUID(data.getLong(), data.getLong());
            if (client.getServer().getClient(id) == null) {
                throw new IllegalArgumentException("Cannot forward to invalid Destination ID: [" + id + "]");
            }
        } else {
            throw new IllegalArgumentException("Invalid UUID data for Destination ID: [" + data.getLong() + ", " + data.getLong() + "]");
        }
        client.getServer().getClient(id).sendPacket(new PacketForwardPacket(client, in));
    }
}

