/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubData.Server.Protocol.Internal;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.Consumer;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.SubData.Server.Library.PingResponse;
import net.ME1312.SubData.Server.Protocol.Internal.PacketPingResponse;
import net.ME1312.SubData.Server.Protocol.PacketStreamIn;
import net.ME1312.SubData.Server.Protocol.PacketStreamOut;
import net.ME1312.SubData.Server.SubDataClient;

public class PacketPing
implements PacketStreamOut,
PacketStreamIn {
    static HashMap<UUID, PacketPing> requests = new HashMap();
    Consumer<PingResponse>[] callbacks;
    private UUID tracker;
    long init;
    long queue;

    public PacketPing() {
    }

    @SafeVarargs
    public PacketPing(Consumer<PingResponse> ... callback) {
        Util.nullpo(callback);
        this.tracker = (UUID)Util.getNew(requests.keySet(), UUID::randomUUID);
        requests.put(this.tracker, this);
        this.init = System.nanoTime();
        this.callbacks = callback;
    }

    @Override
    public void send(SubDataClient client, OutputStream out) throws Throwable {
        this.queue = System.nanoTime();
        out.write(ByteBuffer.allocate(32).order(ByteOrder.BIG_ENDIAN).putLong(this.tracker.getMostSignificantBits()).putLong(this.tracker.getLeastSignificantBits()).putLong(this.init).putLong(this.queue).array());
        out.close();
    }

    @Override
    public void receive(SubDataClient client, InputStream in) throws Throwable {
        int b;
        ByteBuffer data = ByteBuffer.allocate(32).order(ByteOrder.BIG_ENDIAN);
        int i = 0;
        while ((b = in.read()) != -1) {
            data.put((byte)b);
            if (++i != 32) continue;
        }
        in.close();
        data.position(0);
        UUID id = new UUID(data.getLong(), data.getLong());
        data.getLong();
        data.getLong();
        client.sendPacket(new PacketPingResponse(id, System.nanoTime()));
    }
}

