/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubData.Server;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import net.ME1312.Galaxi.Library.Container.ContainedPair;
import net.ME1312.Galaxi.Library.Container.Container;
import net.ME1312.Galaxi.Library.Try;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.SubData.Server.Cipher;
import net.ME1312.SubData.Server.ClientHandler;
import net.ME1312.SubData.Server.DataClient;
import net.ME1312.SubData.Server.Encryption.NEH;
import net.ME1312.SubData.Server.Library.ConnectionState;
import net.ME1312.SubData.Server.Library.DebugUtil;
import net.ME1312.SubData.Server.Library.DisconnectReason;
import net.ME1312.SubData.Server.Library.Exception.EncryptionException;
import net.ME1312.SubData.Server.Library.Exception.IllegalMessageException;
import net.ME1312.SubData.Server.Library.Exception.IllegalPacketException;
import net.ME1312.SubData.Server.Library.Exception.ProtocolException;
import net.ME1312.SubData.Server.Library.InputStreamL1;
import net.ME1312.SubData.Server.Library.OutputStreamL1;
import net.ME1312.SubData.Server.Library.PingResponse;
import net.ME1312.SubData.Server.Library.UnsignedData;
import net.ME1312.SubData.Server.Protocol.Initial.InitPacketDeclaration;
import net.ME1312.SubData.Server.Protocol.Initial.InitialPacket;
import net.ME1312.SubData.Server.Protocol.Initial.InitialProtocol;
import net.ME1312.SubData.Server.Protocol.Internal.PacketDisconnect;
import net.ME1312.SubData.Server.Protocol.Internal.PacketDisconnectUnderstood;
import net.ME1312.SubData.Server.Protocol.Internal.PacketOpenChannel;
import net.ME1312.SubData.Server.Protocol.Internal.PacketPing;
import net.ME1312.SubData.Server.Protocol.Internal.PacketSendMessage;
import net.ME1312.SubData.Server.Protocol.MessageOut;
import net.ME1312.SubData.Server.Protocol.PacketIn;
import net.ME1312.SubData.Server.Protocol.PacketOut;
import net.ME1312.SubData.Server.Protocol.PacketStreamIn;
import net.ME1312.SubData.Server.Protocol.PacketStreamOut;
import net.ME1312.SubData.Server.SubDataServer;

public class SubDataClient
extends DataClient {
    private final Socket socket;
    private final InetSocketAddress address;
    private ClientHandler handler;
    private final InputStreamL1 in;
    private final OutputStreamL1 out;
    private final ExecutorService writer;
    private final HashMap<ConnectionState, LinkedList<PacketOut>> statequeue;
    private Runnable readc;
    private final Cipher cipher = NEH.get();
    private final int cipherlevel = 0;
    private final SubDataServer subdata;
    private int bs;
    private SubDataClient next;
    private ConnectionState state;
    private final DisconnectReason isdcr;
    private Timer timeout;
    private Timer heartbeat;
    private Object asr;

    SubDataClient(SubDataServer subdata, Socket client) throws IOException {
        Util.nullpo((Object[])new Object[]{subdata, client});
        this.subdata = subdata;
        this.bs = subdata.protocol.bs;
        this.state = ConnectionState.PRE_INITIALIZATION;
        this.socket = client;
        this.address = new InetSocketAddress(client.getInetAddress(), client.getPort());
        this.writer = Executors.newSingleThreadExecutor(r -> new Thread(r, "SubDataServer::Data_Writer(" + this.address + ')'));
        this.out = new OutputStreamL1(subdata.log, client.getOutputStream(), this.bs, () -> this.close(DisconnectReason.CONNECTION_INTERRUPTED), "SubDataServer::Block_Writer(" + this.address + ')');
        this.in = new InputStreamL1(new BufferedInputStream(client.getInputStream()), () -> this.close(DisconnectReason.CONNECTION_INTERRUPTED), e -> {
            DebugUtil.logException(new ProtocolException(this.address + ": Received invalid L1 control character: " + DebugUtil.toHex(255, e)), subdata.log);
            this.close(DisconnectReason.PROTOCOL_MISMATCH);
        });
        this.statequeue = new HashMap();
        this.isdcr = DisconnectReason.PROTOCOL_MISMATCH;
        final Timer timeout = this.timeout = new Timer("SubDataServer::Handshake_Timeout(" + this.address + ')');
        timeout.schedule(new TimerTask(){

            @Override
            public void run() {
                if (SubDataClient.this.state.asInt() < ConnectionState.POST_INITIALIZATION.asInt()) {
                    SubDataClient.this.close(DisconnectReason.INITIALIZATION_TIMEOUT);
                }
                timeout.cancel();
            }
        }, (Long)subdata.timeout.value());
        this.heartbeat = new Timer("SubDataServer::Connection_Heartbeat(" + this.address + ')');
        this.heartbeat.schedule(new TimerTask(){

            @Override
            public void run() {
                if (!SubDataClient.this.writer.isShutdown()) {
                    SubDataClient.this.writer.submit(() -> {
                        if (SubDataClient.this.heartbeat != null) {
                            SubDataClient.this.out.control(0);
                            final 2 action = this;
                            SubDataClient.this.heartbeat.schedule(new TimerTask(){

                                @Override
                                public void run() {
                                    action.run();
                                }
                            }, 5000L);
                        }
                    });
                }
            }
        }, 5000L);
    }

    private void read(Container<Boolean> reset, final InputStream data) {
        block16: {
            try {
                int b;
                byte[] pending = new byte[2];
                int id = -1;
                int i = 0;
                while ((b = data.read()) != -1) {
                    pending[i] = (byte)b;
                    if (++i != 2) continue;
                    id = (int)UnsignedData.resign(pending);
                    break;
                }
                if (this.state != ConnectionState.CLOSED && id >= 0) {
                    final Container open = new Container((Object)true);
                    InputStream forward = new InputStream(){

                        @Override
                        public int read(byte[] b, int off, int len) throws IOException {
                            int i = data.read(b, off, len);
                            if (i == -1) {
                                open.value = false;
                            }
                            return i;
                        }

                        @Override
                        public int read() throws IOException {
                            int b = data.read();
                            if (b == -1) {
                                open.value = false;
                            }
                            return b;
                        }

                        @Override
                        public void close() throws IOException {
                            try {
                                while (data.read() != -1) {
                                }
                            }
                            finally {
                                open.value = false;
                            }
                        }
                    };
                    if (this.state == ConnectionState.PRE_INITIALIZATION && id != 0) {
                        throw new ProtocolException(this.address.toString() + ": Only 0x0000 may be received during the PRE_INITIALIZATION stage: [" + DebugUtil.toHex(65535, id) + "]");
                    }
                    if (this.state == ConnectionState.CLOSING && id != 65534) {
                        forward.close();
                    } else {
                        HashMap pIn;
                        HashMap hashMap = pIn = this.state.asInt() >= ConnectionState.POST_INITIALIZATION.asInt() ? this.subdata.protocol.pIn : (HashMap)Util.reflect((Field)InitialProtocol.class.getDeclaredField("pIn"), null);
                        if (!pIn.containsKey(id)) {
                            throw new IllegalPacketException(this.address.toString() + ": Could not find handler for packet: [" + DebugUtil.toHex(65535, id) + "]");
                        }
                        PacketIn packet = (PacketIn)pIn.get(id);
                        if (this.state == ConnectionState.PRE_INITIALIZATION && !(packet instanceof InitPacketDeclaration)) {
                            throw new ProtocolException(this.address.toString() + ": Only " + InitPacketDeclaration.class.getTypeName() + " may be received during the PRE_INITIALIZATION stage: [" + packet.getClass().getTypeName() + "]");
                        }
                        if (this.state == ConnectionState.CLOSING && !(packet instanceof PacketDisconnectUnderstood)) {
                            forward.close();
                        } else {
                            this.readc = () -> {
                                open.value = false;
                            };
                            this.subdata.scheduler.accept(() -> {
                                block4: {
                                    try {
                                        packet.receive(this);
                                        if (packet instanceof PacketStreamIn) {
                                            ((PacketStreamIn)packet).receive(this, forward);
                                        } else {
                                            forward.close();
                                        }
                                    }
                                    catch (Throwable e) {
                                        DebugUtil.logException(new InvocationTargetException(e, this.address.toString() + ": Exception while running packet handler"), this.subdata.log);
                                        Try.all.run(forward::close);
                                        if (this.state.asInt() > ConnectionState.INITIALIZATION.asInt()) break block4;
                                        Try.all.run(() -> this.close(DisconnectReason.PROTOCOL_MISMATCH));
                                    }
                                }
                            });
                            while (((Boolean)open.value).booleanValue()) {
                                Thread.sleep(125L);
                            }
                        }
                    }
                }
            }
            catch (InterruptedIOException pending) {
            }
            catch (ProtocolException e) {
                DebugUtil.logException(e, this.subdata.log);
                this.close(DisconnectReason.PROTOCOL_MISMATCH);
            }
            catch (Exception e) {
                if (((Boolean)reset.value).booleanValue()) break block16;
                if (!(e instanceof SocketException) || Boolean.getBoolean("subdata.debug")) {
                    DebugUtil.logException(e, this.subdata.log);
                }
                if (!(e instanceof SocketException)) {
                    this.close(DisconnectReason.UNHANDLED_EXCEPTION);
                }
                this.close(DisconnectReason.CONNECTION_INTERRUPTED);
            }
        }
    }

    void read() {
        if (!this.isClosed()) {
            new Thread(() -> {
                block7: {
                    Container reset = new Container((Object)false);
                    if (!this.isClosed()) {
                        try {
                            InputStream raw = this.in.open(() -> {
                                if (this.state != ConnectionState.PRE_INITIALIZATION) {
                                    reset.value = true;
                                }
                            }, () -> {
                                if (!this.isClosed()) {
                                    this.read();
                                } else {
                                    Try.all.run(() -> this.close(DisconnectReason.CONNECTION_INTERRUPTED));
                                }
                            });
                            PipedInputStream data = new PipedInputStream(1024);
                            PipedOutputStream forward = new PipedOutputStream(data);
                            Thread reader = new Thread(() -> this.read((Container<Boolean>)reset, data), "SubDataServer::Packet_Reader(" + this.address.toString() + ')');
                            this.readc = reader::interrupt;
                            reader.start();
                            this.cipher.decrypt((DataClient)this, raw, (OutputStream)forward);
                            forward.close();
                        }
                        catch (Exception e) {
                            if (((Boolean)reset.value).booleanValue()) break block7;
                            if (!(e instanceof SocketException) || Boolean.getBoolean("subdata.debug")) {
                                DebugUtil.logException(e, this.subdata.log);
                            }
                            if (!(e instanceof SocketException)) {
                                if (e instanceof EncryptionException) {
                                    this.close(DisconnectReason.ENCRYPTION_MISMATCH);
                                } else {
                                    this.close(DisconnectReason.UNHANDLED_EXCEPTION);
                                }
                            }
                            this.close(DisconnectReason.CONNECTION_INTERRUPTED);
                        }
                    }
                }
            }, "SubDataServer::Data_Reader(" + this.address.toString() + ')').start();
        }
    }

    private void write(PacketOut next, final OutputStream data) {
        try {
            HashMap pOut;
            final Container open = new Container((Object)true);
            OutputStream forward = new OutputStream(){

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    data.write(b, off, len);
                }

                @Override
                public void write(int b) throws IOException {
                    data.write(b);
                }

                @Override
                public void close() throws IOException {
                    open.value = false;
                    data.close();
                }
            };
            HashMap hashMap = pOut = this.state.asInt() >= ConnectionState.POST_INITIALIZATION.asInt() ? this.subdata.protocol.pOut : (HashMap)Util.reflect((Field)InitialProtocol.class.getDeclaredField("pOut"), null);
            if (!pOut.containsKey(next.getClass())) {
                throw new IllegalMessageException(this.address.toString() + ": Could not find ID for packet: " + next.getClass().getTypeName());
            }
            data.write(UnsignedData.unsign(((Integer)pOut.get(next.getClass())).intValue(), 2), 0, 2);
            data.flush();
            this.subdata.scheduler.accept(() -> {
                try {
                    next.sending(this);
                    if (next instanceof PacketStreamOut) {
                        ((PacketStreamOut)next).send(this, forward);
                    } else {
                        forward.close();
                    }
                }
                catch (Throwable e) {
                    DebugUtil.logException(new InvocationTargetException(e, this.address.toString() + ": Exception while running packet writer"), this.subdata.log);
                    Try.all.run(forward::close);
                }
            });
            while (((Boolean)open.value).booleanValue()) {
                Thread.sleep(125L);
            }
        }
        catch (Throwable e) {
            DebugUtil.logException(e, this.subdata.log);
            Try.all.run(data::close);
        }
    }

    void write(PacketOut packet) {
        block6: {
            if (!(packet == null || this.isClosed() && (packet instanceof PacketDisconnect || packet instanceof PacketDisconnectUnderstood))) {
                if (!this.isClosed() && (this.state != ConnectionState.CLOSING || packet instanceof PacketDisconnect || packet instanceof PacketDisconnectUnderstood)) {
                    try {
                        PipedOutputStream data = new PipedOutputStream();
                        PipedInputStream forward = new PipedInputStream(data, 1024);
                        new Thread(() -> this.write(packet, data), "SubDataServer::Packet_Writer(" + this.address.toString() + ')').start();
                        this.cipher.encrypt((DataClient)this, (InputStream)forward, (OutputStream)this.out);
                        forward.close();
                        if (!this.socket.isClosed()) {
                            this.out.limit = this.bs;
                            this.out.flush();
                            this.out.control(23);
                        }
                        break block6;
                    }
                    catch (Throwable e) {
                        if (!(e instanceof SocketException)) {
                            DebugUtil.logException(new InvocationTargetException(e, this.address.toString() + ": Exception while running packet writer"), this.subdata.log);
                        }
                        break block6;
                    }
                }
                this.sendPacket(packet);
            }
        }
    }

    public void sendPacket(PacketOut ... packets) {
        for (PacketOut packet : packets) {
            if (Util.isNull((Object)packet)) continue;
            if (this.isClosed() || this.state == ConnectionState.CLOSING && !(packet instanceof PacketDisconnect) && !(packet instanceof PacketDisconnectUnderstood)) {
                if (this.next == null) {
                    this.sendPacketLater(packet, ConnectionState.CLOSED);
                    continue;
                }
                this.next.sendPacket(packet);
                continue;
            }
            if (this.state.asInt() < ConnectionState.POST_INITIALIZATION.asInt() && !(packet instanceof InitialProtocol.Packet)) {
                this.sendPacketLater(packet, packet instanceof InitialPacket ? ConnectionState.POST_INITIALIZATION : ConnectionState.READY);
                continue;
            }
            if (this.state == ConnectionState.POST_INITIALIZATION && !(packet instanceof InitialPacket)) {
                this.sendPacketLater(packet, ConnectionState.READY);
                continue;
            }
            if (this.writer.isShutdown()) continue;
            this.writer.submit(() -> this.write(packet));
        }
    }

    private void sendPacketLater(PacketOut packet, ConnectionState state) {
        LinkedList<PacketOut> prequeue = this.statequeue.containsKey((Object)state) ? this.statequeue.get((Object)state) : new LinkedList<PacketOut>();
        prequeue.add(packet);
        this.statequeue.put(state, prequeue);
    }

    public void sendMessage(MessageOut ... messages) {
        ArrayList<PacketSendMessage> list = new ArrayList<PacketSendMessage>();
        for (MessageOut message : messages) {
            if (Util.isNull((Object)message)) continue;
            list.add(new PacketSendMessage(message));
        }
        this.sendPacket(list.toArray(new PacketOut[0]));
    }

    public void ping(Consumer<PingResponse> response) {
        Util.nullpo(response);
        this.sendPacket(new PacketPing(response));
    }

    public Socket getSocket() {
        return this.socket;
    }

    public SubDataServer getServer() {
        return this.subdata;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public int getBlockSize() {
        return this.bs;
    }

    public void setBlockSize(Integer size) {
        this.bs = size == null ? this.subdata.protocol.bs : size;
        this.out.limit = this.bs;
    }

    public void tempBlockSize(Integer size) {
        this.out.resize(size == null ? this.bs : size);
    }

    public Object getAuthResponse() {
        return this.asr;
    }

    public ClientHandler getHandler() {
        return this.handler;
    }

    public void setHandler(ClientHandler obj) {
        if (this.handler != null && Arrays.asList(this.handler.getSubData()).contains((Object)this)) {
            this.handler.removeSubData((DataClient)this);
        }
        this.handler = obj;
    }

    @Deprecated
    public void newChannel(Consumer<DataClient> client) {
        this.openChannel(client::accept);
    }

    public void openChannel(Consumer<SubDataClient> client) {
        this.sendPacket(new PacketOpenChannel(client));
    }

    public void reconnect(SubDataClient client) {
        Util.nullpo((Object)((Object)client));
        if (client == this) {
            throw new IllegalArgumentException("Cannot reconnect to 'this'");
        }
        if (this.state.asInt() < ConnectionState.CLOSING.asInt() || this.next != null) {
            throw new IllegalStateException("Cannot override existing data stream");
        }
        this.next = client;
        if (this.statequeue.containsKey((Object)ConnectionState.CLOSED)) {
            for (PacketOut packet : this.statequeue.get((Object)ConnectionState.CLOSED)) {
                this.next.sendPacket(packet);
            }
            this.statequeue.remove((Object)ConnectionState.CLOSED);
        }
    }

    public void close() {
        if (this.state.asInt() < ConnectionState.CLOSING.asInt() && !this.socket.isClosed()) {
            boolean result = true;
            LinkedList events = new LinkedList(this.on.close);
            for (Function next : events) {
                try {
                    if (next == null) continue;
                    result = next.apply(this) != Boolean.FALSE && result;
                }
                catch (Throwable e) {
                    DebugUtil.logException(new InvocationTargetException(e, "Unhandled exception while running SubData Event"), this.subdata.log);
                }
            }
            if (result) {
                this.state = ConnectionState.CLOSING;
                if (!this.isClosed()) {
                    this.sendPacket(new PacketDisconnect());
                }
                this.timeout = new Timer("SubDataServer::Disconnect_Timeout(" + this.address.toString() + ')');
                this.timeout.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        SubDataClient.this.close(DisconnectReason.CLOSE_REQUESTED);
                    }
                }, 5000L);
            }
        }
    }

    void close(DisconnectReason reason) {
        if (this.state != ConnectionState.CLOSED) {
            if (this.state == ConnectionState.CLOSING && reason == DisconnectReason.CONNECTION_INTERRUPTED) {
                reason = DisconnectReason.CLOSE_REQUESTED;
            } else if (this.isdcr != null && reason == DisconnectReason.CONNECTION_INTERRUPTED) {
                reason = this.isdcr;
            }
            this.state = ConnectionState.CLOSED;
            this.timeout.cancel();
            if (this.readc != null) {
                this.readc.run();
            }
            if (reason != DisconnectReason.CLOSE_REQUESTED) {
                this.subdata.log.warning(this.address.toString() + " has disconnected: " + reason);
            } else {
                this.subdata.log.info(this.address.toString() + " has disconnected");
            }
            this.heartbeat.cancel();
            this.heartbeat = null;
            this.writer.shutdown();
            this.out.shutdown();
            this.in.shutdown();
            try {
                this.socket.close();
            }
            catch (IOException e) {
                DebugUtil.logException(e, this.subdata.log);
            }
            this.cipher.retire((DataClient)this);
            if (this.handler != null) {
                ClientHandler tmp = this.handler;
                this.setHandler(null);
                this.handler = tmp;
            }
            if (this.subdata.getClients().containsValue((Object)this)) {
                this.subdata.removeClient(this);
            }
            DisconnectReason freason = reason;
            this.subdata.scheduler.accept(() -> {
                LinkedList events = new LinkedList(this.on.closed);
                for (Consumer next : events) {
                    try {
                        if (next == null) continue;
                        next.accept(new ContainedPair((Object)freason, (Object)this));
                    }
                    catch (Throwable e) {
                        DebugUtil.logException(new InvocationTargetException(e, "Unhandled exception while running SubData Event"), this.subdata.log);
                    }
                }
            });
        }
    }

    public boolean isClosed() {
        return this.state == ConnectionState.CLOSED || this.socket.isClosed();
    }
}

