/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubData.Server;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.logging.Logger;
import net.ME1312.Galaxi.Library.Container.Container;
import net.ME1312.Galaxi.Library.Container.Value;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.Galaxi.Library.Version.Version;
import net.ME1312.SubData.Server.AuthService;
import net.ME1312.SubData.Server.Cipher;
import net.ME1312.SubData.Server.DataProtocol;
import net.ME1312.SubData.Server.Encryption.NEH;
import net.ME1312.SubData.Server.Library.DebugUtil;
import net.ME1312.SubData.Server.Protocol.Initial.InitPacketVerifyState;
import net.ME1312.SubData.Server.Protocol.Internal.PacketDisconnect;
import net.ME1312.SubData.Server.Protocol.Internal.PacketDisconnectUnderstood;
import net.ME1312.SubData.Server.Protocol.Internal.PacketDownloadClientList;
import net.ME1312.SubData.Server.Protocol.Internal.PacketForwardPacket;
import net.ME1312.SubData.Server.Protocol.Internal.PacketNull;
import net.ME1312.SubData.Server.Protocol.Internal.PacketOpenChannel;
import net.ME1312.SubData.Server.Protocol.Internal.PacketPing;
import net.ME1312.SubData.Server.Protocol.Internal.PacketPingResponse;
import net.ME1312.SubData.Server.Protocol.Internal.PacketRecieveMessage;
import net.ME1312.SubData.Server.Protocol.Internal.PacketSendMessage;
import net.ME1312.SubData.Server.Protocol.PacketIn;
import net.ME1312.SubData.Server.Protocol.PacketOut;
import net.ME1312.SubData.Server.SubDataServer;

public class SubDataProtocol
extends DataProtocol {
    public static final int MIN_PACKET_ID = 0;
    public static final int MAX_PACKET_ID = 65519;
    final HashMap<String, Cipher> ciphers = new HashMap();
    final HashMap<Class<? extends PacketOut>, Integer> pOut = new HashMap();
    final HashMap<Integer, PacketIn> pIn = new HashMap();
    int MAX_QUEUE = 64;
    Version version;
    String name;
    Value<Long> timeout = new Container((Object)30000L);
    int bs = 4096;
    AuthService<?> as;

    public SubDataProtocol() {
        this.ciphers.put("NULL", NEH.get());
        this.ciphers.put("NONE", NEH.get());
        this.pIn.put(65526, new PacketDownloadClientList(null, null));
        this.pIn.put(65527, new PacketOpenChannel());
        this.pIn.put(65528, new PacketPingResponse());
        this.pIn.put(65529, new PacketPing());
        this.pIn.put(65530, new InitPacketVerifyState());
        this.pIn.put(65531, new PacketRecieveMessage());
        this.pIn.put(65532, new PacketForwardPacket());
        this.pIn.put(65533, new PacketNull());
        this.pIn.put(65534, new PacketDisconnectUnderstood());
        this.pIn.put(65535, new PacketDisconnect());
        this.pOut.put(PacketDownloadClientList.class, 65526);
        this.pOut.put(PacketOpenChannel.class, 65527);
        this.pOut.put(PacketPingResponse.class, 65528);
        this.pOut.put(PacketPing.class, 65529);
        this.pOut.put(InitPacketVerifyState.class, 65530);
        this.pOut.put(PacketSendMessage.class, 65531);
        this.pOut.put(PacketForwardPacket.class, 65532);
        this.pOut.put(PacketNull.class, 65533);
        this.pOut.put(PacketDisconnectUnderstood.class, 65534);
        this.pOut.put(PacketDisconnect.class, 65535);
    }

    public SubDataServer open(Consumer<Runnable> scheduler, Logger logger, InetAddress address, int port, String cipher) throws IOException {
        return new SubDataServer(this, scheduler, logger, address, port, cipher);
    }

    public SubDataServer open(Logger logger, InetAddress address, int port, String cipher) throws IOException {
        return this.open(Runnable::run, logger, address, port, cipher);
    }

    public void setName(String name) {
        if (this.name != null) {
            throw new IllegalStateException("Protocol name already set");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setVersion(Version version) {
        if (this.version != null) {
            throw new IllegalStateException("Protocol version already set");
        }
        this.version = version;
    }

    public Version getVersion() {
        return this.version != null ? this.version : new Version(new int[]{0});
    }

    public void setAuthService(AuthService<?> service) {
        if (this.as != null) {
            throw new IllegalStateException("Protocol auth service already set");
        }
        this.as = service;
    }

    public AuthService<?> getAuthService() {
        return this.as;
    }

    public void registerCipher(String handle, Cipher cipher) {
        Util.nullpo((Object)cipher);
        if (!handle.equalsIgnoreCase("NULL")) {
            this.ciphers.put(handle.toUpperCase(), cipher);
        }
    }

    public void unregisterCipher(String handle) {
        if (!handle.equalsIgnoreCase("NULL")) {
            this.ciphers.remove(handle.toUpperCase());
        }
    }

    public int getBlockSize() {
        return this.bs;
    }

    public void setBlockSize(int size) {
        this.bs = size;
    }

    public long getTimeout() {
        return (Long)this.timeout.value();
    }

    public void setTimeout(long time) {
        this.timeout.value((Object)time);
    }

    public void registerPacket(int id, PacketIn packet) {
        Util.nullpo((Object)packet);
        if (id > 65519 || id < 0) {
            throw new IllegalArgumentException("Packet ID is not in range (" + DebugUtil.toHex(65535, 0) + " to " + DebugUtil.toHex(65535, 65519) + "): " + DebugUtil.toHex(65535, id));
        }
        this.pIn.put(id, packet);
    }

    public void unregisterPacket(PacketIn packet) {
        Util.nullpo((Object)packet);
        ArrayList<Integer> search = new ArrayList<Integer>(this.pIn.keySet());
        Iterator iterator = search.iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            if (!this.pIn.get(id).equals(packet) || id >= 65519) continue;
            this.pIn.remove(id);
        }
    }

    public void registerPacket(int id, Class<? extends PacketOut> packet) {
        Util.nullpo(packet);
        if (id > 65519 || id < 0) {
            throw new IllegalArgumentException("Packet ID is not in range (" + DebugUtil.toHex(65535, 0) + " to " + DebugUtil.toHex(65519, 65535) + "): " + DebugUtil.toHex(65535, id));
        }
        this.pOut.put(packet, id);
    }

    public void unregisterPacket(Class<? extends PacketOut> packet) {
        Util.nullpo(packet);
        if (this.pOut.containsKey(packet) && this.pOut.get(packet) < 65519) {
            this.pOut.remove(packet);
        }
    }

    public PacketIn getPacket(int id) {
        return this.pIn.get(id);
    }
}

