/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubData.Server;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Logger;
import net.ME1312.Galaxi.Library.Container.Container;
import net.ME1312.Galaxi.Library.Container.Value;
import net.ME1312.Galaxi.Library.Try;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.SubData.Server.Cipher;
import net.ME1312.SubData.Server.CipherFactory;
import net.ME1312.SubData.Server.DataClient;
import net.ME1312.SubData.Server.DataServer;
import net.ME1312.SubData.Server.Encryption.NEH;
import net.ME1312.SubData.Server.Library.DebugUtil;
import net.ME1312.SubData.Server.Library.DisconnectReason;
import net.ME1312.SubData.Server.Library.Exception.EncryptionException;
import net.ME1312.SubData.Server.Protocol.Initial.InitPacketDeclaration;
import net.ME1312.SubData.Server.SubDataClient;
import net.ME1312.SubData.Server.SubDataProtocol;

public class SubDataServer
extends DataServer {
    private final HashMap<UUID, SubDataClient> clients = new HashMap();
    private final ServerSocket server;
    private final String address;
    SubDataProtocol protocol;
    Value<Long> timeout;
    Consumer<Runnable> scheduler;
    String cipher;
    Logger log;

    SubDataServer(SubDataProtocol protocol, Consumer<Runnable> scheduler, Logger log, InetAddress address, int port, String cipher) throws IOException {
        String[] stringArray;
        Util.nullpo((Object)((Object)protocol));
        if (address == null) {
            this.server = new ServerSocket(port, protocol.MAX_QUEUE);
            this.address = "/0.0.0.0:" + port;
            this.whitelist("127.0.0.1");
        } else {
            this.server = new ServerSocket(port, protocol.MAX_QUEUE, address);
            this.address = this.server.getLocalSocketAddress().toString();
            this.whitelist(address.getHostAddress());
        }
        this.protocol = protocol;
        this.timeout = protocol.timeout;
        this.scheduler = scheduler;
        this.log = log;
        cipher = cipher != null ? cipher : "NULL";
        this.cipher = cipher;
        if (cipher.contains("/")) {
            stringArray = cipher.split("/");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = cipher;
        }
        String[] ciphers = stringArray;
        NEH last = NEH.get();
        for (String next : ciphers) {
            if (ciphers[0].equals(next)) {
                last = protocol.ciphers.get(next.toUpperCase());
            } else if (last instanceof CipherFactory) {
                NEH lastF = last;
                last = (Cipher)Try.all.get(() -> (Cipher)((CipherFactory)lastF).newCipher(next.toUpperCase()).key());
            } else {
                last = null;
            }
            if (last != null) continue;
            throw new EncryptionException("Unknown encryption type \"" + next + "\" in \"" + this.cipher + '\"');
        }
        log.info("Listening on " + this.address);
        new Thread(() -> {
            while (!this.server.isClosed()) {
                try {
                    this.addClient(this.server.accept());
                }
                catch (IOException e) {
                    if (e instanceof SocketException) continue;
                    DebugUtil.logException(e, log);
                }
            }
        }, "SubDataServer::Connection_Listener(" + this.server.getLocalSocketAddress().toString() + ')').start();
    }

    public ServerSocket getSocket() {
        return this.server;
    }

    public SubDataProtocol getProtocol() {
        return this.protocol;
    }

    public long getTimeout() {
        return (Long)this.timeout.value();
    }

    public void setTimeout(Long size) {
        this.timeout = size == null ? this.protocol.timeout : new Container((Object)size);
    }

    private SubDataClient addClient(Socket socket) throws IOException {
        Util.nullpo((Object)socket);
        if (this.isWhitelisted(socket.getInetAddress())) {
            SubDataClient client = this.addClient(new SubDataClient(this, socket));
            if (client != null) {
                client.read();
            }
            return client;
        }
        this.log.info(socket.getInetAddress().toString() + " attempted to connect, but isn't white-listed");
        socket.close();
        return null;
    }

    private SubDataClient addClient(SubDataClient client) {
        boolean result = true;
        Try.all.run(() -> Util.reflect((Field)DataClient.class.getDeclaredField("id"), (Object)((Object)client), (Object)Util.getNew(this.clients.keySet(), UUID::randomUUID)));
        LinkedList events = new LinkedList(this.on.connect);
        for (Function next : events) {
            try {
                if (next == null) continue;
                result = next.apply(client) != Boolean.FALSE && result;
            }
            catch (Throwable e) {
                DebugUtil.logException(new InvocationTargetException(e, "Unhandled exception while running SubData Event"), this.log);
            }
        }
        if (result) {
            this.clients.put(client.getID(), client);
            this.log.info(client.getAddress().toString() + " has connected");
            client.sendPacket(new InitPacketDeclaration());
            return client;
        }
        client.close(DisconnectReason.CLOSE_REQUESTED);
        this.log.info(client.getAddress().toString() + " attempted to connect, but was blocked");
        return null;
    }

    public SubDataClient getClient(UUID id) {
        Util.nullpo((Object)id);
        return this.clients.get(id);
    }

    public Map<UUID, ? extends SubDataClient> getClients() {
        return new HashMap<UUID, SubDataClient>(this.clients);
    }

    public void removeClient(DataClient client) {
        Util.nullpo((Object)client);
        this.removeClient(client.getID());
    }

    public void removeClient(UUID id) {
        Util.nullpo((Object)id);
        if (this.clients.containsKey(id)) {
            SubDataClient client = this.clients.get(id);
            this.clients.remove(id);
            client.close();
        }
    }

    public void close() throws IOException {
        boolean result = true;
        LinkedList events = new LinkedList(this.on.close);
        for (Function next : events) {
            try {
                if (next == null) continue;
                result = next.apply(this) != Boolean.FALSE && result;
            }
            catch (Throwable e) {
                DebugUtil.logException(new InvocationTargetException(e, "Unhandled exception while running SubData Event"), this.log);
            }
        }
        if (result) {
            while (this.clients.size() > 0) {
                SubDataClient client = (SubDataClient)((Object)this.clients.values().toArray()[0]);
                client.close();
                Try.all.run(() -> ((SubDataClient)client).waitFor());
            }
            this.server.close();
            this.scheduler.accept(() -> {
                LinkedList events2 = new LinkedList(this.on.closed);
                for (Consumer next : events2) {
                    try {
                        if (next == null) continue;
                        next.accept(this);
                    }
                    catch (Throwable e) {
                        DebugUtil.logException(new InvocationTargetException(e, "Unhandled exception while running SubData Event"), this.log);
                    }
                }
            });
            this.log.info("Listener " + this.address + " has been closed");
        }
    }

    public boolean isClosed() {
        return this.server.isClosed();
    }
}

