/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Client.Bukkit.Graphic;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import net.ME1312.Galaxi.Library.Container.Container;
import net.ME1312.Galaxi.Library.Container.Pair;
import net.ME1312.Galaxi.Library.Container.Value;
import net.ME1312.SubServers.Client.Bukkit.Graphic.PluginRenderer;
import net.ME1312.SubServers.Client.Bukkit.Graphic.UIRenderer;
import net.ME1312.SubServers.Client.Bukkit.Library.Compatibility.AgnosticScheduler;
import net.ME1312.SubServers.Client.Bukkit.Library.ObjectPermission;
import net.ME1312.SubServers.Client.Bukkit.SubPlugin;
import net.ME1312.SubServers.Client.Common.Network.API.Host;
import net.ME1312.SubServers.Client.Common.Network.API.Server;
import net.ME1312.SubServers.Client.Common.Network.API.SubCreator;
import net.ME1312.SubServers.Client.Common.Network.API.SubServer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class DefaultUIRenderer
extends UIRenderer {
    private static final int MAX_VISITED_OBJECTS = 2;
    private final List<Runnable> windowHistory = new LinkedList<Runnable>();
    Object[] lastVisitedObjects = new Object[2];
    int lastPage = 1;
    Runnable lastMenu = null;
    boolean open = false;

    DefaultUIRenderer(SubPlugin plugin, Player player) {
        super(plugin, player);
    }

    @Override
    public void newUI() {
        this.clearHistory();
        if (this.lastMenu == null) {
            this.hostMenu(1);
        } else {
            this.lastMenu.run();
        }
    }

    @Override
    public void clearHistory() {
        this.windowHistory.clear();
    }

    @Override
    public boolean hasHistory() {
        return this.windowHistory.size() > 1;
    }

    @Override
    public void reopen() {
        Runnable lastWindow = this.windowHistory.get(this.windowHistory.size() - 1);
        this.windowHistory.remove(this.windowHistory.size() - 1);
        lastWindow.run();
    }

    @Override
    public void back() {
        this.windowHistory.remove(this.windowHistory.size() - 1);
        this.reopen();
    }

    private ItemStack color(int color) {
        try {
            return new ItemStack(Material.STAINED_GLASS_PANE, 1, (short)color);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void hostMenu(int page) {
        this.setDownloading(ChatColor.stripColor((String)this.plugin.api.getLang("SubServers", "Interface.Host-Menu.Title")));
        this.plugin.api.getHosts(hosts -> this.plugin.api.getGroups(groups -> AgnosticScheduler.following((Entity)this.player).runs((Plugin)this.plugin, c -> {
            ItemMeta blockMeta;
            int i;
            this.setDownloading(null);
            this.lastVisitedObjects[0] = null;
            this.lastPage = page;
            this.lastMenu = () -> this.hostMenu(1);
            this.windowHistory.add(() -> this.hostMenu(page));
            LinkedList index = new LinkedList();
            index.addAll(hosts.values());
            ItemStack div = this.color(15);
            ItemMeta divMeta = div.getItemMeta();
            divMeta.setDisplayName(ChatColor.RESET.toString());
            div.setItemMeta(divMeta);
            int min = (page - 1) * 36;
            int max = min + 35;
            int count = index.size() == 0 ? 27 : (index.size() - min >= max ? 36 : index.size() - min);
            int area = count % 9 == 0 ? count : (count / 9 + 1) * 9;
            Inventory inv = Bukkit.createInventory(null, (int)(18 + area), (String)this.plugin.api.getLang("SubServers", "Interface.Host-Menu.Title"));
            ItemStack block = this.color(7);
            block.setItemMeta(divMeta);
            for (i = 0; i < area; ++i) {
                inv.setItem(i, block);
            }
            ItemStack adiv = block;
            i = count < 9 ? (9 - count) / 2 : 0;
            boolean even = (count & 1) == 0 && count < 9;
            for (Host host : index) {
                LinkedList<String> lore;
                int disabled;
                if (index.indexOf(host) < min || index.indexOf(host) > max) continue;
                if (even && (i == 4 || i == 13 || i == 22 || i == 31)) {
                    inv.setItem(i++, adiv);
                }
                int enabled = (i & 1) == 0 ? 3 : 11;
                int n = disabled = (i & 1) == 0 ? 2 : 14;
                if (host.isAvailable() && host.isEnabled()) {
                    block = this.color(enabled);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(ChatColor.AQUA + host.getDisplayName());
                    lore = new LinkedList();
                    if (!host.getName().equals(host.getDisplayName())) {
                        lore.add(ChatColor.GRAY + host.getName());
                    }
                    lore.add(this.plugin.api.getLang("SubServers", "Interface.Host-Menu.Host-Server-Count").replace("$int$", new DecimalFormat("#,###").format(host.getSubServers().keySet().size())));
                    if (this.plugin.config.get().getMap((Object)"Settings").getBoolean((Object)"Show-Addresses", Boolean.valueOf(false)).booleanValue()) {
                        lore.add(ChatColor.WHITE + host.getAddress().getHostAddress());
                    }
                    blockMeta.setLore(lore);
                } else {
                    block = this.color(disabled);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(ChatColor.RED + host.getDisplayName());
                    lore = new LinkedList<String>();
                    if (!host.getName().equals(host.getDisplayName())) {
                        lore.add(ChatColor.GRAY + host.getName());
                    }
                    if (!host.isAvailable()) {
                        lore.add(this.plugin.api.getLang("SubServers", "Interface.Host-Menu.Host-Unavailable"));
                    } else {
                        lore.add(this.plugin.api.getLang("SubServers", "Interface.Host-Menu.Host-Disabled"));
                    }
                    if (this.plugin.config.get().getMap((Object)"Settings").getBoolean((Object)"Show-Addresses", Boolean.valueOf(false)).booleanValue()) {
                        lore.add(ChatColor.WHITE + host.getAddress().getHostAddress());
                    }
                    blockMeta.setLore(lore);
                }
                block.setItemMeta(blockMeta);
                inv.setItem(i, block);
                if (--count < 9 && (i == 8 || i == 17 || i == 26)) {
                    i += (9 - count) / 2 + 1;
                    even = (count & 1) == 0;
                    continue;
                }
                ++i;
            }
            if (index.size() == 0) {
                block = this.color(14);
                blockMeta = block.getItemMeta();
                blockMeta.setDisplayName(this.plugin.api.getLang("SubServers", "Interface.Host-Menu.No-Hosts"));
                block.setItemMeta(blockMeta);
                inv.setItem(12, block);
                inv.setItem(13, block);
                inv.setItem(14, block);
            }
            for (i = inv.getSize() - 18; i < inv.getSize(); ++i) {
                inv.setItem(i, div);
            }
            i = inv.getSize() - 9;
            if (min != 0) {
                block = this.color(4);
                blockMeta = block.getItemMeta();
                blockMeta.setDisplayName(this.plugin.api.getLang("SubServers", "Interface.Generic.Back-Arrow"));
                block.setItemMeta(blockMeta);
                inv.setItem(i++, block);
                inv.setItem(i++, block);
            } else {
                i += 2;
            }
            ++i;
            if (groups.keySet().size() <= 0) {
                block = this.color(5);
                blockMeta = block.getItemMeta();
                blockMeta.setDisplayName(this.plugin.api.getLang("SubServers", "Interface.Host-Menu.Server-Menu"));
            } else {
                block = this.color(1);
                blockMeta = block.getItemMeta();
                blockMeta.setDisplayName(this.plugin.api.getLang("SubServers", "Interface.Host-Menu.Group-Menu"));
            }
            block.setItemMeta(blockMeta);
            inv.setItem(i++, block);
            inv.setItem(i++, block);
            inv.setItem(i++, block);
            ++i;
            if (index.size() - 1 > max) {
                block = this.color(4);
                blockMeta = block.getItemMeta();
                blockMeta.setDisplayName(this.plugin.api.getLang("SubServers", "Interface.Generic.Next-Arrow"));
                block.setItemMeta(blockMeta);
                inv.setItem(i++, block);
                inv.setItem(i, block);
            }
            this.player.openInventory(inv);
            this.open = true;
        })));
    }

    @Override
    public void hostAdmin(String name) {
        this.setDownloading(ChatColor.stripColor((String)this.plugin.api.getLang("SubServers", "Interface.Host-Admin.Title").replace("$str$", name)));
        this.plugin.api.getHost(name, host -> AgnosticScheduler.following((Entity)this.player).runs((Plugin)this.plugin, c -> {
            this.windowHistory.add(() -> this.hostAdmin(name));
            if (host == null) {
                if (this.hasHistory()) {
                    this.back();
                }
            } else {
                ItemMeta blockMeta;
                ItemStack block;
                this.setDownloading(null);
                this.lastVisitedObjects[0] = host;
                ItemStack div = this.color(15);
                ItemMeta divMeta = div.getItemMeta();
                divMeta.setDisplayName(ChatColor.RESET.toString());
                div.setItemMeta(divMeta);
                Inventory inv = Bukkit.createInventory(null, (int)36, (String)this.plugin.api.getLang("SubServers", "Interface.Host-Admin.Title").replace("$str$", host.getDisplayName()));
                for (int i = 0; i < inv.getSize(); ++i) {
                    inv.setItem(i, div);
                }
                Player player = this.player;
                if (!ObjectPermission.permits(name, (Permissible)player, "subservers.host.%.*", "subservers.host.%.create")) {
                    block = this.color(7);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(ChatColor.GRAY + ChatColor.stripColor((String)this.plugin.api.getLang("SubServers", "Interface.Host-Admin.Creator")));
                    blockMeta.setLore(Arrays.asList(this.plugin.api.getLang("SubServers", "Interface.Generic.Invalid-Permission").replace("$str$", "subservers.host." + name.toLowerCase() + ".create")));
                } else if (!host.isAvailable() || !host.isEnabled()) {
                    block = this.color(7);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(ChatColor.GRAY + ChatColor.stripColor((String)this.plugin.api.getLang("SubServers", "Interface.Host-Admin.Creator")));
                } else {
                    block = this.color(4);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(this.plugin.api.getLang("SubServers", "Interface.Host-Admin.Creator"));
                }
                block.setItemMeta(blockMeta);
                inv.setItem(1, block);
                inv.setItem(2, block);
                inv.setItem(3, block);
                inv.setItem(10, block);
                inv.setItem(11, block);
                inv.setItem(12, block);
                block = this.color(3);
                blockMeta = block.getItemMeta();
                blockMeta.setDisplayName(this.plugin.api.getLang("SubServers", "Interface.Host-Admin.SubServers"));
                block.setItemMeta(blockMeta);
                inv.setItem(5, block);
                inv.setItem(6, block);
                inv.setItem(7, block);
                inv.setItem(14, block);
                inv.setItem(15, block);
                inv.setItem(16, block);
                if (hostPlugins.size() <= 0) {
                    block = div;
                } else {
                    block = this.color(11);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(this.plugin.api.getLang("SubServers", "Interface.Host-Admin.Plugins"));
                    block.setItemMeta(blockMeta);
                }
                inv.setItem(27, block);
                inv.setItem(28, block);
                if (host.isAvailable() && host.isEnabled()) {
                    block = this.color(11);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(ChatColor.AQUA + host.getDisplayName());
                    LinkedList<String> lore = new LinkedList<String>();
                    if (!host.getName().equals(host.getDisplayName())) {
                        lore.add(ChatColor.GRAY + host.getName());
                    }
                    lore.add(this.plugin.api.getLang("SubServers", "Interface.Host-Menu.Host-Server-Count").replace("$int$", new DecimalFormat("#,###").format(host.getSubServers().keySet().size())));
                    if (this.plugin.config.get().getMap((Object)"Settings").getBoolean((Object)"Show-Addresses", Boolean.valueOf(false)).booleanValue()) {
                        lore.add(ChatColor.WHITE + host.getAddress().getHostAddress());
                    }
                    blockMeta.setLore(lore);
                } else {
                    block = this.color(14);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(ChatColor.RED + host.getDisplayName());
                    LinkedList<String> lore = new LinkedList<String>();
                    if (!host.getName().equals(host.getDisplayName())) {
                        lore.add(ChatColor.GRAY + host.getName());
                    }
                    if (!host.isAvailable()) {
                        lore.add(this.plugin.api.getLang("SubServers", "Interface.Host-Menu.Host-Unavailable"));
                    } else {
                        lore.add(this.plugin.api.getLang("SubServers", "Interface.Host-Menu.Host-Disabled"));
                    }
                    if (this.plugin.config.get().getMap((Object)"Settings").getBoolean((Object)"Show-Addresses", Boolean.valueOf(false)).booleanValue()) {
                        lore.add(ChatColor.WHITE + host.getAddress().getHostAddress());
                    }
                    blockMeta.setLore(lore);
                }
                block.setItemMeta(blockMeta);
                inv.setItem(30, block);
                inv.setItem(31, block);
                inv.setItem(32, block);
                if (this.hasHistory()) {
                    block = this.color(14);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(this.plugin.api.getLang("SubServers", "Interface.Generic.Back"));
                    block.setItemMeta(blockMeta);
                    inv.setItem(34, block);
                    inv.setItem(35, block);
                }
                player.openInventory(inv);
                this.open = true;
            }
        }));
    }

    @Override
    public void hostCreator(UIRenderer.CreatorOptions options) {
        this.setDownloading(ChatColor.stripColor((String)this.plugin.api.getLang("SubServers", "Interface.Host-Creator.Title").replace("$str$", options.getHost())));
        if (!options.init()) {
            this.windowHistory.add(() -> this.hostCreator(options));
        }
        this.lastVisitedObjects[0] = options;
        this.plugin.api.getHost(options.getHost(), host -> AgnosticScheduler.following((Entity)this.player).runs((Plugin)this.plugin, c -> {
            if (host == null || !host.isAvailable() || !host.isEnabled()) {
                this.lastVisitedObjects[0] = null;
                if (this.hasHistory()) {
                    this.back();
                }
            } else {
                ItemMeta blockMeta;
                ItemStack block;
                this.setDownloading(null);
                ItemStack div = this.color(15);
                ItemMeta divMeta = div.getItemMeta();
                divMeta.setDisplayName(ChatColor.RESET.toString());
                div.setItemMeta(divMeta);
                Inventory inv = Bukkit.createInventory(null, (int)54, (String)this.plugin.api.getLang("SubServers", "Interface.Host-Creator.Title").replace("$str$", host.getDisplayName()));
                for (int i = 0; i < inv.getSize(); ++i) {
                    inv.setItem(i, div);
                }
                if (options.getName() == null) {
                    block = this.color(14);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(ChatColor.RED + this.plugin.api.getLang("SubServers", "Interface.Host-Creator.Edit-Name"));
                } else {
                    block = this.color(5);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(ChatColor.GREEN + this.plugin.api.getLang("SubServers", "Interface.Host-Creator.Edit-Name"));
                    blockMeta.setLore(Arrays.asList(ChatColor.GRAY + options.getName()));
                }
                block.setItemMeta(blockMeta);
                inv.setItem(10, block);
                inv.setItem(11, block);
                inv.setItem(12, block);
                block = this.color(5);
                blockMeta = block.getItemMeta();
                blockMeta.setDisplayName(ChatColor.GREEN + this.plugin.api.getLang("SubServers", "Interface.Host-Creator.Edit-Port"));
                blockMeta.setLore(Arrays.asList(ChatColor.GRAY.toString() + (options.getPort() == null ? "Auto Select" : options.getPort())));
                block.setItemMeta(blockMeta);
                inv.setItem(14, block);
                inv.setItem(15, block);
                inv.setItem(16, block);
                if (options.getTemplate() == null) {
                    block = this.color(14);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(ChatColor.RED + this.plugin.api.getLang("SubServers", "Interface.Host-Creator.Edit-Template"));
                } else {
                    block = this.color(5);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(ChatColor.GREEN + this.plugin.api.getLang("SubServers", "Interface.Host-Creator.Edit-Template"));
                    blockMeta.setLore(Arrays.asList(ChatColor.GRAY + options.getTemplate()));
                }
                block.setItemMeta(blockMeta);
                inv.setItem(28, block);
                inv.setItem(29, block);
                inv.setItem(30, block);
                if (options.getVersion() == null && (options.getTemplate() == null || host.getCreator().getTemplate(options.getTemplate()).requiresVersion())) {
                    block = this.color(14);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(ChatColor.RED + this.plugin.api.getLang("SubServers", "Interface.Host-Creator.Edit-Version"));
                } else {
                    block = this.color(5);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(ChatColor.GREEN + this.plugin.api.getLang("SubServers", "Interface.Host-Creator.Edit-Version"));
                    blockMeta.setLore(Arrays.asList(ChatColor.GRAY + (options.getVersion() == null ? "Unspecified" : "Minecraft " + options.getVersion().toString())));
                }
                block.setItemMeta(blockMeta);
                inv.setItem(32, block);
                inv.setItem(33, block);
                inv.setItem(34, block);
                if (!options.hasHistory()) {
                    block = this.color(7);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(ChatColor.GRAY + ChatColor.stripColor((String)this.plugin.api.getLang("SubServers", "Interface.Generic.Undo")));
                    block.setItemMeta(blockMeta);
                } else {
                    block = this.color(1);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(this.plugin.api.getLang("SubServers", "Interface.Generic.Undo"));
                    block.setItemMeta(blockMeta);
                }
                block.setItemMeta(blockMeta);
                inv.setItem(45, block);
                inv.setItem(46, block);
                if (options.getName() == null || options.getTemplate() == null || options.getVersion() == null && host.getCreator().getTemplate(options.getTemplate()).requiresVersion()) {
                    block = this.color(7);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(ChatColor.GRAY + ChatColor.stripColor((String)this.plugin.api.getLang("SubServers", "Interface.Host-Creator.Submit")));
                    blockMeta.setLore(Arrays.asList(this.plugin.api.getLang("SubServers", "Interface.Host-Creator.Form-Incomplete")));
                    block.setItemMeta(blockMeta);
                } else {
                    block = this.color(4);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(this.plugin.api.getLang("SubServers", "Interface.Host-Creator.Submit"));
                    block.setItemMeta(blockMeta);
                }
                block.setItemMeta(blockMeta);
                inv.setItem(48, block);
                inv.setItem(49, block);
                inv.setItem(50, block);
                if (this.hasHistory()) {
                    block = this.color(14);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(this.plugin.api.getLang("SubServers", "Interface.Generic.Back"));
                    block.setItemMeta(blockMeta);
                    inv.setItem(52, block);
                    inv.setItem(53, block);
                }
                this.player.openInventory(inv);
                this.open = true;
            }
        }));
    }

    public void hostCreatorTemplates(int page, UIRenderer.CreatorOptions options) {
        this.setDownloading(ChatColor.stripColor((String)this.plugin.api.getLang("SubServers", "Interface.Host-Creator.Edit-Template.Title").replace("$str$", options.getHost())));
        options.init();
        this.lastVisitedObjects[0] = options;
        this.plugin.api.getHost(options.getHost(), host -> AgnosticScheduler.following((Entity)this.player).runs((Plugin)this.plugin, c -> {
            if (host == null || !host.isAvailable() || !host.isEnabled()) {
                this.lastVisitedObjects[0] = null;
                if (this.hasHistory()) {
                    this.back();
                }
            } else {
                ItemMeta blockMeta;
                int i;
                this.lastPage = page;
                this.setDownloading(null);
                LinkedList<SubCreator.ServerTemplate> index = new LinkedList<SubCreator.ServerTemplate>();
                for (SubCreator.ServerTemplate template : host.getCreator().getTemplates().values()) {
                    if (!template.isEnabled()) continue;
                    index.add(template);
                }
                ItemStack div = this.color(15);
                ItemMeta divMeta = div.getItemMeta();
                divMeta.setDisplayName(ChatColor.RESET.toString());
                div.setItemMeta(divMeta);
                int min = (page - 1) * 36;
                int max = min + 35;
                int count = index.size() == 0 ? 27 : (index.size() - min >= max ? 36 : index.size() - min);
                int area = count % 9 == 0 ? count : (count / 9 + 1) * 9;
                Inventory inv = Bukkit.createInventory(null, (int)(18 + area), (String)this.plugin.api.getLang("SubServers", "Interface.Host-Creator.Edit-Template.Title").replace("$str$", host.getDisplayName()));
                ItemStack block = this.color(7);
                block.setItemMeta(divMeta);
                for (i = 0; i < area; ++i) {
                    inv.setItem(i, block);
                }
                ItemStack adiv = block;
                i = count < 9 ? (9 - count) / 2 : 0;
                boolean even = (count & 1) == 0 && count < 9;
                for (SubCreator.ServerTemplate template : index) {
                    if (index.indexOf(template) < min || index.indexOf(template) > max) continue;
                    if (even && (i == 4 || i == 13 || i == 22 || i == 31)) {
                        inv.setItem(i++, adiv);
                    }
                    block = this.parseItem(template.getIcon(), new ItemStack(Material.ENDER_CHEST));
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(ChatColor.YELLOW + template.getDisplayName());
                    LinkedList<String> lore = new LinkedList<String>();
                    if (!template.getName().equals(template.getDisplayName())) {
                        lore.add(ChatColor.GRAY + template.getName());
                    }
                    blockMeta.setLore(lore);
                    block.setItemMeta(blockMeta);
                    inv.setItem(i, block);
                    if (--count < 9 && (i == 8 || i == 17 || i == 26)) {
                        i += (9 - count) / 2 + 1;
                        even = (count & 1) == 0;
                        continue;
                    }
                    ++i;
                }
                if (index.size() == 0) {
                    block = this.color(14);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(this.plugin.api.getLang("SubServers", "Interface.Host-Creator.Edit-Template.No-Templates"));
                    block.setItemMeta(blockMeta);
                    inv.setItem(12, block);
                    inv.setItem(13, block);
                    inv.setItem(14, block);
                }
                for (i = inv.getSize() - 18; i < inv.getSize(); ++i) {
                    inv.setItem(i, div);
                }
                i = inv.getSize() - 9;
                if (min != 0) {
                    block = this.color(4);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(this.plugin.api.getLang("SubServers", "Interface.Generic.Back-Arrow"));
                    block.setItemMeta(blockMeta);
                    inv.setItem(i++, block);
                    inv.setItem(i++, block);
                } else {
                    i += 2;
                }
                block = this.color(14);
                blockMeta = block.getItemMeta();
                blockMeta.setDisplayName(this.plugin.api.getLang("SubServers", "Interface.Generic.Back"));
                block.setItemMeta(blockMeta);
                int n = ++i;
                inv.setItem(n, block);
                int n2 = ++i;
                inv.setItem(n2, block);
                int n3 = ++i;
                ++i;
                inv.setItem(n3, block);
                ++i;
                if (index.size() - 1 > max) {
                    block = this.color(4);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(this.plugin.api.getLang("SubServers", "Interface.Generic.Next-Arrow"));
                    block.setItemMeta(blockMeta);
                    inv.setItem(i++, block);
                    inv.setItem(i, block);
                }
                this.player.openInventory(inv);
                this.open = true;
            }
        }));
    }

    @Override
    public void hostPlugin(int page, String name) {
        this.setDownloading(ChatColor.stripColor((String)this.plugin.api.getLang("SubServers", "Interface.Host-Plugin.Title").replace("$str$", name)));
        this.plugin.api.getHost(name, host -> AgnosticScheduler.following((Entity)this.player).runs((Plugin)this.plugin, c -> {
            this.windowHistory.add(() -> this.hostPlugin(page, name));
            if (host == null) {
                if (this.hasHistory()) {
                    this.back();
                }
            } else {
                ItemMeta blockMeta;
                int i;
                this.setDownloading(null);
                this.lastVisitedObjects[0] = host;
                this.lastPage = page;
                LinkedList<String> renderers = new LinkedList<String>();
                for (String renderer : hostPlugins.keySet()) {
                    if (!((PluginRenderer)hostPlugins.get(renderer)).isEnabled(host)) continue;
                    renderers.add(renderer);
                }
                Collections.sort(renderers);
                ItemStack div = this.color(15);
                ItemMeta divMeta = div.getItemMeta();
                divMeta.setDisplayName(ChatColor.RESET.toString());
                div.setItemMeta(divMeta);
                int min = (page - 1) * 36;
                int max = min + 35;
                int count = renderers.size() == 0 ? 27 : (renderers.size() - min >= max ? 36 : renderers.size() - min);
                int area = count % 9 == 0 ? count : (count / 9 + 1) * 9;
                Inventory inv = Bukkit.createInventory(null, (int)(18 + area), (String)this.plugin.api.getLang("SubServers", "Interface.Host-Plugin.Title").replace("$str$", host.getDisplayName()));
                ItemStack block = this.color(7);
                block.setItemMeta(divMeta);
                for (i = 0; i < area; ++i) {
                    inv.setItem(i, block);
                }
                ItemStack adiv = block;
                i = count < 9 ? (9 - count) / 2 : 0;
                boolean even = (count & 1) == 0 && count < 9;
                for (String renderer : renderers) {
                    if (renderers.indexOf(renderer) < min || renderers.indexOf(renderer) > max) continue;
                    if (even && (i == 4 || i == 13 || i == 22 || i == 31)) {
                        inv.setItem(i++, adiv);
                    }
                    inv.setItem(i, ((PluginRenderer)hostPlugins.get(renderer)).getIcon());
                    if (--count < 9 && (i == 8 || i == 17 || i == 26)) {
                        i += (9 - count) / 2 + 1;
                        even = (count & 1) == 0;
                        continue;
                    }
                    ++i;
                }
                if (renderers.size() == 0) {
                    block = this.color(14);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(this.plugin.api.getLang("SubServers", "Interface.Host-Plugin.No-Plugins"));
                    block.setItemMeta(blockMeta);
                    inv.setItem(12, block);
                    inv.setItem(13, block);
                    inv.setItem(14, block);
                }
                for (i = inv.getSize() - 18; i < inv.getSize(); ++i) {
                    inv.setItem(i, div);
                }
                i = inv.getSize() - 9;
                if (min != 0) {
                    block = this.color(4);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(this.plugin.api.getLang("SubServers", "Interface.Generic.Back-Arrow"));
                    block.setItemMeta(blockMeta);
                    inv.setItem(i++, block);
                    inv.setItem(i++, block);
                } else {
                    i += 2;
                }
                ++i;
                if (this.hasHistory()) {
                    block = this.color(14);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(this.plugin.api.getLang("SubServers", "Interface.Generic.Back"));
                    block.setItemMeta(blockMeta);
                    inv.setItem(i++, block);
                    inv.setItem(i++, block);
                    inv.setItem(i++, block);
                    ++i;
                }
                if (renderers.size() - 1 > max) {
                    block = this.color(4);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(this.plugin.api.getLang("SubServers", "Interface.Generic.Next-Arrow"));
                    block.setItemMeta(blockMeta);
                    inv.setItem(i++, block);
                    inv.setItem(i, block);
                }
                this.player.openInventory(inv);
                this.open = true;
            }
        }));
    }

    @Override
    public void groupMenu(int page) {
        this.setDownloading(ChatColor.stripColor((String)this.plugin.api.getLang("SubServers", "Interface.Group-Menu.Title")));
        this.plugin.api.getServers(servers -> AgnosticScheduler.following((Entity)this.player).runs((Plugin)this.plugin, c -> {
            ItemMeta blockMeta;
            int i;
            this.setDownloading(null);
            this.lastVisitedObjects[0] = null;
            this.lastPage = page;
            this.lastMenu = () -> this.groupMenu(1);
            this.windowHistory.add(() -> this.groupMenu(page));
            TreeMap groups = new TreeMap();
            ArrayList<Server> ungrouped = new ArrayList<Server>();
            HashMap<String, String> conflitresolver = new HashMap<String, String>();
            for (Server server : servers.values()) {
                List sgl = server.getGroups();
                if (sgl.size() == 0) {
                    ungrouped.add(server);
                    continue;
                }
                Iterator iterator = sgl.iterator();
                while (iterator.hasNext()) {
                    String name;
                    String group = name = (String)iterator.next();
                    if (conflitresolver.containsKey(name.toLowerCase())) {
                        group = (String)conflitresolver.get(name.toLowerCase());
                    } else {
                        conflitresolver.put(name.toLowerCase(), name);
                    }
                    List<Server> list = groups.containsKey(group) ? (List)groups.get(group) : new ArrayList();
                    list.add(server);
                    groups.put(group, list);
                }
            }
            LinkedList index = new LinkedList();
            if (ungrouped.size() != 0) {
                index.add(null);
            }
            index.addAll(groups.keySet());
            ItemStack div = this.color(15);
            ItemMeta divMeta = div.getItemMeta();
            divMeta.setDisplayName(ChatColor.RESET.toString());
            div.setItemMeta(divMeta);
            int min = (page - 1) * 36;
            int max = min + 35;
            int count = index.size() == 0 ? 27 : (index.size() - min >= max ? 36 : index.size() - min);
            int area = count % 9 == 0 ? count : (count / 9 + 1) * 9;
            Inventory inv = Bukkit.createInventory(null, (int)(18 + area), (String)this.plugin.api.getLang("SubServers", "Interface.Group-Menu.Title"));
            ItemStack block = this.color(7);
            block.setItemMeta(divMeta);
            for (i = 0; i < area; ++i) {
                inv.setItem(i, block);
            }
            ItemStack adiv = block;
            i = count < 9 ? (9 - count) / 2 : 0;
            boolean even = (count & 1) == 0 && count < 9;
            for (String group : index) {
                int size;
                if (index.indexOf(group) < min || index.indexOf(group) > max) continue;
                if (even && (i == 4 || i == 13 || i == 22 || i == 31)) {
                    inv.setItem(i++, adiv);
                }
                int color = (i & 1) == 0 ? 1 : 4;
                block = this.color(color);
                blockMeta = block.getItemMeta();
                if (group == null) {
                    blockMeta.setDisplayName(this.plugin.api.getLang("SubServers", "Interface.Group-Menu.Ungrouped"));
                    size = ungrouped.size();
                } else {
                    blockMeta.setDisplayName(ChatColor.GOLD + group);
                    size = ((List)groups.get(group)).size();
                }
                LinkedList<String> lore = new LinkedList<String>();
                lore.add(this.plugin.api.getLang("SubServers", "Interface.Group-Menu.Group-Server-Count").replace("$int$", new DecimalFormat("#,###").format(size)));
                blockMeta.setLore(lore);
                block.setItemMeta(blockMeta);
                inv.setItem(i, block);
                if (--count < 9 && (i == 8 || i == 17 || i == 26)) {
                    i += (9 - count) / 2 + 1;
                    even = (count & 1) == 0;
                    continue;
                }
                ++i;
            }
            for (i = inv.getSize() - 18; i < inv.getSize(); ++i) {
                inv.setItem(i, div);
            }
            i = inv.getSize() - 9;
            if (min != 0) {
                block = this.color(4);
                blockMeta = block.getItemMeta();
                blockMeta.setDisplayName(this.plugin.api.getLang("SubServers", "Interface.Generic.Back-Arrow"));
                block.setItemMeta(blockMeta);
                inv.setItem(i++, block);
                inv.setItem(i++, block);
            } else {
                i += 2;
            }
            block = this.color(5);
            blockMeta = block.getItemMeta();
            blockMeta.setDisplayName(this.plugin.api.getLang("SubServers", "Interface.Group-Menu.Server-Menu"));
            block.setItemMeta(blockMeta);
            int n = ++i;
            inv.setItem(n, block);
            int n2 = ++i;
            inv.setItem(n2, block);
            int n3 = ++i;
            ++i;
            inv.setItem(n3, block);
            ++i;
            if (index.size() - 1 > max) {
                block = this.color(4);
                blockMeta = block.getItemMeta();
                blockMeta.setDisplayName(this.plugin.api.getLang("SubServers", "Interface.Generic.Next-Arrow"));
                block.setItemMeta(blockMeta);
                inv.setItem(i++, block);
                inv.setItem(i, block);
            }
            this.player.openInventory(inv);
            this.open = true;
        }));
    }

    @Override
    public void serverMenu(int page, String host, String group) {
        this.setDownloading(ChatColor.stripColor((String)(host == null ? (group == null ? this.plugin.api.getLang("SubServers", "Interface.Server-Menu.Title") : (group.length() == 0 ? this.plugin.api.getLang("SubServers", "Interface.Group-SubServer.Title-Ungrouped") : this.plugin.api.getLang("SubServers", "Interface.Group-SubServer.Title").replace("$str$", group))) : this.plugin.api.getLang("SubServers", "Interface.Host-SubServer.Title").replace("$str$", host))));
        Container hostname = new Container((Object)host);
        Container servercontainer = new Container(new LinkedList());
        Runnable renderer = () -> this.lambda$serverMenu$22(page, (Value)servercontainer, host, group, (Value)hostname);
        if (host != null && host.length() > 0) {
            this.plugin.api.getHost(host, arg_0 -> this.lambda$serverMenu$23((Value)hostname, (Value)servercontainer, renderer, arg_0));
        } else if (group != null) {
            this.plugin.api.getGroup(group.length() == 0 ? null : group, arg_0 -> this.lambda$serverMenu$24((Value)servercontainer, renderer, arg_0));
        } else {
            this.plugin.api.getServers(arg_0 -> DefaultUIRenderer.lambda$serverMenu$25((Value)servercontainer, renderer, arg_0));
        }
    }

    @Override
    public void serverAdmin(String name) {
        this.setDownloading(ChatColor.stripColor((String)this.plugin.api.getLang("SubServers", "Interface.Server-Admin.Title").replace("$str$", name)));
        BiConsumer<Server, Host> renderer = (server, host) -> AgnosticScheduler.following((Entity)this.player).runs((Plugin)this.plugin, c -> {
            ItemMeta blockMeta;
            ItemStack block;
            int i;
            this.setDownloading(null);
            this.lastVisitedObjects[0] = server;
            ItemStack div = this.color(15);
            ItemMeta divMeta = div.getItemMeta();
            divMeta.setDisplayName(ChatColor.RESET.toString());
            div.setItemMeta(divMeta);
            Inventory inv = Bukkit.createInventory(null, (int)36, (String)this.plugin.api.getLang("SubServers", "Interface.Server-Admin.Title").replace("$str$", server.getDisplayName()));
            SubServer subserver = host != null ? (SubServer)server : null;
            for (i = 0; i < inv.getSize(); ++i) {
                inv.setItem(i, div);
            }
            i = 0;
            Player player = this.player;
            if (host == null || ((SubServer)server).isRunning()) {
                boolean permits;
                if (host == null || !ObjectPermission.permits(server, (Permissible)player, "subservers.subserver.%.*", "subservers.subserver.%.terminate")) {
                    block = this.color(7);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(ChatColor.GRAY + ChatColor.stripColor((String)this.plugin.api.getLang("SubServers", "Interface.Server-Admin.Terminate")));
                    if (host != null) {
                        blockMeta.setLore(Arrays.asList(this.plugin.api.getLang("SubServers", "Interface.Generic.Invalid-Permission").replace("$str$", "subservers.subserver." + name.toLowerCase() + ".terminate")));
                    }
                } else {
                    block = this.color(14);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(this.plugin.api.getLang("SubServers", "Interface.Server-Admin.Terminate"));
                }
                block.setItemMeta(blockMeta);
                inv.setItem(1, block);
                inv.setItem(10, block);
                if (host == null || !ObjectPermission.permits(server, (Permissible)player, "subservers.subserver.%.*", "subservers.subserver.%.stop")) {
                    block = this.color(7);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(ChatColor.GRAY + ChatColor.stripColor((String)this.plugin.api.getLang("SubServers", "Interface.Server-Admin.Stop")));
                    if (host != null) {
                        blockMeta.setLore(Arrays.asList(this.plugin.api.getLang("SubServers", "Interface.Generic.Invalid-Permission").replace("$str$", "subservers.subserver." + name.toLowerCase() + ".stop")));
                    }
                } else {
                    block = this.color(2);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(this.plugin.api.getLang("SubServers", "Interface.Server-Admin.Stop"));
                }
                block.setItemMeta(blockMeta);
                inv.setItem(2, block);
                inv.setItem(3, block);
                inv.setItem(11, block);
                inv.setItem(12, block);
                if ((host == null && server.getSubData()[0] == null) | (permits = !ObjectPermission.permits(server, (Permissible)player, "subservers.subserver.%.*", "subservers.subserver.%.command"))) {
                    block = this.color(7);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(ChatColor.GRAY + ChatColor.stripColor((String)this.plugin.api.getLang("SubServers", "Interface.Server-Admin.Command")));
                    if (permits) {
                        blockMeta.setLore(Arrays.asList(this.plugin.api.getLang("SubServers", "Interface.Generic.Invalid-Permission").replace("$str$", "subservers.subserver." + name.toLowerCase() + ".command")));
                    }
                } else {
                    block = this.color(3);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(this.plugin.api.getLang("SubServers", "Interface.Server-Admin.Command"));
                }
                block.setItemMeta(blockMeta);
                inv.setItem(5, block);
                inv.setItem(6, block);
                inv.setItem(7, block);
                inv.setItem(14, block);
                inv.setItem(15, block);
                inv.setItem(16, block);
            } else {
                SubCreator.ServerTemplate template;
                if (!ObjectPermission.permits((Server)subserver, (Permissible)player, "subservers.subserver.%.*", "subservers.subserver.%.start")) {
                    block = this.color(7);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(ChatColor.GRAY + ChatColor.stripColor((String)this.plugin.api.getLang("SubServers", "Interface.Server-Admin.Start")));
                    blockMeta.setLore(Arrays.asList(this.plugin.api.getLang("SubServers", "Interface.Generic.Invalid-Permission").replace("$str$", "subservers.subserver." + name.toLowerCase() + ".start")));
                } else if (!(host.isAvailable() && host.isEnabled() && subserver.isAvailable() && subserver.isEnabled() && subserver.getCurrentIncompatibilities().size() == 0)) {
                    block = this.color(7);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(ChatColor.GRAY + ChatColor.stripColor((String)this.plugin.api.getLang("SubServers", "Interface.Server-Admin.Start")));
                } else {
                    block = this.color(5);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(this.plugin.api.getLang("SubServers", "Interface.Server-Admin.Start"));
                }
                block.setItemMeta(blockMeta);
                if (subserver.getTemplate() == null || !(template = host.getCreator().getTemplate(subserver.getTemplate())).isEnabled() || !template.canUpdate()) {
                    inv.setItem(3, block);
                    inv.setItem(4, block);
                    inv.setItem(5, block);
                    inv.setItem(12, block);
                    inv.setItem(13, block);
                    inv.setItem(14, block);
                } else {
                    inv.setItem(1, block);
                    inv.setItem(2, block);
                    inv.setItem(3, block);
                    inv.setItem(10, block);
                    inv.setItem(11, block);
                    inv.setItem(12, block);
                    if (!ObjectPermission.permits((Server)subserver, (Permissible)player, "subservers.subserver.%.*", "subservers.subserver.%.update")) {
                        block = this.color(7);
                        blockMeta = block.getItemMeta();
                        blockMeta.setDisplayName(ChatColor.GRAY + ChatColor.stripColor((String)this.plugin.api.getLang("SubServers", "Interface.Server-Admin.Update")));
                        blockMeta.setLore(Arrays.asList(this.plugin.api.getLang("SubServers", "Interface.Generic.Invalid-Permission").replace("$str$", "subservers.subserver." + name.toLowerCase() + ".update")));
                    } else if (!(host.isAvailable() && host.isEnabled() && subserver.isAvailable() && subserver.getCurrentIncompatibilities().size() == 0)) {
                        block = this.color(7);
                        blockMeta = block.getItemMeta();
                        blockMeta.setDisplayName(ChatColor.GRAY + ChatColor.stripColor((String)this.plugin.api.getLang("SubServers", "Interface.Server-Admin.Update")));
                    } else {
                        block = this.color(4);
                        blockMeta = block.getItemMeta();
                        blockMeta.setDisplayName(this.plugin.api.getLang("SubServers", "Interface.Server-Admin.Update"));
                    }
                    block.setItemMeta(blockMeta);
                    inv.setItem(5, block);
                    inv.setItem(6, block);
                    inv.setItem(7, block);
                    inv.setItem(14, block);
                    inv.setItem(15, block);
                    inv.setItem(16, block);
                }
            }
            if (serverPlugins.size() > 0) {
                block = this.color(11);
                blockMeta = block.getItemMeta();
                blockMeta.setDisplayName(this.plugin.api.getLang("SubServers", "Interface.Server-Admin.Plugins"));
                block.setItemMeta(blockMeta);
            } else {
                block = div;
            }
            inv.setItem(27, block);
            inv.setItem(28, block);
            if (host == null) {
                block = this.color(0);
                blockMeta = block.getItemMeta();
                blockMeta.setDisplayName(ChatColor.WHITE + server.getDisplayName());
                LinkedList<String> lore = new LinkedList<String>();
                if (!server.getName().equals(server.getDisplayName())) {
                    lore.add(ChatColor.GRAY + server.getName());
                }
                lore.add(this.plugin.api.getLang("SubServers", "Interface.Server-Menu.Server-External"));
                lore.add(this.plugin.api.getLang("SubServers", "Interface.Server-Menu.Server-Player-Count").replace("$int$", new DecimalFormat("#,###").format(server.getRemotePlayers().size())));
                lore.add(ChatColor.WHITE + (this.plugin.config.get().getMap((Object)"Settings").getBoolean((Object)"Show-Addresses", Boolean.valueOf(false)) != false ? server.getAddress().getAddress().getHostAddress() + ':' : "") + server.getAddress().getPort());
                blockMeta.setLore(lore);
            } else if (subserver.isRunning()) {
                int blocktype = subserver.getStopAction() == SubServer.StopAction.REMOVE_SERVER || subserver.getStopAction() == SubServer.StopAction.RECYCLE_SERVER || subserver.getStopAction() == SubServer.StopAction.DELETE_SERVER ? 11 : 5;
                block = this.color(blocktype);
                blockMeta = block.getItemMeta();
                LinkedList<String> lore = new LinkedList<String>();
                if (!subserver.getName().equals(subserver.getDisplayName())) {
                    lore.add(ChatColor.GRAY + subserver.getName());
                }
                if (subserver.getStopAction() == SubServer.StopAction.REMOVE_SERVER || subserver.getStopAction() == SubServer.StopAction.RECYCLE_SERVER || subserver.getStopAction() == SubServer.StopAction.DELETE_SERVER) {
                    blockMeta.setDisplayName(ChatColor.AQUA + subserver.getDisplayName());
                    lore.add(this.plugin.api.getLang("SubServers", "Interface.Server-Menu.SubServer-Temporary"));
                } else {
                    blockMeta.setDisplayName(ChatColor.GREEN + subserver.getDisplayName());
                }
                lore.add(this.plugin.api.getLang("SubServers", "Interface.Server-Menu.Server-Player-Count").replace("$int$", new DecimalFormat("#,###").format(subserver.getRemotePlayers().size())));
                lore.add(ChatColor.WHITE + (this.plugin.config.get().getMap((Object)"Settings").getBoolean((Object)"Show-Addresses", Boolean.valueOf(false)) != false ? subserver.getAddress().getAddress().getHostAddress() + ':' : "") + subserver.getAddress().getPort());
                blockMeta.setLore(lore);
            } else if (subserver.isAvailable() && subserver.isEnabled() && subserver.getCurrentIncompatibilities().size() == 0) {
                block = this.color(4);
                blockMeta = block.getItemMeta();
                blockMeta.setDisplayName(ChatColor.YELLOW + subserver.getDisplayName());
                LinkedList<String> lore = new LinkedList<String>();
                if (!subserver.getName().equals(subserver.getDisplayName())) {
                    lore.add(ChatColor.GRAY + subserver.getName());
                }
                lore.add(this.plugin.api.getLang("SubServers", "Interface.Server-Menu.SubServer-Offline"));
                lore.add(ChatColor.WHITE + (this.plugin.config.get().getMap((Object)"Settings").getBoolean((Object)"Show-Addresses", Boolean.valueOf(false)) != false ? subserver.getAddress().getAddress().getHostAddress() + ':' : "") + subserver.getAddress().getPort());
                blockMeta.setLore(lore);
            } else {
                block = this.color(14);
                blockMeta = block.getItemMeta();
                blockMeta.setDisplayName(ChatColor.RED + subserver.getDisplayName());
                LinkedList<String> lore = new LinkedList<String>();
                if (!subserver.getName().equals(subserver.getDisplayName())) {
                    lore.add(ChatColor.GRAY + subserver.getName());
                }
                if (subserver.getCurrentIncompatibilities().size() != 0) {
                    String list = "";
                    for (String other : subserver.getCurrentIncompatibilities()) {
                        if (list.length() != 0) {
                            list = list + ", ";
                        }
                        list = list + other;
                    }
                    lore.add(this.plugin.api.getLang("SubServers", "Interface.Server-Menu.SubServer-Incompatible").replace("$str$", list));
                }
                if (!subserver.isAvailable() || !subserver.isEnabled()) {
                    lore.add(this.plugin.api.getLang("SubServers", !subserver.isAvailable() ? "Interface.Server-Menu.SubServer-Unavailable" : "Interface.Server-Menu.SubServer-Disabled"));
                }
                lore.add(ChatColor.WHITE + (this.plugin.config.get().getMap((Object)"Settings").getBoolean((Object)"Show-Addresses", Boolean.valueOf(false)) != false ? subserver.getAddress().getAddress().getHostAddress() + ':' : "") + subserver.getAddress().getPort());
                blockMeta.setLore(lore);
            }
            block.setItemMeta(blockMeta);
            inv.setItem(30, block);
            inv.setItem(31, block);
            inv.setItem(32, block);
            if (this.hasHistory()) {
                block = this.color(14);
                blockMeta = block.getItemMeta();
                blockMeta.setDisplayName(this.plugin.api.getLang("SubServers", "Interface.Generic.Back"));
                block.setItemMeta(blockMeta);
                inv.setItem(34, block);
                inv.setItem(35, block);
            }
            player.openInventory(inv);
            this.open = true;
        });
        this.plugin.api.getServer(name, server -> {
            this.windowHistory.add(() -> this.serverAdmin(name));
            if (server == null) {
                if (this.hasHistory()) {
                    this.back();
                }
            } else if (server instanceof SubServer) {
                ((SubServer)server).getHost(host -> {
                    if (host == null) {
                        if (this.hasHistory()) {
                            this.back();
                        }
                    } else {
                        renderer.accept((Server)server, (Host)host);
                    }
                });
            } else {
                renderer.accept((Server)server, (Host)null);
            }
        });
    }

    @Override
    public void serverPlugin(int page, String name) {
        this.setDownloading(ChatColor.stripColor((String)this.plugin.api.getLang("SubServers", "Interface.SubServer-Plugin.Title").replace("$str$", name)));
        this.plugin.api.getServer(name, server -> AgnosticScheduler.following((Entity)this.player).runs((Plugin)this.plugin, c -> {
            this.windowHistory.add(() -> this.serverPlugin(page, name));
            if (server == null) {
                if (this.hasHistory()) {
                    this.back();
                }
            } else {
                ItemMeta blockMeta;
                int i;
                this.setDownloading(null);
                this.lastVisitedObjects[0] = server;
                this.lastPage = page;
                LinkedList<String> renderers = new LinkedList<String>();
                for (String renderer : serverPlugins.keySet()) {
                    if (!((PluginRenderer)serverPlugins.get(renderer)).isEnabled(server)) continue;
                    renderers.add(renderer);
                }
                Collections.sort(renderers);
                ItemStack div = this.color(15);
                ItemMeta divMeta = div.getItemMeta();
                divMeta.setDisplayName(ChatColor.RESET.toString());
                div.setItemMeta(divMeta);
                int min = (page - 1) * 36;
                int max = min + 35;
                int count = renderers.size() == 0 ? 27 : (renderers.size() - min >= max ? 36 : renderers.size() - min);
                int area = count % 9 == 0 ? count : (count / 9 + 1) * 9;
                Inventory inv = Bukkit.createInventory(null, (int)(18 + area), (String)this.plugin.api.getLang("SubServers", "Interface.SubServer-Plugin.Title").replace("$str$", server.getDisplayName()));
                ItemStack block = this.color(7);
                block.setItemMeta(divMeta);
                for (i = 0; i < area; ++i) {
                    inv.setItem(i, block);
                }
                ItemStack adiv = block;
                i = count < 9 ? (9 - count) / 2 : 0;
                boolean even = (count & 1) == 0 && count < 9;
                for (String renderer : renderers) {
                    if (renderers.indexOf(renderer) < min || renderers.indexOf(renderer) > max) continue;
                    if (even && (i == 4 || i == 13 || i == 22 || i == 31)) {
                        inv.setItem(i++, adiv);
                    }
                    inv.setItem(i, ((PluginRenderer)serverPlugins.get(renderer)).getIcon());
                    if (--count < 9 && (i == 8 || i == 17 || i == 26)) {
                        i += (9 - count) / 2 + 1;
                        even = (count & 1) == 0;
                        continue;
                    }
                    ++i;
                }
                if (renderers.size() == 0) {
                    block = this.color(14);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(this.plugin.api.getLang("SubServers", "Interface.SubServer-Plugin.No-Plugins"));
                    block.setItemMeta(blockMeta);
                    inv.setItem(12, block);
                    inv.setItem(13, block);
                    inv.setItem(14, block);
                }
                for (i = inv.getSize() - 18; i < inv.getSize(); ++i) {
                    inv.setItem(i, div);
                }
                i = inv.getSize() - 9;
                if (min != 0) {
                    block = this.color(4);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(this.plugin.api.getLang("SubServers", "Interface.Generic.Back-Arrow"));
                    block.setItemMeta(blockMeta);
                    inv.setItem(i++, block);
                    inv.setItem(i++, block);
                } else {
                    i += 2;
                }
                ++i;
                if (this.hasHistory()) {
                    block = this.color(14);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(this.plugin.api.getLang("SubServers", "Interface.Generic.Back"));
                    block.setItemMeta(blockMeta);
                    inv.setItem(i++, block);
                    inv.setItem(i++, block);
                    inv.setItem(i++, block);
                    ++i;
                }
                if (renderers.size() - 1 > max) {
                    block = this.color(4);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(this.plugin.api.getLang("SubServers", "Interface.Generic.Next-Arrow"));
                    block.setItemMeta(blockMeta);
                    inv.setItem(i++, block);
                    inv.setItem(i, block);
                }
                this.player.openInventory(inv);
                this.open = true;
            }
        }));
    }

    private static /* synthetic */ void lambda$serverMenu$25(Value servercontainer, Runnable renderer, Map servers) {
        ((List)servercontainer.value()).addAll(servers.values());
        renderer.run();
    }

    private /* synthetic */ void lambda$serverMenu$24(Value servercontainer, Runnable renderer, Pair servers) {
        if (servers == null) {
            if (this.hasHistory()) {
                this.back();
            }
        } else {
            ((List)servercontainer.value()).addAll((Collection)servers.value());
            renderer.run();
        }
    }

    private /* synthetic */ void lambda$serverMenu$23(Value hostname, Value servercontainer, Runnable renderer, Host object) {
        if (object == null) {
            if (this.hasHistory()) {
                this.back();
            }
        } else {
            hostname.value((Object)object.getDisplayName());
            ((List)servercontainer.value()).addAll(object.getSubServers().values());
            renderer.run();
        }
    }

    private /* synthetic */ void lambda$serverMenu$22(int page, Value servercontainer, String host, String group, Value hostname) {
        AgnosticScheduler.following((Entity)this.player).runs((Plugin)this.plugin, c -> {
            ItemMeta blockMeta;
            int area;
            this.setDownloading(null);
            this.lastPage = page;
            List servers = (List)servercontainer.value();
            this.lastVisitedObjects[0] = host;
            this.lastVisitedObjects[1] = group;
            this.windowHistory.add(() -> this.serverMenu(page, host, group));
            ItemStack div = this.color(15);
            ItemMeta divMeta = div.getItemMeta();
            divMeta.setDisplayName(ChatColor.RESET.toString());
            div.setItemMeta(divMeta);
            int i = 0;
            int min = (page - 1) * 36;
            int max = min + 35;
            int count = servers.size() == 0 ? 27 : (servers.size() - min >= max ? 36 : servers.size() - min);
            int n = area = count % 9 == 0 ? count : (count / 9 + 1) * 9;
            Inventory inv = Bukkit.createInventory(null, (int)(18 + area), (String)(host == null ? (group == null ? this.plugin.api.getLang("SubServers", "Interface.Server-Menu.Title") : (group.length() == 0 ? this.plugin.api.getLang("SubServers", "Interface.Group-SubServer.Title-Ungrouped") : this.plugin.api.getLang("SubServers", "Interface.Group-SubServer.Title").replace("$str$", group))) : this.plugin.api.getLang("SubServers", "Interface.Host-SubServer.Title").replace("$str$", (CharSequence)hostname.value())));
            ItemStack block = this.color(7);
            block.setItemMeta(divMeta);
            while (i < area) {
                inv.setItem(i, block);
                ++i;
            }
            ItemStack adiv = block;
            i = count < 9 ? (9 - count) / 2 : 0;
            boolean even = (count & 1) == 0 && count < 9;
            for (Server server : servers) {
                LinkedList<String> lore;
                int disabled;
                if (servers.indexOf(server) < min || servers.indexOf(server) > max) continue;
                if (even && (i == 4 || i == 13 || i == 22 || i == 31)) {
                    inv.setItem(i++, adiv);
                }
                int external = (i & 1) == 0 ? 0 : 8;
                int online = (i & 1) == 0 ? 5 : 13;
                int temp = (i & 1) == 0 ? 3 : 11;
                int offline = (i & 1) == 0 ? 4 : 1;
                int n2 = disabled = (i & 1) == 0 ? 2 : 14;
                if (!(server instanceof SubServer)) {
                    block = this.color(external);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(ChatColor.WHITE + server.getDisplayName());
                    lore = new LinkedList<String>();
                    if (!server.getName().equals(server.getDisplayName())) {
                        lore.add(ChatColor.GRAY + server.getName());
                    }
                    lore.add(this.plugin.api.getLang("SubServers", "Interface.Server-Menu.Server-External"));
                    lore.add(this.plugin.api.getLang("SubServers", "Interface.Server-Menu.Server-Player-Count").replace("$int$", new DecimalFormat("#,###").format(server.getRemotePlayers().size())));
                    lore.add(ChatColor.WHITE + (this.plugin.config.get().getMap((Object)"Settings").getBoolean((Object)"Show-Addresses", Boolean.valueOf(false)) != false ? server.getAddress().getAddress().getHostAddress() + ':' : "") + server.getAddress().getPort());
                    blockMeta.setLore(lore);
                } else if (((SubServer)server).isRunning()) {
                    int blocktype = ((SubServer)server).getStopAction() == SubServer.StopAction.REMOVE_SERVER || ((SubServer)server).getStopAction() == SubServer.StopAction.RECYCLE_SERVER || ((SubServer)server).getStopAction() == SubServer.StopAction.DELETE_SERVER ? temp : online;
                    block = this.color(blocktype);
                    blockMeta = block.getItemMeta();
                    LinkedList<String> lore2 = new LinkedList<String>();
                    if (!server.getName().equals(server.getDisplayName())) {
                        lore2.add(ChatColor.GRAY + server.getName());
                    }
                    if (((SubServer)server).getStopAction() == SubServer.StopAction.REMOVE_SERVER || ((SubServer)server).getStopAction() == SubServer.StopAction.RECYCLE_SERVER || ((SubServer)server).getStopAction() == SubServer.StopAction.DELETE_SERVER) {
                        blockMeta.setDisplayName(ChatColor.AQUA + server.getDisplayName());
                        lore2.add(this.plugin.api.getLang("SubServers", "Interface.Server-Menu.SubServer-Temporary"));
                    } else {
                        blockMeta.setDisplayName(ChatColor.GREEN + server.getDisplayName());
                    }
                    lore2.add(this.plugin.api.getLang("SubServers", "Interface.Server-Menu.Server-Player-Count").replace("$int$", new DecimalFormat("#,###").format(server.getRemotePlayers().size())));
                    lore2.add(ChatColor.WHITE + (this.plugin.config.get().getMap((Object)"Settings").getBoolean((Object)"Show-Addresses", Boolean.valueOf(false)) != false ? server.getAddress().getAddress().getHostAddress() + ':' : "") + server.getAddress().getPort());
                    blockMeta.setLore(lore2);
                } else if (((SubServer)server).isAvailable() && ((SubServer)server).isEnabled() && ((SubServer)server).getCurrentIncompatibilities().size() == 0) {
                    block = this.color(offline);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(ChatColor.YELLOW + server.getDisplayName());
                    lore = new LinkedList();
                    if (!server.getName().equals(server.getDisplayName())) {
                        lore.add(ChatColor.GRAY + server.getName());
                    }
                    lore.add(this.plugin.api.getLang("SubServers", "Interface.Server-Menu.SubServer-Offline"));
                    lore.add(ChatColor.WHITE + (this.plugin.config.get().getMap((Object)"Settings").getBoolean((Object)"Show-Addresses", Boolean.valueOf(false)) != false ? server.getAddress().getAddress().getHostAddress() + ':' : "") + server.getAddress().getPort());
                    blockMeta.setLore(lore);
                } else {
                    block = this.color(disabled);
                    blockMeta = block.getItemMeta();
                    blockMeta.setDisplayName(ChatColor.RED + server.getDisplayName());
                    lore = new LinkedList();
                    if (!server.getName().equals(server.getDisplayName())) {
                        lore.add(ChatColor.GRAY + server.getName());
                    }
                    if (((SubServer)server).getCurrentIncompatibilities().size() != 0) {
                        String list = "";
                        for (String other : ((SubServer)server).getCurrentIncompatibilities()) {
                            if (list.length() != 0) {
                                list = list + ", ";
                            }
                            list = list + other;
                        }
                        lore.add(this.plugin.api.getLang("SubServers", "Interface.Server-Menu.SubServer-Incompatible").replace("$str$", list));
                    }
                    if (!((SubServer)server).isAvailable() || !((SubServer)server).isEnabled()) {
                        lore.add(this.plugin.api.getLang("SubServers", !((SubServer)server).isAvailable() ? "Interface.Server-Menu.SubServer-Unavailable" : "Interface.Server-Menu.SubServer-Disabled"));
                    }
                    lore.add(ChatColor.WHITE + (this.plugin.config.get().getMap((Object)"Settings").getBoolean((Object)"Show-Addresses", Boolean.valueOf(false)) != false ? server.getAddress().getAddress().getHostAddress() + ':' : "") + server.getAddress().getPort());
                    blockMeta.setLore(lore);
                }
                block.setItemMeta(blockMeta);
                inv.setItem(i, block);
                if (--count < 9 && (i == 8 || i == 17 || i == 26)) {
                    i += (9 - count) / 2 + 1;
                    even = (count & 1) == 0;
                    continue;
                }
                ++i;
            }
            if (servers.size() == 0) {
                block = this.color(14);
                blockMeta = block.getItemMeta();
                blockMeta.setDisplayName(this.plugin.api.getLang("SubServers", "Interface.Server-Menu.No-Servers"));
                block.setItemMeta(blockMeta);
                inv.setItem(12, block);
                inv.setItem(13, block);
                inv.setItem(14, block);
            }
            for (i = inv.getSize() - 18; i < inv.getSize(); ++i) {
                inv.setItem(i, div);
            }
            i = inv.getSize() - 9;
            if (min != 0) {
                block = this.color(4);
                blockMeta = block.getItemMeta();
                blockMeta.setDisplayName(this.plugin.api.getLang("SubServers", "Interface.Generic.Back-Arrow"));
                block.setItemMeta(blockMeta);
                inv.setItem(i++, block);
                inv.setItem(i++, block);
            } else {
                i += 2;
            }
            ++i;
            if (host == null || group == null || this.hasHistory()) {
                block = this.color(host == null && group == null ? 11 : 14);
                blockMeta = block.getItemMeta();
                blockMeta.setDisplayName(host == null && group == null ? this.plugin.api.getLang("SubServers", "Interface.Server-Menu.Host-Menu") : this.plugin.api.getLang("SubServers", "Interface.Generic.Back"));
                block.setItemMeta(blockMeta);
                inv.setItem(i++, block);
                inv.setItem(i++, block);
                inv.setItem(i++, block);
                ++i;
            }
            if (servers.size() - 1 > max) {
                block = this.color(4);
                blockMeta = block.getItemMeta();
                blockMeta.setDisplayName(this.plugin.api.getLang("SubServers", "Interface.Generic.Next-Arrow"));
                block.setItemMeta(blockMeta);
                inv.setItem(i++, block);
                inv.setItem(i, block);
            }
            this.player.openInventory(inv);
            this.open = true;
        });
    }
}

