/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Client.Bukkit.Library;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.ME1312.Galaxi.Library.Container.ContainedPair;
import net.ME1312.Galaxi.Library.Container.Container;
import net.ME1312.Galaxi.Library.Container.Pair;
import net.ME1312.Galaxi.Library.Map.ObjectMap;
import net.ME1312.Galaxi.Library.Merger;
import net.ME1312.Galaxi.Library.Try;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.SubServers.Client.Bukkit.Event.SubAddHostEvent;
import net.ME1312.SubServers.Client.Bukkit.Event.SubAddProxyEvent;
import net.ME1312.SubServers.Client.Bukkit.Event.SubAddServerEvent;
import net.ME1312.SubServers.Client.Bukkit.Event.SubEditServerEvent;
import net.ME1312.SubServers.Client.Bukkit.Event.SubStartEvent;
import net.ME1312.SubServers.Client.Bukkit.Event.SubStartedEvent;
import net.ME1312.SubServers.Client.Bukkit.Event.SubStopEvent;
import net.ME1312.SubServers.Client.Bukkit.Event.SubStoppedEvent;
import net.ME1312.SubServers.Client.Bukkit.Library.Compatibility.AgnosticScheduler;
import net.ME1312.SubServers.Client.Bukkit.SubAPI;
import net.ME1312.SubServers.Client.Bukkit.SubPlugin;
import net.ME1312.SubServers.Client.Common.Network.API.Host;
import net.ME1312.SubServers.Client.Common.Network.API.Proxy;
import net.ME1312.SubServers.Client.Common.Network.API.Server;
import net.ME1312.SubServers.Client.Common.Network.API.SubCreator;
import net.ME1312.SubServers.Client.Common.Network.API.SubServer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public final class Placeholders {
    private final CopyOnWriteArrayList<Runnable> listeners;
    private final SubPlugin plugin;
    public final Cache cache;
    private MethodHandle papi;
    private Runnable task;
    private boolean init;
    private static final Pattern replacements = Pattern.compile("#?([^\\s#]+?\\(.*?\\))|\\$([^$]+)\\$", 2);

    public Placeholders(SubPlugin plugin) {
        this.plugin = plugin;
        this.listeners = new CopyOnWriteArrayList();
        this.cache = new Cache();
        this.init = false;
    }

    public void start() {
        if (!this.init) {
            this.init = true;
            this.papi = (MethodHandle)Try.all.get(() -> MethodHandles.publicLookup().findStatic(Class.forName("me.clip.placeholderapi.PlaceholderAPI"), "setPlaceholders", MethodType.methodType(String.class, new Class[]{OfflinePlayer.class, String.class})));
            Bukkit.getPluginManager().registerEvents(this.cache.events, (Plugin)this.plugin);
            AgnosticScheduler.async.runs((Plugin)this.plugin, c -> {
                if (this.task == null) {
                    int interval = this.plugin.config.get().getMap((Object)"Settings").getInt((Object)"PlaceholderAPI-Cache-Interval", Integer.valueOf(30));
                    int start = interval - new Random().nextInt(interval + 1);
                    Consumer<Runnable> task = c2 -> this.cache.refresh(() -> {
                        for (Runnable listener : this.listeners) {
                            try {
                                listener.run();
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    this.task = AgnosticScheduler.async.repeats((Plugin)this.plugin, task, start, interval, TimeUnit.SECONDS);
                    task.accept(null);
                }
            }, 6L, TimeUnit.SECONDS);
        }
    }

    public void stop() {
        if (this.task != null) {
            try {
                this.task.run();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.task = null;
        }
    }

    public void clear() {
        this.cache.reset();
    }

    public void listen(Runnable task) {
        this.listeners.add(task);
    }

    public String request(OfflinePlayer player, String request) {
        String response;
        boolean colored;
        boolean bl = colored = !request.startsWith("plain_");
        if (!colored || request.startsWith("color_")) {
            request = request.substring(6);
        }
        if (!this.init) {
            this.start();
        }
        if ((response = this.runMethod(player, request)) != null && !colored) {
            return ChatColor.stripColor((String)response);
        }
        return response;
    }

    private String[] arguments(OfflinePlayer player, String text, boolean replace) {
        LinkedList<String> arguments = new LinkedList<String>();
        if (text != null && !text.isEmpty()) {
            Pattern p = replacements;
            Matcher m = p.matcher(text);
            StringBuilder argument = new StringBuilder();
            while (m.find()) {
                String[] replacement = this.findMethod(player, text, m.start(), replace);
                if (replacement[0].contains(",")) {
                    String[] s = replacement[0].split(",");
                    argument.append(s[0]);
                    arguments.add(argument.toString().trim());
                    for (int i = 1; i < s.length - 1; ++i) {
                        arguments.add(s[i].trim());
                    }
                    argument = new StringBuilder();
                    argument.append(s[s.length - 1]);
                } else {
                    argument.append(replacement[0]);
                }
                argument.append(replacement[1]);
                text = replacement[2];
                m = p.matcher(text);
            }
            if (text.contains(",")) {
                String[] s = text.split(",");
                argument.append(s[0]);
                arguments.add(argument.toString().trim());
                argument = null;
                for (int i = 1; i < s.length; ++i) {
                    arguments.add(s[i].trim());
                }
            } else if (text.length() > 0) {
                argument.append(text);
            }
            if (argument != null && argument.length() > 0) {
                arguments.add(argument.toString().trim());
            }
        }
        return arguments.toArray(new String[0]);
    }

    public String replace(OfflinePlayer player, String text) {
        if (text != null) {
            Pattern p = replacements;
            Matcher m = p.matcher(text);
            StringBuilder str = new StringBuilder();
            while (m.find()) {
                String[] replacement = this.findMethod(player, text, m.start(), true);
                str.append(replacement[0]);
                str.append(replacement[1]);
                text = replacement[2];
                m = p.matcher(text);
            }
            str.append(text);
            return str.toString();
        }
        return null;
    }

    private String[] findMethod(OfflinePlayer player, String text, int start, boolean run) {
        CharSequence str;
        String[] values = new String[3];
        values[0] = text.substring(0, start);
        text = text.substring(start);
        int[] open = new int[]{40, 60};
        int[] close = new int[]{41, 62};
        Arrays.sort(open);
        Arrays.sort(close);
        int i = -1;
        if (text.codePointAt(0) == 36) {
            Matcher m = Pattern.compile("^\\$([^$]+)\\$", 2).matcher(text);
            if (m.find()) {
                str = '%' + m.group(1) + '%';
                text = text.substring(m.end());
                if (run) {
                    String response = this.papi == null ? null : (String)Try.all.get(() -> this.lambda$findMethod$4(player, (String)str));
                    values[1] = response == null ? m.group() : response;
                } else {
                    values[1] = m.group();
                }
            }
        } else {
            String response;
            ++i;
            boolean responses = false;
            str = new StringBuilder();
            int level = 0;
            while ((long)i < text.codePoints().count()) {
                int c = text.codePointAt(i);
                ((StringBuilder)str).appendCodePoint(c);
                if (Arrays.binarySearch(open, c) >= 0) {
                    ++level;
                } else if (Arrays.binarySearch(close, c) >= 0 && --level <= 0) {
                    if (responses) break;
                    boolean more = false;
                    int ix = i + 1;
                    while ((long)ix < text.codePoints().count()) {
                        int cx = text.codePointAt(ix);
                        if (!Character.isWhitespace(cx) && cx != 95) {
                            more = cx == 60;
                            break;
                        }
                        ++ix;
                    }
                    if (!more) break;
                    responses = true;
                }
                ++i;
            }
            values[1] = run ? ((response = this.runMethod(player, ((StringBuilder)str).toString())) == null ? ((StringBuilder)str).toString() : response) : ((StringBuilder)str).toString();
        }
        StringBuilder str2 = new StringBuilder();
        ++i;
        while ((long)i < text.codePoints().count()) {
            str2.appendCodePoint(text.codePointAt(i));
            ++i;
        }
        values[2] = str2.toString();
        return values;
    }

    private String[] parseMethod(OfflinePlayer player, String text) {
        Matcher m = Pattern.compile("^#?(.+?)(?:[\\s_]*\\((.*?)\\))?(?:[\\s_]*<(.*)>)?$", 2).matcher(text);
        if (m.find()) {
            String[] values = new String[3];
            values[0] = m.group(1);
            if (m.group(2) == null || m.group(2).trim().isEmpty() || m.group(3) == null || m.group(3).trim().isEmpty()) {
                values[1] = m.group(2);
                values[2] = m.group(3);
            } else {
                text = text.substring(m.end(1));
                int stage = 1;
                int level = 0;
                int i = 0;
                int open = 40;
                int close = 41;
                boolean responses = false;
                StringBuilder str = new StringBuilder();
                while ((long)i < text.codePoints().count()) {
                    int c = text.codePointAt(i);
                    if (c == open) {
                        if (level > 0) {
                            str.appendCodePoint(c);
                        }
                        ++level;
                    } else if (c == close) {
                        if (--level > 0) {
                            str.appendCodePoint(c);
                        } else {
                            if (responses) break;
                            boolean more = false;
                            int ix = i + 1;
                            while ((long)ix < text.codePoints().count()) {
                                int cx = text.codePointAt(ix);
                                if (!Character.isWhitespace(cx) && cx != 95) {
                                    more = cx == 60;
                                    break;
                                }
                                ++ix;
                            }
                            if (!more) break;
                            responses = true;
                            open = 60;
                            close = 62;
                            values[stage++] = str.toString();
                            str = new StringBuilder();
                        }
                    } else if (level > 0) {
                        str.appendCodePoint(c);
                    }
                    ++i;
                }
                values[stage] = str.toString();
                if (level > 0 || (long)(++i) < text.codePoints().count()) {
                    return null;
                }
            }
            return values;
        }
        return null;
    }

    private String runMethod(OfflinePlayer player, String text) {
        String[] parsed = this.parseMethod(player, text);
        if (parsed != null) {
            String method = parsed[0];
            String[] args = this.arguments(player, parsed[1], true);
            String[] responses = this.arguments(player, parsed[2], false);
            for (int i = 0; i < responses.length; ++i) {
                responses[i] = ChatColor.translateAlternateColorCodes((char)'&', (String)responses[i].trim());
            }
            return this.replace(player, this.runMethod(player, method, args, responses));
        }
        return null;
    }

    private String runMethod(OfflinePlayer player, String method, String[] args, String[] responses) {
        Server server = this.plugin.api.getName() != null ? this.cache.getServer(this.plugin.api.getName()) : null;
        SubServer subserver = server instanceof SubServer ? (SubServer)server : null;
        Pair<String, List<Server>> group = null;
        Host host = subserver != null ? this.cache.getHost(subserver.getHost()) : null;
        Proxy proxy = this.cache.getMasterProxy();
        if ((method = method.toLowerCase()).startsWith("proxy.")) {
            if (args.length > 0 && !args[0].isEmpty()) {
                proxy = this.cache.getProxy(args[0]);
            }
            if (proxy == null) {
                return null;
            }
        } else if (method.startsWith("host.")) {
            if (args.length > 0 && !args[0].isEmpty()) {
                host = this.cache.getHost(args[0]);
            }
            if (host == null) {
                return null;
            }
        } else if (method.startsWith("group.")) {
            if (args.length > 0 && !args[0].isEmpty()) {
                group = this.cache.getGroup(args[0]);
            }
        } else if (method.startsWith("server.")) {
            if (args.length > 0 && !args[0].isEmpty()) {
                server = this.cache.getServer(args[0]);
            }
            if (server == null) {
                return null;
            }
        } else if (method.startsWith("subserver.")) {
            if (args.length > 0 && !args[0].isEmpty()) {
                subserver = this.cache.getSubServer(args[0]);
                server = subserver;
            }
            if (subserver == null) {
                return null;
            }
        }
        if (method.startsWith("subserver.host")) {
            if (method.equals("subserver.host")) {
                return subserver.getHost();
            }
            LinkedList<String> arguments = new LinkedList<String>();
            arguments.addAll(Arrays.asList(args));
            if (args.length > 0) {
                arguments.removeFirst();
            }
            arguments.addFirst(subserver.getHost());
            return this.runMethod(player, method.substring(10), arguments.toArray(new String[0]), responses);
        }
        if (method.startsWith("subserver.template")) {
            if (method.equals("subserver.template")) {
                return subserver.getTemplate() != null ? subserver.getTemplate() : Placeholders.defaults(responses, "(custom)")[0];
            }
            if (subserver.getTemplate() != null) {
                LinkedList<String> arguments = new LinkedList<String>();
                arguments.addAll(Arrays.asList(args));
                if (args.length > 0) {
                    arguments.removeFirst();
                }
                arguments.addFirst(subserver.getTemplate());
                arguments.addFirst(subserver.getHost());
                return this.runMethod(player, "host.creator." + method.substring(10), arguments.toArray(new String[0]), responses);
            }
            return null;
        }
        switch (method) {
            case "example": {
                return Placeholders.defaults(responses, ChatColor.LIGHT_PURPLE + "Example!")[0];
            }
            case "players": {
                int i = this.cache.getMasterProxy().getPlayers().size();
                for (Proxy p : this.cache.getProxies().values()) {
                    i += p.getPlayers().size();
                }
                return Integer.toString(i);
            }
            case "proxy": 
            case "proxies": {
                return Integer.toString(this.cache.getProxies().size() + 1);
            }
            case "proxy.displayname": {
                return proxy.getDisplayName();
            }
            case "proxy.type": {
                return Placeholders.defaults(responses, "Master Proxy", "Proxy")[proxy.isMaster() ? 0 : 1];
            }
            case "proxy.players": {
                return Integer.toString(proxy.getPlayers().size());
            }
            case "proxy.subdata": {
                return Placeholders.defaults(responses, ChatColor.GREEN + "Connected", ChatColor.RED + "Disconnected")[proxy.getSubData()[0] == null ? 1 : 0];
            }
            case "proxy.subdata.channels": 
            case "proxy.subdata.subchannels": {
                return Integer.toString(proxy.getSubData().length - (method.endsWith(".subchannels") ? 1 : 0));
            }
            case "proxy.signature": {
                return proxy.getSignature();
            }
            case "host": 
            case "hosts": {
                return Integer.toString(this.cache.getHosts().size());
            }
            case "host.displayname": {
                return host.getDisplayName();
            }
            case "host.available": {
                return Placeholders.defaults(responses, ChatColor.GREEN + "Available", ChatColor.RED + "Unavailable")[host.isAvailable() ? 0 : 1];
            }
            case "host.enabled": {
                return Placeholders.defaults(responses, ChatColor.GREEN + "Enabled", ChatColor.RED + "Disabled")[host.isEnabled() ? 0 : 1];
            }
            case "host.address": {
                return host.getAddress().getHostAddress();
            }
            case "host.creator.template": 
            case "host.subcreator.template": 
            case "host.creator.templates": 
            case "host.subcreator.templates": {
                return Integer.toString(host.getCreator().getTemplates().size());
            }
            case "host.creator.template.displayname": 
            case "host.subcreator.template.displayname": {
                SubCreator.ServerTemplate template;
                SubCreator.ServerTemplate serverTemplate = template = args.length > 1 && !args[1].isEmpty() ? host.getCreator().getTemplate(args[1]) : null;
                if (template != null) {
                    return template.getDisplayName();
                }
                return null;
            }
            case "host.creator.template.enabled": 
            case "host.subcreator.template.enabled": {
                SubCreator.ServerTemplate template;
                SubCreator.ServerTemplate serverTemplate = template = args.length > 1 && !args[1].isEmpty() ? host.getCreator().getTemplate(args[1]) : null;
                if (template != null) {
                    return Placeholders.defaults(responses, ChatColor.GREEN + "Enabled", ChatColor.RED + "Disabled")[template.isEnabled() ? 0 : 1];
                }
                return null;
            }
            case "host.creator.template.type": 
            case "host.subcreator.template.type": {
                SubCreator.ServerTemplate template;
                SubCreator.ServerTemplate serverTemplate = template = args.length > 1 && !args[1].isEmpty() ? host.getCreator().getTemplate(args[1]) : null;
                if (template != null) {
                    return template.getType().toString();
                }
                return null;
            }
            case "host.creator.template.requiresversion": 
            case "host.subcreator.template.requiresversion": {
                SubCreator.ServerTemplate template;
                SubCreator.ServerTemplate serverTemplate = template = args.length > 1 && !args[1].isEmpty() ? host.getCreator().getTemplate(args[1]) : null;
                if (template != null) {
                    return Placeholders.defaults(responses, ChatColor.GREEN + "Optional", ChatColor.YELLOW + "Required")[template.requiresVersion() ? 1 : 0];
                }
                return null;
            }
            case "host.creator.template.updatable": 
            case "host.subcreator.template.updatable": {
                SubCreator.ServerTemplate template;
                SubCreator.ServerTemplate serverTemplate = template = args.length > 1 && !args[1].isEmpty() ? host.getCreator().getTemplate(args[1]) : null;
                if (template != null) {
                    return Placeholders.defaults(responses, ChatColor.GREEN + "Updatable", ChatColor.RED + "Not Updatable")[template.canUpdate() ? 0 : 1];
                }
                return null;
            }
            case "host.servers": 
            case "host.subservers": {
                return Integer.toString(host.getSubServers().size());
            }
            case "host.players": {
                return Integer.toString(host.getRemotePlayers().size());
            }
            case "host.subdata": {
                return Placeholders.defaults(responses, ChatColor.GREEN + "Connected", ChatColor.YELLOW + "Unsupported", ChatColor.RED + "Disconnected")[host.getSubData().length <= 0 ? 1 : (host.getSubData()[0] == null ? 2 : 0)];
            }
            case "host.subdata.channels": 
            case "host.subdata.subchannels": {
                return Integer.toString(Math.max(host.getSubData().length - (method.endsWith(".subchannels") ? 1 : 0), 0));
            }
            case "host.signature": {
                return host.getSignature();
            }
            case "group": 
            case "groups": {
                return Integer.toString(this.cache.getGroups().size());
            }
            case "group.servers": {
                return Integer.toString(group == null ? 0 : ((List)group.value()).size());
            }
            case "group.players": {
                int i = 0;
                if (group != null) {
                    for (Server s : (List)group.value()) {
                        i += s.getRemotePlayers().size();
                    }
                }
                return Integer.toString(i);
            }
            case "server": 
            case "servers": {
                return Integer.toString(this.cache.getServers().size());
            }
            case "server.displayname": 
            case "subserver.displayname": {
                return server.getDisplayName();
            }
            case "server.type": 
            case "subserver.type": {
                return Placeholders.defaults(responses, "Subserver", "Server")[server instanceof SubServer ? 0 : 1];
            }
            case "server.groups": 
            case "subserver.groups": {
                return Integer.toString(server.getGroups().size());
            }
            case "server.address": 
            case "subserver.address": {
                return server.getAddress().getAddress().getHostAddress() + ':' + server.getAddress().getPort();
            }
            case "server.motd": 
            case "subserver.motd": {
                return server.getMotd();
            }
            case "server.restricted": 
            case "subserver.restricted": {
                return Placeholders.defaults(responses, ChatColor.GREEN + "Public", ChatColor.RED + "Private")[server.isRestricted() ? 1 : 0];
            }
            case "server.hidden": 
            case "subserver.hidden": {
                return Placeholders.defaults(responses, ChatColor.GREEN + "Visible", ChatColor.RED + "Hidden")[server.isHidden() ? 1 : 0];
            }
            case "server.players": 
            case "subserver.players": {
                return Integer.toString(server.getRemotePlayers().size());
            }
            case "server.subdata": 
            case "subserver.subdata": {
                return Placeholders.defaults(responses, ChatColor.GREEN + "Connected", ChatColor.RED + "Disconnected")[server.getSubData()[0] == null ? 1 : 0];
            }
            case "server.subdata.channels": 
            case "subserver.subdata.channels": 
            case "server.subdata.subchannels": 
            case "subserver.subdata.subchannels": {
                return Integer.toString(server.getSubData().length - (method.endsWith(".subchannels") ? 1 : 0));
            }
            case "server.signature": 
            case "subserver.signature": {
                return server.getSignature();
            }
            case "subserver": 
            case "subservers": {
                return Integer.toString(this.cache.getSubServers().size());
            }
            case "subserver.available": {
                return Placeholders.defaults(responses, ChatColor.GREEN + "Available", ChatColor.RED + "Unavailable")[subserver.isAvailable() ? 0 : 1];
            }
            case "subserver.enabled": {
                return Placeholders.defaults(responses, ChatColor.GREEN + "Enabled", ChatColor.RED + "Disabled")[subserver.isEnabled() ? 0 : 1];
            }
            case "subserver.editable": {
                return Placeholders.defaults(responses, ChatColor.GREEN + "Editable", ChatColor.RED + "Locked")[subserver.isEditable() ? 0 : 1];
            }
            case "subserver.running": {
                return Placeholders.defaults(responses, ChatColor.GREEN + "Running", ChatColor.RED + "Offline")[subserver.isRunning() ? 0 : 1];
            }
            case "subserver.online": {
                return Placeholders.defaults(responses, ChatColor.GREEN + "Online", ChatColor.YELLOW + "Starting", ChatColor.RED + "Offline")[subserver.isOnline() ? 0 : (subserver.isRunning() ? 1 : 2)];
            }
            case "subserver.logging": {
                return Placeholders.defaults(responses, ChatColor.GREEN + "Logging", ChatColor.RED + "Muted")[subserver.isLogging() ? 0 : 1];
            }
            case "subserver.temporary": {
                return Placeholders.defaults(responses, ChatColor.GREEN + "Permanent", ChatColor.AQUA + "Temporary")[subserver.getStopAction() == SubServer.StopAction.REMOVE_SERVER || subserver.getStopAction() == SubServer.StopAction.RECYCLE_SERVER || subserver.getStopAction() == SubServer.StopAction.DELETE_SERVER ? 1 : 0];
            }
            case "subserver.stopaction": {
                return subserver.getStopAction().toString();
            }
            case "subserver.incompatibilities": 
            case "subserver.incompatibilities.current": {
                List list = method.endsWith(".current") ? subserver.getCurrentIncompatibilities() : subserver.getIncompatibilities();
                return Integer.toString(list.size());
            }
        }
        return null;
    }

    private static String[] defaults(String[] overrides, String ... defaults) {
        for (int i = 0; i < defaults.length; ++i) {
            defaults[i] = (i < overrides.length && overrides[i].length() > 0 ? overrides : defaults)[i];
        }
        return defaults;
    }

    private /* synthetic */ String lambda$findMethod$4(OfflinePlayer player, String str) throws Throwable {
        return this.papi.invokeExact(player, str);
    }

    public final class Cache {
        private Map<String, Proxy> proxies = new TreeMap<String, Proxy>();
        private Map<String, Host> hosts = new TreeMap<String, Host>();
        private Map<String, Server> servers = new TreeMap<String, Server>();
        private Proxy master = null;
        private Listener events = new Events();

        private void reset() {
            this.proxies.clear();
            this.hosts.clear();
            this.servers.clear();
            this.master = null;
        }

        private void refresh(Runnable callback) {
            if (SubAPI.getInstance().getSubDataNetwork()[0] != null) {
                Container order = new Container(null);
                Merger async = new Merger(() -> {
                    try {
                        for (Host host : this.hosts.values()) {
                            Map servers = (Map)Util.reflect((Field)Host.class.getDeclaredField("servers"), (Object)host);
                            if (((Boolean)order.value).booleanValue()) {
                                this.servers.putAll(servers);
                                continue;
                            }
                            servers.replaceAll((name, existing) -> {
                                Server server = this.servers.getOrDefault(name, null);
                                return server instanceof SubServer ? (SubServer)server : existing;
                            });
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    callback.run();
                });
                async.reserve(4);
                SubAPI.getInstance().getProxies(proxies -> {
                    this.proxies = proxies;
                    async.release();
                });
                SubAPI.getInstance().getMasterProxy(master -> {
                    this.master = master;
                    async.release();
                });
                SubAPI.getInstance().getHosts(hosts -> {
                    order.value = true;
                    this.hosts = hosts;
                    async.release();
                });
                SubAPI.getInstance().getServers(servers -> {
                    order.value = false;
                    this.servers = servers;
                    async.release();
                });
            }
        }

        public Map<String, Proxy> getProxies() {
            return this.proxies;
        }

        public Proxy getProxy(String name) {
            Util.nullpo((Object)name);
            Proxy proxy = this.getProxies().getOrDefault(name.toLowerCase(), null);
            if (proxy == null && this.master != null && this.master.getName().equalsIgnoreCase(name)) {
                proxy = this.master;
            }
            return proxy;
        }

        public Proxy getMasterProxy() {
            return this.master;
        }

        public Map<String, Host> getHosts() {
            return this.hosts;
        }

        public Host getHost(String name) {
            Util.nullpo((Object)name);
            return this.getHosts().getOrDefault(name.toLowerCase(), null);
        }

        public Map<String, List<Server>> getGroups() {
            TreeMap<String, List<Server>> groups = new TreeMap<String, List<Server>>();
            HashMap<String, String> conflitresolver = new HashMap<String, String>();
            for (Server server : this.getServers().values()) {
                Iterator iterator = server.getGroups().iterator();
                while (iterator.hasNext()) {
                    String name;
                    String group = name = (String)iterator.next();
                    if (conflitresolver.containsKey(name.toLowerCase())) {
                        group = (String)conflitresolver.get(name.toLowerCase());
                    } else {
                        conflitresolver.put(name.toLowerCase(), name);
                    }
                    List<Object> list = groups.containsKey(group) ? groups.get(group) : new ArrayList();
                    list.add(server);
                    groups.put(group, list);
                }
            }
            return groups;
        }

        public Map<String, List<Server>> getLowercaseGroups() {
            Map<String, List<Server>> groups = this.getGroups();
            TreeMap<String, List<Server>> lowercaseGroups = new TreeMap<String, List<Server>>();
            for (String key : groups.keySet()) {
                lowercaseGroups.put(key.toLowerCase(), groups.get(key));
            }
            return lowercaseGroups;
        }

        public Pair<String, List<Server>> getGroup(String name) {
            Util.nullpo((Object)name);
            for (Map.Entry<String, List<Server>> group : this.getLowercaseGroups().entrySet()) {
                if (!group.getKey().equalsIgnoreCase(name)) continue;
                return new ContainedPair((Object)group.getKey(), group.getValue());
            }
            return null;
        }

        public Map<String, Server> getServers() {
            return this.servers;
        }

        public Server getServer(String name) {
            Util.nullpo((Object)name);
            return this.getServers().getOrDefault(name.toLowerCase(), null);
        }

        public Map<String, SubServer> getSubServers() {
            TreeMap<String, SubServer> servers = new TreeMap<String, SubServer>();
            for (Map.Entry<String, Server> server : this.servers.entrySet()) {
                if (!(server.getValue() instanceof SubServer)) continue;
                servers.put(server.getKey(), (SubServer)server.getValue());
            }
            return servers;
        }

        public SubServer getSubServer(String name) {
            Util.nullpo((Object)name);
            return this.getSubServers().getOrDefault(name.toLowerCase(), null);
        }

        private final class Events
        implements Listener {
            private HashMap<String, Runnable> edits = new HashMap();

            private Events() {
            }

            @EventHandler(priority=EventPriority.LOWEST)
            public void add(SubAddProxyEvent e) {
                SubAPI.getInstance().getProxy(e.getProxy(), proxy -> {
                    if (proxy != null) {
                        Cache.this.proxies.put(proxy.getName().toLowerCase(), proxy);
                    }
                });
            }

            @EventHandler(priority=EventPriority.LOWEST)
            public void add(SubAddHostEvent e) {
                SubAPI.getInstance().getHost(e.getHost(), host -> {
                    if (host != null) {
                        Cache.this.hosts.put(host.getName().toLowerCase(), host);
                    }
                });
            }

            @EventHandler(priority=EventPriority.LOWEST)
            public void add(SubAddServerEvent e) {
                this.add(e.getServer());
            }

            public void add(String s) {
                SubAPI.getInstance().getServer(s, server -> {
                    if (server != null) {
                        Cache.this.servers.put(server.getName().toLowerCase(), server);
                    }
                });
            }

            @EventHandler(priority=EventPriority.LOWEST)
            public void edit(SubEditServerEvent e) {
                String s = e.getServer().toLowerCase();
                if (this.edits.containsKey(s)) {
                    this.edits.get(s).run();
                }
                this.edits.put(s, AgnosticScheduler.async.runs((Plugin)Placeholders.this.plugin, Cache.this.servers.containsKey(s) ? c -> ((Server)Cache.this.servers.get(s)).refresh() : c -> this.add(s), 6L, TimeUnit.SECONDS));
            }

            @EventHandler(priority=EventPriority.LOWEST)
            public void start(SubStartEvent e) {
                Server server = Cache.this.getServer(e.getServer());
                if (server != null) {
                    Try.all.run(() -> ((ObjectMap)Util.reflect((Field)Server.class.getDeclaredField("raw"), (Object)server)).set((Object)"running", (Object)true));
                    server.refresh();
                } else {
                    this.add(e.getServer());
                }
            }

            @EventHandler(priority=EventPriority.LOWEST)
            public void started(SubStartedEvent e) {
                Server server = Cache.this.getServer(e.getServer());
                if (server != null) {
                    Try.all.run(() -> ((ObjectMap)Util.reflect((Field)Server.class.getDeclaredField("raw"), (Object)server)).set((Object)"online", (Object)true));
                    server.refresh();
                } else {
                    this.add(e.getServer());
                }
            }

            @EventHandler(priority=EventPriority.LOWEST)
            public void stopping(SubStopEvent e) {
                Server server = Cache.this.getServer(e.getServer());
                if (server != null) {
                    Try.all.run(() -> ((ObjectMap)Util.reflect((Field)Server.class.getDeclaredField("raw"), (Object)server)).set((Object)"stopping", (Object)true));
                    server.refresh();
                } else {
                    this.add(e.getServer());
                }
            }

            @EventHandler(priority=EventPriority.LOWEST)
            public void stopped(SubStoppedEvent e) {
                Server server = Cache.this.getServer(e.getServer());
                if (server != null) {
                    Try.all.run(() -> {
                        ObjectMap raw = (ObjectMap)Util.reflect((Field)Server.class.getDeclaredField("raw"), (Object)server);
                        raw.set((Object)"online", (Object)false);
                        raw.set((Object)"running", (Object)false);
                        raw.set((Object)"stopping", (Object)false);
                        server.refresh();
                    });
                } else {
                    this.add(e.getServer());
                }
            }
        }
    }
}

