/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubData.Client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import net.ME1312.Galaxi.Library.Container.Pair;
import net.ME1312.Galaxi.Library.Map.ObjectMap;
import net.ME1312.SubData.Client.DataProtocol;
import net.ME1312.SubData.Client.DataSender;
import net.ME1312.SubData.Client.Library.DisconnectReason;
import net.ME1312.SubData.Client.Library.PingResponse;
import net.ME1312.SubData.Client.Protocol.MessageOut;

public abstract class DataClient
implements DataSender {
    public final Events on = new Events();
    private UUID id;

    public abstract void getClient(UUID var1, Consumer<ObjectMap<String>> var2);

    public abstract void getClients(Consumer<Map<UUID, ObjectMap<String>>> var1);

    @Override
    public abstract void ping(Consumer<PingResponse> var1);

    public abstract void ping(UUID var1, Consumer<PingResponse> var2);

    @Override
    public abstract void sendMessage(MessageOut ... var1);

    public abstract void forwardMessage(UUID var1, MessageOut ... var2);

    public abstract int getBlockSize();

    public abstract void tempBlockSize(Integer var1);

    @Override
    @Deprecated
    public DataClient getConnection() {
        return this;
    }

    @Override
    public abstract DataProtocol getProtocol();

    @Override
    public UUID getID() {
        return this.id;
    }

    public abstract InetSocketAddress getAddress();

    public abstract DataClient newChannel() throws IOException;

    public abstract void close() throws IOException;

    public void waitFor() throws InterruptedException {
        while (!this.isClosed()) {
            Thread.sleep(125L);
        }
    }

    public abstract boolean isClosed();

    public static class Events {
        LinkedList<Consumer<DataClient>> ready = new LinkedList();
        LinkedList<Function<DataClient, Boolean>> close = new LinkedList();
        LinkedList<Consumer<Pair<DisconnectReason, DataClient>>> closed = new LinkedList();

        private Events() {
        }

        @SafeVarargs
        public final void ready(Consumer<DataClient> ... callbacks) {
            this.ready.addAll(Arrays.asList(callbacks));
        }

        @SafeVarargs
        public final void close(Function<DataClient, Boolean> ... callbacks) {
            this.close.addAll(Arrays.asList(callbacks));
        }

        @SafeVarargs
        public final void closed(Consumer<Pair<DisconnectReason, DataClient>> ... callbacks) {
            this.closed.addAll(Arrays.asList(callbacks));
        }
    }
}

