/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubData.Client.Library;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import net.ME1312.Galaxi.Library.Map.ObjectMap;
import org.msgpack.value.MapValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;

public class MessageData {
    public static MapValue pack(ObjectMap<?> map) {
        return (MapValue)MessageData.complicate(map.get());
    }

    private static Value complicate(Object value) {
        if (value == null) {
            return ValueFactory.newNil();
        }
        if (value instanceof Value) {
            return (Value)value;
        }
        if (value instanceof Map) {
            ValueFactory.MapBuilder map = ValueFactory.newMapBuilder();
            for (Object key : ((Map)value).keySet()) {
                Value k = MessageData.complicate(key);
                Value v = MessageData.complicate(((Map)value).get(key));
                if (v == null) continue;
                map.put(k, v);
            }
            return map.build();
        }
        if (value instanceof Collection) {
            LinkedList<Value> values = new LinkedList<Value>();
            for (Object object : (Collection)value) {
                Value v = MessageData.complicate(object);
                if (v == null) continue;
                values.add(v);
            }
            return ValueFactory.newArray(values);
        }
        if (value instanceof Boolean) {
            return ValueFactory.newBoolean((boolean)((Boolean)value));
        }
        if (value instanceof Number) {
            if (((Number)value).doubleValue() == (double)((long)((Number)value).doubleValue())) {
                return ValueFactory.newInteger((long)((Number)value).longValue());
            }
            return ValueFactory.newFloat((double)((Number)value).doubleValue());
        }
        if (value instanceof String) {
            return ValueFactory.newString((String)((String)value));
        }
        return null;
    }

    public static <K> ObjectMap<K> unpack(MapValue msgpack) {
        return (ObjectMap)MessageData.simplify((Value)msgpack, false);
    }

    private static Object simplify(Value value, boolean asKey) {
        if (value.isNilValue()) {
            return null;
        }
        if (value.isMapValue()) {
            ObjectMap section = new ObjectMap();
            Map map = value.asMapValue().map();
            for (Value key : map.keySet()) {
                section.set(MessageData.simplify(key, true), MessageData.simplify((Value)map.get(key), false));
            }
            return section;
        }
        if (value.isArrayValue()) {
            LinkedList<Object> objects = new LinkedList<Object>();
            for (Value v : value.asArrayValue().list()) {
                objects.add(MessageData.simplify(v, false));
            }
            return objects;
        }
        if (value.isBooleanValue()) {
            return value.asBooleanValue().getBoolean();
        }
        if (value.isFloatValue()) {
            if (asKey) {
                return value.asIntegerValue().toDouble();
            }
            if (value.asFloatValue().toDouble() == (double)((float)value.asFloatValue().toDouble())) {
                return Float.valueOf(value.asFloatValue().toFloat());
            }
            return value.asFloatValue().toDouble();
        }
        if (value.isIntegerValue()) {
            if (asKey) {
                return value.asIntegerValue().asInt();
            }
            if (value.asIntegerValue().isInByteRange()) {
                return value.asIntegerValue().asByte();
            }
            if (value.asIntegerValue().isInShortRange()) {
                return value.asIntegerValue().asShort();
            }
            if (value.asIntegerValue().isInIntRange()) {
                return value.asIntegerValue().asInt();
            }
            if (value.asIntegerValue().isInLongRange()) {
                return value.asIntegerValue().asLong();
            }
            return value.asIntegerValue().asBigInteger();
        }
        if (value.isStringValue()) {
            return value.asStringValue().asString();
        }
        return value;
    }
}

