/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Bungee.Host.External;

import com.google.common.collect.Range;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Consumer;
import net.ME1312.Galaxi.Library.Config.YAMLConfig;
import net.ME1312.Galaxi.Library.Container.ContainedPair;
import net.ME1312.Galaxi.Library.Container.Container;
import net.ME1312.Galaxi.Library.Container.Pair;
import net.ME1312.Galaxi.Library.Container.Value;
import net.ME1312.Galaxi.Library.Map.ObjectMap;
import net.ME1312.Galaxi.Library.Try;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.Galaxi.Library.Version.Version;
import net.ME1312.SubData.Server.Protocol.PacketOut;
import net.ME1312.SubData.Server.SubDataClient;
import net.ME1312.SubServers.Bungee.Event.SubCreateEvent;
import net.ME1312.SubServers.Bungee.Event.SubCreatedEvent;
import net.ME1312.SubServers.Bungee.Host.External.ExternalHost;
import net.ME1312.SubServers.Bungee.Host.External.ExternalSubLogger;
import net.ME1312.SubServers.Bungee.Host.External.ExternalSubServer;
import net.ME1312.SubServers.Bungee.Host.Host;
import net.ME1312.SubServers.Bungee.Host.SubCreator;
import net.ME1312.SubServers.Bungee.Host.SubLogger;
import net.ME1312.SubServers.Bungee.Host.SubServer;
import net.ME1312.SubServers.Bungee.Library.Compatibility.Logger;
import net.ME1312.SubServers.Bungee.Network.Packet.PacketExConfigureHost;
import net.ME1312.SubServers.Bungee.Network.Packet.PacketExCreateServer;
import net.ME1312.SubServers.Bungee.Network.Packet.PacketExDownloadTemplates;
import net.ME1312.SubServers.Bungee.Network.Packet.PacketExUploadTemplates;
import net.ME1312.SubServers.Bungee.SubAPI;
import net.ME1312.SubServers.Bungee.SubProxy;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.plugin.Event;

public class ExternalSubCreator
extends SubCreator {
    private HashMap<String, SubCreator.ServerTemplate> templates = new HashMap();
    private HashMap<String, SubCreator.ServerTemplate> templatesR = new HashMap();
    private Boolean enableRT = false;
    private ExternalHost host;
    private Range<Integer> ports;
    private Value<Boolean> log;
    private String gitBash;
    private TreeMap<String, Pair<Integer, ExternalSubLogger>> thread;

    public ExternalSubCreator(ExternalHost host, Range<Integer> ports, boolean log, String gitBash) {
        if (!ports.hasLowerBound() || !ports.hasUpperBound()) {
            throw new IllegalArgumentException("Port range is not bound");
        }
        Util.nullpo((Object[])new Object[]{host, ports, log, gitBash});
        this.host = host;
        this.ports = ports;
        this.log = new Container((Object)log);
        this.gitBash = gitBash;
        this.thread = new TreeMap();
        this.reload();
    }

    @Override
    public void reload() {
        this.templatesR.clear();
        if (new File(this.host.plugin.dir, "SubServers/Templates").exists()) {
            for (File file : new File(this.host.plugin.dir, "SubServers/Templates").listFiles()) {
                try {
                    if (!file.isDirectory() || file.getName().endsWith(".x")) continue;
                    ObjectMap config = new File(file, "template.yml").exists() ? new YAMLConfig(new File(file, "template.yml")).get().getMap((Object)"Template", new ObjectMap()) : new ObjectMap();
                    SubCreator.ServerTemplate template = this.loadTemplate(file.getName(), config.getBoolean((Object)"Enabled", Boolean.valueOf(true)), config.getBoolean((Object)"Internal", Boolean.valueOf(false)), config.getString((Object)"Icon", "::NULL::"), file, (ObjectMap<String>)config.getMap((Object)"Build", new ObjectMap()), (ObjectMap<String>)config.getMap((Object)"Settings", new ObjectMap()));
                    this.templatesR.put(file.getName().toLowerCase(), template);
                    if (!config.getKeys().contains("Display")) continue;
                    template.setDisplayName(Util.unescapeJavaString((String)config.getString((Object)"Display")));
                }
                catch (Exception e) {
                    Logger.get((String)this.host.getName()).severe("Couldn't load template: " + file.getName());
                    e.printStackTrace();
                }
            }
        }
        if (this.host.available && !((Boolean)Try.all.get(() -> (Boolean)Util.reflect((Field)SubProxy.class.getDeclaredField("reloading"), (Object)((Object)this.host.plugin)), (Object)false)).booleanValue()) {
            this.host.queue(new PacketOut[]{new PacketExConfigureHost(this.host.plugin, this.host), new PacketExUploadTemplates(this.host.plugin, () -> {
                if (this.enableRT == null || this.enableRT.booleanValue()) {
                    this.host.queue(new PacketOut[]{new PacketExDownloadTemplates(this.host.plugin, this.host)});
                }
            })});
        }
    }

    @Override
    public boolean create(UUID player, String name, SubCreator.ServerTemplate template, Version version, Integer port, Consumer<SubServer> callback) {
        Util.nullpo((Object[])new Object[]{name, template});
        if (this.host.isAvailable() && this.host.isEnabled() && template.isEnabled() && !SubAPI.getInstance().getSubServers().containsKey(name.toLowerCase()) && !SubCreator.isReserved(name) && (version != null || !template.requiresVersion())) {
            StackTraceElement[] origin = new Throwable().getStackTrace();
            if (port == null) {
                Container i = new Container((Object)((Integer)this.ports.lowerEndpoint() - 1));
                port = ((InetSocketAddress)Util.getNew(ExternalSubCreator.getAllReservedAddresses(), () -> {
                    do {
                        i.value = (Integer)i.value + 1;
                        if ((Integer)i.value <= (Integer)this.ports.upperEndpoint()) continue;
                        throw new IllegalStateException("There are no more ports available in range: " + this.ports.toString());
                    } while (!this.ports.contains((Comparable)((Integer)i.value)));
                    return new InetSocketAddress(this.host.getAddress(), (int)((Integer)i.value));
                })).getPort();
            }
            String prefix = name + File.separator + "Creator";
            ExternalSubLogger logger = new ExternalSubLogger(this, prefix, this.log, null);
            this.thread.put(name.toLowerCase(), (Pair<Integer, ExternalSubLogger>)new ContainedPair((Object)port, (Object)logger));
            int fport = port;
            SubCreateEvent event = new SubCreateEvent(player, this.host, name, template, version, port);
            this.host.plugin.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                logger.start();
                this.host.queue(new PacketOut[]{new PacketExCreateServer(player, name, template, version, port, logger.getExternalAddress(), data -> {
                    this.finish(player, null, name, template, version, fport, prefix, origin, (ObjectMap<Integer>)data, callback);
                    this.thread.remove(name.toLowerCase());
                })});
                return true;
            }
            this.thread.remove(name.toLowerCase());
            return false;
        }
        return false;
    }

    private <T> void callback(StackTraceElement[] origin, Consumer<T> callback, T value) {
        if (callback != null) {
            try {
                callback.accept(value);
            }
            catch (Throwable e) {
                InvocationTargetException ew = new InvocationTargetException(e);
                ew.setStackTrace(origin);
                ew.printStackTrace();
            }
        }
    }

    @Override
    public boolean update(UUID player, SubServer server, SubCreator.ServerTemplate template, Version version, Consumer<Boolean> callback) {
        SubCreator.ServerTemplate ft;
        Util.nullpo((Object)server);
        SubCreator.ServerTemplate serverTemplate = ft = template == null ? server.getTemplate() : template;
        if (this.host.isAvailable() && this.host.isEnabled() && this.host == server.getHost() && server.isAvailable() && !server.isRunning() && ft != null && ft.isEnabled() && ft.canUpdate() && (version != null || !ft.requiresVersion())) {
            StackTraceElement[] origin = new Throwable().getStackTrace();
            String name = server.getName();
            String prefix = name + File.separator + "Updater";
            ((ExternalSubServer)server).updating(true);
            ExternalSubLogger logger = new ExternalSubLogger(this, prefix, this.log, null);
            this.thread.put(name.toLowerCase(), (Pair<Integer, ExternalSubLogger>)new ContainedPair((Object)server.getAddress().getPort(), (Object)logger));
            SubCreateEvent event = new SubCreateEvent(player, server, ft, version);
            this.host.plugin.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                logger.start();
                this.host.queue(new PacketOut[]{new PacketExCreateServer(player, server, ft, version, logger.getExternalAddress(), data -> {
                    this.finish(player, server, server.getName(), ft, version, server.getAddress().getPort(), prefix, origin, (ObjectMap<Integer>)data, s -> {
                        ((ExternalSubServer)server).updating(false);
                        if (callback != null) {
                            callback.accept(s != null);
                        }
                    });
                    this.thread.remove(name.toLowerCase());
                })});
                return true;
            }
            this.thread.remove(name.toLowerCase());
            return false;
        }
        return false;
    }

    private void finish(UUID player, SubServer update, String name, SubCreator.ServerTemplate template, Version version, int port, String prefix, StackTraceElement[] origin, ObjectMap<Integer> data, Consumer<SubServer> callback) {
        try {
            if (data.getInt((Object)1) == 0) {
                Logger.get((String)prefix).info("Saving...");
                SubServer subserver = update;
                if (update == null || update.getTemplate() != template || template.getBuildOptions().getBoolean((Object)"Update-Settings", Boolean.valueOf(false)).booleanValue()) {
                    if (this.host.plugin.exServers.containsKey(name.toLowerCase())) {
                        this.host.plugin.exServers.remove(name.toLowerCase());
                    }
                    ObjectMap server = new ObjectMap();
                    ObjectMap config = new ObjectMap((Map)data.getObject((Object)2));
                    if (config.contains((Object)"Directory") && (update != null || !template.getConfigOptions().contains((Object)"Directory"))) {
                        config.remove((Object)"Directory");
                    }
                    if (update == null) {
                        server.set((Object)"Enabled", (Object)true);
                        server.set((Object)"Display", (Object)"");
                        server.set((Object)"Host", (Object)this.host.getName());
                        server.set((Object)"Template", (Object)template.getName());
                        server.set((Object)"Group", new ArrayList());
                        server.set((Object)"Port", (Object)port);
                        server.set((Object)"Motd", (Object)"Some SubServer");
                        server.set((Object)"Log", (Object)true);
                        server.set((Object)"Directory", (Object)("./" + name));
                        server.set((Object)"Executable", (Object)("java -Xmx1024M -jar " + template.getType().toString() + ".jar"));
                        server.set((Object)"Stop-Command", (Object)"stop");
                        server.set((Object)"Stop-Action", (Object)"NONE");
                        server.set((Object)"Run-On-Launch", (Object)false);
                        server.set((Object)"Restricted", (Object)false);
                        server.set((Object)"Incompatible", new ArrayList());
                        server.set((Object)"Hidden", (Object)false);
                    } else {
                        server.setAll(this.host.plugin.servers.get().getMap((Object)"Servers").getMap((Object)name, new HashMap()));
                        server.set((Object)"Template", (Object)template.getName());
                    }
                    server.setAll(config);
                    if (update != null) {
                        Try.all.run(() -> update.getHost().forceRemoveSubServer(name));
                    }
                    subserver = this.host.constructSubServer(name, server.getBoolean((Object)"Enabled"), port, ChatColor.translateAlternateColorCodes((char)'&', (String)Util.unescapeJavaString((String)server.getString((Object)"Motd"))), server.getBoolean((Object)"Log"), server.getString((Object)"Directory"), server.getString((Object)"Executable"), server.getString((Object)"Stop-Command"), server.getBoolean((Object)"Hidden"), server.getBoolean((Object)"Restricted"));
                    if (server.getString((Object)"Display").length() > 0) {
                        subserver.setDisplayName(Util.unescapeJavaString((String)server.getString((Object)"Display")));
                    }
                    subserver.setTemplate(server.getString((Object)"Template"));
                    for (String group : server.getStringList((Object)"Group")) {
                        subserver.addGroup(group);
                    }
                    SubServer.StopAction action = (SubServer.StopAction)((Object)Try.all.get(() -> SubServer.StopAction.valueOf(server.getString((Object)"Stop-Action").toUpperCase().replace('-', '_').replace(' ', '_'))));
                    if (action != null) {
                        subserver.setStopAction(action);
                    }
                    if (server.contains((Object)"Extra")) {
                        for (String extra : server.getMap((Object)"Extra").getKeys()) {
                            subserver.addExtra(extra, server.getMap((Object)"Extra").getObject((Object)extra));
                        }
                    }
                    if (update != null && this.host.plugin.servers.get().getMap((Object)"Servers").contains((Object)name) || subserver.getStopAction() != SubServer.StopAction.REMOVE_SERVER && subserver.getStopAction() != SubServer.StopAction.RECYCLE_SERVER && subserver.getStopAction() != SubServer.StopAction.DELETE_SERVER) {
                        this.host.plugin.servers.get().getMap((Object)"Servers").set((Object)name, (Object)server);
                        this.host.plugin.servers.save();
                    }
                    this.host.addSubServer(subserver);
                    if (update == null && template.getBuildOptions().getBoolean((Object)"Run-On-Finish", Boolean.valueOf(true)).booleanValue()) {
                        while (!subserver.isAvailable() && this.host.isAvailable()) {
                            Thread.sleep(250L);
                        }
                        if (subserver.isAvailable()) {
                            subserver.start();
                        }
                    }
                }
                this.host.plugin.getPluginManager().callEvent((Event)new SubCreatedEvent(player, this.host, name, template, version, port, subserver, update != null, true));
                this.callback(origin, callback, subserver);
            } else {
                Logger.get((String)prefix).info(data.getString((Object)3));
                this.host.plugin.getPluginManager().callEvent((Event)new SubCreatedEvent(player, this.host, name, template, version, port, update, update != null, false));
                this.callback(origin, callback, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.callback(origin, callback, null);
        }
    }

    @Override
    public void terminate() {
        HashMap<String, Pair<Integer, ExternalSubLogger>> thread = new HashMap<String, Pair<Integer, ExternalSubLogger>>();
        thread.putAll(this.thread);
        for (String i : thread.keySet()) {
            this.terminate(i);
        }
    }

    @Override
    public void terminate(String name) {
        if (this.thread.containsKey(name.toLowerCase())) {
            ((SubDataClient)this.host.getSubData()[0]).sendPacket(new PacketOut[]{new PacketExCreateServer(name.toLowerCase())});
            this.thread.remove(name.toLowerCase());
        }
    }

    @Override
    public void waitFor() throws InterruptedException {
        HashMap<String, Pair<Integer, ExternalSubLogger>> thread = new HashMap<String, Pair<Integer, ExternalSubLogger>>();
        thread.putAll(this.thread);
        for (String i : thread.keySet()) {
            this.waitFor(i);
        }
    }

    @Override
    public void waitFor(String name) throws InterruptedException {
        while (this.thread.containsKey(name.toLowerCase()) && this.host.getSubData()[0] != null) {
            Thread.sleep(250L);
        }
    }

    @Override
    public Host getHost() {
        return this.host;
    }

    @Override
    public Range getPortRange() {
        return this.ports;
    }

    @Override
    public void setPortRange(Range<Integer> value) {
        if (!value.hasLowerBound() || !value.hasUpperBound()) {
            throw new IllegalArgumentException("Port range is not bound");
        }
        this.ports = value;
    }

    @Override
    public String getBashDirectory() {
        return this.gitBash;
    }

    @Override
    public List<SubLogger> getLoggers() {
        ArrayList<SubLogger> loggers = new ArrayList<SubLogger>();
        HashMap<String, Pair<Integer, ExternalSubLogger>> temp = new HashMap<String, Pair<Integer, ExternalSubLogger>>();
        temp.putAll(this.thread);
        for (String i : temp.keySet()) {
            loggers.add(this.getLogger(i));
        }
        return loggers;
    }

    @Override
    public SubLogger getLogger(String name) {
        return (SubLogger)this.thread.get(name.toLowerCase()).value();
    }

    @Override
    public boolean isLogging() {
        return (Boolean)this.log.value();
    }

    @Override
    public void setLogging(boolean value) {
        Util.nullpo((Object)value);
        this.log.value((Object)value);
    }

    @Override
    public List<String> getReservedNames() {
        return new ArrayList<String>(this.thread.keySet());
    }

    @Override
    public List<Integer> getReservedPorts() {
        ArrayList<Integer> ports = new ArrayList<Integer>();
        for (Pair<Integer, ExternalSubLogger> task : this.thread.values()) {
            ports.add((Integer)task.key());
        }
        return ports;
    }

    @Override
    public Map<String, SubCreator.ServerTemplate> getTemplates() {
        TreeMap<String, SubCreator.ServerTemplate> map = new TreeMap<String, SubCreator.ServerTemplate>();
        if (this.enableRT != null && this.enableRT.booleanValue()) {
            for (Map.Entry<String, SubCreator.ServerTemplate> template : this.templatesR.entrySet()) {
                if (template.getValue().isInternal()) continue;
                map.put(template.getKey(), template.getValue());
            }
        }
        for (Map.Entry<String, SubCreator.ServerTemplate> template : this.templates.entrySet()) {
            if (template.getValue().isInternal()) continue;
            map.put(template.getKey(), template.getValue());
        }
        return map;
    }

    @Override
    public SubCreator.ServerTemplate getTemplate(String name) {
        Util.nullpo((Object)name);
        name = name.toLowerCase();
        SubCreator.ServerTemplate template = this.templates.getOrDefault(name, null);
        if (template == null && this.enableRT != null && this.enableRT.booleanValue()) {
            template = this.templatesR.getOrDefault(name, null);
        }
        if (template == null || template.isInternal()) {
            return null;
        }
        return template;
    }
}

