/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Bungee.Host.External;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.UUID;
import java.util.function.Supplier;
import net.ME1312.Galaxi.Library.Container.ContainedPair;
import net.ME1312.Galaxi.Library.Container.Container;
import net.ME1312.Galaxi.Library.Container.Pair;
import net.ME1312.Galaxi.Library.Container.Value;
import net.ME1312.Galaxi.Library.Map.ObjectMap;
import net.ME1312.Galaxi.Library.Map.ObjectMapValue;
import net.ME1312.Galaxi.Library.Try;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.SubData.Server.Protocol.PacketOut;
import net.ME1312.SubData.Server.SubDataClient;
import net.ME1312.SubServers.Bungee.Event.SubEditServerEvent;
import net.ME1312.SubServers.Bungee.Event.SubSendCommandEvent;
import net.ME1312.SubServers.Bungee.Event.SubStartEvent;
import net.ME1312.SubServers.Bungee.Event.SubStopEvent;
import net.ME1312.SubServers.Bungee.Event.SubStoppedEvent;
import net.ME1312.SubServers.Bungee.Host.External.ExternalHost;
import net.ME1312.SubServers.Bungee.Host.External.ExternalSubLogger;
import net.ME1312.SubServers.Bungee.Host.Host;
import net.ME1312.SubServers.Bungee.Host.Proxy;
import net.ME1312.SubServers.Bungee.Host.ServerImpl;
import net.ME1312.SubServers.Bungee.Host.SubLogger;
import net.ME1312.SubServers.Bungee.Host.SubServer;
import net.ME1312.SubServers.Bungee.Host.SubServerImpl;
import net.ME1312.SubServers.Bungee.Library.Compatibility.Logger;
import net.ME1312.SubServers.Bungee.Library.Exception.InvalidServerException;
import net.ME1312.SubServers.Bungee.Network.Packet.PacketExControlServer;
import net.ME1312.SubServers.Bungee.Network.Packet.PacketOutExEditServer;
import net.ME1312.SubServers.Bungee.SubAPI;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.plugin.Event;

public class ExternalSubServer
extends SubServerImpl {
    private ExternalHost host;
    private boolean enabled;
    private Value<Boolean> log;
    private String dir;
    String exec;
    private String stopcmd;
    private SubServer.StopAction stopaction;
    private LinkedList<SubServer.LoggedCommand> history;
    private ExternalSubLogger logger;
    private boolean running;
    private boolean lock;

    public static ExternalSubServer construct(ExternalHost host, String name, boolean enabled, int port, String motd, boolean log, String directory, String executable, String stopcmd, boolean hidden, boolean restricted) throws InvalidServerException {
        try {
            return new ExternalSubServer(host, name, enabled, port, motd, log, directory, executable, stopcmd, hidden, restricted);
        }
        catch (NoSuchMethodError e) {
            return new ExternalSubServer(host, name, enabled, (Integer)port, motd, log, directory, executable, stopcmd, hidden, restricted);
        }
    }

    protected ExternalSubServer(ExternalHost host, String name, boolean enabled, int port, String motd, boolean log, String directory, String executable, String stopcmd, boolean hidden, boolean restricted) throws InvalidServerException {
        super((Host)host, name, port, motd, hidden, restricted);
        this.init(host, name, enabled, port, motd, log, directory, executable, stopcmd, hidden, restricted);
    }

    protected ExternalSubServer(ExternalHost host, String name, boolean enabled, Integer port, String motd, boolean log, String directory, String executable, String stopcmd, boolean hidden, boolean restricted) throws InvalidServerException {
        super((Host)host, name, port, motd, hidden, restricted);
        this.init(host, name, enabled, port, motd, log, directory, executable, stopcmd, hidden, restricted);
    }

    private void init(ExternalHost host, String name, boolean enabled, int port, String motd, boolean log, String directory, String executable, String stopcmd, boolean hidden, boolean restricted) throws InvalidServerException {
        Util.nullpo((Object[])new Object[]{host, name, enabled, port, motd, log, stopcmd, hidden, restricted});
        this.host = host;
        this.enabled = enabled;
        this.log = new Container((Object)log);
        this.dir = directory;
        this.exec = executable;
        this.stopcmd = stopcmd;
        this.stopaction = SubServer.StopAction.NONE;
        this.history = new LinkedList();
        this.logger = new ExternalSubLogger(this, this.getName(), this.log, null);
        this.running = false;
        this.lock = false;
    }

    void registered(boolean value) {
        this.registered = value;
    }

    void updating(boolean value) {
        this.updating = value;
    }

    @Override
    public boolean start(UUID player) {
        if (!this.lock && this.isAvailable() && this.isEnabled() && !this.running && this.getCurrentIncompatibilities().size() == 0) {
            this.lock = true;
            SubStartEvent event = new SubStartEvent(player, this);
            this.host.plugin.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                Logger.get((String)"SubServers").info("Now starting " + this.getName());
                this.started(null);
                this.host.queue(new PacketOut[]{new PacketExControlServer(this, PacketExControlServer.Action.START, this.logger.getExternalAddress().toString())});
                return true;
            }
            this.lock = false;
            return false;
        }
        return false;
    }

    void started(UUID address) {
        if (!this.running) {
            this.stopping = false;
            this.started = false;
            this.running = true;
            this.lock = false;
            this.logger.start();
            if (address != null) {
                if (address != this.logger.getExternalAddress()) {
                    this.host.queue(new PacketOut[]{new PacketExControlServer(this, PacketExControlServer.Action.SET_LOGGING_ADDRESS, this.logger.getExternalAddress().toString())});
                }
                this.host.plugin.getPluginManager().callEvent((Event)new SubStartEvent(null, this));
            }
        }
    }

    private void falsestart() {
        Logger.get((String)"SubServers").info("Couldn't start " + this.getName() + " - See the " + this.host.getName() + " console for more details");
        this.running = false;
        this.logger.stop();
    }

    @Override
    public boolean stop(UUID player) {
        if (this.running) {
            SubStopEvent event = new SubStopEvent(player, this, false);
            this.host.plugin.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                this.history.add(new SubServer.LoggedCommand(player, this.stopcmd));
                this.host.queue(new PacketOut[]{new PacketExControlServer(this, PacketExControlServer.Action.STOP, new Object[0])});
                this.stopping = true;
                return true;
            }
            return false;
        }
        return false;
    }

    void stopped(Boolean allowrestart) {
        block10: {
            this.logger.stop();
            this.history.clear();
            this.started = false;
            this.running = false;
            this.stopping = false;
            SubStoppedEvent event = new SubStoppedEvent(this);
            this.host.plugin.getPluginManager().callEvent((Event)event);
            Logger.get((String)"SubServers").info(this.getName() + " has stopped");
            if (this.stopaction == SubServer.StopAction.REMOVE_SERVER || this.stopaction == SubServer.StopAction.RECYCLE_SERVER || this.stopaction == SubServer.StopAction.DELETE_SERVER) {
                try {
                    if (this.stopaction == SubServer.StopAction.RECYCLE_SERVER) {
                        this.host.recycleSubServer(this.getName());
                        break block10;
                    }
                    if (this.stopaction == SubServer.StopAction.DELETE_SERVER) {
                        this.host.deleteSubServer(this.getName());
                        break block10;
                    }
                    try {
                        if (this.host.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(this.getName())) {
                            this.host.plugin.servers.get().getMap((Object)"Servers").remove((Object)this.getName());
                            this.host.plugin.servers.save();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    this.host.removeSubServer(this.getName());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else if (this.stopaction == SubServer.StopAction.RESTART && allowrestart.booleanValue()) {
                new Thread(() -> {
                    try {
                        Thread.sleep(250L);
                        this.start();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }, "SubServers.Bungee::External_Server_Restart_Handler(" + this.getName() + ')').start();
            }
        }
    }

    @Override
    public boolean terminate(UUID player) {
        if (this.running) {
            SubStopEvent event = new SubStopEvent(player, this, true);
            this.host.plugin.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                this.host.queue(new PacketOut[]{new PacketExControlServer(this, PacketExControlServer.Action.TERMINATE, new Object[0])});
                this.stopping = true;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean command(UUID player, String command) {
        Util.nullpo((Object)command);
        if (this.running) {
            SubSendCommandEvent event = new SubSendCommandEvent(player, this, command, null);
            this.host.plugin.getPluginManager().callEvent((Event)event);
            if (!(event.isCancelled() || player != null && DISALLOWED_COMMANDS.matcher(command).find())) {
                this.history.add(new SubServer.LoggedCommand(player, event.getCommand()));
                if (event.getCommand().equalsIgnoreCase(this.stopcmd)) {
                    this.host.queue(new PacketOut[]{new PacketExControlServer(this, PacketExControlServer.Action.STOP, new Object[0])});
                    this.stopping = true;
                } else {
                    this.host.queue(new PacketOut[]{new PacketExControlServer(this, PacketExControlServer.Action.COMMAND, event.getCommand())});
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    protected int edit(UUID player, ObjectMap<String> edit, boolean perma) {
        if (this.isAvailable()) {
            int c = 0;
            boolean state = this.isRunning();
            SubServer forward = null;
            ObjectMap pending = edit.clone();
            for (String key : edit.getKeys()) {
                pending.remove((Object)key);
                ObjectMapValue value = edit.get((Object)key);
                boolean allowed = true;
                if (perma) {
                    Object event = new SubEditServerEvent(player, this, (Pair<String, ?>)new ContainedPair((Object)key, (Object)value));
                    this.host.plugin.getPluginManager().callEvent((Event)event);
                    boolean bl = allowed = !((SubEditServerEvent)((Object)event)).isCancelled();
                }
                if (!allowed) continue;
                try {
                    SubServer server2;
                    switch (key.toLowerCase()) {
                        case "name": {
                            if (!value.isString() || !this.host.removeSubServer(player, this.getName()) || (server2 = this.host.constructSubServer(value.asString(), this.isEnabled(), this.getAddress().getPort(), this.getMotd(), this.isLogging(), this.getPath(), this.getExecutable(), this.getStopCommand(), this.isHidden(), this.isRestricted())) == null) break;
                            if (perma && this.host.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(this.getName())) {
                                ObjectMap config = this.host.plugin.servers.get().getMap((Object)"Servers").getMap((Object)this.getName());
                                this.host.plugin.servers.get().getMap((Object)"Servers").remove((Object)this.getName());
                                this.host.plugin.servers.get().getMap((Object)"Servers").set((Object)server2.getName(), (Object)config);
                                this.host.plugin.servers.save();
                            }
                            forward = server2;
                            ++c;
                            break;
                        }
                        case "display": {
                            if (!value.isString()) break;
                            this.setDisplayName(value.asString());
                            this.logger.name = this.getDisplayName();
                            if (perma && this.host.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(this.getName())) {
                                if (this.getName().equals(this.getDisplayName())) {
                                    this.host.plugin.servers.get().getMap((Object)"Servers").getMap((Object)this.getName()).remove((Object)"Display");
                                } else {
                                    this.host.plugin.servers.get().getMap((Object)"Servers").getMap((Object)this.getName()).set((Object)"Display", (Object)this.getDisplayName());
                                }
                                this.host.plugin.servers.save();
                            }
                            ++c;
                            break;
                        }
                        case "enabled": {
                            if (!value.isBoolean()) break;
                            if (this.enabled != value.asBoolean()) {
                                this.host.queue(new PacketOut[]{new PacketExControlServer(this, PacketExControlServer.Action.SET_ENABLED, value.asBoolean())});
                            }
                            this.enabled = value.asBoolean();
                            if (perma && this.host.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(this.getName())) {
                                this.host.plugin.servers.get().getMap((Object)"Servers").getMap((Object)this.getName()).set((Object)"Enabled", (Object)this.isEnabled());
                                this.host.plugin.servers.save();
                            }
                            ++c;
                            break;
                        }
                        case "group": {
                            if (!value.isList()) break;
                            Util.reflect((Field)ServerImpl.class.getDeclaredField("groups"), (Object)this, (Object)value.asStringList());
                            if (perma && this.host.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(this.getName())) {
                                this.host.plugin.servers.get().getMap((Object)"Servers").getMap((Object)this.getName()).set((Object)"Group", (Object)value.asStringList());
                                this.host.plugin.servers.save();
                            }
                            ++c;
                            break;
                        }
                        case "host": {
                            if (!value.isString() || !this.host.removeSubServer(player, this.getName())) break;
                            this.waitFor(() -> this.host.getSubServer(this.getName()), null);
                            server2 = this.host.plugin.api.getHost(value.asString()).constructSubServer(this.getName(), this.isEnabled(), this.getAddress().getPort(), this.getMotd(), this.isLogging(), this.getPath(), this.getExecutable(), this.getStopCommand(), this.isHidden(), this.isRestricted());
                            if (server2 == null) break;
                            if (perma && this.host.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(this.getName())) {
                                this.host.plugin.servers.get().getMap((Object)"Servers").getMap((Object)this.getName()).set((Object)"Host", (Object)server2.getHost().getName());
                                this.host.plugin.servers.save();
                            }
                            forward = server2;
                            ++c;
                            break;
                        }
                        case "template": {
                            if (!value.isString()) break;
                            this.setTemplate(value.asString());
                            if (perma && this.host.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(this.getName())) {
                                this.host.plugin.servers.get().getMap((Object)"Servers").getMap((Object)this.getName()).set((Object)"Template", (Object)value.asString());
                                this.host.plugin.servers.save();
                            }
                            ++c;
                            break;
                        }
                        case "port": {
                            if (!value.isNumber() || !this.host.removeSubServer(player, this.getName())) break;
                            this.waitFor(() -> this.host.getSubServer(this.getName()), null);
                            server2 = this.host.constructSubServer(this.getName(), this.isEnabled(), value.asInt(), this.getMotd(), this.isLogging(), this.getPath(), this.getExecutable(), this.getStopCommand(), this.isHidden(), this.isRestricted());
                            if (server2 == null) break;
                            if (perma && this.host.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(this.getName())) {
                                this.host.plugin.servers.get().getMap((Object)"Servers").getMap((Object)this.getName()).set((Object)"Port", (Object)server2.getAddress().getPort());
                                this.host.plugin.servers.save();
                            }
                            forward = server2;
                            ++c;
                            break;
                        }
                        case "motd": {
                            if (!value.isString()) break;
                            this.setMotd(ChatColor.translateAlternateColorCodes((char)'&', (String)Util.unescapeJavaString((String)value.asString())));
                            if (perma && this.host.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(this.getName())) {
                                this.host.plugin.servers.get().getMap((Object)"Servers").getMap((Object)this.getName()).set((Object)"Motd", (Object)value.asString());
                                this.host.plugin.servers.save();
                            }
                            ++c;
                            break;
                        }
                        case "log": {
                            if (!value.isBoolean()) break;
                            if (this.log.value() != value.asBoolean()) {
                                this.host.queue(new PacketOut[]{new PacketExControlServer(this, PacketExControlServer.Action.SET_LOGGING, value.asBoolean())});
                            }
                            this.log.value((Object)value.asBoolean());
                            if (perma && this.host.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(this.getName())) {
                                this.host.plugin.servers.get().getMap((Object)"Servers").getMap((Object)this.getName()).set((Object)"Log", (Object)this.isLogging());
                                this.host.plugin.servers.save();
                            }
                            ++c;
                            break;
                        }
                        case "dir": 
                        case "directory": {
                            if (!value.isString() || !this.host.removeSubServer(player, this.getName())) break;
                            this.waitFor(() -> this.host.getSubServer(this.getName()), null);
                            server2 = this.host.constructSubServer(this.getName(), this.isEnabled(), this.getAddress().getPort(), this.getMotd(), this.isLogging(), value.asString(), this.getExecutable(), this.getStopCommand(), this.isHidden(), this.isRestricted());
                            if (server2 == null) break;
                            if (perma && this.host.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(this.getName())) {
                                this.host.plugin.servers.get().getMap((Object)"Servers").getMap((Object)this.getName()).set((Object)"Directory", (Object)server2.getPath());
                                this.host.plugin.servers.save();
                            }
                            forward = server2;
                            ++c;
                            break;
                        }
                        case "exec": 
                        case "executable": {
                            if (!value.isString() || !this.host.removeSubServer(player, this.getName())) break;
                            this.waitFor(() -> this.host.getSubServer(this.getName()), null);
                            server2 = this.host.constructSubServer(this.getName(), this.isEnabled(), this.getAddress().getPort(), this.getMotd(), this.isLogging(), this.getPath(), value.asString(), this.getStopCommand(), this.isHidden(), this.isRestricted());
                            if (server2 == null) break;
                            if (perma && this.host.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(this.getName())) {
                                this.host.plugin.servers.get().getMap((Object)"Servers").getMap((Object)this.getName()).set((Object)"Executable", (Object)value.asString());
                                this.host.plugin.servers.save();
                            }
                            forward = server2;
                            ++c;
                            break;
                        }
                        case "state": {
                            if (!value.isBoolean()) break;
                            state = value.asBoolean();
                            break;
                        }
                        case "stop-cmd": 
                        case "stop-command": {
                            if (!value.isString()) break;
                            if (!this.stopcmd.equals(value.asString())) {
                                this.host.queue(new PacketOut[]{new PacketExControlServer(this, PacketExControlServer.Action.SET_STOP_COMMAND, value.asString())});
                            }
                            this.stopcmd = value.asString();
                            if (perma && this.host.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(this.getName())) {
                                this.host.plugin.servers.get().getMap((Object)"Servers").getMap((Object)this.getName()).set((Object)"Stop-Command", (Object)this.getStopCommand());
                                this.host.plugin.servers.save();
                            }
                            ++c;
                            break;
                        }
                        case "stop-action": {
                            Object action;
                            if (!value.isString() || (action = (SubServer.StopAction)((Object)Try.all.get(() -> SubServer.StopAction.valueOf(value.asString().toUpperCase().replace('-', '_').replace(' ', '_'))))) == null) break;
                            this.stopaction = action;
                            if (perma && this.host.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(this.getName())) {
                                this.host.plugin.servers.get().getMap((Object)"Servers").getMap((Object)this.getName()).set((Object)"Stop-Action", (Object)this.getStopAction().toString());
                                this.host.plugin.servers.save();
                            }
                            ++c;
                            break;
                        }
                        case "auto-run": 
                        case "run-on-launch": {
                            if (!value.isBoolean()) break;
                            if (perma && this.host.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(this.getName())) {
                                this.host.plugin.servers.get().getMap((Object)"Servers").getMap((Object)this.getName()).set((Object)"Run-On-Launch", (Object)value.asBoolean());
                                this.host.plugin.servers.save();
                            }
                            ++c;
                            break;
                        }
                        case "incompatible": {
                            if (!value.isList()) break;
                            for (SubServer oserver : this.getIncompatibilities()) {
                                this.toggleCompatibility(oserver);
                            }
                            Object action = value.asStringList().iterator();
                            while (action.hasNext()) {
                                String oname = (String)action.next();
                                SubServer oserver = this.host.plugin.api.getSubServer(oname);
                                if (oserver == null || !this.isCompatible(oserver)) continue;
                                this.toggleCompatibility(oserver);
                            }
                            if (perma && this.host.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(this.getName())) {
                                this.host.plugin.servers.get().getMap((Object)"Servers").getMap((Object)this.getName()).set((Object)"Incompatible", (Object)value.asStringList());
                                this.host.plugin.servers.save();
                            }
                            ++c;
                            break;
                        }
                        case "restricted": {
                            if (!value.isBoolean()) break;
                            this.setRestricted(value.asBoolean());
                            if (perma && this.host.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(this.getName())) {
                                this.host.plugin.servers.get().getMap((Object)"Servers").getMap((Object)this.getName()).set((Object)"Restricted", (Object)this.isRestricted());
                                this.host.plugin.servers.save();
                            }
                            ++c;
                            break;
                        }
                        case "hidden": {
                            if (!value.isBoolean()) break;
                            this.setHidden(value.asBoolean());
                            if (perma && this.host.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(this.getName())) {
                                this.host.plugin.servers.get().getMap((Object)"Servers").getMap((Object)this.getName()).set((Object)"Hidden", (Object)this.isHidden());
                                this.host.plugin.servers.save();
                            }
                            ++c;
                            break;
                        }
                        case "whitelist": {
                            Object action;
                            if (!value.isList()) break;
                            Util.reflect((Field)ServerImpl.class.getDeclaredField("whitelist"), (Object)this, (Object)value.asUUIDList());
                            if (this.isRegistered()) {
                                action = SubAPI.getInstance().getProxies().values().iterator();
                                while (action.hasNext()) {
                                    Proxy proxy = (Proxy)action.next();
                                    if (proxy.getSubData()[0] == null) continue;
                                    ((SubDataClient)proxy.getSubData()[0]).sendPacket(new PacketOut[]{new PacketOutExEditServer(this, PacketOutExEditServer.Edit.WHITELIST_SET, value.asUUIDList())});
                                }
                            }
                            ++c;
                        }
                    }
                    if (forward == null) continue;
                    forward.setStopAction(this.getStopAction());
                    if (!this.getName().equals(this.getDisplayName())) {
                        forward.setDisplayName(this.getDisplayName());
                    }
                    ArrayList<String> groups = new ArrayList<String>();
                    forward.setTemplate(this.getTemplate());
                    groups.addAll(this.getGroups());
                    for (String group : groups) {
                        this.removeGroup(group);
                        forward.addGroup(group);
                    }
                    for (SubServer server2 : this.getIncompatibilities()) {
                        this.toggleCompatibility(server2);
                        forward.toggleCompatibility(server2);
                    }
                    for (String extra : this.getExtra().getKeys()) {
                        forward.addExtra(extra, this.getExtra(extra));
                    }
                    if (state) {
                        pending.set((Object)"state", (Object)true);
                    }
                    c += perma ? forward.permaEdit(player, (ObjectMap<String>)pending) : forward.edit(player, (ObjectMap<String>)pending);
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!this.isRunning() && forward == null && state) {
                this.start(player);
            }
            return c;
        }
        return -1;
    }

    private <V> void waitFor(Supplier<V> method, V value) throws InterruptedException {
        while (method.get() != value) {
            Thread.sleep(250L);
        }
    }

    @Override
    public void waitFor() throws InterruptedException {
        while (this.running && this.host.getSubData()[0] != null) {
            Thread.sleep(250L);
        }
    }

    @Override
    public boolean isRunning() {
        return this.running || this.lock;
    }

    @Override
    public void setDisplayName(String value) {
        super.setDisplayName(value);
        this.logger.name = this.getDisplayName();
    }

    @Override
    public Host getHost() {
        return this.host;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled && this.host.isEnabled();
    }

    @Override
    public void setEnabled(boolean value) {
        Util.nullpo((Object)value);
        if (this.enabled != value) {
            this.host.queue(new PacketOut[]{new PacketExControlServer(this, PacketExControlServer.Action.SET_ENABLED, value)});
        }
        this.enabled = value;
    }

    @Override
    public boolean isLogging() {
        return (Boolean)this.log.value();
    }

    @Override
    public void setLogging(boolean value) {
        Util.nullpo((Object)value);
        if ((Boolean)this.log.value() != value) {
            this.host.queue(new PacketOut[]{new PacketExControlServer(this, PacketExControlServer.Action.SET_LOGGING, value)});
        }
        this.log.value((Object)value);
    }

    @Override
    public SubLogger getLogger() {
        return this.logger;
    }

    @Override
    public LinkedList<SubServer.LoggedCommand> getCommandHistory() {
        return new LinkedList<SubServer.LoggedCommand>(this.history);
    }

    @Override
    public String getPath() {
        return this.dir;
    }

    @Override
    public String getExecutable() {
        return this.exec;
    }

    @Override
    public String getStopCommand() {
        return this.stopcmd;
    }

    @Override
    public void setStopCommand(String value) {
        Util.nullpo((Object)value);
        if (!this.stopcmd.equals(value)) {
            this.host.queue(new PacketOut[]{new PacketExControlServer(this, PacketExControlServer.Action.SET_STOP_COMMAND, value)});
        }
        this.stopcmd = value;
    }

    @Override
    public SubServer.StopAction getStopAction() {
        return this.stopaction;
    }

    @Override
    public void setStopAction(SubServer.StopAction action) {
        Util.nullpo((Object)((Object)action));
        this.stopaction = action;
    }
}

