/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Bungee.Host.Internal;

import com.dosse.upnp.UPnP;
import com.google.common.collect.Range;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileWriter;
import java.net.InetAddress;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import net.ME1312.Galaxi.Library.Config.YAMLSection;
import net.ME1312.Galaxi.Library.Directories;
import net.ME1312.Galaxi.Library.Map.ObjectMap;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.SubServers.Bungee.Event.SubAddServerEvent;
import net.ME1312.SubServers.Bungee.Event.SubRemoveServerEvent;
import net.ME1312.SubServers.Bungee.Host.Host;
import net.ME1312.SubServers.Bungee.Host.Internal.InternalSubCreator;
import net.ME1312.SubServers.Bungee.Host.Internal.InternalSubServer;
import net.ME1312.SubServers.Bungee.Host.SubCreator;
import net.ME1312.SubServers.Bungee.Host.SubServer;
import net.ME1312.SubServers.Bungee.Library.Compatibility.Logger;
import net.ME1312.SubServers.Bungee.Library.Exception.InvalidServerException;
import net.ME1312.SubServers.Bungee.SubProxy;
import net.md_5.bungee.api.plugin.Event;

public class InternalHost
extends Host {
    public static final boolean DRM_ALLOW = System.getProperty("RM.subservers", "true").equalsIgnoreCase("true");
    private HashMap<String, SubServer> servers = new HashMap();
    private String name;
    private boolean enabled;
    private InetAddress address;
    private SubCreator creator;
    private String directory;
    SubProxy plugin;

    public InternalHost(SubProxy plugin, String name, boolean enabled, Range<Integer> ports, boolean log, InetAddress address, String directory, String gitBash) {
        super(plugin, name, enabled, ports, log, address, directory, gitBash);
        if (!DRM_ALLOW) {
            throw new IllegalStateException("SubServers' hosting capabilities have been disabled by your provider");
        }
        this.plugin = plugin;
        this.name = name;
        this.enabled = enabled;
        this.address = address;
        this.creator = new InternalSubCreator(this, ports, log, gitBash);
        this.directory = directory;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    @Override
    public InetAddress getAddress() {
        return this.address;
    }

    @Override
    public String getPath() {
        return this.directory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public SubCreator getCreator() {
        return this.creator;
    }

    @Override
    public Map<String, ? extends SubServer> getSubServers() {
        return new TreeMap<String, SubServer>(this.servers);
    }

    @Override
    public SubServer getSubServer(String name) {
        if (Util.isNull((Object)name)) {
            return null;
        }
        return this.servers.get(name.toLowerCase());
    }

    @Override
    public SubServer constructSubServer(String name, boolean enabled, int port, String motd, boolean log, String directory, String executable, String stopcmd, boolean hidden, boolean restricted) throws InvalidServerException {
        return InternalSubServer.construct(this, name, enabled, port, motd, log, directory, executable, stopcmd, hidden, restricted);
    }

    @Override
    public boolean addSubServer(UUID player, SubServer server) throws InvalidServerException {
        if (server.getHost() != this) {
            throw new IllegalArgumentException("That Server does not belong to this Host!");
        }
        if (this.plugin.api.getServers().containsKey(server.getName().toLowerCase())) {
            throw new InvalidServerException("A Server already exists with this name!");
        }
        SubAddServerEvent event = new SubAddServerEvent(player, this, server);
        this.plugin.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            ((InternalSubServer)server).registered(true);
            this.servers.put(server.getName().toLowerCase(), server);
            if (UPnP.isUPnPAvailable() && this.plugin.config.get().getMap((Object)"Settings").getMap((Object)"UPnP", new ObjectMap()).getBoolean((Object)"Forward-Servers", Boolean.valueOf(false)).booleanValue()) {
                UPnP.openPortTCP((int)server.getAddress().getPort());
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean removeSubServer(UUID player, String name, boolean forced) throws InterruptedException {
        Util.nullpo((Object)name);
        InternalSubServer server = (InternalSubServer)this.servers.get(name.toLowerCase());
        SubRemoveServerEvent event = new SubRemoveServerEvent(player, this, server);
        this.plugin.getPluginManager().callEvent((Event)event);
        if (forced || !event.isCancelled()) {
            server.registered(false);
            if (server.isRunning()) {
                server.stop();
                server.waitFor();
            }
            this.servers.remove(name.toLowerCase());
            if (UPnP.isUPnPAvailable() && UPnP.isMappedTCP((int)server.getAddress().getPort())) {
                UPnP.closePortTCP((int)server.getAddress().getPort());
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean recycleSubServer(UUID player, String name, boolean forced) throws InterruptedException {
        return this.recycleSubServer(player, name, forced, true);
    }

    protected boolean recycleSubServer(UUID player, String name, boolean forced, boolean multithreading) throws InterruptedException {
        Util.nullpo((Object)name);
        String server = this.servers.get(name.toLowerCase()).getName();
        File from = new File(this.getPath(), this.servers.get(server.toLowerCase()).getPath());
        if (this.removeSubServer(player, server, forced)) {
            Runnable method = () -> {
                File to = new File(this.plugin.dir, "SubServers/Recently Deleted/" + server.toLowerCase());
                try {
                    if (from.exists()) {
                        Logger.get((String)"SubServers").info("Moving Files...");
                        if (to.exists()) {
                            if (to.isDirectory()) {
                                Directories.delete((File)to);
                            } else {
                                to.delete();
                            }
                        }
                        to.mkdirs();
                        Directories.copy((File)from, (File)to);
                        Directories.delete((File)from);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Logger.get((String)"SubServers").info("Saving...");
                YAMLSection info = this.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(server) ? new YAMLSection(this.plugin.servers.get().getMap((Object)"Servers").getMap((Object)server).get()) : new YAMLSection();
                info.set((Object)"Name", (Object)server);
                info.set((Object)"Timestamp", (Object)Calendar.getInstance().getTime().getTime());
                try {
                    if (this.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(server)) {
                        this.plugin.servers.get().getMap((Object)"Servers").remove((Object)server);
                        this.plugin.servers.save();
                    }
                    if (!to.exists()) {
                        to.mkdirs();
                    }
                    FileWriter writer = new FileWriter(new File(to, "info.json"), false);
                    writer.write(new Gson().toJson((Object)info.get()));
                    writer.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Logger.get((String)"SubServers").info("Deleted SubServer: " + server);
            };
            if (multithreading) {
                new Thread(method, "SubServers.Bungee::Internal_Server_Recycler(" + name + ')').start();
            } else {
                method.run();
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean deleteSubServer(UUID player, String name, boolean forced) throws InterruptedException {
        return this.deleteSubServer(player, name, forced, true);
    }

    protected boolean deleteSubServer(UUID player, String name, boolean forced, boolean multithreading) throws InterruptedException {
        Util.nullpo((Object)name);
        String server = this.servers.get(name.toLowerCase()).getName();
        File from = new File(this.getPath(), this.servers.get(server.toLowerCase()).getPath());
        if (this.removeSubServer(player, server, forced)) {
            Runnable method = () -> {
                try {
                    if (from.exists()) {
                        Logger.get((String)"SubServers").info("Removing Files...");
                        Directories.delete((File)from);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Logger.get((String)"SubServers").info("Saving...");
                try {
                    if (this.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(server)) {
                        this.plugin.servers.get().getMap((Object)"Servers").remove((Object)server);
                        this.plugin.servers.save();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Logger.get((String)"SubServers").info("Deleted SubServer: " + server);
            };
            if (multithreading) {
                new Thread(method, "SubServers.Bungee::Internal_Server_Deletion(" + name + ')').start();
            } else {
                method.run();
            }
            return true;
        }
        return false;
    }
}

