/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Bungee.Host.Internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.ME1312.Galaxi.Library.Container.Value;
import net.ME1312.Galaxi.Library.Try;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.SubServers.Bungee.Host.SubLogFilter;
import net.ME1312.SubServers.Bungee.Host.SubLogger;
import net.ME1312.SubServers.Bungee.Library.Compatibility.Logger;
import net.ME1312.SubServers.Bungee.SubAPI;

public class InternalSubLogger
extends SubLogger {
    Process process;
    private Object handle;
    String name;
    Value<Boolean> log;
    private List<SubLogFilter> filters = new CopyOnWriteArrayList<SubLogFilter>();
    File file;
    private PrintWriter writer = null;
    private boolean started = false;
    private Thread out = null;
    private Thread err = null;
    private Level level = Level.INFO;
    private static final String PATTERN = "^((?:\\s*\\[?([0-9]{2}:[0-9]{2}:[0-9]{2})]?)?[\\s\\/\\\\\\|]*(?:\\[|\\[.*\\/)?(DEBUG|MESSAGE|MSG|" + Pattern.quote(Level.INFO.getLocalizedName()) + "|INFO|" + Pattern.quote(Level.WARNING.getLocalizedName()) + "|WARNING|WARN|ERROR|ERR|" + Pattern.quote(Level.SEVERE.getLocalizedName()) + "|SEVERE)\\]?(?::|\\s*>)?\\s*)";

    InternalSubLogger(Process process, Object user, String name, Value<Boolean> log, File file) {
        this.process = process;
        this.handle = user;
        this.name = name;
        this.log = log;
        this.file = file;
    }

    void init() {
        ArrayList<SubLogFilter> filters = new ArrayList<SubLogFilter>();
        filters.addAll(this.filters);
        for (SubLogFilter filter : filters) {
            try {
                filter.start();
            }
            catch (Throwable e) {
                new InvocationTargetException(e, "Exception while running SubLogger Event").printStackTrace();
            }
        }
    }

    @Override
    public void start() {
        this.started = true;
        if (this.file != null && this.writer == null) {
            try {
                this.writer = new PrintWriter(this.file, "UTF-8");
                this.writer.println("---------- LOG START \u2014 " + this.name + " ----------");
                this.writer.flush();
            }
            catch (FileNotFoundException | UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        if (this.out == null) {
            this.out = new Thread(() -> this.start(this.process.getInputStream(), false), "SubServers.Bungee::Internal_Log_Spooler(" + this.name + ')');
            this.out.start();
        }
        if (this.err == null) {
            this.err = new Thread(() -> this.start(this.process.getErrorStream(), true), "SubServers.Bungee::Internal_Error_Spooler(" + this.name + ')');
            this.err.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(InputStream in, boolean isErr) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((line = br.readLine()) != null) {
                this.log(line);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (isErr) {
                this.err = null;
            } else {
                this.out = null;
            }
            this.stop();
        }
    }

    private void log(String line) {
        if (!line.startsWith(">")) {
            String msg = line;
            String type = null;
            Matcher matcher = Pattern.compile(PATTERN).matcher(msg.replaceAll("\u001b\\[[;\\d]*m", ""));
            if (matcher.find()) {
                type = matcher.group(3).toUpperCase();
            }
            msg = msg.replaceAll(PATTERN, "");
            if (type != null) {
                if (type.equalsIgnoreCase(Level.INFO.getLocalizedName())) {
                    this.level = Level.INFO;
                } else if (type.equalsIgnoreCase(Level.WARNING.getLocalizedName())) {
                    this.level = Level.WARNING;
                } else if (type.equalsIgnoreCase(Level.SEVERE.getLocalizedName())) {
                    this.level = Level.SEVERE;
                } else {
                    switch (type) {
                        case "WARNING": 
                        case "WARN": {
                            this.level = Level.WARNING;
                            break;
                        }
                        case "SEVERE": 
                        case "ERROR": 
                        case "ERR": {
                            this.level = Level.SEVERE;
                            break;
                        }
                        default: {
                            this.level = Level.INFO;
                        }
                    }
                }
            }
            this.log(this.level, msg);
            if (this.writer != null) {
                this.writer.println(line);
                this.writer.flush();
            }
        }
    }

    void log(Level level, String message) {
        boolean allow = SubAPI.getInstance().getInternals().sudo == this.getHandler() && SubAPI.getInstance().getInternals().canSudo || (Boolean)this.log.value() != false && (SubAPI.getInstance().getInternals().sudo == null || !SubAPI.getInstance().getInternals().canSudo);
        ArrayList<SubLogFilter> filters = new ArrayList<SubLogFilter>();
        filters.addAll(this.filters);
        for (SubLogFilter filter : filters) {
            try {
                allow = filter.log(level, message) && allow;
            }
            catch (Throwable e) {
                new InvocationTargetException(e, "Exception while running SubLogger Event").printStackTrace();
            }
        }
        if (allow || !this.started) {
            Logger.get((String)this.name).log(level, message);
        }
    }

    @Override
    public void stop() {
        try {
            if (this.out != null) {
                this.out.interrupt();
            }
            if (this.err != null) {
                this.err.interrupt();
            }
            this.level = Level.INFO;
            if (this.started) {
                this.started = false;
                if (this.writer != null) {
                    PrintWriter writer = this.writer;
                    this.writer = null;
                    int l = (("---------- LOG START \u2014 " + this.name + " ----------").length() - 9) / 2;
                    String s = "";
                    while (s.length() < l) {
                        s = s + '-';
                    }
                    if (writer != null) {
                        writer.println(s + " LOG END " + s);
                        writer.close();
                    }
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    void destroy() {
        this.filters.addAll(this.filters);
        for (SubLogFilter filter : this.filters) {
            try {
                filter.stop();
            }
            catch (Throwable e) {
                new InvocationTargetException(e, "Exception while running SubLogger Event").printStackTrace();
            }
        }
    }

    @Override
    public void registerFilter(SubLogFilter filter) {
        Util.nullpo((Object)filter);
        this.filters.add(filter);
    }

    @Override
    public void unregisterFilter(SubLogFilter filter) {
        Util.nullpo((Object)filter);
        Try.all.run(() -> this.filters.remove(filter));
    }

    @Override
    public Object getHandler() {
        return this.handle;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isLogging() {
        return (Boolean)this.log.value();
    }
}

