/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Bungee.Host.Internal;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.UUID;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import net.ME1312.Galaxi.Library.Container.ContainedPair;
import net.ME1312.Galaxi.Library.Container.Container;
import net.ME1312.Galaxi.Library.Container.Pair;
import net.ME1312.Galaxi.Library.Container.Value;
import net.ME1312.Galaxi.Library.Map.ObjectMap;
import net.ME1312.Galaxi.Library.Map.ObjectMapValue;
import net.ME1312.Galaxi.Library.Try;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.Galaxi.Library.Version.Version;
import net.ME1312.SubData.Server.Protocol.PacketOut;
import net.ME1312.SubData.Server.SubDataClient;
import net.ME1312.SubServers.Bungee.Event.SubEditServerEvent;
import net.ME1312.SubServers.Bungee.Event.SubSendCommandEvent;
import net.ME1312.SubServers.Bungee.Event.SubStartEvent;
import net.ME1312.SubServers.Bungee.Event.SubStopEvent;
import net.ME1312.SubServers.Bungee.Event.SubStoppedEvent;
import net.ME1312.SubServers.Bungee.Host.Executable;
import net.ME1312.SubServers.Bungee.Host.Host;
import net.ME1312.SubServers.Bungee.Host.Internal.InternalHost;
import net.ME1312.SubServers.Bungee.Host.Internal.InternalSubLogger;
import net.ME1312.SubServers.Bungee.Host.Proxy;
import net.ME1312.SubServers.Bungee.Host.ServerImpl;
import net.ME1312.SubServers.Bungee.Host.SubLogger;
import net.ME1312.SubServers.Bungee.Host.SubServer;
import net.ME1312.SubServers.Bungee.Host.SubServerImpl;
import net.ME1312.SubServers.Bungee.Library.Compatibility.Logger;
import net.ME1312.SubServers.Bungee.Library.Exception.InvalidServerException;
import net.ME1312.SubServers.Bungee.Network.Packet.PacketOutExEditServer;
import net.ME1312.SubServers.Bungee.SubAPI;
import net.ME1312.SubServers.Bungee.SubProxy;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.plugin.Event;

public class InternalSubServer
extends SubServerImpl {
    private InternalHost host;
    private boolean enabled;
    private Value<Boolean> log;
    private String dir;
    private File directory;
    private String executable;
    private String stopcmd;
    private SubServer.StopAction stopaction;
    private LinkedList<SubServer.LoggedCommand> history;
    private Process process;
    private InternalSubLogger logger;
    private Thread thread;
    private BufferedWriter command;
    private boolean allowrestart;
    private boolean lock;

    public static InternalSubServer construct(InternalHost host, String name, boolean enabled, int port, String motd, boolean log, String directory, String executable, String stopcmd, boolean hidden, boolean restricted) throws InvalidServerException {
        try {
            return new InternalSubServer(host, name, enabled, port, motd, log, directory, executable, stopcmd, hidden, restricted);
        }
        catch (NoSuchMethodError e) {
            return new InternalSubServer(host, name, enabled, (Integer)port, motd, log, directory, executable, stopcmd, hidden, restricted);
        }
    }

    protected InternalSubServer(InternalHost host, String name, boolean enabled, int port, String motd, boolean log, String directory, String executable, String stopcmd, boolean hidden, boolean restricted) throws InvalidServerException {
        super((Host)host, name, port, motd, hidden, restricted);
        this.init(host, name, enabled, port, motd, log, directory, executable, stopcmd, hidden, restricted);
    }

    protected InternalSubServer(InternalHost host, String name, boolean enabled, Integer port, String motd, boolean log, String directory, String executable, String stopcmd, boolean hidden, boolean restricted) throws InvalidServerException {
        super((Host)host, name, port, motd, hidden, restricted);
        this.init(host, name, enabled, port, motd, log, directory, executable, stopcmd, hidden, restricted);
    }

    private void init(InternalHost host, String name, boolean enabled, int port, String motd, boolean log, String directory, String executable, String stopcmd, boolean hidden, boolean restricted) throws InvalidServerException {
        File[] locations;
        Util.nullpo((Object[])new Object[]{host, name, enabled, port, motd, log, directory, executable, stopcmd, hidden, restricted});
        this.host = host;
        this.enabled = enabled;
        this.log = new Container((Object)log);
        this.dir = directory;
        this.directory = new File(host.getPath(), directory);
        this.executable = executable;
        this.stopcmd = stopcmd;
        this.stopaction = SubServer.StopAction.NONE;
        this.history = new LinkedList();
        this.process = null;
        this.logger = new InternalSubLogger(null, this, this.getName(), this.log, null);
        this.thread = null;
        this.command = null;
        for (File location : locations = new File[]{new File(this.directory, "plugins/SubServers.Client.jar"), new File(this.directory, "mods/SubServers.Client.jar")}) {
            if (!location.exists()) continue;
            try {
                JarInputStream updated = new JarInputStream(SubProxy.class.getResourceAsStream("/net/ME1312/SubServers/Bungee/Library/Files/client.jar"));
                JarFile existing = new JarFile(location);
                if (existing.getManifest().getMainAttributes().getValue("Implementation-Title") != null && existing.getManifest().getMainAttributes().getValue("Implementation-Title").startsWith("SubServers.Client") && existing.getManifest().getMainAttributes().getValue("Specification-Title") != null && updated.getManifest().getMainAttributes().getValue("Implementation-Title") != null && updated.getManifest().getMainAttributes().getValue("Implementation-Title").startsWith("SubServers.Client") && updated.getManifest().getMainAttributes().getValue("Specification-Title") != null && new Version(existing.getManifest().getMainAttributes().getValue("Specification-Title")).compareTo(new Version(updated.getManifest().getMainAttributes().getValue("Specification-Title"))) < 0) {
                    location.delete();
                    Util.copyFromJar((ClassLoader)SubProxy.class.getClassLoader(), (String)"net/ME1312/SubServers/Bungee/Library/Files/client.jar", (String)location.getPath());
                }
                existing.close();
                updated.close();
            }
            catch (Throwable e) {
                System.out.println("Couldn't auto-update SubServers.Client for subserver: " + name);
                e.printStackTrace();
            }
        }
        this.lock = false;
    }

    void registered(boolean value) {
        this.registered = value;
    }

    void updating(boolean value) {
        this.updating = value;
    }

    private void run() {
        block15: {
            boolean locked = this.lock;
            this.allowrestart = true;
            this.stopping = false;
            this.started = false;
            try {
                ProcessBuilder pb = new ProcessBuilder(new String[0]).command(Executable.parse(this.host.getCreator().getBashDirectory(), this.executable)).directory(this.directory);
                pb.environment().put("java", System.getProperty("java.home") + File.separator + "bin" + File.separator + "java");
                pb.environment().put("name", this.getName());
                pb.environment().put("host", this.host.getName());
                pb.environment().put("address", this.host.getAddress().getHostAddress());
                pb.environment().put("port", Integer.toString(this.getAddress().getPort()));
                this.logger.init();
                this.process = pb.start();
                Logger.get((String)"SubServers").info("Now starting " + this.getName());
                this.logger.process = this.process;
                this.logger.start();
                locked = false;
                this.lock = false;
                this.command = new BufferedWriter(new OutputStreamWriter(this.process.getOutputStream()));
                for (SubServer.LoggedCommand command : this.history) {
                    if (!this.process.isAlive()) continue;
                    this.command.write(command.getCommand());
                    this.command.newLine();
                    this.command.flush();
                }
                if (this.process.isAlive()) {
                    this.process.waitFor();
                }
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
                if (locked) {
                    this.lock = false;
                }
                this.allowrestart = false;
            }
            this.logger.destroy();
            Logger.get((String)"SubServers").info(this.getName() + " has stopped");
            this.process = null;
            this.command = null;
            this.started = false;
            this.stopping = false;
            this.history.clear();
            SubStoppedEvent event = new SubStoppedEvent(this);
            this.host.plugin.getPluginManager().callEvent((Event)event);
            if (this.stopaction == SubServer.StopAction.REMOVE_SERVER || this.stopaction == SubServer.StopAction.RECYCLE_SERVER || this.stopaction == SubServer.StopAction.DELETE_SERVER) {
                try {
                    if (this.stopaction == SubServer.StopAction.RECYCLE_SERVER) {
                        this.host.recycleSubServer(null, this.getName(), false, false);
                        break block15;
                    }
                    if (this.stopaction == SubServer.StopAction.DELETE_SERVER) {
                        this.host.deleteSubServer(null, this.getName(), false, false);
                        break block15;
                    }
                    try {
                        if (this.host.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(this.getName())) {
                            this.host.plugin.servers.get().getMap((Object)"Servers").remove((Object)this.getName());
                            this.host.plugin.servers.save();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    this.host.removeSubServer(this.getName());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else if (this.stopaction == SubServer.StopAction.RESTART && this.allowrestart) {
                new Thread(() -> {
                    try {
                        while (this.thread != null && this.thread.isAlive()) {
                            Thread.sleep(250L);
                        }
                        this.start();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }, "SubServers.Bungee::Internal_Server_Restart_Handler(" + this.getName() + ')').start();
            }
        }
    }

    @Override
    public boolean start(UUID player) {
        if (!this.lock && this.isAvailable() && this.isEnabled() && (this.thread == null || !this.thread.isAlive()) && this.getCurrentIncompatibilities().size() == 0) {
            this.lock = true;
            SubStartEvent event = new SubStartEvent(player, this);
            this.host.plugin.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                this.thread = new Thread(this::run, "SubServers.Bungee::Internal_Server_Process_Handler(" + this.getName() + ')');
                this.thread.start();
                return true;
            }
            this.lock = false;
            return false;
        }
        return false;
    }

    @Override
    public boolean stop(UUID player) {
        if (this.thread != null && this.thread.isAlive()) {
            SubStopEvent event = new SubStopEvent(player, this, false);
            this.host.plugin.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                try {
                    this.stopping = true;
                    this.allowrestart = false;
                    this.history.add(new SubServer.LoggedCommand(player, this.stopcmd));
                    if (this.process != null && this.process.isAlive()) {
                        this.command.write(this.stopcmd);
                        this.command.newLine();
                        this.command.flush();
                    }
                    return true;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean terminate(UUID player) {
        if (this.thread != null && this.thread.isAlive()) {
            SubStopEvent event = new SubStopEvent(player, this, true);
            this.host.plugin.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                this.stopping = true;
                this.allowrestart = false;
                if (this.process != null && this.process.isAlive()) {
                    Executable.terminate(this.process);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean command(UUID player, String command) {
        Util.nullpo((Object)command);
        if (this.thread != null && this.thread.isAlive()) {
            SubSendCommandEvent event = new SubSendCommandEvent(player, this, command, null);
            this.host.plugin.getPluginManager().callEvent((Event)event);
            if (!(event.isCancelled() || player != null && DISALLOWED_COMMANDS.matcher(command).find())) {
                try {
                    if (event.getCommand().equalsIgnoreCase(this.stopcmd)) {
                        this.stopping = true;
                        this.allowrestart = false;
                    }
                    this.history.add(new SubServer.LoggedCommand(player, event.getCommand()));
                    if (this.process != null && this.process.isAlive()) {
                        this.command.write(event.getCommand());
                        this.command.newLine();
                        this.command.flush();
                    }
                    return true;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    protected int edit(UUID player, ObjectMap<String> edit, boolean perma) {
        if (this.isAvailable()) {
            int c = 0;
            boolean state = this.isRunning();
            SubServer forward = null;
            ObjectMap pending = edit.clone();
            for (String key : edit.getKeys()) {
                pending.remove((Object)key);
                ObjectMapValue value = edit.get((Object)key);
                boolean allowed = true;
                if (perma) {
                    Object event = new SubEditServerEvent(player, this, (Pair<String, ?>)new ContainedPair((Object)key, (Object)value));
                    this.host.plugin.getPluginManager().callEvent((Event)event);
                    boolean bl = allowed = !((SubEditServerEvent)((Object)event)).isCancelled();
                }
                if (!allowed) continue;
                try {
                    SubServer server2;
                    switch (key.toLowerCase()) {
                        case "name": {
                            if (!value.isString() || !this.host.removeSubServer(player, this.getName()) || (server2 = this.host.constructSubServer(value.asString(), this.isEnabled(), this.getAddress().getPort(), this.getMotd(), this.isLogging(), this.getPath(), this.getExecutable(), this.getStopCommand(), this.isHidden(), this.isRestricted())) == null) break;
                            if (perma && this.host.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(this.getName())) {
                                ObjectMap config = this.host.plugin.servers.get().getMap((Object)"Servers").getMap((Object)this.getName());
                                this.host.plugin.servers.get().getMap((Object)"Servers").remove((Object)this.getName());
                                this.host.plugin.servers.get().getMap((Object)"Servers").set((Object)server2.getName(), (Object)config);
                                this.host.plugin.servers.save();
                            }
                            forward = server2;
                            ++c;
                            break;
                        }
                        case "display": {
                            if (!value.isString()) break;
                            this.setDisplayName(value.asString());
                            this.logger.name = this.getDisplayName();
                            if (perma && this.host.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(this.getName())) {
                                if (this.getName().equals(this.getDisplayName())) {
                                    this.host.plugin.servers.get().getMap((Object)"Servers").getMap((Object)this.getName()).remove((Object)"Display");
                                } else {
                                    this.host.plugin.servers.get().getMap((Object)"Servers").getMap((Object)this.getName()).set((Object)"Display", (Object)this.getDisplayName());
                                }
                                this.host.plugin.servers.save();
                            }
                            ++c;
                            break;
                        }
                        case "enabled": {
                            if (!value.isBoolean()) break;
                            this.enabled = value.asBoolean();
                            if (perma && this.host.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(this.getName())) {
                                this.host.plugin.servers.get().getMap((Object)"Servers").getMap((Object)this.getName()).set((Object)"Enabled", (Object)this.isEnabled());
                                this.host.plugin.servers.save();
                            }
                            ++c;
                            break;
                        }
                        case "group": {
                            if (!value.isList()) break;
                            Util.reflect((Field)ServerImpl.class.getDeclaredField("groups"), (Object)this, (Object)value.asStringList());
                            if (perma && this.host.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(this.getName())) {
                                this.host.plugin.servers.get().getMap((Object)"Servers").getMap((Object)this.getName()).set((Object)"Group", (Object)value.asStringList());
                                this.host.plugin.servers.save();
                            }
                            ++c;
                            break;
                        }
                        case "host": {
                            if (!value.isString() || !this.host.removeSubServer(player, this.getName()) || (server2 = this.host.plugin.api.getHost(value.asString()).constructSubServer(this.getName(), this.isEnabled(), this.getAddress().getPort(), this.getMotd(), this.isLogging(), this.getPath(), this.getExecutable(), this.getStopCommand(), this.isHidden(), this.isRestricted())) == null) break;
                            if (perma && this.host.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(this.getName())) {
                                this.host.plugin.servers.get().getMap((Object)"Servers").getMap((Object)this.getName()).set((Object)"Host", (Object)server2.getHost().getName());
                                this.host.plugin.servers.save();
                            }
                            forward = server2;
                            ++c;
                            break;
                        }
                        case "template": {
                            if (!value.isString()) break;
                            this.setTemplate(value.asString());
                            if (perma && this.host.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(this.getName())) {
                                this.host.plugin.servers.get().getMap((Object)"Servers").getMap((Object)this.getName()).set((Object)"Template", (Object)value.asString());
                                this.host.plugin.servers.save();
                            }
                            ++c;
                            break;
                        }
                        case "port": {
                            if (!value.isNumber() || !this.host.removeSubServer(player, this.getName()) || (server2 = this.host.constructSubServer(this.getName(), this.isEnabled(), value.asInt(), this.getMotd(), this.isLogging(), this.getPath(), this.getExecutable(), this.getStopCommand(), this.isHidden(), this.isRestricted())) == null) break;
                            if (perma && this.host.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(this.getName())) {
                                this.host.plugin.servers.get().getMap((Object)"Servers").getMap((Object)this.getName()).set((Object)"Port", (Object)server2.getAddress().getPort());
                                this.host.plugin.servers.save();
                            }
                            forward = server2;
                            ++c;
                            break;
                        }
                        case "motd": {
                            if (!value.isString()) break;
                            this.setMotd(ChatColor.translateAlternateColorCodes((char)'&', (String)Util.unescapeJavaString((String)value.asString())));
                            if (perma && this.host.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(this.getName())) {
                                this.host.plugin.servers.get().getMap((Object)"Servers").getMap((Object)this.getName()).set((Object)"Motd", (Object)value.asString());
                                this.host.plugin.servers.save();
                            }
                            ++c;
                            break;
                        }
                        case "log": {
                            if (!value.isBoolean()) break;
                            this.log.value((Object)value.asBoolean());
                            if (perma && this.host.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(this.getName())) {
                                this.host.plugin.servers.get().getMap((Object)"Servers").getMap((Object)this.getName()).set((Object)"Log", (Object)this.isLogging());
                                this.host.plugin.servers.save();
                            }
                            ++c;
                            break;
                        }
                        case "dir": 
                        case "directory": {
                            if (!value.isString()) break;
                            if (this.isRunning()) {
                                this.stop(player);
                                this.waitFor();
                            }
                            this.dir = value.asString();
                            this.directory = new File(this.getHost().getPath(), value.asString());
                            if (perma && this.host.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(this.getName())) {
                                this.host.plugin.servers.get().getMap((Object)"Servers").getMap((Object)this.getName()).set((Object)"Directory", (Object)this.getPath());
                                this.host.plugin.servers.save();
                            }
                            ++c;
                            break;
                        }
                        case "exec": 
                        case "executable": {
                            if (!value.isString()) break;
                            if (this.isRunning()) {
                                this.stop(player);
                                this.waitFor();
                            }
                            this.executable = value.asString();
                            if (perma && this.host.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(this.getName())) {
                                this.host.plugin.servers.get().getMap((Object)"Servers").getMap((Object)this.getName()).set((Object)"Executable", (Object)value.asString());
                                this.host.plugin.servers.save();
                            }
                            ++c;
                            break;
                        }
                        case "stop-cmd": 
                        case "stop-command": {
                            if (!value.isString()) break;
                            this.stopcmd = value.asString();
                            if (perma && this.host.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(this.getName())) {
                                this.host.plugin.servers.get().getMap((Object)"Servers").getMap((Object)this.getName()).set((Object)"Stop-Command", (Object)this.getStopCommand());
                                this.host.plugin.servers.save();
                            }
                            ++c;
                            break;
                        }
                        case "stop-action": {
                            Object action;
                            if (!value.isString() || (action = (SubServer.StopAction)((Object)Try.all.get(() -> SubServer.StopAction.valueOf(value.asString().toUpperCase().replace('-', '_').replace(' ', '_'))))) == null) break;
                            this.stopaction = action;
                            if (perma && this.host.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(this.getName())) {
                                this.host.plugin.servers.get().getMap((Object)"Servers").getMap((Object)this.getName()).set((Object)"Stop-Action", (Object)this.getStopAction().toString());
                                this.host.plugin.servers.save();
                            }
                            ++c;
                            break;
                        }
                        case "state": {
                            if (!value.isBoolean()) break;
                            state = value.asBoolean();
                            break;
                        }
                        case "auto-run": 
                        case "run-on-launch": {
                            if (!value.isBoolean()) break;
                            if (perma && this.host.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(this.getName())) {
                                this.host.plugin.servers.get().getMap((Object)"Servers").getMap((Object)this.getName()).set((Object)"Run-On-Launch", (Object)value.asBoolean());
                                this.host.plugin.servers.save();
                            }
                            ++c;
                            break;
                        }
                        case "incompatible": {
                            if (!value.isList()) break;
                            for (SubServer oserver : this.getIncompatibilities()) {
                                this.toggleCompatibility(oserver);
                            }
                            Object action = value.asStringList().iterator();
                            while (action.hasNext()) {
                                String oname = (String)action.next();
                                SubServer oserver = this.host.plugin.api.getSubServer(oname);
                                if (oserver == null || !this.isCompatible(oserver)) continue;
                                this.toggleCompatibility(oserver);
                            }
                            if (perma && this.host.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(this.getName())) {
                                this.host.plugin.servers.get().getMap((Object)"Servers").getMap((Object)this.getName()).set((Object)"Incompatible", (Object)value.asStringList());
                                this.host.plugin.servers.save();
                            }
                            ++c;
                            break;
                        }
                        case "restricted": {
                            if (!value.isBoolean()) break;
                            this.setRestricted(value.asBoolean());
                            if (perma && this.host.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(this.getName())) {
                                this.host.plugin.servers.get().getMap((Object)"Servers").getMap((Object)this.getName()).set((Object)"Restricted", (Object)this.isRestricted());
                                this.host.plugin.servers.save();
                            }
                            ++c;
                            break;
                        }
                        case "hidden": {
                            if (!value.isBoolean()) break;
                            this.setHidden(value.asBoolean());
                            if (perma && this.host.plugin.servers.get().getMap((Object)"Servers").getKeys().contains(this.getName())) {
                                this.host.plugin.servers.get().getMap((Object)"Servers").getMap((Object)this.getName()).set((Object)"Hidden", (Object)this.isHidden());
                                this.host.plugin.servers.save();
                            }
                            ++c;
                            break;
                        }
                        case "whitelist": {
                            Object action;
                            if (!value.isList()) break;
                            Util.reflect((Field)ServerImpl.class.getDeclaredField("whitelist"), (Object)this, (Object)value.asUUIDList());
                            if (this.isRegistered()) {
                                action = SubAPI.getInstance().getProxies().values().iterator();
                                while (action.hasNext()) {
                                    Proxy proxy = (Proxy)action.next();
                                    if (proxy.getSubData()[0] == null) continue;
                                    ((SubDataClient)proxy.getSubData()[0]).sendPacket(new PacketOut[]{new PacketOutExEditServer(this, PacketOutExEditServer.Edit.WHITELIST_SET, value.asUUIDList())});
                                }
                            }
                            ++c;
                        }
                    }
                    if (forward == null) continue;
                    forward.setStopAction(this.getStopAction());
                    if (!this.getName().equals(this.getDisplayName())) {
                        forward.setDisplayName(this.getDisplayName());
                    }
                    forward.setTemplate(this.getTemplate());
                    ArrayList<String> groups = new ArrayList<String>();
                    groups.addAll(this.getGroups());
                    for (String group : groups) {
                        this.removeGroup(group);
                        forward.addGroup(group);
                    }
                    for (SubServer server2 : this.getIncompatibilities()) {
                        this.toggleCompatibility(server2);
                        forward.toggleCompatibility(server2);
                    }
                    for (String extra : this.getExtra().getKeys()) {
                        forward.addExtra(extra, this.getExtra(extra));
                    }
                    forward.getHost().addSubServer(player, forward);
                    if (state) {
                        pending.set((Object)"state", (Object)true);
                    }
                    c += perma ? forward.permaEdit(player, (ObjectMap<String>)pending) : forward.edit(player, (ObjectMap<String>)pending);
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!this.isRunning() && forward == null && state) {
                this.start(player);
            }
            return c;
        }
        return -1;
    }

    @Override
    public void waitFor() throws InterruptedException {
        while (this.thread != null && this.thread.isAlive()) {
            Thread.sleep(250L);
        }
    }

    @Override
    public boolean isRunning() {
        return this.process != null && this.process.isAlive() || this.lock;
    }

    @Override
    public void setDisplayName(String value) {
        super.setDisplayName(value);
        this.logger.name = this.getDisplayName();
    }

    @Override
    public Host getHost() {
        return this.host;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled && this.host.isEnabled();
    }

    @Override
    public void setEnabled(boolean value) {
        Util.nullpo((Object)value);
        this.enabled = value;
    }

    @Override
    public boolean isLogging() {
        return (Boolean)this.log.value();
    }

    @Override
    public void setLogging(boolean value) {
        Util.nullpo((Object)value);
        this.log.value((Object)value);
    }

    @Override
    public SubLogger getLogger() {
        return this.logger;
    }

    @Override
    public LinkedList<SubServer.LoggedCommand> getCommandHistory() {
        return new LinkedList<SubServer.LoggedCommand>(this.history);
    }

    @Override
    public String getPath() {
        return this.dir;
    }

    @Override
    public String getExecutable() {
        return this.executable;
    }

    @Override
    public String getStopCommand() {
        return this.stopcmd;
    }

    @Override
    public void setStopCommand(String value) {
        Util.nullpo((Object)value);
        this.stopcmd = value;
    }

    @Override
    public SubServer.StopAction getStopAction() {
        return this.stopaction;
    }

    @Override
    public void setStopAction(SubServer.StopAction action) {
        Util.nullpo((Object)((Object)action));
        this.stopaction = action;
    }
}

