/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Bungee.Host;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import net.ME1312.Galaxi.Library.Container.ContainedPair;
import net.ME1312.Galaxi.Library.Container.Pair;
import net.ME1312.Galaxi.Library.Map.ObjectMap;
import net.ME1312.SubServers.Bungee.Host.Host;
import net.ME1312.SubServers.Bungee.Host.ServerImpl;
import net.ME1312.SubServers.Bungee.Host.SubCreator;
import net.ME1312.SubServers.Bungee.Host.SubServer;
import net.ME1312.SubServers.Bungee.Library.Exception.InvalidServerException;
import net.ME1312.SubServers.Bungee.SubAPI;

public abstract class SubServerImpl
extends ServerImpl
implements SubServer {
    protected static final Pattern DISALLOWED_COMMANDS = Pattern.compile("^/?(?:[^\\s]+:)?sub(?:servers?)?(?:\\s|$)", 0);
    private List<Pair<String, String>> incompatibilities = new ArrayList<Pair<String, String>>();
    private SubCreator.ServerTemplate templateV = null;
    private String templateS = null;
    protected boolean registered;
    protected boolean started;
    protected boolean stopping;
    protected boolean updating;

    protected SubServerImpl(Host host, String name, int port, String motd, boolean hidden, boolean restricted) throws InvalidServerException {
        super(name, (SocketAddress)new InetSocketAddress(host.getAddress().getHostAddress(), port), motd, hidden, restricted);
    }

    protected SubServerImpl(Host host, String name, Integer port, String motd, boolean hidden, boolean restricted) throws InvalidServerException {
        super(name, new InetSocketAddress(host.getAddress().getHostAddress(), (int)port), motd, hidden, restricted);
    }

    @Override
    public int edit(UUID player, ObjectMap<String> edit) {
        return this.edit(player, edit, false);
    }

    @Override
    public int permaEdit(UUID player, ObjectMap<String> edit) {
        return this.edit(player, edit, true);
    }

    protected int edit(UUID player, ObjectMap<String> edit, boolean perma) {
        return -1;
    }

    @Override
    protected final boolean isRegistered() {
        return this.registered;
    }

    @Override
    public boolean isAvailable() {
        return this.registered && !this.updating && this.getHost().isAvailable();
    }

    @Override
    public boolean isOnline() {
        return this.isRunning() && this.started;
    }

    @Override
    public boolean isStopping() {
        return this.isRunning() && this.stopping;
    }

    @Override
    public void setTemplate(String template) {
        this.templateV = null;
        this.templateS = template;
    }

    @Override
    public void setTemplate(SubCreator.ServerTemplate template) {
        this.templateV = template;
        this.templateS = template != null ? template.getName() : null;
    }

    @Override
    public SubCreator.ServerTemplate getTemplate() {
        if (this.templateV != null) {
            return this.templateV;
        }
        if (this.templateS != null && this.getHost().getCreator().getTemplates().containsKey(this.templateS.toLowerCase())) {
            return this.getHost().getCreator().getTemplate(this.templateS.toLowerCase());
        }
        return null;
    }

    @Override
    public void toggleCompatibility(SubServer ... server) {
        for (SubServer s : server) {
            if (this.equals(s)) continue;
            ContainedPair info = new ContainedPair((Object)s.getHost().getName(), (Object)s.getName());
            if (this.isCompatible(s)) {
                this.incompatibilities.add((Pair<String, String>)info);
                if (!s.isCompatible(this)) continue;
                this.toggleCompatibility(this);
                continue;
            }
            this.incompatibilities.remove(info);
            if (s.isCompatible(this)) continue;
            this.toggleCompatibility(this);
        }
    }

    @Override
    public boolean isCompatible(SubServer server) {
        return !this.incompatibilities.contains(new ContainedPair((Object)server.getHost().getName(), (Object)server.getName()));
    }

    @Override
    public List<SubServer> getIncompatibilities() {
        ArrayList<SubServer> servers = new ArrayList<SubServer>();
        ArrayList<Pair<String, String>> temp = new ArrayList<Pair<String, String>>();
        temp.addAll(this.incompatibilities);
        for (Pair pair : temp) {
            try {
                SubServer server = SubAPI.getInstance().getHost((String)pair.key()).getSubServer((String)pair.value());
                if (server == null) {
                    throw new NullPointerException();
                }
                servers.add(server);
            }
            catch (Throwable e) {
                this.incompatibilities.remove(pair);
            }
        }
        return servers;
    }

    @Override
    public List<SubServer> getCurrentIncompatibilities() {
        ArrayList<SubServer> servers = new ArrayList<SubServer>();
        for (SubServer server : this.getIncompatibilities()) {
            if (!server.isRunning()) continue;
            servers.add(server);
        }
        return servers;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof SubServerImpl && super.equals(obj);
    }

    @Override
    public ObjectMap<String> forSubData() {
        ObjectMap<String> sinfo = super.forSubData();
        sinfo.set((Object)"type", (Object)"SubServer");
        sinfo.set((Object)"host", (Object)this.getHost().getName());
        sinfo.set((Object)"template", this.getTemplate() != null ? this.getTemplate().getName() : null);
        sinfo.set((Object)"available", (Object)this.isAvailable());
        sinfo.set((Object)"enabled", (Object)this.isEnabled());
        sinfo.set((Object)"editable", (Object)this.isEditable());
        sinfo.set((Object)"log", (Object)this.isLogging());
        sinfo.set((Object)"dir", (Object)this.getPath());
        sinfo.set((Object)"exec", (Object)this.getExecutable());
        sinfo.set((Object)"running", (Object)this.isRunning());
        sinfo.set((Object)"online", (Object)this.isOnline());
        sinfo.set((Object)"stopping", (Object)this.isStopping());
        sinfo.set((Object)"stop-cmd", (Object)this.getStopCommand());
        sinfo.set((Object)"stop-action", (Object)this.getStopAction().toString());
        sinfo.set((Object)"auto-run", (Object)SubAPI.getInstance().getInternals().servers.get().getMap((Object)"Servers").getMap((Object)this.getName(), new ObjectMap()).getBoolean((Object)"Run-On-Launch", Boolean.valueOf(false)));
        ArrayList<String> incompatibleCurrent = new ArrayList<String>();
        ArrayList<String> incompatible = new ArrayList<String>();
        for (SubServer server : this.getCurrentIncompatibilities()) {
            incompatibleCurrent.add(server.getName());
        }
        for (SubServer server : this.getIncompatibilities()) {
            incompatible.add(server.getName());
        }
        sinfo.set((Object)"incompatible", incompatibleCurrent);
        sinfo.set((Object)"incompatible-list", incompatible);
        return sinfo;
    }
}

