/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Bungee.Library.Compatibility;

import com.google.common.io.Resources;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.ME1312.SubServers.Bungee.SubAPI;
import net.md_5.bungee.api.ProxyServer;

public class JNA {
    private static ClassLoader JNA = null;
    private static final String JNA_VERSION = "5.2.0";
    private static final String JNA_DOWNLOAD = "https://oss.sonatype.org/service/local/repositories/releases/content/net/java/dev/jna/$1/5.2.0/$1-5.2.0.jar";

    private JNA() {
    }

    public static ClassLoader get() {
        if (JNA == null) {
            boolean announced = false;
            Logger log = ProxyServer.getInstance().getLogger();
            File library = new File(SubAPI.getInstance().getInternals().dir, "SubServers/Cache/Libraries");
            File jna = new File(library, "jna-5.2.0.jar");
            jna.getParentFile().mkdirs();
            if (!jna.exists()) {
                announced = true;
                log.info(">> Downloading JNA v5.2.0");
                try (FileOutputStream fin = new FileOutputStream(jna);){
                    Resources.copy((URL)new URL(JNA_DOWNLOAD.replace("$1", "jna")), (OutputStream)fin);
                }
                catch (Throwable e) {
                    jna.delete();
                    e.printStackTrace();
                }
            }
            File platform = new File(library, "jna-platform-5.2.0.jar");
            platform.getParentFile().mkdirs();
            if (!platform.exists()) {
                if (!announced) {
                    log.info(">> Downloading JNA platform v5.2.0");
                }
                announced = true;
                try (FileOutputStream fin = new FileOutputStream(platform);){
                    Resources.copy((URL)new URL(JNA_DOWNLOAD.replace("$1", "jna-platform")), (OutputStream)fin);
                }
                catch (Throwable e) {
                    platform.delete();
                    e.printStackTrace();
                }
            }
            if (jna.exists() && platform.exists()) {
                if (announced) {
                    log.info(">> JNA download complete");
                }
                try {
                    JNA = new URLClassLoader(new URL[]{jna.toURI().toURL(), platform.toURI().toURL()});
                }
                catch (Throwable e) {
                    log.log(Level.SEVERE, ">> Couldn't load JNA:", e);
                }
            } else {
                log.log(Level.SEVERE, ">> Couldn't load JNA:", new FileNotFoundException());
            }
        }
        return JNA;
    }
}

