/*
 * Decompiled with CFR 0.152.
 */
package net.ME1312.SubServers.Bungee.Library;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import net.ME1312.Galaxi.Library.Util;
import net.ME1312.SubServers.Bungee.Library.FileScanner;

public class ReplacementScanner
extends FileScanner {
    private final Map<String, String> replacements = new LinkedHashMap<String, String>();

    public ReplacementScanner(Map<String, String> replacements) {
        TreeMap order = new TreeMap(Comparator.reverseOrder());
        for (String key : replacements.keySet()) {
            int length = key.length();
            if (!order.containsKey(length)) {
                order.put(length, new LinkedList());
            }
            ((LinkedList)order.get(length)).add(key);
        }
        for (Integer length : order.keySet()) {
            for (String key : (LinkedList)order.get(length)) {
                this.replacements.put(key, replacements.get(key));
            }
        }
    }

    public Map<String, String> getReplacements() {
        return new HashMap<String, String>(this.replacements);
    }

    public void replace(File dir, String ... whitelist) throws IOException {
        super.scan(dir, whitelist);
    }

    @Override
    protected void act(File dir, String name) throws IOException {
        File file = new File(dir, name);
        FileInputStream stream = new FileInputStream(file);
        String string = Util.readAll((Reader)new InputStreamReader(stream));
        stream.close();
        boolean update = false;
        for (Map.Entry<String, String> replacement : this.replacements.entrySet()) {
            String placeholder = "SubServers::" + replacement.getKey();
            if (!string.contains(placeholder)) continue;
            string = string.replace(placeholder, replacement.getValue());
            update = true;
        }
        if (update) {
            FileWriter writer = new FileWriter(file, false);
            writer.write(string);
            writer.close();
        }
    }

    public Object replace(Object value) {
        if (value instanceof Map) {
            ArrayList list = new ArrayList();
            list.addAll(((Map)value).keySet());
            for (String key : list) {
                ((Map)value).put(key, this.replace(((Map)value).get(key)));
            }
            return value;
        }
        if (value instanceof Collection) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object val : (Collection)value) {
                list.add(this.replace(val));
            }
            return list;
        }
        if (value.getClass().isArray()) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < ((Object[])value).length; ++i) {
                list.add(this.replace(((Object[])value)[i]));
            }
            return list;
        }
        if (value instanceof String) {
            return this.replaceObj((String)value);
        }
        return value;
    }

    private String replaceObj(String string) {
        for (Map.Entry<String, String> replacement : this.replacements.entrySet()) {
            string = string.replace('$' + replacement.getKey() + '$', replacement.getValue());
        }
        return string;
    }
}

